/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.TemplateCompletionProposalComputer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.actions.QuickMenuCreator;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class SurroundWithTemplateMenuAction
implements IWorkbenchWindowPulldownDelegate2 {
    public static final String SURROUND_WITH_QUICK_MENU_ACTION_ID = "org.eclipse.cdt.ui.edit.text.c.surround.with.quickMenu";
    private static final String C_TEMPLATE_PREFERENCE_PAGE_ID = "org.eclipse.cdt.ui.preferences.TemplatePreferencePage";
    private static final String TEMPLATE_GROUP = "templateGroup";
    private static final String CONFIG_GROUP = "configGroup";
    private static Action NONE_APPLICABLE_ACTION = new Action(ActionMessages.SurroundWithTemplateMenuAction_NoneApplicable){

        public void run() {
        }

        public boolean isEnabled() {
            return false;
        }
    };
    private Menu fMenu;
    private IPartService fPartService;
    private IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            SurroundWithTemplateMenuAction.this.disposeMenuItems();
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    protected void disposeMenuItems() {
        if (this.fMenu == null || this.fMenu.isDisposed()) {
            return;
        }
        MenuItem[] items = this.fMenu.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem menuItem = items[i];
            if (!menuItem.isDisposed()) {
                menuItem.dispose();
            }
            ++i;
        }
    }

    public Menu getMenu(Menu parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    public static void fillMenu(IMenuManager menu, CEditor editor) {
        IAction[] actions = SurroundWithTemplateMenuAction.getTemplateActions(editor);
        if (actions == null || actions.length == 0) {
            menu.add((IAction)NONE_APPLICABLE_ACTION);
        } else {
            menu.add((IContributionItem)new Separator(TEMPLATE_GROUP));
            int i = 0;
            while (i < actions.length) {
                menu.add(actions[i]);
                ++i;
            }
        }
        menu.add((IContributionItem)new Separator(CONFIG_GROUP));
        menu.add((IAction)new ConfigureTemplatesAction());
    }

    public void dispose() {
        if (this.fPartService != null) {
            this.fPartService.removePartListener(this.fPartListener);
            this.fPartService = null;
        }
        this.setMenu(null);
    }

    public void init(IWorkbenchWindow window) {
        IPartService partService;
        if (this.fPartService != null) {
            this.fPartService.removePartListener(this.fPartListener);
            this.fPartService = null;
        }
        if (window != null && (partService = window.getPartService()) != null) {
            this.fPartService = partService;
            partService.addPartListener(this.fPartListener);
        }
    }

    public void run(IAction action) {
        IWorkbenchPart activePart = CUIPlugin.getActivePage().getActivePart();
        if (!(activePart instanceof CEditor)) {
            return;
        }
        final CEditor editor = (CEditor)activePart;
        new QuickMenuCreator(){

            protected void fillMenu(IMenuManager menu) {
                SurroundWithTemplateMenuAction.fillMenu(menu, editor);
            }
        }.createMenu();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected void fillMenu(Menu menu) {
        IWorkbenchPart activePart = CUIPlugin.getActivePage().getActivePart();
        if (!(activePart instanceof CEditor)) {
            ActionContributionItem item = new ActionContributionItem((IAction)NONE_APPLICABLE_ACTION);
            item.fill(menu, -1);
            return;
        }
        CEditor editor = (CEditor)activePart;
        IAction[] actions = SurroundWithTemplateMenuAction.getTemplateActions(editor);
        if (actions == null || actions.length <= 0) {
            ActionContributionItem item = new ActionContributionItem((IAction)NONE_APPLICABLE_ACTION);
            item.fill(menu, -1);
        } else {
            int i = 0;
            while (i < actions.length) {
                ActionContributionItem item = new ActionContributionItem(actions[i]);
                item.fill(menu, -1);
                ++i;
            }
        }
        Separator configGroup = new Separator(CONFIG_GROUP);
        configGroup.fill(menu, -1);
        ActionContributionItem configAction = new ActionContributionItem((IAction)new ConfigureTemplatesAction());
        configAction.fill(menu, -1);
    }

    protected void initMenu() {
        this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                SurroundWithTemplateMenuAction.this.fillMenu(m);
            }
        });
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }

    private static IAction[] getTemplateActions(CEditor editor) {
        ITextSelection textSelection = SurroundWithTemplateMenuAction.getTextSelection(editor);
        if (textSelection == null || textSelection.getLength() == 0) {
            return null;
        }
        IWorkingCopy tu = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
        if (tu == null) {
            return null;
        }
        TemplateCompletionProposalComputer templateComputer = new TemplateCompletionProposalComputer();
        CContentAssistInvocationContext context = new CContentAssistInvocationContext((ITextViewer)editor.getViewer(), textSelection.getOffset(), (IEditorPart)editor, true, false);
        List<ICompletionProposal> proposals = templateComputer.computeCompletionProposals(context, null);
        if (proposals == null || proposals.isEmpty()) {
            return null;
        }
        return SurroundWithTemplateMenuAction.getActionsFromProposals(proposals, context.getInvocationOffset(), (ITextViewer)editor.getViewer());
    }

    private static ITextSelection getTextSelection(CEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)selection;
    }

    private static IAction[] getActionsFromProposals(List<ICompletionProposal> proposals, final int offset, final ITextViewer viewer) {
        ArrayList<5> result = new ArrayList<5>();
        int j = 1;
        for (final ICompletionProposal proposal : proposals) {
            StringBuffer actionName = new StringBuffer();
            if (j < 10) {
                actionName.append('&').append(j).append(' ');
            }
            actionName.append(proposal.getDisplayString());
            Action action = new Action(actionName.toString()){

                public void run() {
                    SurroundWithTemplateMenuAction.applyProposal(proposal, viewer, '\u0000', 0, offset);
                }
            };
            result.add(action);
            ++j;
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new IAction[result.size()]);
    }

    private static void applyProposal(ICompletionProposal proposal, ITextViewer viewer, char trigger, int stateMask, final int offset) {
        Assert.isTrue((boolean)(proposal instanceof ICompletionProposalExtension2));
        IRewriteTarget target = null;
        IEditingSupportRegistry registry = null;
        IEditingSupport helper = new IEditingSupport(){

            public boolean isOriginator(DocumentEvent event, IRegion focus) {
                return focus.getOffset() <= offset && focus.getOffset() + focus.getLength() >= offset;
            }

            public boolean ownsFocusShell() {
                return false;
            }
        };
        try {
            IDocument document = viewer.getDocument();
            if (viewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)viewer;
                target = extension.getRewriteTarget();
            }
            if (target != null) {
                target.beginCompoundChange();
            }
            if (viewer instanceof IEditingSupportRegistry) {
                registry = (IEditingSupportRegistry)viewer;
                registry.register(helper);
            }
            ((ICompletionProposalExtension2)proposal).apply(viewer, trigger, stateMask, offset);
            Point selection = proposal.getSelection(document);
            if (selection != null) {
                viewer.setSelectedRange(selection.x, selection.y);
                viewer.revealRange(selection.x, selection.y);
            }
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
            if (registry != null) {
                registry.unregister(helper);
            }
        }
    }

    private static class ConfigureTemplatesAction
    extends Action {
        public ConfigureTemplatesAction() {
            super(ActionMessages.SurroundWithTemplateMenuAction_ConfigureTemplatesActionName);
        }

        public void run() {
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)SurroundWithTemplateMenuAction.C_TEMPLATE_PREFERENCE_PAGE_ID, (String[])new String[]{SurroundWithTemplateMenuAction.C_TEMPLATE_PREFERENCE_PAGE_ID}, null).open();
        }

        private Shell getShell() {
            return CUIPlugin.getActiveWorkbenchShell();
        }
    }
}

