/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.externaltools.internal.launchConfigurations;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.externaltools.internal.launchConfigurations.BackgroundResourceRefresher;
import org.eclipse.core.externaltools.internal.launchConfigurations.ExternalToolsCoreUtil;
import org.eclipse.core.externaltools.internal.launchConfigurations.ExternalToolsProgramMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;

public class ProgramLaunchDelegate
extends LaunchConfigurationDelegate {
    private static final String ATTR_LAUNCH_IN_BACKGROUND = "org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND";

    /*
     * Unable to fully structure code
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block20: {
            if (monitor.isCanceled()) {
                return;
            }
            location = ExternalToolsCoreUtil.getLocation(configuration);
            if (monitor.isCanceled()) {
                return;
            }
            workingDirectory = ExternalToolsCoreUtil.getWorkingDirectory(configuration);
            if (monitor.isCanceled()) {
                return;
            }
            arguments = ExternalToolsCoreUtil.getArguments(configuration);
            if (monitor.isCanceled()) {
                return;
            }
            cmdLineLength = 1;
            if (arguments != null) {
                cmdLineLength += arguments.length;
            }
            cmdLine = new String[cmdLineLength];
            cmdLine[0] = location.toOSString();
            if (arguments != null) {
                System.arraycopy(arguments, 0, cmdLine, 1, arguments.length);
            }
            workingDir = null;
            if (workingDirectory != null) {
                workingDir = workingDirectory.toFile();
            }
            if (monitor.isCanceled()) {
                return;
            }
            envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
            if (monitor.isCanceled()) {
                return;
            }
            p = DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp);
            process = null;
            processAttributes = new HashMap<String, String>();
            programName = location.lastSegment();
            extension = location.getFileExtension();
            if (extension != null) {
                programName = programName.substring(0, programName.length() - (extension.length() + 1));
            }
            programName = programName.toLowerCase();
            processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
            if (p != null) {
                monitor.beginTask(NLS.bind((String)ExternalToolsProgramMessages.ProgramLaunchDelegate_3, (Object[])new String[]{configuration.getName()}), -1);
                process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)location.toOSString(), processAttributes);
            }
            if (p == null || process == null) {
                if (p != null) {
                    p.destroy();
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.externaltools", 150, ExternalToolsProgramMessages.ProgramLaunchDelegate_4, null));
            }
            process.setAttribute(IProcess.ATTR_CMDLINE, this.generateCommandLine(cmdLine));
            if (!configuration.getAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true)) ** GOTO lbl58
            scope = configuration.getAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, null);
            if (scope == null) break block20;
            refresher = new BackgroundResourceRefresher(configuration, process);
            refresher.startBackgroundRefresh();
            break block20;
lbl-1000:
            // 1 sources

            {
                try {
                    if (monitor.isCanceled()) {
                        process.terminate();
                        break;
                    }
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException v0) {}
lbl58:
                // 3 sources

                ** while (!process.isTerminated())
            }
lbl59:
            // 2 sources

            RefreshUtil.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
        }
    }

    private String generateCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command);
                buf.append('\"');
            } else {
                buf.append(command);
            }
            ++i;
        }
        return buf.toString();
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject[] projects = ExternalToolsCoreUtil.getBuildProjects(configuration, null);
        if (projects == null) {
            return null;
        }
        boolean isRef = ExternalToolsCoreUtil.isIncludeReferencedProjects(configuration, null);
        if (isRef) {
            return this.computeReferencedBuildOrder(projects);
        }
        return this.computeBuildOrder(projects);
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if ("org.eclipse.ui.externaltools.builder".equals(configuration.getType().getCategory())) {
            return true;
        }
        return super.saveBeforeLaunch(configuration, mode, monitor);
    }
}

