/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.tag;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.tag.IWritableTag;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.core.runtime.CoreException;

public class PDOMTag
implements IWritableTag {
    private final Database db;
    private final long record;
    private String taggerId;
    private int dataLen = -1;

    public PDOMTag(Database db, long record) {
        this.db = db;
        this.record = record;
    }

    public PDOMTag(Database db, int dataLen) throws CoreException {
        this.db = db;
        this.record = db.malloc(Fields.sizeof(dataLen));
        this.dataLen = dataLen;
        Fields.DataLen.put(db, this.record, 0L, dataLen);
    }

    public long getNode() throws CoreException {
        return Fields.Node.getRecPtr(this.db, this.record, 0L);
    }

    @Override
    public String getTaggerId() {
        if (this.taggerId == null) {
            try {
                long taggerIdRecord = Fields.TaggerId.getRecPtr(this.db, this.record, 0L);
                this.taggerId = taggerIdRecord == 0L ? new String() : this.db.getString(taggerIdRecord).getString();
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return this.taggerId;
    }

    @Override
    public int getDataLen() {
        if (this.dataLen < 0) {
            try {
                this.dataLen = Fields.DataLen.getInt(this.db, this.record, 0L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                return 0;
            }
        }
        return this.dataLen;
    }

    public long getRecord() {
        return this.record;
    }

    public PDOMTag cloneWith(byte[] data) throws CoreException {
        PDOMTag partialTag = null;
        try {
            long existing_node = Fields.Node.getRecPtr(this.db, this.record, 0L);
            long existing_id = Fields.TaggerId.getRecPtr(this.db, this.record, 0L);
            partialTag = new PDOMTag(this.db, data.length);
            Fields.Node.putRecPtr(this.db, partialTag.record, 0L, existing_node);
            Fields.TaggerId.putRecPtr(this.db, partialTag.record, 0L, existing_id);
            if (partialTag.putBytes(0, data, data.length)) {
                PDOMTag tag = partialTag;
                partialTag = null;
                PDOMTag pDOMTag = tag;
                return pDOMTag;
            }
        }
        finally {
            if (partialTag != null) {
                partialTag.delete();
            }
        }
        return null;
    }

    public void delete() {
        if (this.db != null && this.record != 0L) {
            try {
                this.db.free(this.record);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
    }

    public void setNode(long node) throws CoreException {
        Fields.Node.putRecPtr(this.db, this.record, 0L, node);
    }

    public void setTaggerId(long idRecord) throws CoreException {
        Fields.TaggerId.putRecPtr(this.db, this.record, 0L, idRecord);
    }

    private boolean isInBounds(int offset, int len) {
        int data_len = this.getDataLen();
        return offset >= 0 && offset < data_len && offset + len <= data_len;
    }

    @Override
    public boolean putByte(int offset, byte data) {
        if (!this.isInBounds(offset, 1)) {
            return false;
        }
        try {
            Fields.Data.put(this.db, this.record, (long)offset, data);
            return true;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    @Override
    public boolean putBytes(int offset, byte[] data, int len) {
        boolean fullWrite;
        boolean bl = fullWrite = len < 0;
        if (fullWrite) {
            len = data.length;
        }
        if (!this.isInBounds(offset, len)) {
            return false;
        }
        try {
            Fields.Data.put(this.db, this.record, data, offset, len);
            int currLen = this.getDataLen();
            if (fullWrite && offset == 0 && currLen > len) {
                Fields.DataLen.put(this.db, this.record, 0L, len);
                this.dataLen = len;
            }
            return true;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    @Override
    public int getByte(int offset) {
        if (!this.isInBounds(offset, 1)) {
            return -1;
        }
        try {
            return Fields.Data.getByte(this.db, this.record, offset);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return -1;
        }
    }

    @Override
    public byte[] getBytes(int offset, int len) {
        int n = len = len >= 0 ? len : this.getDataLen() - offset;
        if (!this.isInBounds(offset, len)) {
            return null;
        }
        try {
            return Fields.Data.getBytes(this.db, this.record, offset, len);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public static class BTreeComparator
    implements IBTreeComparator {
        private final Database db;

        public BTreeComparator(Database db) {
            this.db = db;
        }

        @Override
        public int compare(long record1, long record2) throws CoreException {
            long tagger2;
            long node2;
            if (record1 == record2) {
                return 0;
            }
            long node1 = Fields.Node.getRecPtr(this.db, record1, 0L);
            if (node1 < (node2 = Fields.Node.getRecPtr(this.db, record2, 0L))) {
                return -1;
            }
            if (node1 > node2) {
                return 1;
            }
            long tagger1 = Fields.TaggerId.getRecPtr(this.db, record1, 0L);
            if (tagger1 < (tagger2 = Fields.TaggerId.getRecPtr(this.db, record2, 0L))) {
                return -1;
            }
            if (tagger1 > tagger2) {
                return 1;
            }
            return 0;
        }
    }

    public static class BTreeVisitor
    implements IBTreeVisitor {
        private final Database db;
        private final long node2;
        private final long tagger2;
        public boolean hasResult = false;
        public long tagRecord = 0L;

        public BTreeVisitor(Database db, long node2, long tagger2) {
            this.db = db;
            this.node2 = node2;
            this.tagger2 = tagger2;
        }

        @Override
        public int compare(long record1) throws CoreException {
            long node1 = Fields.Node.getRecPtr(this.db, record1, 0L);
            if (node1 < this.node2) {
                return -1;
            }
            if (node1 > this.node2) {
                return 1;
            }
            long tagger1 = Fields.TaggerId.getRecPtr(this.db, record1, 0L);
            if (tagger1 < this.tagger2) {
                return -1;
            }
            if (tagger1 > this.tagger2) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean visit(long record) throws CoreException {
            this.tagRecord = record;
            this.hasResult = true;
            return false;
        }
    }

    private static enum Fields {
        Node,
        TaggerId,
        DataLen,
        Data;

        public final long offset = this.ordinal() * 4;

        public static int sizeof(int datalen) {
            return (int)Fields.Data.offset + datalen;
        }

        public long getRecPtr(Database db, long instance, long data_offset) throws CoreException {
            return db.getRecPtr(instance + this.offset + data_offset);
        }

        public void putRecPtr(Database db, long instance, long data_offset, long value) throws CoreException {
            db.putRecPtr(instance + this.offset + data_offset, value);
        }

        public void put(Database db, long instance, long data_offset, byte value) throws CoreException {
            db.putByte(instance + this.offset + data_offset, value);
        }

        public void put(Database db, long instance, byte[] data, long data_offset, int len) throws CoreException {
            db.putBytes(instance + this.offset + data_offset, data, len);
        }

        public byte getByte(Database db, long instance, long data_offset) throws CoreException {
            return db.getByte(instance + this.offset + data_offset);
        }

        public byte[] getBytes(Database db, long instance, long data_offset, int len) throws CoreException {
            byte[] data = new byte[len];
            db.getBytes(instance + this.offset + data_offset, data);
            return data;
        }

        public void put(Database db, long instance, long data_offset, int value) throws CoreException {
            db.putInt(instance + this.offset + data_offset, value);
        }

        public int getInt(Database db, long instance, long data_offset) throws CoreException {
            return db.getInt(instance + this.offset + data_offset);
        }
    }
}

