/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.Objects;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtxFile;

class ASTFileLocation
implements IASTFileLocation {
    private LocationCtxFile fLocationCtx;
    private int fOffset;
    private int fLength;

    public ASTFileLocation(LocationCtxFile fileLocationCtx, int startOffset, int length) {
        this.fLocationCtx = fileLocationCtx;
        this.fOffset = startOffset;
        this.fLength = length;
    }

    @Override
    public String getFileName() {
        return this.fLocationCtx.getFilePath();
    }

    @Override
    public IASTFileLocation asFileLocation() {
        return this;
    }

    @Override
    public int getNodeLength() {
        return this.fLength;
    }

    @Override
    public int getNodeOffset() {
        return this.fOffset;
    }

    @Override
    public int getEndingLineNumber() {
        int end = this.fLength > 0 ? this.fOffset + this.fLength - 1 : this.fOffset;
        return this.fLocationCtx.getLineNumber(end);
    }

    @Override
    public int getStartingLineNumber() {
        return this.fLocationCtx.getLineNumber(this.fOffset);
    }

    public char[] getSource() {
        return this.fLocationCtx.getSource(this.fOffset, this.fLength);
    }

    public String toString() {
        return String.valueOf(this.getFileName()) + "[" + this.fOffset + "," + (this.fOffset + this.fLength) + "]";
    }

    public int getSequenceNumber() {
        return this.fLocationCtx.getSequenceNumberForOffset(this.fOffset, true);
    }

    public int getSequenceEndNumber() {
        return this.fLocationCtx.getSequenceNumberForOffset(this.fOffset + this.fLength, true);
    }

    public LocationCtxFile getLocationContext() {
        return this.fLocationCtx;
    }

    @Override
    public IASTPreprocessorIncludeStatement getContextInclusionStatement() {
        return this.fLocationCtx.getInclusionStatement();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ASTFileLocation other = (ASTFileLocation)obj;
        if (this.fOffset != other.fOffset) {
            return false;
        }
        if (this.fLength != other.fLength) {
            return false;
        }
        return Objects.equals(this.fLocationCtx, this.fLocationCtx);
    }
}

