/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.internal.core.dom.parser.ASTTypeIdInitializerExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;

public class CPPASTTypeIdInitializerExpression
extends ASTTypeIdInitializerExpression
implements ICPPASTExpression {
    private ICPPEvaluation fEvaluation;

    private CPPASTTypeIdInitializerExpression() {
    }

    public CPPASTTypeIdInitializerExpression(IASTTypeId typeId, IASTInitializer initializer) {
        super(typeId, initializer);
    }

    @Override
    public IASTTypeIdInitializerExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public IASTTypeIdInitializerExpression copy(IASTNode.CopyStyle style) {
        CPPASTTypeIdInitializerExpression expr = new CPPASTTypeIdInitializerExpression();
        this.initializeCopy(expr, style);
        return expr;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.computeEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation computeEvaluation() {
        IASTInitializer initializer = this.getInitializer();
        if (!(initializer instanceof ICPPASTInitializerClause)) {
            return EvalFixed.INCOMPLETE;
        }
        IType type = CPPVisitor.createType(this.getTypeId());
        if (type == null || type instanceof IProblemType) {
            return EvalFixed.INCOMPLETE;
        }
        return new EvalTypeId(type, this, ((ICPPASTInitializerClause)((Object)initializer)).getEvaluation());
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getTypeOrFunctionSet(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }
}

