/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.ViperTabbedPropertySheetPage;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.PropertySheet;

public class ViperPropertySheet
extends PropertySheet {
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.removeAll();
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.removeAll();
        ViperHelp.setContextHelp((Control)parent, ViperHelp.SETTINGS_VIEW_CONTEXT_ID);
    }

    protected boolean isImportant(IWorkbenchPart part) {
        if (part instanceof SessionEditor || part instanceof SourceSassEditor) {
            return super.isImportant(part);
        }
        return false;
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        this.refreshSettingsView(part);
    }

    private void refreshSettingsView(IWorkbenchPart part) {
        ViperTabbedPropertySheetPage sheetPage;
        if (!(part instanceof SessionEditor) && !(part instanceof PropertySheet)) {
            return;
        }
        IPage currPage = this.getCurrentPage();
        if (currPage instanceof ViperTabbedPropertySheetPage && (sheetPage = (ViperTabbedPropertySheetPage)currPage).getCurrentTab() != null) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = workbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        IWorkbenchPart contributingPart = null;
        if (part instanceof PropertySheet && ((PropertySheet)part).getPartName().equals("Settings")) {
            contributingPart = this.getCurrentContributingPart();
            if (contributingPart == null) {
                contributingPart = activePage.getActiveEditor();
            }
            activePage.activate(contributingPart);
        } else if (part instanceof SessionEditor && activePage.isPartVisible((IWorkbenchPart)this)) {
            this.setFocus();
        }
    }
}

