/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.run;

import com.nvidia.viper.ViperMessages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;

public enum NvprofResult {
    NVPROF_SUCCESS(0, ViperMessages.NvprofSuccess_Desc),
    NVPROF_ERROR_OUT_OF_MEMORY(1, ViperMessages.NvprofError_OutOfMemory_Desc),
    NVPROF_ERROR_IO(2, ViperMessages.NvprofError_IO_Desc),
    NVPROF_ERROR_NO_APP_TO_RUN(3, ViperMessages.NvprofError_NoApp_Desc),
    NVPROF_ERROR_INTERNAL(4, ViperMessages.NvprofError_Internal_Desc),
    NVPROF_ERROR_INVALID_CMD_ARGS(5, ViperMessages.NvprofError_InvalidCmdArgs_Desc),
    NVPROF_ERROR_MISSING_CMD_ARGS(6, ViperMessages.NvprofError_MissingCmdArgs_Desc),
    NVPROF_ERROR_LIBINJECT_NOT_FOUND(7, ViperMessages.NvprofError_LibinjectNotFound_Linux_Desc),
    NVPROF_ERROR_LIBINJECT_VERSION_MISMATCH(8, ViperMessages.NvprofError_LibinjectVersionMismatch_Linux_Desc),
    NVPROF_ERROR_APPLICATION_FAIL(9, ViperMessages.NvprofError_ApplicationFail_Desc),
    NVPROF_ERROR_COMMUNICATION(10, ViperMessages.NvprofError_Communication_Desc),
    NVPROF_ERROR_CUDA(11, ViperMessages.NvprofError_Cuda_Desc),
    NVPROF_ERROR_CUPTI(12, ViperMessages.NvprofError_Cupti_Desc),
    NVPROF_ERROR_APPLICATION_NOT_FOUND(13, ViperMessages.NvprofError_ApplicationNotFound_Desc),
    NVPROF_ERROR_INCOMPATIBLE_WITH_OLD_PROFILER(14, ViperMessages.NvprofError_OldProfiler_Desc),
    NVPROF_ERROR_APPLICATION_SIGNALED(15, ViperMessages.NvprofError_ApplicationSignaled_Desc),
    NVPROF_ERROR_ALREADY_RUNNING(16, ViperMessages.NvprofError_ApplicationRunning_Desc),
    NVPROF_ERROR_HARDWARE_BUSY(17, ViperMessages.NvprofError_HardwareBusy_Desc),
    NVPROF_ERROR_UNIFIED_MEMORY(18, ViperMessages.NvprofError_UnifiedMemory_Desc),
    NVPROF_ERROR_CUDA_DRIVER_INCOMPATIBLE(19, ViperMessages.NvprofError_CudaDriverIncompatible_Desc),
    NVPROF_ERROR_CANT_LOAD_PDM(20, ViperMessages.NvprofError_CantLoadPDM_Desc),
    NVPROF_ERROR_DEVICE_UNSUPPORTED(21, ViperMessages.NvprofError_DeviceUnsupported_Desc),
    NVPROF_ERROR_APPLICATION_NOT_SUPPORTED(22, ViperMessages.NvprofError_ApplicationUnsupported_Desc),
    NVPROF_ERROR_CUDA_DRIVER_NOT_FOUND(23, ViperMessages.NvprofError_CudaDriverNotFound_Desc),
    NVPROF_ERROR_LIBACCINJECT_NOT_FOUND(24, ViperMessages.NvprofError_OpenAccInjectionDLLNotFound_Desc),
    NVPROF_ERROR_VIRTUALIZED_DEVICE_UNSUPPORTED(25, ViperMessages.NvprofError_VirtualDeviceNotSupoorted_Desc),
    NVPROF_ERROR_TRACING_NOT_SUPPORTED(26, ViperMessages.NvprofError_TracingNotSupported_Desc);

    private int code;
    private String message;
    private static Map<Integer, NvprofResult> codeMap;

    static {
        codeMap = new HashMap<Integer, NvprofResult>();
        NvprofResult[] nvprofResultArray = NvprofResult.values();
        int n = nvprofResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            NvprofResult res = nvprofResultArray[n2];
            codeMap.put(res.getCode(), res);
            ++n2;
        }
    }

    private NvprofResult(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage(boolean isLocal) {
        if (isLocal) {
            switch (this) {
                case NVPROF_ERROR_LIBINJECT_NOT_FOUND: {
                    if ("macosx".equals(Platform.getOS())) {
                        return ViperMessages.NvprofError_LibinjectNotFound_Mac_Desc;
                    }
                    if ("win32".equals(Platform.getOS())) {
                        return ViperMessages.NvprofError_LibinjectNotFound_Win_Desc;
                    }
                    return ViperMessages.NvprofError_LibinjectNotFound_Linux_Desc;
                }
                case NVPROF_ERROR_LIBINJECT_VERSION_MISMATCH: {
                    if ("macosx".equals(Platform.getOS())) {
                        return ViperMessages.NvprofError_LibinjectVersionMismatch_Mac_Desc;
                    }
                    if ("win32".equals(Platform.getOS())) {
                        return ViperMessages.NvprofError_LibinjectVersionMismatch_Win_Desc;
                    }
                    return ViperMessages.NvprofError_LibinjectVersionMismatch_Linux_Desc;
                }
            }
            return this.message;
        }
        return this.message;
    }

    public static NvprofResult valueOf(String string) {
        return Enum.valueOf(NvprofResult.class, string);
    }
}

