/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityName;
import com.nvidia.viper.activity.CuptiActivityObjectKind;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineKind;

public class TimelineProcess
extends Timeline
implements IModel {
    private final int processId;
    public static String DISPLAY_NAME_WITH_BIN = "Process \"%s\" (%d)";

    public TimelineProcess(int processId) {
        super(String.valueOf((long)processId & 0xFFFFFFFFL), TimelineKind.PROCESS);
        this.processId = processId;
    }

    @Override
    public String getDisplayName(boolean verbose) {
        if (this.getCustomName() != null) {
            return String.format(DISPLAY_NAME_WITH_BIN, this.getCustomName(), this.processId);
        }
        return "Process " + super.getDisplayName(verbose);
    }

    public int getId() {
        return this.processId;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            if (this.getCustomName() != null) {
                CuptiActivityName nameActivity = new CuptiActivityName(CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_PROCESS.getCode(), this.getId(), 0, 0, 0, 0, this.getCustomName());
                nameActivity.appendToPDM(pdm.getNativeHandle());
            }
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

