/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.activity.CuptiActivityGlobalAccess;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultUncoalescedGlobalMemory;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import java.util.List;

public class KernelInstanceUncoalescedGlobalMemoryAnalysis
extends AnalysisBase {
    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = false;
        Analysis analysis = session.getAnalysis();
        if (analysis != null) {
            TimelineIntervalKernel interval = AnalysisStage.getHostLaunchedKernel(analysis.getActiveScopeInterval());
            if (interval == null || generateAllResults) {
                results.add(new AnalysisResult(AnalysisDescriptor.SL_GLOBALMEMORYUNCOALESCED_NO_KERNEL));
            }
            if (interval instanceof TimelineIntervalKernel) {
                TimelineIntervalKernel kernel = interval;
                int totalResults = 0;
                int droppedResults = 0;
                AnalysisResultUncoalescedGlobalMemory gma = new AnalysisResultUncoalescedGlobalMemory(session, kernel, AnalysisDescriptor.SL_GLOBALMEMORY_UNCOALESCED);
                for (ICuptiActivitySourceLevelResult result : kernel.getSourceLevelResults()) {
                    if (!(result instanceof CuptiActivityGlobalAccess)) continue;
                    ++totalResults;
                    ret = true;
                    if (gma.addResult(result)) continue;
                    ++droppedResults;
                }
                if (!gma.getMarkerSourceLevelResults().isEmpty() || generateAllResults) {
                    results.add(gma);
                    if (droppedResults > 0 || generateAllResults) {
                        AnalysisDescriptor desc = droppedResults == totalResults ? AnalysisDescriptor.SL_GLOBALMEMORYUNCOALESCED_NO_SOURCE : AnalysisDescriptor.SL_GLOBALMEMORY_UNCOALESCED_FEW_SOURCE;
                        results.add(new AnalysisResult(desc));
                    }
                }
                if (totalResults <= 0 || generateAllResults) {
                    results.add(new AnalysisResult(AnalysisDescriptor.SL_GLOBALMEMORYUNCOALESCED_NO_DATA));
                }
            }
        }
        return ret;
    }
}

