/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultInterval;
import com.nvidia.viper.analysis.BandwidthUtilizationData;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.value.IValue;
import com.nvidia.viper.value.ValueBandwidth;
import com.nvidia.viper.value.ValuePercent;
import org.eclipse.jface.action.Action;

public class AnalysisResultDramUtilization
extends AnalysisResultInterval<BandwidthUtilizationData> {
    private long totalKernelTime = 0L;

    public AnalysisResultDramUtilization(Session session, AnalysisDescriptor desc) {
        super(session, desc);
    }

    public void setTotalKernelTime(long totalKernelTime) {
        this.totalKernelTime = totalKernelTime;
    }

    @Override
    public String getDetails(ResultOutput otpt) {
        if (this.totalKernelTime > 0L) {
            double utilAvg = 0.0;
            long bwAvg = 0L;
            long utilTime = 0L;
            for (ITimelineInterval interval : this.intervals.keySet()) {
                Double util = ((BandwidthUtilizationData)this.getData(interval)).getUtilization();
                if (util == null) continue;
                utilAvg += util.doubleValue();
                utilTime += interval.getDuration();
                Long bw = ((BandwidthUtilizationData)this.getData(interval)).getThroughput();
                if (bw == null) continue;
                bwAvg += bw.longValue();
            }
            ValuePercent utilValue = new ValuePercent(utilAvg /= (double)this.getIntervalCount());
            ValueBandwidth bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, bwAvg /= (long)this.getIntervalCount());
            double utilTimeAvg = (double)utilTime / (double)this.totalKernelTime;
            ValuePercent utilTimeValue = new ValuePercent(utilTimeAvg * 100.0);
            return utilValue + " (" + bwValue + ") avg, for kernels accounting for " + utilTimeValue.toString() + " of compute";
        }
        return null;
    }

    @Override
    public IValue getValue(ITimelineInterval interval) {
        Double util = ((BandwidthUtilizationData)this.getData(interval)).getUtilization();
        if (util == null) {
            return null;
        }
        return new ValuePercent(util);
    }

    public IValue getThroughput(ITimelineInterval interval) {
        Long bw = ((BandwidthUtilizationData)this.getData(interval)).getThroughput();
        if (bw == null) {
            return null;
        }
        return new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, bw);
    }

    @Override
    public String getValueDescription(ITimelineInterval interval) {
        return "Percentage of theoretical peak DRAM bandwidth being utilized";
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                ViperHelp.displayHelp(ViperHelp.BANDWIDTH);
            }
        };
    }
}

