/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityPCSamplingStallReason;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.ITimelineInterval;

public class CuptiActivityPCSampling
extends CuptiActivityBase
implements ICuptiActivity,
ICuptiActivitySourceLevelResult {
    public int flags;
    public int sourceLocatorId;
    public int correlationId;
    public int functionId;
    public long pcOffset;
    public long samples;
    public long latencySamples;
    public int stallReason;

    public CuptiActivityPCSampling() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
    }

    public CuptiActivityPCSampling(ITimelineInterval interval, boolean isNull) {
        this();
        if (isNull && interval.getPrimaryCorrelationId() != 0) {
            this.sourceLocatorId = 0;
            this.correlationId = interval.getPrimaryCorrelationId();
            this.functionId = 0;
            this.pcOffset = 0L;
            this.samples = 0L;
            this.stallReason = CuptiActivityPCSamplingStallReason.CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALID.getCode();
        }
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        NativeCupti.cuptiPDMAppendActivity(hPdm, this);
    }

    public CuptiActivityPCSamplingStallReason getStallReason() {
        return CuptiActivityPCSamplingStallReason.valueOf(this.stallReason);
    }

    @Override
    public boolean isNullResult() {
        return this.sourceLocatorId == 0 && this.pcOffset == 0L && this.functionId == 0 && this.samples == 0L && this.stallReason == CuptiActivityPCSamplingStallReason.CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALID.getCode();
    }

    @Override
    public int getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public void setCorrelationId(int id) {
        this.correlationId = id;
    }

    @Override
    public int getSourceLocatorId() {
        return this.sourceLocatorId;
    }

    @Override
    public void setSourceLocatorId(int id) {
        this.sourceLocatorId = id;
    }

    @Override
    public int getFunctionId() {
        return this.functionId;
    }

    @Override
    public void setFunctionId(int id) {
        this.functionId = id;
    }

    @Override
    public long getPcOffset() {
        return this.pcOffset;
    }
}

