/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.editor.AbstractViewerColumnsManager;
import com.nvidia.viper.editor.IViewerColumnsManager;
import com.nvidia.viper.editor.SourceSassColumnControl;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.editor.ViewerControl;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.ui.ViperViewerBase;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SelectHotSpotAction
extends Action
implements IMenuCreator {
    private SourceSassEditor editor;
    private Menu menu;
    public static String ID = "com.nvidia.viper.showhotspot";
    private static final String PREFIX_TITLE = "Hot Spot - %s";
    private static final String DEFAULT_TITLE = String.format("Hot Spot - %s", "None");

    public SelectHotSpotAction() {
        super(DEFAULT_TITLE, 4);
        this.setText(DEFAULT_TITLE);
        this.setToolTipText("Select analysis for viewing hot spot");
        this.setId(ID);
        this.setMenuCreator(this);
    }

    public void run() {
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = new Menu(parent);
            this.fillMenu();
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void setEditor(SourceSassEditor editor) {
        if (this.editor != editor) {
            this.editor = editor;
            this.menu = null;
            this.setTitle();
            this.setColumnListeners();
        }
    }

    private void setColumnListeners() {
        final List<AnalysisResultSourceLevelKind> sourceLevelResultsKind = AnalysisResultSourceLevelKind.getResultsMenu(this.getComputeCapabilityMajor());
        for (final AnalysisResultSourceLevelKind sourceLevelResultKind : sourceLevelResultsKind) {
            IViewerColumnsManager viewerColumnsManager = sourceLevelResultKind.getColumnsManager(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL);
            if (!(viewerColumnsManager instanceof ModelWithProperties)) continue;
            ((ModelWithProperties)((Object)viewerColumnsManager)).addPropertyChangeListener(new ISessionPropertyChangeListener(){

                @Override
                public void propertyChange(IModel model, String propertyName) {
                    if (propertyName.equals(AbstractViewerColumnsManager.PROPERTY_COLUMN_DISABLED) || propertyName.equals(AbstractViewerColumnsManager.PROPERTY_COLUMN_ENABLED)) {
                        AnalysisResultSourceLevelKind currentKind = SelectHotSpotAction.this.getCurrentEnabledAnalysis(sourceLevelResultsKind);
                        if (propertyName.equals(AbstractViewerColumnsManager.PROPERTY_COLUMN_DISABLED)) {
                            if (sourceLevelResultKind.equals((Object)SelectHotSpotAction.this.getCurrentAnnotationKind())) {
                                if (currentKind != null) {
                                    SelectHotSpotAction.this.setText(String.format(SelectHotSpotAction.PREFIX_TITLE, currentKind.getLabel()));
                                    SelectHotSpotAction.this.createAnnotations(currentKind);
                                } else {
                                    SelectHotSpotAction.this.setText(DEFAULT_TITLE);
                                    SelectHotSpotAction.this.removeAnnotations();
                                }
                            }
                        } else if (currentKind != null) {
                            SelectHotSpotAction.this.setText(String.format(SelectHotSpotAction.PREFIX_TITLE, currentKind.getLabel()));
                            SelectHotSpotAction.this.createAnnotations(currentKind);
                        } else {
                            SelectHotSpotAction.this.setTitle();
                        }
                        if (SelectHotSpotAction.this.menu != null && !SelectHotSpotAction.this.menu.isDisposed()) {
                            MenuItem[] items;
                            MenuItem[] menuItemArray = items = SelectHotSpotAction.this.menu.getItems();
                            int n = items.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MenuItem item = menuItemArray[n2];
                                if (String.format(SelectHotSpotAction.PREFIX_TITLE, item.getText()).equals(SelectHotSpotAction.this.getText())) {
                                    item.setEnabled(true);
                                    item.setSelection(true);
                                } else if (item.getText().equals(sourceLevelResultKind.getLabel())) {
                                    item.setEnabled(propertyName.equals(AbstractViewerColumnsManager.PROPERTY_COLUMN_ENABLED));
                                    item.setSelection(false);
                                } else {
                                    item.setSelection(false);
                                }
                                ++n2;
                            }
                        }
                    }
                }
            });
        }
    }

    private AnalysisResultSourceLevelKind getCurrentEnabledAnalysis(List<AnalysisResultSourceLevelKind> sourceLevelResultsKind) {
        SourceSassColumnControl columnControl = this.editor.getViewerControl(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL).getColumnControl();
        int numEnabled = 0;
        AnalysisResultSourceLevelKind currentKind = null;
        for (AnalysisResultSourceLevelKind resultKind : sourceLevelResultsKind) {
            IViewerColumnsManager columnsManager = resultKind.getColumnsManager(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL);
            if (columnsManager.isVisible(columnControl)) {
                currentKind = resultKind;
                ++numEnabled;
            }
            if (numEnabled <= 1) continue;
            return null;
        }
        return currentKind;
    }

    private void setTitle() {
        AnalysisResultSourceLevelKind currentAnnotationKind = this.getCurrentAnnotationKind();
        if (currentAnnotationKind != null) {
            this.setText(String.format(PREFIX_TITLE, currentAnnotationKind.getLabel()));
        } else {
            this.setText(DEFAULT_TITLE);
        }
    }

    private AnalysisResultSourceLevelKind getCurrentAnnotationKind() {
        ViperViewerBase viewer = this.editor.getViewerControl(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL).getViewer();
        AnalysisResultSourceLevelKind currentAnnotationKind = viewer.getCurrentAnnotationKind();
        return currentAnnotationKind;
    }

    private int getComputeCapabilityMajor() {
        AnalysisResultSourceLevel sourceLevelResult = this.editor.getSourceSassModel().getAnalysisResultSourceLevel();
        return sourceLevelResult.getKernel().getMajorComputeCapability();
    }

    private void fillMenu() {
        List<AnalysisResultSourceLevelKind> sourceLevelResultsKind = AnalysisResultSourceLevelKind.getResultsMenu(this.getComputeCapabilityMajor());
        SourceSassColumnControl columnControl = this.editor.getViewerControl(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL).getColumnControl();
        for (final AnalysisResultSourceLevelKind sourceLevelResultKind : sourceLevelResultsKind) {
            final MenuItem item = new MenuItem(this.menu, 16);
            item.setText(sourceLevelResultKind.getLabel());
            IViewerColumnsManager viewerColumnsManager = sourceLevelResultKind.getColumnsManager(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL);
            item.setEnabled(viewerColumnsManager.isVisible(columnControl));
            if (String.format(PREFIX_TITLE, item.getText()).equals(this.getText())) {
                item.setSelection(true);
            }
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (item.getSelection()) {
                        SelectHotSpotAction.this.createAnnotations(sourceLevelResultKind);
                        SelectHotSpotAction.this.setText(String.format(SelectHotSpotAction.PREFIX_TITLE, item.getText()));
                    } else {
                        SelectHotSpotAction.this.removeAnnotations();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void removeAnnotations() {
        ViperViewerBase viewer;
        ViewerControl viewerControl = this.editor.getViewerControl(ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL);
        if (viewerControl != null) {
            viewer = viewerControl.getViewer();
            viewer.removeAnnotations();
        }
        viewer = this.editor.getViewerControl(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL).getViewer();
        viewer.removeAnnotations();
    }

    public void createAnnotations(AnalysisResultSourceLevelKind sourceLevelResultKind) {
        ViperViewerBase viewer;
        ViewerControl viewerControl = this.editor.getViewerControl(ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL);
        if (viewerControl != null) {
            viewer = viewerControl.getViewer();
            IViewerColumnsManager sourceViewerColumnsManager = sourceLevelResultKind.getColumnsManager(ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL);
            if (sourceViewerColumnsManager != null) {
                sourceViewerColumnsManager.createAnnotations(viewer, viewer.getAnnotationModel());
            }
        }
        viewer = this.editor.getViewerControl(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL).getViewer();
        sourceLevelResultKind.getColumnsManager(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL).createAnnotations(viewer, viewer.getAnnotationModel());
    }
}

