/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.IViperJobListener;
import com.nvidia.viper.ui.NonModalProgressMonitorDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;

public abstract class ViperJob {
    private final String name;
    private IStatus result = null;
    private ListenerList listeners = new ListenerList();
    private final ProgressMonitorDialog dialog;
    private final IProgressMonitor monitor;

    public ViperJob(String name) {
        this.name = name;
        this.dialog = new NonModalProgressMonitorDialog(Display.getDefault().getActiveShell());
        this.dialog.setBlockOnOpen(false);
        this.dialog.setCancelable(true);
        this.monitor = new WrappedProgressMonitor(this.dialog.getProgressMonitor(), Display.getDefault());
    }

    public void addJobListener(IViperJobListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeJobListener(IViperJobListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus getResult() {
        ViperJob viperJob = this;
        synchronized (viperJob) {
            return this.result;
        }
    }

    public void schedule() {
        this.dialog.open();
        Thread thd = new Thread(this.name){

            @Override
            public void run() {
                IStatus status = ViperJob.this.run(ViperJob.this.monitor);
                ViperJob.this.closeProgress();
                ViperJob.this.setResult(status);
                Object[] llist = ViperJob.this.listeners.getListeners();
                int i = 0;
                while (i < llist.length) {
                    ((IViperJobListener)llist[i]).done();
                    ++i;
                }
            }
        };
        thd.start();
    }

    protected abstract IStatus run(IProgressMonitor var1);

    public void cancelJob() {
        this.monitor.setCanceled(true);
        this.closeProgress();
        this.setResult(Status.CANCEL_STATUS);
    }

    private void closeProgress() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ViperJob.this.monitor.done();
                ViperJob.this.dialog.close();
            }
        });
    }

    private synchronized void setResult(IStatus status) {
        this.result = status;
    }

    private class WrappedProgressMonitor
    extends ProgressMonitorWrapper {
        private Display display;

        public WrappedProgressMonitor(IProgressMonitor monitor, Display display) {
            super(monitor);
            this.display = display;
        }

        public void beginTask(final String name, final int totalWork) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    WrappedProgressMonitor.this.getWrappedProgressMonitor().beginTask(name, totalWork);
                }
            });
        }

        public void done() {
            if (!this.display.isDisposed()) {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WrappedProgressMonitor.this.getWrappedProgressMonitor().done();
                    }
                });
            }
        }

        public void internalWorked(final double work) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    WrappedProgressMonitor.this.getWrappedProgressMonitor().internalWorked(work);
                }
            });
        }

        public void setTaskName(final String name) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    WrappedProgressMonitor.this.getWrappedProgressMonitor().setTaskName(name);
                }
            });
        }

        public void subTask(final String name) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    WrappedProgressMonitor.this.getWrappedProgressMonitor().subTask(name);
                }
            });
        }

        public void worked(final int work) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    WrappedProgressMonitor.this.getWrappedProgressMonitor().worked(work);
                }
            });
        }

        public void setBlocked(final IStatus reason) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WrappedProgressMonitor.this.getWrappedProgressMonitor() instanceof IProgressMonitorWithBlocking) {
                        ((IProgressMonitorWithBlocking)WrappedProgressMonitor.this.getWrappedProgressMonitor()).setBlocked(reason);
                    }
                }
            });
        }

        public void clearBlocked() {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WrappedProgressMonitor.this.getWrappedProgressMonitor() instanceof IProgressMonitorWithBlocking) {
                        ((IProgressMonitorWithBlocking)WrappedProgressMonitor.this.getWrappedProgressMonitor()).clearBlocked();
                    }
                }
            });
        }
    }
}

