"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstantBackoff = void 0;
class ConstantBackoff {
    /**
     * Backoff that returns a constant interval.
     */
    constructor(interval) {
        this.interval = interval;
    }
    /**
     * @inheritdoc
     */
    next() {
        return instance(this.interval);
    }
}
exports.ConstantBackoff = ConstantBackoff;
const instance = (interval) => ({
    duration: interval,
    next() {
        return this;
    },
});//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/488a1f239235055e34e673291fb8d8c810886f81/node_modules/cockatiel/dist/backoff/ConstantBackoff.js.map