/*! @azure/msal-browser v4.16.0 2025-07-23 */
"use strict";!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).msal={})}(this,(function(e){
/*! @azure/msal-common v15.9.0 2025-07-23 */
const t={LIBRARY_NAME:"MSAL.JS",SKU:"msal.js.common",CACHE_PREFIX:"msal",DEFAULT_AUTHORITY:"https://login.microsoftonline.com/common/",DEFAULT_AUTHORITY_HOST:"login.microsoftonline.com",DEFAULT_COMMON_TENANT:"common",ADFS:"adfs",DSTS:"dstsv2",AAD_INSTANCE_DISCOVERY_ENDPT:"https://login.microsoftonline.com/common/discovery/instance?api-version=1.1&authorization_endpoint=",CIAM_AUTH_URL:".ciamlogin.com",AAD_TENANT_DOMAIN_SUFFIX:".onmicrosoft.com",RESOURCE_DELIM:"|",NO_ACCOUNT:"NO_ACCOUNT",CLAIMS:"claims",CONSUMER_UTID:"9188040d-6c67-4c5b-b112-36a304b66dad",OPENID_SCOPE:"openid",PROFILE_SCOPE:"profile",OFFLINE_ACCESS_SCOPE:"offline_access",EMAIL_SCOPE:"email",CODE_GRANT_TYPE:"authorization_code",RT_GRANT_TYPE:"refresh_token",S256_CODE_CHALLENGE_METHOD:"S256",URL_FORM_CONTENT_TYPE:"application/x-www-form-urlencoded;charset=utf-8",AUTHORIZATION_PENDING:"authorization_pending",NOT_DEFINED:"not_defined",EMPTY_STRING:"",NOT_APPLICABLE:"N/A",NOT_AVAILABLE:"Not Available",FORWARD_SLASH:"/",IMDS_ENDPOINT:"http://169.254.169.254/metadata/instance/compute/location",IMDS_VERSION:"2020-06-01",IMDS_TIMEOUT:2e3,AZURE_REGION_AUTO_DISCOVER_FLAG:"TryAutoDetect",REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX:"login.microsoft.com",KNOWN_PUBLIC_CLOUDS:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"],SHR_NONCE_VALIDITY:240,INVALID_INSTANCE:"invalid_instance"},r=200,n=400,o=400,i=499,s=500,a=599,c="GET",l="POST",h=[t.OPENID_SCOPE,t.PROFILE_SCOPE,t.OFFLINE_ACCESS_SCOPE],d=[...h,t.EMAIL_SCOPE],u="Content-Type",g="Content-Length",p="Retry-After",m="X-AnchorMailbox",f="WWW-Authenticate",y="Authentication-Info",C="x-ms-request-id",v="x-ms-httpver",w="active-account-filters",I="common",T="organizations",A="consumers",k="access_token",S="xms_cc",b={LOGIN:"login",SELECT_ACCOUNT:"select_account",CONSENT:"consent",NONE:"none",CREATE:"create",NO_SESSION:"no_session"},E="code",R="id_token token refresh_token",_={QUERY:"query",FRAGMENT:"fragment"},P="query",M="authorization_code",O="refresh_token",q="MSSTS",N="ADFS",L="Generic",U="-",H=".",x={ID_TOKEN:"IdToken",ACCESS_TOKEN:"AccessToken",ACCESS_TOKEN_WITH_AUTH_SCHEME:"AccessToken_With_AuthScheme",REFRESH_TOKEN:"RefreshToken"},D="appmetadata",B="1",F="authority-metadata",z=86400,K="config",G="cache",$="network",Q="hardcoded_values",j={SCHEMA_VERSION:5,MAX_LAST_HEADER_BYTES:330,MAX_CACHED_ERRORS:50,CACHE_KEY:"server-telemetry",CATEGORY_SEPARATOR:"|",VALUE_SEPARATOR:",",OVERFLOW_TRUE:"1",OVERFLOW_FALSE:"0",UNKNOWN_ERROR:"unknown_error"},W={BEARER:"Bearer",POP:"pop",SSH:"ssh-cert"},V=60,J=3600,Y="throttling",X="retry-after, h429",Z="invalid_grant",ee="client_mismatch",te="1",re="3",ne="4",oe="2",ie="4",se="5",ae="0",ce="1",le="2",he="3",de="4",ue={Jwt:"JWT",Jwk:"JWK",Pop:"pop"},ge="unexpected_error",pe="post_request_failed";var me=Object.freeze({__proto__:null,postRequestFailed:pe,unexpectedError:ge});
/*! @azure/msal-common v15.9.0 2025-07-23 */const fe={[ge]:"Unexpected error in authentication.",[pe]:"Post request failed from the network, could be a 4xx/5xx or a network unavailability. Please check the exact error code for details."},ye={unexpectedError:{code:ge,desc:fe[ge]},postRequestFailed:{code:pe,desc:fe[pe]}};class Ce extends Error{constructor(e,r,n){super(r?`${e}: ${r}`:e),Object.setPrototypeOf(this,Ce.prototype),this.errorCode=e||t.EMPTY_STRING,this.errorMessage=r||t.EMPTY_STRING,this.subError=n||t.EMPTY_STRING,this.name="AuthError"}setCorrelationId(e){this.correlationId=e}}function ve(e,t){return new Ce(e,t?`${fe[e]} ${t}`:fe[e])}
/*! @azure/msal-common v15.9.0 2025-07-23 */const we="client_info_decoding_error",Ie="client_info_empty_error",Te="token_parsing_error",Ae="null_or_empty_token",ke="endpoints_resolution_error",Se="network_error",be="openid_config_error",Ee="hash_not_deserialized",Re="invalid_state",_e="state_mismatch",Pe="state_not_found",Me="nonce_mismatch",Oe="auth_time_not_found",qe="max_age_transpired",Ne="multiple_matching_tokens",Le="multiple_matching_accounts",Ue="multiple_matching_appMetadata",He="request_cannot_be_made",xe="cannot_remove_empty_scope",De="cannot_append_scopeset",Be="empty_input_scopeset",Fe="device_code_polling_cancelled",ze="device_code_expired",Ke="device_code_unknown_error",Ge="no_account_in_silent_request",$e="invalid_cache_record",Qe="invalid_cache_environment",je="no_account_found",We="no_crypto_object",Ve="unexpected_credential_type",Je="invalid_assertion",Ye="invalid_client_credential",Xe="token_refresh_required",Ze="user_timeout_reached",et="token_claims_cnf_required_for_signedjwt",tt="authorization_code_missing_from_server_response",rt="binding_key_not_removed",nt="end_session_endpoint_not_supported",ot="key_id_missing",it="no_network_connectivity",st="user_canceled",at="missing_tenant_id_error",ct="method_not_implemented",lt="nested_app_auth_bridge_disabled";var ht=Object.freeze({__proto__:null,authTimeNotFound:Oe,authorizationCodeMissingFromServerResponse:tt,bindingKeyNotRemoved:rt,cannotAppendScopeSet:De,cannotRemoveEmptyScope:xe,clientInfoDecodingError:we,clientInfoEmptyError:Ie,deviceCodeExpired:ze,deviceCodePollingCancelled:Fe,deviceCodeUnknownError:Ke,emptyInputScopeSet:Be,endSessionEndpointNotSupported:nt,endpointResolutionError:ke,hashNotDeserialized:Ee,invalidAssertion:Je,invalidCacheEnvironment:Qe,invalidCacheRecord:$e,invalidClientCredential:Ye,invalidState:Re,keyIdMissing:ot,maxAgeTranspired:qe,methodNotImplemented:ct,missingTenantIdError:at,multipleMatchingAccounts:Le,multipleMatchingAppMetadata:Ue,multipleMatchingTokens:Ne,nestedAppAuthBridgeDisabled:lt,networkError:Se,noAccountFound:je,noAccountInSilentRequest:Ge,noCryptoObject:We,noNetworkConnectivity:it,nonceMismatch:Me,nullOrEmptyToken:Ae,openIdConfigError:be,requestCannotBeMade:He,stateMismatch:_e,stateNotFound:Pe,tokenClaimsCnfRequiredForSignedJwt:et,tokenParsingError:Te,tokenRefreshRequired:Xe,unexpectedCredentialType:Ve,userCanceled:st,userTimeoutReached:Ze});
/*! @azure/msal-common v15.9.0 2025-07-23 */const dt={[we]:"The client info could not be parsed/decoded correctly",[Ie]:"The client info was empty",[Te]:"Token cannot be parsed",[Ae]:"The token is null or empty",[ke]:"Endpoints cannot be resolved",[Se]:"Network request failed",[be]:"Could not retrieve endpoints. Check your authority and verify the .well-known/openid-configuration endpoint returns the required endpoints.",[Ee]:"The hash parameters could not be deserialized",[Re]:"State was not the expected format",[_e]:"State mismatch error",[Pe]:"State not found",[Me]:"Nonce mismatch error",[Oe]:"Max Age was requested and the ID token is missing the auth_time variable. auth_time is an optional claim and is not enabled by default - it must be enabled. See https://aka.ms/msaljs/optional-claims for more information.",[qe]:"Max Age is set to 0, or too much time has elapsed since the last end-user authentication.",[Ne]:"The cache contains multiple tokens satisfying the requirements. Call AcquireToken again providing more requirements such as authority or account.",[Le]:"The cache contains multiple accounts satisfying the given parameters. Please pass more info to obtain the correct account",[Ue]:"The cache contains multiple appMetadata satisfying the given parameters. Please pass more info to obtain the correct appMetadata",[He]:"Token request cannot be made without authorization code or refresh token.",[xe]:"Cannot remove null or empty scope from ScopeSet",[De]:"Cannot append ScopeSet",[Be]:"Empty input ScopeSet cannot be processed",[Fe]:"Caller has cancelled token endpoint polling during device code flow by setting DeviceCodeRequest.cancel = true.",[ze]:"Device code is expired.",[Ke]:"Device code stopped polling for unknown reasons.",[Ge]:"Please pass an account object, silent flow is not supported without account information",[$e]:"Cache record object was null or undefined.",[Qe]:"Invalid environment when attempting to create cache entry",[je]:"No account found in cache for given key.",[We]:"No crypto object detected.",[Ve]:"Unexpected credential type.",[Je]:"Client assertion must meet requirements described in https://tools.ietf.org/html/rfc7515",[Ye]:"Client credential (secret, certificate, or assertion) must not be empty when creating a confidential client. An application should at most have one credential",[Xe]:"Cannot return token from cache because it must be refreshed. This may be due to one of the following reasons: forceRefresh parameter is set to true, claims have been requested, there is no cached access token or it is expired.",[Ze]:"User defined timeout for device code polling reached",[et]:"Cannot generate a POP jwt if the token_claims are not populated",[tt]:"Server response does not contain an authorization code to proceed",[rt]:"Could not remove the credential's binding key from storage.",[nt]:"The provided authority does not support logout",[ot]:"A keyId value is missing from the requested bound token's cache record and is required to match the token to it's stored binding key.",[it]:"No network connectivity. Check your internet connection.",[st]:"User cancelled the flow.",[at]:"A tenant id - not common, organizations, or consumers - must be specified when using the client_credentials flow.",[ct]:"This method has not been implemented",[lt]:"The nested app auth bridge is disabled"},ut={clientInfoDecodingError:{code:we,desc:dt[we]},clientInfoEmptyError:{code:Ie,desc:dt[Ie]},tokenParsingError:{code:Te,desc:dt[Te]},nullOrEmptyToken:{code:Ae,desc:dt[Ae]},endpointResolutionError:{code:ke,desc:dt[ke]},networkError:{code:Se,desc:dt[Se]},unableToGetOpenidConfigError:{code:be,desc:dt[be]},hashNotDeserialized:{code:Ee,desc:dt[Ee]},invalidStateError:{code:Re,desc:dt[Re]},stateMismatchError:{code:_e,desc:dt[_e]},stateNotFoundError:{code:Pe,desc:dt[Pe]},nonceMismatchError:{code:Me,desc:dt[Me]},authTimeNotFoundError:{code:Oe,desc:dt[Oe]},maxAgeTranspired:{code:qe,desc:dt[qe]},multipleMatchingTokens:{code:Ne,desc:dt[Ne]},multipleMatchingAccounts:{code:Le,desc:dt[Le]},multipleMatchingAppMetadata:{code:Ue,desc:dt[Ue]},tokenRequestCannotBeMade:{code:He,desc:dt[He]},removeEmptyScopeError:{code:xe,desc:dt[xe]},appendScopeSetError:{code:De,desc:dt[De]},emptyInputScopeSetError:{code:Be,desc:dt[Be]},DeviceCodePollingCancelled:{code:Fe,desc:dt[Fe]},DeviceCodeExpired:{code:ze,desc:dt[ze]},DeviceCodeUnknownError:{code:Ke,desc:dt[Ke]},NoAccountInSilentRequest:{code:Ge,desc:dt[Ge]},invalidCacheRecord:{code:$e,desc:dt[$e]},invalidCacheEnvironment:{code:Qe,desc:dt[Qe]},noAccountFound:{code:je,desc:dt[je]},noCryptoObj:{code:We,desc:dt[We]},unexpectedCredentialType:{code:Ve,desc:dt[Ve]},invalidAssertion:{code:Je,desc:dt[Je]},invalidClientCredential:{code:Ye,desc:dt[Ye]},tokenRefreshRequired:{code:Xe,desc:dt[Xe]},userTimeoutReached:{code:Ze,desc:dt[Ze]},tokenClaimsRequired:{code:et,desc:dt[et]},noAuthorizationCodeFromServer:{code:tt,desc:dt[tt]},bindingKeyNotRemovedError:{code:rt,desc:dt[rt]},logoutNotSupported:{code:nt,desc:dt[nt]},keyIdMissing:{code:ot,desc:dt[ot]},noNetworkConnectivity:{code:it,desc:dt[it]},userCanceledError:{code:st,desc:dt[st]},missingTenantIdError:{code:at,desc:dt[at]},nestedAppAuthBridgeDisabled:{code:lt,desc:dt[lt]}};class gt extends Ce{constructor(e,t){super(e,t?`${dt[e]}: ${t}`:dt[e]),this.name="ClientAuthError",Object.setPrototypeOf(this,gt.prototype)}}function pt(e,t){return new gt(e,t)}
/*! @azure/msal-common v15.9.0 2025-07-23 */const mt={createNewGuid:()=>{throw pt(ct)},base64Decode:()=>{throw pt(ct)},base64Encode:()=>{throw pt(ct)},base64UrlEncode:()=>{throw pt(ct)},encodeKid:()=>{throw pt(ct)},async getPublicKeyThumbprint(){throw pt(ct)},async removeTokenBindingKey(){throw pt(ct)},async clearKeystore(){throw pt(ct)},async signJwt(){throw pt(ct)},async hashString(){throw pt(ct)}};
/*! @azure/msal-common v15.9.0 2025-07-23 */var ft;e.LogLevel=void 0,(ft=e.LogLevel||(e.LogLevel={}))[ft.Error=0]="Error",ft[ft.Warning=1]="Warning",ft[ft.Info=2]="Info",ft[ft.Verbose=3]="Verbose",ft[ft.Trace=4]="Trace";class yt{constructor(r,n,o){this.level=e.LogLevel.Info;const i=r||yt.createDefaultLoggerOptions();this.localCallback=i.loggerCallback||(()=>{}),this.piiLoggingEnabled=i.piiLoggingEnabled||!1,this.level="number"==typeof i.logLevel?i.logLevel:e.LogLevel.Info,this.correlationId=i.correlationId||t.EMPTY_STRING,this.packageName=n||t.EMPTY_STRING,this.packageVersion=o||t.EMPTY_STRING}static createDefaultLoggerOptions(){return{loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:e.LogLevel.Info}}clone(e,t,r){return new yt({loggerCallback:this.localCallback,piiLoggingEnabled:this.piiLoggingEnabled,logLevel:this.level,correlationId:r||this.correlationId},e,t)}logMessage(t,r){if(r.logLevel>this.level||!this.piiLoggingEnabled&&r.containsPii)return;const n=`${`[${(new Date).toUTCString()}] : [${r.correlationId||this.correlationId||""}]`} : ${this.packageName}@${this.packageVersion} : ${e.LogLevel[r.logLevel]} - ${t}`;this.executeCallback(r.logLevel,n,r.containsPii||!1)}executeCallback(e,t,r){this.localCallback&&this.localCallback(e,t,r)}error(r,n){this.logMessage(r,{logLevel:e.LogLevel.Error,containsPii:!1,correlationId:n||t.EMPTY_STRING})}errorPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Error,containsPii:!0,correlationId:n||t.EMPTY_STRING})}warning(r,n){this.logMessage(r,{logLevel:e.LogLevel.Warning,containsPii:!1,correlationId:n||t.EMPTY_STRING})}warningPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Warning,containsPii:!0,correlationId:n||t.EMPTY_STRING})}info(r,n){this.logMessage(r,{logLevel:e.LogLevel.Info,containsPii:!1,correlationId:n||t.EMPTY_STRING})}infoPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Info,containsPii:!0,correlationId:n||t.EMPTY_STRING})}verbose(r,n){this.logMessage(r,{logLevel:e.LogLevel.Verbose,containsPii:!1,correlationId:n||t.EMPTY_STRING})}verbosePii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Verbose,containsPii:!0,correlationId:n||t.EMPTY_STRING})}trace(r,n){this.logMessage(r,{logLevel:e.LogLevel.Trace,containsPii:!1,correlationId:n||t.EMPTY_STRING})}tracePii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Trace,containsPii:!0,correlationId:n||t.EMPTY_STRING})}isPiiLoggingEnabled(){return this.piiLoggingEnabled||!1}}
/*! @azure/msal-common v15.9.0 2025-07-23 */const Ct="@azure/msal-common",vt="15.9.0",wt={None:"none",AzurePublic:"https://login.microsoftonline.com",AzurePpe:"https://login.windows-ppe.net",AzureChina:"https://login.chinacloudapi.cn",AzureGermany:"https://login.microsoftonline.de",AzureUsGovernment:"https://login.microsoftonline.us"};
/*! @azure/msal-common v15.9.0 2025-07-23 */
function It(e,t){const r=function(e){if(!e)throw pt(Ae);const t=/^([^\.\s]*)\.([^\.\s]+)\.([^\.\s]*)$/.exec(e);if(!t||t.length<4)throw pt(Te);return t[2]}(e);try{const e=t(r);return JSON.parse(e)}catch(e){throw pt(Te)}}function Tt(e,t){if(0===t||Date.now()-3e5>e+t)throw pt(qe)}
/*! @azure/msal-common v15.9.0 2025-07-23 */function At(){return Math.round((new Date).getTime()/1e3)}function kt(e){return e.getTime()/1e3}function St(e){return e?new Date(1e3*Number(e)):new Date}function bt(e,t){const r=Number(e)||0;return At()+t>r}function Et(e){return Number(e)>At()}
/*! @azure/msal-common v15.9.0 2025-07-23 */function Rt(e){return[qt(e),Nt(e),Lt(e),Ut(e),Ht(e)].join(U).toLowerCase()}function _t(e,t,r,n,o){return{credentialType:x.ID_TOKEN,homeAccountId:e,environment:t,clientId:n,secret:r,realm:o}}function Pt(e,t,r,n,o,i,s,a,c,l,h,d,u,g,p){const m={homeAccountId:e,credentialType:x.ACCESS_TOKEN,secret:r,cachedAt:At().toString(),expiresOn:s.toString(),extendedExpiresOn:a.toString(),environment:t,clientId:n,realm:o,target:i,tokenType:h||W.BEARER};if(d&&(m.userAssertionHash=d),l&&(m.refreshOn=l.toString()),g&&(m.requestedClaims=g,m.requestedClaimsHash=p),m.tokenType?.toLowerCase()!==W.BEARER.toLowerCase())switch(m.credentialType=x.ACCESS_TOKEN_WITH_AUTH_SCHEME,m.tokenType){case W.POP:const e=It(r,c);if(!e?.cnf?.kid)throw pt(et);m.keyId=e.cnf.kid;break;case W.SSH:m.keyId=u}return m}function Mt(e,t,r,n,o,i,s){const a={credentialType:x.REFRESH_TOKEN,homeAccountId:e,environment:t,clientId:n,secret:r};return i&&(a.userAssertionHash=i),o&&(a.familyId=o),s&&(a.expiresOn=s.toString()),a}function Ot(e){return e.hasOwnProperty("homeAccountId")&&e.hasOwnProperty("environment")&&e.hasOwnProperty("credentialType")&&e.hasOwnProperty("clientId")&&e.hasOwnProperty("secret")}function qt(e){return[e.homeAccountId,e.environment].join(U).toLowerCase()}function Nt(e){const t=e.credentialType===x.REFRESH_TOKEN&&e.familyId||e.clientId;return[e.credentialType,t,e.realm||""].join(U).toLowerCase()}function Lt(e){return(e.target||"").toLowerCase()}function Ut(e){return(e.requestedClaimsHash||"").toLowerCase()}function Ht(e){return e.tokenType&&e.tokenType.toLowerCase()!==W.BEARER.toLowerCase()?e.tokenType.toLowerCase():""}function xt(){return At()+z}function Dt(e,t,r){e.authorization_endpoint=t.authorization_endpoint,e.token_endpoint=t.token_endpoint,e.end_session_endpoint=t.end_session_endpoint,e.issuer=t.issuer,e.endpointsFromNetwork=r,e.jwks_uri=t.jwks_uri}function Bt(e,t,r){e.aliases=t.aliases,e.preferred_cache=t.preferred_cache,e.preferred_network=t.preferred_network,e.aliasesFromNetwork=r}function Ft(e){return e.expiresAt<=At()}
/*! @azure/msal-common v15.9.0 2025-07-23 */const zt="redirect_uri_empty",Kt="claims_request_parsing_error",Gt="authority_uri_insecure",$t="url_parse_error",Qt="empty_url_error",jt="empty_input_scopes_error",Wt="invalid_claims",Vt="token_request_empty",Jt="logout_request_empty",Yt="invalid_code_challenge_method",Xt="pkce_params_missing",Zt="invalid_cloud_discovery_metadata",er="invalid_authority_metadata",tr="untrusted_authority",rr="missing_ssh_jwk",nr="missing_ssh_kid",or="missing_nonce_authentication_header",ir="invalid_authentication_header",sr="cannot_set_OIDCOptions",ar="cannot_allow_platform_broker",cr="authority_mismatch",lr="invalid_request_method_for_EAR",hr="invalid_authorize_post_body_parameters";var dr=Object.freeze({__proto__:null,authorityMismatch:cr,authorityUriInsecure:Gt,cannotAllowPlatformBroker:ar,cannotSetOIDCOptions:sr,claimsRequestParsingError:Kt,emptyInputScopesError:jt,invalidAuthenticationHeader:ir,invalidAuthorityMetadata:er,invalidAuthorizePostBodyParameters:hr,invalidClaims:Wt,invalidCloudDiscoveryMetadata:Zt,invalidCodeChallengeMethod:Yt,invalidRequestMethodForEAR:lr,logoutRequestEmpty:Jt,missingNonceAuthenticationHeader:or,missingSshJwk:rr,missingSshKid:nr,pkceParamsMissing:Xt,redirectUriEmpty:zt,tokenRequestEmpty:Vt,untrustedAuthority:tr,urlEmptyError:Qt,urlParseError:$t});
/*! @azure/msal-common v15.9.0 2025-07-23 */const ur={[zt]:"A redirect URI is required for all calls, and none has been set.",[Kt]:"Could not parse the given claims request object.",[Gt]:"Authority URIs must use https.  Please see here for valid authority configuration options: https://docs.microsoft.com/en-us/azure/active-directory/develop/msal-js-initializing-client-applications#configuration-options",[$t]:"URL could not be parsed into appropriate segments.",[Qt]:"URL was empty or null.",[jt]:"Scopes cannot be passed as null, undefined or empty array because they are required to obtain an access token.",[Wt]:"Given claims parameter must be a stringified JSON object.",[Vt]:"Token request was empty and not found in cache.",[Jt]:"The logout request was null or undefined.",[Yt]:'code_challenge_method passed is invalid. Valid values are "plain" and "S256".',[Xt]:"Both params: code_challenge and code_challenge_method are to be passed if to be sent in the request",[Zt]:"Invalid cloudDiscoveryMetadata provided. Must be a stringified JSON object containing tenant_discovery_endpoint and metadata fields",[er]:"Invalid authorityMetadata provided. Must by a stringified JSON object containing authorization_endpoint, token_endpoint, issuer fields.",[tr]:"The provided authority is not a trusted authority. Please include this authority in the knownAuthorities config parameter.",[rr]:"Missing sshJwk in SSH certificate request. A stringified JSON Web Key is required when using the SSH authentication scheme.",[nr]:"Missing sshKid in SSH certificate request. A string that uniquely identifies the public SSH key is required when using the SSH authentication scheme.",[or]:"Unable to find an authentication header containing server nonce. Either the Authentication-Info or WWW-Authenticate headers must be present in order to obtain a server nonce.",[ir]:"Invalid authentication header provided",[sr]:"Cannot set OIDCOptions parameter. Please change the protocol mode to OIDC or use a non-Microsoft authority.",[ar]:"Cannot set allowPlatformBroker parameter to true when not in AAD protocol mode.",[cr]:"Authority mismatch error. Authority provided in login request or PublicClientApplication config does not match the environment of the provided account. Please use a matching account or make an interactive request to login to this authority.",[hr]:"Invalid authorize post body parameters provided. If you are using authorizePostBodyParameters, the request method must be POST. Please check the request method and parameters.",[lr]:"Invalid request method for EAR protocol mode. The request method cannot be GET when using EAR protocol mode. Please change the request method to POST."},gr={redirectUriNotSet:{code:zt,desc:ur[zt]},claimsRequestParsingError:{code:Kt,desc:ur[Kt]},authorityUriInsecure:{code:Gt,desc:ur[Gt]},urlParseError:{code:$t,desc:ur[$t]},urlEmptyError:{code:Qt,desc:ur[Qt]},emptyScopesError:{code:jt,desc:ur[jt]},invalidClaimsRequest:{code:Wt,desc:ur[Wt]},tokenRequestEmptyError:{code:Vt,desc:ur[Vt]},logoutRequestEmptyError:{code:Jt,desc:ur[Jt]},invalidCodeChallengeMethod:{code:Yt,desc:ur[Yt]},invalidCodeChallengeParams:{code:Xt,desc:ur[Xt]},invalidCloudDiscoveryMetadata:{code:Zt,desc:ur[Zt]},invalidAuthorityMetadata:{code:er,desc:ur[er]},untrustedAuthority:{code:tr,desc:ur[tr]},missingSshJwk:{code:rr,desc:ur[rr]},missingSshKid:{code:nr,desc:ur[nr]},missingNonceAuthenticationHeader:{code:or,desc:ur[or]},invalidAuthenticationHeader:{code:ir,desc:ur[ir]},cannotSetOIDCOptions:{code:sr,desc:ur[sr]},cannotAllowPlatformBroker:{code:ar,desc:ur[ar]},authorityMismatch:{code:cr,desc:ur[cr]},invalidAuthorizePostBodyParameters:{code:hr,desc:ur[hr]},invalidRequestMethodForEAR:{code:lr,desc:ur[lr]}};class pr extends Ce{constructor(e){super(e,ur[e]),this.name="ClientConfigurationError",Object.setPrototypeOf(this,pr.prototype)}}function mr(e){return new pr(e)}
/*! @azure/msal-common v15.9.0 2025-07-23 */class fr{static isEmptyObj(e){if(e)try{const t=JSON.parse(e);return 0===Object.keys(t).length}catch(e){}return!0}static startsWith(e,t){return 0===e.indexOf(t)}static endsWith(e,t){return e.length>=t.length&&e.lastIndexOf(t)===e.length-t.length}static queryStringToObject(e){const t={},r=e.split("&"),n=e=>decodeURIComponent(e.replace(/\+/g," "));return r.forEach((e=>{if(e.trim()){const[r,o]=e.split(/=(.+)/g,2);r&&o&&(t[n(r)]=n(o))}})),t}static trimArrayEntries(e){return e.map((e=>e.trim()))}static removeEmptyStringsFromArray(e){return e.filter((e=>!!e))}static jsonParseHelper(e){try{return JSON.parse(e)}catch(e){return null}}static matchPattern(e,t){return new RegExp(e.replace(/\\/g,"\\\\").replace(/\*/g,"[^ ]*").replace(/\?/g,"\\?")).test(t)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */class yr{constructor(e){const t=e?fr.trimArrayEntries([...e]):[],r=t?fr.removeEmptyStringsFromArray(t):[];if(!r||!r.length)throw mr(jt);this.scopes=new Set,r.forEach((e=>this.scopes.add(e)))}static fromString(e){const r=(e||t.EMPTY_STRING).split(" ");return new yr(r)}static createSearchScopes(e){const r=new yr(e);return r.containsOnlyOIDCScopes()?r.removeScope(t.OFFLINE_ACCESS_SCOPE):r.removeOIDCScopes(),r}containsScope(e){const t=this.printScopesLowerCase().split(" "),r=new yr(t);return!!e&&r.scopes.has(e.toLowerCase())}containsScopeSet(e){return!(!e||e.scopes.size<=0)&&(this.scopes.size>=e.scopes.size&&e.asArray().every((e=>this.containsScope(e))))}containsOnlyOIDCScopes(){let e=0;return d.forEach((t=>{this.containsScope(t)&&(e+=1)})),this.scopes.size===e}appendScope(e){e&&this.scopes.add(e.trim())}appendScopes(e){try{e.forEach((e=>this.appendScope(e)))}catch(e){throw pt(De)}}removeScope(e){if(!e)throw pt(xe);this.scopes.delete(e.trim())}removeOIDCScopes(){d.forEach((e=>{this.scopes.delete(e)}))}unionScopeSets(e){if(!e)throw pt(Be);const t=new Set;return e.scopes.forEach((e=>t.add(e.toLowerCase()))),this.scopes.forEach((e=>t.add(e.toLowerCase()))),t}intersectingScopeSets(e){if(!e)throw pt(Be);e.containsOnlyOIDCScopes()||e.removeOIDCScopes();const t=this.unionScopeSets(e),r=e.getScopeCount(),n=this.getScopeCount();return t.size<n+r}getScopeCount(){return this.scopes.size}asArray(){const e=[];return this.scopes.forEach((t=>e.push(t))),e}printScopes(){if(this.scopes){return this.asArray().join(" ")}return t.EMPTY_STRING}printScopesLowerCase(){return this.printScopes().toLowerCase()}}
/*! @azure/msal-common v15.9.0 2025-07-23 */function Cr(e,t){if(!e)throw pt(Ie);try{const r=t(e);return JSON.parse(r)}catch(e){throw pt(we)}}function vr(e){if(!e)throw pt(we);const r=e.split(H,2);return{uid:r[0],utid:r.length<2?t.EMPTY_STRING:r[1]}}
/*! @azure/msal-common v15.9.0 2025-07-23 */function wr(e,t){return!!e&&!!t&&e===t.split(".")[1]}function Ir(e,t,r,n){if(n){const{oid:t,sub:r,tid:o,name:i,tfp:s,acr:a}=n,c=o||s||a||"";return{tenantId:c,localAccountId:t||r||"",name:i,isHomeTenant:wr(c,e)}}return{tenantId:r,localAccountId:t,isHomeTenant:wr(r,e)}}function Tr(e,t,r,n){let o=e;if(t){const{isHomeTenant:r,...n}=t;o={...e,...n}}if(r){const{isHomeTenant:t,...i}=Ir(e.homeAccountId,e.localAccountId,e.tenantId,r);return o={...o,...i,idTokenClaims:r,idToken:n},o}return o}
/*! @azure/msal-common v15.9.0 2025-07-23 */const Ar=0,kr=1,Sr=2,br=3;
/*! @azure/msal-common v15.9.0 2025-07-23 */function Er(e){if(e){return e.tid||e.tfp||e.acr||null}return null}
/*! @azure/msal-common v15.9.0 2025-07-23 */const Rr={AAD:"AAD",OIDC:"OIDC",EAR:"EAR"};
/*! @azure/msal-common v15.9.0 2025-07-23 */class _r{generateAccountId(){return[this.homeAccountId,this.environment].join(U).toLowerCase()}generateAccountKey(){return _r.generateAccountCacheKey({homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId})}getAccountInfo(){return{homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId,name:this.name,nativeAccountId:this.nativeAccountId,authorityType:this.authorityType,tenantProfiles:new Map((this.tenantProfiles||[]).map((e=>[e.tenantId,e])))}}isSingleTenant(){return!this.tenantProfiles}static generateAccountCacheKey(e){const t=e.homeAccountId.split(".")[1];return[e.homeAccountId,e.environment||"",t||e.tenantId||""].join(U).toLowerCase()}static createAccount(e,t,r){const n=new _r;let o;t.authorityType===kr?n.authorityType=N:t.protocolMode===Rr.OIDC?n.authorityType=L:n.authorityType=q,e.clientInfo&&r&&(o=Cr(e.clientInfo,r)),n.clientInfo=e.clientInfo,n.homeAccountId=e.homeAccountId,n.nativeAccountId=e.nativeAccountId;const i=e.environment||t&&t.getPreferredCache();if(!i)throw pt(Qe);n.environment=i,n.realm=o?.utid||Er(e.idTokenClaims)||"",n.localAccountId=o?.uid||e.idTokenClaims?.oid||e.idTokenClaims?.sub||"";const s=e.idTokenClaims?.preferred_username||e.idTokenClaims?.upn,a=e.idTokenClaims?.emails?e.idTokenClaims.emails[0]:null;if(n.username=s||a||"",n.name=e.idTokenClaims?.name||"",n.cloudGraphHostName=e.cloudGraphHostName,n.msGraphHost=e.msGraphHost,e.tenantProfiles)n.tenantProfiles=e.tenantProfiles;else{const t=Ir(e.homeAccountId,n.localAccountId,n.realm,e.idTokenClaims);n.tenantProfiles=[t]}return n}static createFromAccountInfo(e,t,r){const n=new _r;return n.authorityType=e.authorityType||L,n.homeAccountId=e.homeAccountId,n.localAccountId=e.localAccountId,n.nativeAccountId=e.nativeAccountId,n.realm=e.tenantId,n.environment=e.environment,n.username=e.username,n.name=e.name,n.cloudGraphHostName=t,n.msGraphHost=r,n.tenantProfiles=Array.from(e.tenantProfiles?.values()||[]),n}static generateHomeAccountId(e,t,r,n,o){if(t!==kr&&t!==Sr){if(e)try{const t=Cr(e,n.base64Decode);if(t.uid&&t.utid)return`${t.uid}.${t.utid}`}catch(e){}r.warning("No client info in response")}return o?.sub||""}static isAccountEntity(e){return!!e&&(e.hasOwnProperty("homeAccountId")&&e.hasOwnProperty("environment")&&e.hasOwnProperty("realm")&&e.hasOwnProperty("localAccountId")&&e.hasOwnProperty("username")&&e.hasOwnProperty("authorityType"))}static accountInfoIsEqual(e,t,r){if(!e||!t)return!1;let n=!0;if(r){const r=e.idTokenClaims||{},o=t.idTokenClaims||{};n=r.iat===o.iat&&r.nonce===o.nonce}return e.homeAccountId===t.homeAccountId&&e.localAccountId===t.localAccountId&&e.username===t.username&&e.tenantId===t.tenantId&&e.environment===t.environment&&e.nativeAccountId===t.nativeAccountId&&n}}
/*! @azure/msal-common v15.9.0 2025-07-23 */function Pr(e){return e.startsWith("#/")?e.substring(2):e.startsWith("#")||e.startsWith("?")?e.substring(1):e}function Mr(e){if(!e||e.indexOf("=")<0)return null;try{const t=Pr(e),r=Object.fromEntries(new URLSearchParams(t));if(r.code||r.ear_jwe||r.error||r.error_description||r.state)return r}catch(e){throw pt(Ee)}return null}function Or(e,t=!0,r){const n=new Array;return e.forEach(((e,o)=>{!t&&r&&o in r?n.push(`${o}=${e}`):n.push(`${o}=${encodeURIComponent(e)}`)})),n.join("&")}
/*! @azure/msal-common v15.9.0 2025-07-23 */class qr{get urlString(){return this._urlString}constructor(e){if(this._urlString=e,!this._urlString)throw mr(Qt);e.includes("#")||(this._urlString=qr.canonicalizeUri(e))}static canonicalizeUri(e){if(e){let t=e.toLowerCase();return fr.endsWith(t,"?")?t=t.slice(0,-1):fr.endsWith(t,"?/")&&(t=t.slice(0,-2)),fr.endsWith(t,"/")||(t+="/"),t}return e}validateAsUri(){let e;try{e=this.getUrlComponents()}catch(e){throw mr($t)}if(!e.HostNameAndPort||!e.PathSegments)throw mr($t);if(!e.Protocol||"https:"!==e.Protocol.toLowerCase())throw mr(Gt)}static appendQueryString(e,t){return t?e.indexOf("?")<0?`${e}?${t}`:`${e}&${t}`:e}static removeHashFromUrl(e){return qr.canonicalizeUri(e.split("#")[0])}replaceTenantPath(e){const t=this.getUrlComponents(),r=t.PathSegments;return!e||0===r.length||r[0]!==I&&r[0]!==T||(r[0]=e),qr.constructAuthorityUriFromObject(t)}getUrlComponents(){const e=RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?"),t=this.urlString.match(e);if(!t)throw mr($t);const r={Protocol:t[1],HostNameAndPort:t[4],AbsolutePath:t[5],QueryString:t[7]};let n=r.AbsolutePath.split("/");return n=n.filter((e=>e&&e.length>0)),r.PathSegments=n,r.QueryString&&r.QueryString.endsWith("/")&&(r.QueryString=r.QueryString.substring(0,r.QueryString.length-1)),r}static getDomainFromUrl(e){const t=RegExp("^([^:/?#]+://)?([^/?#]*)"),r=e.match(t);if(!r)throw mr($t);return r[2]}static getAbsoluteUrl(e,r){if(e[0]===t.FORWARD_SLASH){const t=new qr(r).getUrlComponents();return t.Protocol+"//"+t.HostNameAndPort+e}return e}static constructAuthorityUriFromObject(e){return new qr(e.Protocol+"//"+e.HostNameAndPort+"/"+e.PathSegments.join("/"))}static hashContainsKnownProperties(e){return!!Mr(e)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */const Nr={"login.microsoftonline.com":{token_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.com/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.com/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/logout"},"login.chinacloudapi.cn":{token_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.chinacloudapi.cn/{tenantid}/discovery/v2.0/keys",issuer:"https://login.partner.microsoftonline.cn/{tenantid}/v2.0",authorization_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/logout"},"login.microsoftonline.us":{token_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.us/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.us/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/logout"}},Lr={metadata:[{preferred_network:"login.microsoftonline.com",preferred_cache:"login.windows.net",aliases:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"]},{preferred_network:"login.partner.microsoftonline.cn",preferred_cache:"login.partner.microsoftonline.cn",aliases:["login.partner.microsoftonline.cn","login.chinacloudapi.cn"]},{preferred_network:"login.microsoftonline.de",preferred_cache:"login.microsoftonline.de",aliases:["login.microsoftonline.de"]},{preferred_network:"login.microsoftonline.us",preferred_cache:"login.microsoftonline.us",aliases:["login.microsoftonline.us","login.usgovcloudapi.net"]},{preferred_network:"login-us.microsoftonline.com",preferred_cache:"login-us.microsoftonline.com",aliases:["login-us.microsoftonline.com"]}]},Ur=new Set;function Hr(e,t,r,n){if(n?.trace(`getAliasesFromMetadata called with source: ${r}`),e&&t){const o=xr(t,e);if(o)return n?.trace(`getAliasesFromMetadata: found cloud discovery metadata in ${r}, returning aliases`),o.aliases;n?.trace(`getAliasesFromMetadata: did not find cloud discovery metadata in ${r}`)}return null}function xr(e,t){for(let r=0;r<e.length;r++){const n=e[r];if(n.aliases.includes(t))return n}return null}
/*! @azure/msal-common v15.9.0 2025-07-23 */Lr.metadata.forEach((e=>{e.aliases.forEach((e=>{Ur.add(e)}))}));const Dr="cache_quota_exceeded",Br="cache_error_unknown",Fr={[Dr]:"Exceeded cache storage capacity.",[Br]:"Unexpected error occurred when using cache storage."};class zr extends Ce{constructor(e,t){const r=t||(Fr[e]?Fr[e]:Fr[Br]);super(`${e}: ${r}`),Object.setPrototypeOf(this,zr.prototype),this.name="CacheError",this.errorCode=e,this.errorMessage=r}}function Kr(e){return e instanceof Error?"QuotaExceededError"===e.name||"NS_ERROR_DOM_QUOTA_REACHED"===e.name||e.message.includes("exceeded the quota")?new zr(Dr):new zr(e.name,e.message):new zr(Br)}
/*! @azure/msal-common v15.9.0 2025-07-23 */class Gr{constructor(e,t,r,n,o){this.clientId=e,this.cryptoImpl=t,this.commonLogger=r.clone(Ct,vt),this.staticAuthorityOptions=o,this.performanceClient=n}getAllAccounts(e,t){return this.buildTenantProfiles(this.getAccountsFilteredBy(e,t),t,e)}getAccountInfoFilteredBy(e,t){const r=this.getAllAccounts(e,t);if(r.length>1){return r.sort((e=>e.idTokenClaims?-1:1))[0]}return 1===r.length?r[0]:null}getBaseAccountInfo(e,t){const r=this.getAccountsFilteredBy(e,t);return r.length>0?r[0].getAccountInfo():null}buildTenantProfiles(e,t,r){return e.flatMap((e=>this.getTenantProfilesFromAccountEntity(e,t,r?.tenantId,r)))}getTenantedAccountInfoByFilter(e,t,r,n,o){let i,s=null;if(o&&!this.tenantProfileMatchesFilter(r,o))return null;const a=this.getIdToken(e,n,t,r.tenantId);return a&&(i=It(a.secret,this.cryptoImpl.base64Decode),!this.idTokenClaimsMatchTenantProfileFilter(i,o))?null:(s=Tr(e,r,i,a?.secret),s)}getTenantProfilesFromAccountEntity(e,t,r,n){const o=e.getAccountInfo();let i=o.tenantProfiles||new Map;const s=this.getTokenKeys();if(r){const e=i.get(r);if(!e)return[];i=new Map([[r,e]])}const a=[];return i.forEach((e=>{const r=this.getTenantedAccountInfoByFilter(o,s,e,t,n);r&&a.push(r)})),a}tenantProfileMatchesFilter(e,t){return!(t.localAccountId&&!this.matchLocalAccountIdFromTenantProfile(e,t.localAccountId))&&((!t.name||e.name===t.name)&&(void 0===t.isHomeTenant||e.isHomeTenant===t.isHomeTenant))}idTokenClaimsMatchTenantProfileFilter(e,t){if(t){if(t.localAccountId&&!this.matchLocalAccountIdFromTokenClaims(e,t.localAccountId))return!1;if(t.loginHint&&!this.matchLoginHintFromTokenClaims(e,t.loginHint))return!1;if(t.username&&!this.matchUsername(e.preferred_username,t.username))return!1;if(t.name&&!this.matchName(e,t.name))return!1;if(t.sid&&!this.matchSid(e,t.sid))return!1}return!0}async saveCacheRecord(e,t,r){if(!e)throw pt($e);try{e.account&&await this.setAccount(e.account,t),e.idToken&&!1!==r?.idToken&&await this.setIdTokenCredential(e.idToken,t),e.accessToken&&!1!==r?.accessToken&&await this.saveAccessToken(e.accessToken,t),e.refreshToken&&!1!==r?.refreshToken&&await this.setRefreshTokenCredential(e.refreshToken,t),e.appMetadata&&this.setAppMetadata(e.appMetadata,t)}catch(e){throw this.commonLogger?.error("CacheManager.saveCacheRecord: failed"),e instanceof Ce?e:Kr(e)}}async saveAccessToken(e,t){const r={clientId:e.clientId,credentialType:e.credentialType,environment:e.environment,homeAccountId:e.homeAccountId,realm:e.realm,tokenType:e.tokenType,requestedClaimsHash:e.requestedClaimsHash},n=this.getTokenKeys(),o=yr.fromString(e.target);n.accessToken.forEach((e=>{if(!this.accessTokenKeyMatchesFilter(e,r,!1))return;const n=this.getAccessTokenCredential(e,t);if(n&&this.credentialMatchesFilter(n,r)){yr.fromString(n.target).intersectingScopeSets(o)&&this.removeAccessToken(e,t)}})),await this.setAccessTokenCredential(e,t)}getAccountsFilteredBy(e,t){const r=this.getAccountKeys(),n=[];return r.forEach((r=>{if(!this.isAccountKey(r,e.homeAccountId))return;const o=this.getAccount(r,t);if(!o)return;if(e.homeAccountId&&!this.matchHomeAccountId(o,e.homeAccountId))return;if(e.username&&!this.matchUsername(o.username,e.username))return;if(e.environment&&!this.matchEnvironment(o,e.environment))return;if(e.realm&&!this.matchRealm(o,e.realm))return;if(e.nativeAccountId&&!this.matchNativeAccountId(o,e.nativeAccountId))return;if(e.authorityType&&!this.matchAuthorityType(o,e.authorityType))return;const i={localAccountId:e?.localAccountId,name:e?.name},s=o.tenantProfiles?.filter((e=>this.tenantProfileMatchesFilter(e,i)));s&&0===s.length||n.push(o)})),n}isAccountKey(e,t,r){return!(e.split(U).length<3)&&(!(t&&!e.toLowerCase().includes(t.toLowerCase()))&&!(r&&!e.toLowerCase().includes(r.toLowerCase())))}isCredentialKey(e){if(e.split(U).length<6)return!1;const t=e.toLowerCase();if(-1===t.indexOf(x.ID_TOKEN.toLowerCase())&&-1===t.indexOf(x.ACCESS_TOKEN.toLowerCase())&&-1===t.indexOf(x.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase())&&-1===t.indexOf(x.REFRESH_TOKEN.toLowerCase()))return!1;if(t.indexOf(x.REFRESH_TOKEN.toLowerCase())>-1){const e=`${x.REFRESH_TOKEN}${U}${this.clientId}${U}`,r=`${x.REFRESH_TOKEN}${U}${B}${U}`;if(-1===t.indexOf(e.toLowerCase())&&-1===t.indexOf(r.toLowerCase()))return!1}else if(-1===t.indexOf(this.clientId.toLowerCase()))return!1;return!0}credentialMatchesFilter(e,t){if(t.clientId&&!this.matchClientId(e,t.clientId))return!1;if(t.userAssertionHash&&!this.matchUserAssertionHash(e,t.userAssertionHash))return!1;if("string"==typeof t.homeAccountId&&!this.matchHomeAccountId(e,t.homeAccountId))return!1;if(t.environment&&!this.matchEnvironment(e,t.environment))return!1;if(t.realm&&!this.matchRealm(e,t.realm))return!1;if(t.credentialType&&!this.matchCredentialType(e,t.credentialType))return!1;if(t.familyId&&!this.matchFamilyId(e,t.familyId))return!1;if(t.target&&!this.matchTarget(e,t.target))return!1;if((t.requestedClaimsHash||e.requestedClaimsHash)&&e.requestedClaimsHash!==t.requestedClaimsHash)return!1;if(e.credentialType===x.ACCESS_TOKEN_WITH_AUTH_SCHEME){if(t.tokenType&&!this.matchTokenType(e,t.tokenType))return!1;if(t.tokenType===W.SSH&&t.keyId&&!this.matchKeyId(e,t.keyId))return!1}return!0}getAppMetadataFilteredBy(e){const t=this.getKeys(),r={};return t.forEach((t=>{if(!this.isAppMetadata(t))return;const n=this.getAppMetadata(t);n&&(e.environment&&!this.matchEnvironment(n,e.environment)||e.clientId&&!this.matchClientId(n,e.clientId)||(r[t]=n))})),r}getAuthorityMetadataByAlias(e){const t=this.getAuthorityMetadataKeys();let r=null;return t.forEach((t=>{if(!this.isAuthorityMetadata(t)||-1===t.indexOf(this.clientId))return;const n=this.getAuthorityMetadata(t);n&&-1!==n.aliases.indexOf(e)&&(r=n)})),r}removeAllAccounts(e){this.getAccountKeys().forEach((t=>{this.removeAccount(t,e)}))}removeAccount(e,t){const r=this.getAccount(e,t);r&&(this.removeAccountContext(r,t),this.removeItem(e,t))}removeAccountContext(e,t){const r=this.getTokenKeys(),n=e.generateAccountId();r.idToken.forEach((e=>{0===e.indexOf(n)&&this.removeIdToken(e,t)})),r.accessToken.forEach((e=>{0===e.indexOf(n)&&this.removeAccessToken(e,t)})),r.refreshToken.forEach((e=>{0===e.indexOf(n)&&this.removeRefreshToken(e,t)}))}removeAccessToken(e,t){const r=this.getAccessTokenCredential(e,t);if(this.removeItem(e,t),this.performanceClient.incrementFields({accessTokensRemoved:1},t),!r||r.credentialType.toLowerCase()!==x.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase()||r.tokenType!==W.POP)return;const n=r.keyId;n&&this.cryptoImpl.removeTokenBindingKey(n).catch((()=>{this.commonLogger.error(`Failed to remove token binding key ${n}`,t),this.performanceClient?.incrementFields({removeTokenBindingKeyFailure:1},t)}))}removeAppMetadata(e){return this.getKeys().forEach((t=>{this.isAppMetadata(t)&&this.removeItem(t,e)})),!0}readAccountFromCache(e,t){const r=_r.generateAccountCacheKey(e);return this.getAccount(r,t)}getIdToken(e,t,r,n,o){this.commonLogger.trace("CacheManager - getIdToken called");const i={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:x.ID_TOKEN,clientId:this.clientId,realm:n},s=this.getIdTokensByFilter(i,t,r),a=s.size;if(a<1)return this.commonLogger.info("CacheManager:getIdToken - No token found"),null;if(a>1){let r=s;if(!n){const t=new Map;s.forEach(((r,n)=>{r.realm===e.tenantId&&t.set(n,r)}));const n=t.size;if(n<1)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account but none match account entity tenant id, returning first result"),s.values().next().value;if(1===n)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account, defaulting to home tenant profile"),t.values().next().value;r=t}return this.commonLogger.info("CacheManager:getIdToken - Multiple matching ID tokens found, clearing them"),r.forEach(((e,r)=>{this.removeIdToken(r,t)})),o&&t&&o.addFields({multiMatchedID:s.size},t),null}return this.commonLogger.info("CacheManager:getIdToken - Returning ID token"),s.values().next().value}getIdTokensByFilter(e,t,r){const n=r&&r.idToken||this.getTokenKeys().idToken,o=new Map;return n.forEach((r=>{if(!this.idTokenKeyMatchesFilter(r,{clientId:this.clientId,...e}))return;const n=this.getIdTokenCredential(r,t);n&&this.credentialMatchesFilter(n,e)&&o.set(r,n)})),o}idTokenKeyMatchesFilter(e,t){const r=e.toLowerCase();return(!t.clientId||-1!==r.indexOf(t.clientId.toLowerCase()))&&(!t.homeAccountId||-1!==r.indexOf(t.homeAccountId.toLowerCase()))}removeIdToken(e,t){this.removeItem(e,t)}removeRefreshToken(e,t){this.removeItem(e,t)}getAccessToken(e,t,r,n){const o=t.correlationId;this.commonLogger.trace("CacheManager - getAccessToken called",o);const i=yr.createSearchScopes(t.scopes),s=t.authenticationScheme||W.BEARER,a=s&&s.toLowerCase()!==W.BEARER.toLowerCase()?x.ACCESS_TOKEN_WITH_AUTH_SCHEME:x.ACCESS_TOKEN,c={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:a,clientId:this.clientId,realm:n||e.tenantId,target:i,tokenType:s,keyId:t.sshKid,requestedClaimsHash:t.requestedClaimsHash},l=r&&r.accessToken||this.getTokenKeys().accessToken,h=[];l.forEach((e=>{if(this.accessTokenKeyMatchesFilter(e,c,!0)){const t=this.getAccessTokenCredential(e,o);t&&this.credentialMatchesFilter(t,c)&&h.push(t)}}));const d=h.length;return d<1?(this.commonLogger.info("CacheManager:getAccessToken - No token found",o),null):d>1?(this.commonLogger.info("CacheManager:getAccessToken - Multiple access tokens found, clearing them",o),h.forEach((e=>{this.removeAccessToken(Rt(e),o)})),this.performanceClient.addFields({multiMatchedAT:h.length},o),null):(this.commonLogger.info("CacheManager:getAccessToken - Returning access token",o),h[0])}accessTokenKeyMatchesFilter(e,t,r){const n=e.toLowerCase();if(t.clientId&&-1===n.indexOf(t.clientId.toLowerCase()))return!1;if(t.homeAccountId&&-1===n.indexOf(t.homeAccountId.toLowerCase()))return!1;if(t.realm&&-1===n.indexOf(t.realm.toLowerCase()))return!1;if(t.requestedClaimsHash&&-1===n.indexOf(t.requestedClaimsHash.toLowerCase()))return!1;if(t.target){const e=t.target.asArray();for(let t=0;t<e.length;t++){if(r&&!n.includes(e[t].toLowerCase()))return!1;if(!r&&n.includes(e[t].toLowerCase()))return!0}}return!0}getAccessTokensByFilter(e,t){const r=this.getTokenKeys(),n=[];return r.accessToken.forEach((r=>{if(!this.accessTokenKeyMatchesFilter(r,e,!0))return;const o=this.getAccessTokenCredential(r,t);o&&this.credentialMatchesFilter(o,e)&&n.push(o)})),n}getRefreshToken(e,t,r,n,o){this.commonLogger.trace("CacheManager - getRefreshToken called");const i=t?B:void 0,s={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:x.REFRESH_TOKEN,clientId:this.clientId,familyId:i},a=n&&n.refreshToken||this.getTokenKeys().refreshToken,c=[];a.forEach((e=>{if(this.refreshTokenKeyMatchesFilter(e,s)){const t=this.getRefreshTokenCredential(e,r);t&&this.credentialMatchesFilter(t,s)&&c.push(t)}}));const l=c.length;return l<1?(this.commonLogger.info("CacheManager:getRefreshToken - No refresh token found."),null):(l>1&&o&&r&&o.addFields({multiMatchedRT:l},r),this.commonLogger.info("CacheManager:getRefreshToken - returning refresh token"),c[0])}refreshTokenKeyMatchesFilter(e,t){const r=e.toLowerCase();return(!t.familyId||-1!==r.indexOf(t.familyId.toLowerCase()))&&(!(!t.familyId&&t.clientId&&-1===r.indexOf(t.clientId.toLowerCase()))&&(!t.homeAccountId||-1!==r.indexOf(t.homeAccountId.toLowerCase())))}readAppMetadataFromCache(e){const t={environment:e,clientId:this.clientId},r=this.getAppMetadataFilteredBy(t),n=Object.keys(r).map((e=>r[e])),o=n.length;if(o<1)return null;if(o>1)throw pt(Ue);return n[0]}isAppMetadataFOCI(e){const t=this.readAppMetadataFromCache(e);return!(!t||t.familyId!==B)}matchHomeAccountId(e,t){return!("string"!=typeof e.homeAccountId||t!==e.homeAccountId)}matchLocalAccountIdFromTokenClaims(e,t){return t===(e.oid||e.sub)}matchLocalAccountIdFromTenantProfile(e,t){return e.localAccountId===t}matchName(e,t){return!(t.toLowerCase()!==e.name?.toLowerCase())}matchUsername(e,t){return!(!e||"string"!=typeof e||t?.toLowerCase()!==e.toLowerCase())}matchUserAssertionHash(e,t){return!(!e.userAssertionHash||t!==e.userAssertionHash)}matchEnvironment(e,t){if(this.staticAuthorityOptions){const r=function(e,t){let r;const n=e.canonicalAuthority;if(n){const o=new qr(n).getUrlComponents().HostNameAndPort;r=Hr(o,e.cloudDiscoveryMetadata?.metadata,K,t)||Hr(o,Lr.metadata,Q,t)||e.knownAuthorities}return r||[]}(this.staticAuthorityOptions,this.commonLogger);if(r.includes(t)&&r.includes(e.environment))return!0}const r=this.getAuthorityMetadataByAlias(t);return!!(r&&r.aliases.indexOf(e.environment)>-1)}matchCredentialType(e,t){return e.credentialType&&t.toLowerCase()===e.credentialType.toLowerCase()}matchClientId(e,t){return!(!e.clientId||t!==e.clientId)}matchFamilyId(e,t){return!(!e.familyId||t!==e.familyId)}matchRealm(e,t){return!(e.realm?.toLowerCase()!==t.toLowerCase())}matchNativeAccountId(e,t){return!(!e.nativeAccountId||t!==e.nativeAccountId)}matchLoginHintFromTokenClaims(e,t){return e.login_hint===t||(e.preferred_username===t||e.upn===t)}matchSid(e,t){return e.sid===t}matchAuthorityType(e,t){return!(!e.authorityType||t.toLowerCase()!==e.authorityType.toLowerCase())}matchTarget(e,t){if(e.credentialType!==x.ACCESS_TOKEN&&e.credentialType!==x.ACCESS_TOKEN_WITH_AUTH_SCHEME||!e.target)return!1;return yr.fromString(e.target).containsScopeSet(t)}matchTokenType(e,t){return!(!e.tokenType||e.tokenType!==t)}matchKeyId(e,t){return!(!e.keyId||e.keyId!==t)}isAppMetadata(e){return-1!==e.indexOf(D)}isAuthorityMetadata(e){return-1!==e.indexOf(F)}generateAuthorityMetadataCacheKey(e){return`${F}-${this.clientId}-${e}`}static toObject(e,t){for(const r in t)e[r]=t[r];return e}}class $r extends Gr{async setAccount(){throw pt(ct)}getAccount(){throw pt(ct)}async setIdTokenCredential(){throw pt(ct)}getIdTokenCredential(){throw pt(ct)}async setAccessTokenCredential(){throw pt(ct)}getAccessTokenCredential(){throw pt(ct)}async setRefreshTokenCredential(){throw pt(ct)}getRefreshTokenCredential(){throw pt(ct)}setAppMetadata(){throw pt(ct)}getAppMetadata(){throw pt(ct)}setServerTelemetry(){throw pt(ct)}getServerTelemetry(){throw pt(ct)}setAuthorityMetadata(){throw pt(ct)}getAuthorityMetadata(){throw pt(ct)}getAuthorityMetadataKeys(){throw pt(ct)}setThrottlingCache(){throw pt(ct)}getThrottlingCache(){throw pt(ct)}removeItem(){throw pt(ct)}getKeys(){throw pt(ct)}getAccountKeys(){throw pt(ct)}getTokenKeys(){throw pt(ct)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */const Qr={AcquireTokenByCode:"acquireTokenByCode",AcquireTokenByRefreshToken:"acquireTokenByRefreshToken",AcquireTokenSilent:"acquireTokenSilent",AcquireTokenSilentAsync:"acquireTokenSilentAsync",AcquireTokenPopup:"acquireTokenPopup",AcquireTokenPreRedirect:"acquireTokenPreRedirect",AcquireTokenRedirect:"acquireTokenRedirect",CryptoOptsGetPublicKeyThumbprint:"cryptoOptsGetPublicKeyThumbprint",CryptoOptsSignJwt:"cryptoOptsSignJwt",SilentCacheClientAcquireToken:"silentCacheClientAcquireToken",SilentIframeClientAcquireToken:"silentIframeClientAcquireToken",AwaitConcurrentIframe:"awaitConcurrentIframe",SilentRefreshClientAcquireToken:"silentRefreshClientAcquireToken",SsoSilent:"ssoSilent",StandardInteractionClientGetDiscoveredAuthority:"standardInteractionClientGetDiscoveredAuthority",FetchAccountIdWithNativeBroker:"fetchAccountIdWithNativeBroker",NativeInteractionClientAcquireToken:"nativeInteractionClientAcquireToken",BaseClientCreateTokenRequestHeaders:"baseClientCreateTokenRequestHeaders",NetworkClientSendPostRequestAsync:"networkClientSendPostRequestAsync",RefreshTokenClientExecutePostToTokenEndpoint:"refreshTokenClientExecutePostToTokenEndpoint",AuthorizationCodeClientExecutePostToTokenEndpoint:"authorizationCodeClientExecutePostToTokenEndpoint",BrokerHandhshake:"brokerHandshake",AcquireTokenByRefreshTokenInBroker:"acquireTokenByRefreshTokenInBroker",AcquireTokenByBroker:"acquireTokenByBroker",RefreshTokenClientExecuteTokenRequest:"refreshTokenClientExecuteTokenRequest",RefreshTokenClientAcquireToken:"refreshTokenClientAcquireToken",RefreshTokenClientAcquireTokenWithCachedRefreshToken:"refreshTokenClientAcquireTokenWithCachedRefreshToken",RefreshTokenClientAcquireTokenByRefreshToken:"refreshTokenClientAcquireTokenByRefreshToken",RefreshTokenClientCreateTokenRequestBody:"refreshTokenClientCreateTokenRequestBody",AcquireTokenFromCache:"acquireTokenFromCache",SilentFlowClientAcquireCachedToken:"silentFlowClientAcquireCachedToken",SilentFlowClientGenerateResultFromCacheRecord:"silentFlowClientGenerateResultFromCacheRecord",AcquireTokenBySilentIframe:"acquireTokenBySilentIframe",InitializeBaseRequest:"initializeBaseRequest",InitializeSilentRequest:"initializeSilentRequest",InitializeClientApplication:"initializeClientApplication",InitializeCache:"initializeCache",SilentIframeClientTokenHelper:"silentIframeClientTokenHelper",SilentHandlerInitiateAuthRequest:"silentHandlerInitiateAuthRequest",SilentHandlerMonitorIframeForHash:"silentHandlerMonitorIframeForHash",SilentHandlerLoadFrame:"silentHandlerLoadFrame",SilentHandlerLoadFrameSync:"silentHandlerLoadFrameSync",StandardInteractionClientCreateAuthCodeClient:"standardInteractionClientCreateAuthCodeClient",StandardInteractionClientGetClientConfiguration:"standardInteractionClientGetClientConfiguration",StandardInteractionClientInitializeAuthorizationRequest:"standardInteractionClientInitializeAuthorizationRequest",GetAuthCodeUrl:"getAuthCodeUrl",GetStandardParams:"getStandardParams",HandleCodeResponseFromServer:"handleCodeResponseFromServer",HandleCodeResponse:"handleCodeResponse",HandleResponseEar:"handleResponseEar",HandleResponsePlatformBroker:"handleResponsePlatformBroker",HandleResponseCode:"handleResponseCode",UpdateTokenEndpointAuthority:"updateTokenEndpointAuthority",AuthClientAcquireToken:"authClientAcquireToken",AuthClientExecuteTokenRequest:"authClientExecuteTokenRequest",AuthClientCreateTokenRequestBody:"authClientCreateTokenRequestBody",PopTokenGenerateCnf:"popTokenGenerateCnf",PopTokenGenerateKid:"popTokenGenerateKid",HandleServerTokenResponse:"handleServerTokenResponse",DeserializeResponse:"deserializeResponse",AuthorityFactoryCreateDiscoveredInstance:"authorityFactoryCreateDiscoveredInstance",AuthorityResolveEndpointsAsync:"authorityResolveEndpointsAsync",AuthorityResolveEndpointsFromLocalSources:"authorityResolveEndpointsFromLocalSources",AuthorityGetCloudDiscoveryMetadataFromNetwork:"authorityGetCloudDiscoveryMetadataFromNetwork",AuthorityUpdateCloudDiscoveryMetadata:"authorityUpdateCloudDiscoveryMetadata",AuthorityGetEndpointMetadataFromNetwork:"authorityGetEndpointMetadataFromNetwork",AuthorityUpdateEndpointMetadata:"authorityUpdateEndpointMetadata",AuthorityUpdateMetadataWithRegionalInformation:"authorityUpdateMetadataWithRegionalInformation",RegionDiscoveryDetectRegion:"regionDiscoveryDetectRegion",RegionDiscoveryGetRegionFromIMDS:"regionDiscoveryGetRegionFromIMDS",RegionDiscoveryGetCurrentVersion:"regionDiscoveryGetCurrentVersion",AcquireTokenByCodeAsync:"acquireTokenByCodeAsync",GetEndpointMetadataFromNetwork:"getEndpointMetadataFromNetwork",GetCloudDiscoveryMetadataFromNetworkMeasurement:"getCloudDiscoveryMetadataFromNetworkMeasurement",HandleRedirectPromiseMeasurement:"handleRedirectPromise",HandleNativeRedirectPromiseMeasurement:"handleNativeRedirectPromise",UpdateCloudDiscoveryMetadataMeasurement:"updateCloudDiscoveryMetadataMeasurement",UsernamePasswordClientAcquireToken:"usernamePasswordClientAcquireToken",NativeMessageHandlerHandshake:"nativeMessageHandlerHandshake",NativeGenerateAuthResult:"nativeGenerateAuthResult",RemoveHiddenIframe:"removeHiddenIframe",ClearTokensAndKeysWithClaims:"clearTokensAndKeysWithClaims",CacheManagerGetRefreshToken:"cacheManagerGetRefreshToken",ImportExistingCache:"importExistingCache",SetUserData:"setUserData",LocalStorageUpdated:"localStorageUpdated",GeneratePkceCodes:"generatePkceCodes",GenerateCodeVerifier:"generateCodeVerifier",GenerateCodeChallengeFromVerifier:"generateCodeChallengeFromVerifier",Sha256Digest:"sha256Digest",GetRandomValues:"getRandomValues",GenerateHKDF:"generateHKDF",GenerateBaseKey:"generateBaseKey",Base64Decode:"base64Decode",UrlEncodeArr:"urlEncodeArr",Encrypt:"encrypt",Decrypt:"decrypt",GenerateEarKey:"generateEarKey",DecryptEarResponse:"decryptEarResponse"},jr=new Map([[Qr.AcquireTokenByCode,"ATByCode"],[Qr.AcquireTokenByRefreshToken,"ATByRT"],[Qr.AcquireTokenSilent,"ATS"],[Qr.AcquireTokenSilentAsync,"ATSAsync"],[Qr.AcquireTokenPopup,"ATPopup"],[Qr.AcquireTokenRedirect,"ATRedirect"],[Qr.CryptoOptsGetPublicKeyThumbprint,"CryptoGetPKThumb"],[Qr.CryptoOptsSignJwt,"CryptoSignJwt"],[Qr.SilentCacheClientAcquireToken,"SltCacheClientAT"],[Qr.SilentIframeClientAcquireToken,"SltIframeClientAT"],[Qr.SilentRefreshClientAcquireToken,"SltRClientAT"],[Qr.SsoSilent,"SsoSlt"],[Qr.StandardInteractionClientGetDiscoveredAuthority,"StdIntClientGetDiscAuth"],[Qr.FetchAccountIdWithNativeBroker,"FetchAccIdWithNtvBroker"],[Qr.NativeInteractionClientAcquireToken,"NtvIntClientAT"],[Qr.BaseClientCreateTokenRequestHeaders,"BaseClientCreateTReqHead"],[Qr.NetworkClientSendPostRequestAsync,"NetClientSendPost"],[Qr.RefreshTokenClientExecutePostToTokenEndpoint,"RTClientExecPost"],[Qr.AuthorizationCodeClientExecutePostToTokenEndpoint,"AuthCodeClientExecPost"],[Qr.BrokerHandhshake,"BrokerHandshake"],[Qr.AcquireTokenByRefreshTokenInBroker,"ATByRTInBroker"],[Qr.AcquireTokenByBroker,"ATByBroker"],[Qr.RefreshTokenClientExecuteTokenRequest,"RTClientExecTReq"],[Qr.RefreshTokenClientAcquireToken,"RTClientAT"],[Qr.RefreshTokenClientAcquireTokenWithCachedRefreshToken,"RTClientATWithCachedRT"],[Qr.RefreshTokenClientAcquireTokenByRefreshToken,"RTClientATByRT"],[Qr.RefreshTokenClientCreateTokenRequestBody,"RTClientCreateTReqBody"],[Qr.AcquireTokenFromCache,"ATFromCache"],[Qr.SilentFlowClientAcquireCachedToken,"SltFlowClientATCached"],[Qr.SilentFlowClientGenerateResultFromCacheRecord,"SltFlowClientGenResFromCache"],[Qr.AcquireTokenBySilentIframe,"ATBySltIframe"],[Qr.InitializeBaseRequest,"InitBaseReq"],[Qr.InitializeSilentRequest,"InitSltReq"],[Qr.InitializeClientApplication,"InitClientApplication"],[Qr.InitializeCache,"InitCache"],[Qr.ImportExistingCache,"importCache"],[Qr.SetUserData,"setUserData"],[Qr.LocalStorageUpdated,"localStorageUpdated"],[Qr.SilentIframeClientTokenHelper,"SIClientTHelper"],[Qr.SilentHandlerInitiateAuthRequest,"SHandlerInitAuthReq"],[Qr.SilentHandlerMonitorIframeForHash,"SltHandlerMonitorIframeForHash"],[Qr.SilentHandlerLoadFrame,"SHandlerLoadFrame"],[Qr.SilentHandlerLoadFrameSync,"SHandlerLoadFrameSync"],[Qr.StandardInteractionClientCreateAuthCodeClient,"StdIntClientCreateAuthCodeClient"],[Qr.StandardInteractionClientGetClientConfiguration,"StdIntClientGetClientConf"],[Qr.StandardInteractionClientInitializeAuthorizationRequest,"StdIntClientInitAuthReq"],[Qr.GetAuthCodeUrl,"GetAuthCodeUrl"],[Qr.HandleCodeResponseFromServer,"HandleCodeResFromServer"],[Qr.HandleCodeResponse,"HandleCodeResp"],[Qr.HandleResponseEar,"HandleRespEar"],[Qr.HandleResponseCode,"HandleRespCode"],[Qr.HandleResponsePlatformBroker,"HandleRespPlatBroker"],[Qr.UpdateTokenEndpointAuthority,"UpdTEndpointAuth"],[Qr.AuthClientAcquireToken,"AuthClientAT"],[Qr.AuthClientExecuteTokenRequest,"AuthClientExecTReq"],[Qr.AuthClientCreateTokenRequestBody,"AuthClientCreateTReqBody"],[Qr.PopTokenGenerateCnf,"PopTGenCnf"],[Qr.PopTokenGenerateKid,"PopTGenKid"],[Qr.HandleServerTokenResponse,"HandleServerTRes"],[Qr.DeserializeResponse,"DeserializeRes"],[Qr.AuthorityFactoryCreateDiscoveredInstance,"AuthFactCreateDiscInst"],[Qr.AuthorityResolveEndpointsAsync,"AuthResolveEndpointsAsync"],[Qr.AuthorityResolveEndpointsFromLocalSources,"AuthResolveEndpointsFromLocal"],[Qr.AuthorityGetCloudDiscoveryMetadataFromNetwork,"AuthGetCDMetaFromNet"],[Qr.AuthorityUpdateCloudDiscoveryMetadata,"AuthUpdCDMeta"],[Qr.AuthorityGetEndpointMetadataFromNetwork,"AuthUpdCDMetaFromNet"],[Qr.AuthorityUpdateEndpointMetadata,"AuthUpdEndpointMeta"],[Qr.AuthorityUpdateMetadataWithRegionalInformation,"AuthUpdMetaWithRegInfo"],[Qr.RegionDiscoveryDetectRegion,"RegDiscDetectReg"],[Qr.RegionDiscoveryGetRegionFromIMDS,"RegDiscGetRegFromIMDS"],[Qr.RegionDiscoveryGetCurrentVersion,"RegDiscGetCurrentVer"],[Qr.AcquireTokenByCodeAsync,"ATByCodeAsync"],[Qr.GetEndpointMetadataFromNetwork,"GetEndpointMetaFromNet"],[Qr.GetCloudDiscoveryMetadataFromNetworkMeasurement,"GetCDMetaFromNet"],[Qr.HandleRedirectPromiseMeasurement,"HandleRedirectPromise"],[Qr.HandleNativeRedirectPromiseMeasurement,"HandleNtvRedirectPromise"],[Qr.UpdateCloudDiscoveryMetadataMeasurement,"UpdateCDMeta"],[Qr.UsernamePasswordClientAcquireToken,"UserPassClientAT"],[Qr.NativeMessageHandlerHandshake,"NtvMsgHandlerHandshake"],[Qr.NativeGenerateAuthResult,"NtvGenAuthRes"],[Qr.RemoveHiddenIframe,"RemoveHiddenIframe"],[Qr.ClearTokensAndKeysWithClaims,"ClearTAndKeysWithClaims"],[Qr.CacheManagerGetRefreshToken,"CacheManagerGetRT"],[Qr.GeneratePkceCodes,"GenPkceCodes"],[Qr.GenerateCodeVerifier,"GenCodeVerifier"],[Qr.GenerateCodeChallengeFromVerifier,"GenCodeChallengeFromVerifier"],[Qr.Sha256Digest,"Sha256Digest"],[Qr.GetRandomValues,"GetRandomValues"],[Qr.GenerateHKDF,"genHKDF"],[Qr.GenerateBaseKey,"genBaseKey"],[Qr.Base64Decode,"b64Decode"],[Qr.UrlEncodeArr,"urlEncArr"],[Qr.Encrypt,"encrypt"],[Qr.Decrypt,"decrypt"],[Qr.GenerateEarKey,"genEarKey"],[Qr.DecryptEarResponse,"decryptEarResp"]]),Wr=1,Vr=2,Jr=new Set(["accessTokenSize","durationMs","idTokenSize","matsSilentStatus","matsHttpStatus","refreshTokenSize","queuedTimeMs","startTimeMs","status","multiMatchedAT","multiMatchedID","multiMatchedRT","unencryptedCacheCount","encryptedCacheExpiredCount"]);
/*! @azure/msal-common v15.9.0 2025-07-23 */
class Yr{startMeasurement(){}endMeasurement(){}flushMeasurement(){return null}}class Xr{generateId(){return"callback-id"}startMeasurement(e,t){return{end:()=>null,discard:()=>{},add:()=>{},increment:()=>{},event:{eventId:this.generateId(),status:Wr,authority:"",libraryName:"",libraryVersion:"",clientId:"",name:e,startTimeMs:Date.now(),correlationId:t||""},measurement:new Yr}}startPerformanceMeasurement(){return new Yr}calculateQueuedTime(){return 0}addQueueMeasurement(){}setPreQueueTime(){}endMeasurement(){return null}discardMeasurements(){}removePerformanceCallback(){return!0}addPerformanceCallback(){return""}emitEvents(){}addFields(){}incrementFields(){}cacheEventByCorrelationId(){}}
/*! @azure/msal-common v15.9.0 2025-07-23 */const Zr={tokenRenewalOffsetSeconds:300,preventCorsPreflight:!1},en={loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:e.LogLevel.Info,correlationId:t.EMPTY_STRING},tn={claimsBasedCachingEnabled:!1},rn={async sendGetRequestAsync(){throw pt(ct)},async sendPostRequestAsync(){throw pt(ct)}},nn={sku:t.SKU,version:vt,cpu:t.EMPTY_STRING,os:t.EMPTY_STRING},on={clientSecret:t.EMPTY_STRING,clientAssertion:void 0},sn={azureCloudInstance:wt.None,tenant:`${t.DEFAULT_COMMON_TENANT}`},an={application:{appName:"",appVersion:""}};function cn(e){return e.authOptions.authority.options.protocolMode===Rr.OIDC}
/*! @azure/msal-common v15.9.0 2025-07-23 */const ln="home_account_id",hn="UPN",dn="client_id",un="redirect_uri",gn="token_type",pn="req_cnf",mn="return_spa_code",fn="x-client-xtra-sku",yn="brk_client_id",Cn="brk_redirect_uri",vn="instance_aware";
/*! @azure/msal-common v15.9.0 2025-07-23 */
/*! @azure/msal-common v15.9.0 2025-07-23 */
function wn(e,t,r){if(!t)return;const n=e.get(dn);n&&e.has(yn)&&r?.addFields({embeddedClientId:n,embeddedRedirectUri:e.get(un)},t)}function In(e,t){e.set("response_type",t)}function Tn(e,t,r=!0,n=h){!r||n.includes("openid")||t.includes("openid")||n.push("openid");const o=r?[...t||[],...n]:t||[],i=new yr(o);e.set("scope",i.printScopes())}function An(e,t){e.set(dn,t)}function kn(e,t){e.set(un,t)}function Sn(e,t){e.set("login_hint",t)}function bn(e,t){e.set(m,`UPN:${t}`)}function En(e,t){e.set(m,`Oid:${t.uid}@${t.utid}`)}function Rn(e,t){e.set("sid",t)}function _n(e,t,r){const n=zn(t,r);try{JSON.parse(n)}catch(e){throw mr(Wt)}e.set("claims",n)}function Pn(e,t){e.set("client-request-id",t)}function Mn(e,t){e.set("x-client-SKU",t.sku),e.set("x-client-VER",t.version),t.os&&e.set("x-client-OS",t.os),t.cpu&&e.set("x-client-CPU",t.cpu)}function On(e,t){t?.appName&&e.set("x-app-name",t.appName),t?.appVersion&&e.set("x-app-ver",t.appVersion)}function qn(e,t){t&&e.set("state",t)}function Nn(e,t,r){if(!t||!r)throw mr(Xt);e.set("code_challenge",t),e.set("code_challenge_method",r)}function Ln(e,t){e.set("client_secret",t)}function Un(e,t){t&&e.set("client_assertion",t)}function Hn(e,t){t&&e.set("client_assertion_type",t)}function xn(e,t){e.set("grant_type",t)}function Dn(e){e.set("client_info","1")}function Bn(e){e.has(vn)||e.set(vn,"true")}function Fn(e,t){Object.entries(t).forEach((([t,r])=>{!e.has(t)&&r&&e.set(t,r)}))}function zn(e,t){let r;if(e)try{r=JSON.parse(e)}catch(e){throw mr(Wt)}else r={};return t&&t.length>0&&(r.hasOwnProperty(k)||(r[k]={}),r[k][S]={values:t}),JSON.stringify(r)}function Kn(e,t){t&&(e.set(gn,W.POP),e.set(pn,t))}function Gn(e,t){t&&(e.set(gn,W.SSH),e.set(pn,t))}function $n(e,t){e.set("x-client-current-telemetry",t.generateCurrentRequestHeaderValue()),e.set("x-client-last-telemetry",t.generateLastRequestHeaderValue())}function Qn(e){e.set("x-ms-lib-capability",X)}function jn(e,t,r){e.has(yn)||e.set(yn,t),e.has(Cn)||e.set(Cn,r)}
/*! @azure/msal-common v15.9.0 2025-07-23 */
const Wn=(e,t,r,n,o)=>(...i)=>{r.trace(`Executing function ${t}`);const s=n?.startMeasurement(t,o);if(o){const e=t+"CallCount";n?.incrementFields({[e]:1},o)}try{const n=e(...i);return s?.end({success:!0}),r.trace(`Returning result from ${t}`),n}catch(e){r.trace(`Error occurred in ${t}`);try{r.trace(JSON.stringify(e))}catch(e){r.trace("Unable to print error message.")}throw s?.end({success:!1},e),e}},Vn=(e,t,r,n,o)=>(...i)=>{r.trace(`Executing function ${t}`);const s=n?.startMeasurement(t,o);if(o){const e=t+"CallCount";n?.incrementFields({[e]:1},o)}return n?.setPreQueueTime(t,o),e(...i).then((e=>(r.trace(`Returning result from ${t}`),s?.end({success:!0}),e))).catch((e=>{r.trace(`Error occurred in ${t}`);try{r.trace(JSON.stringify(e))}catch(e){r.trace("Unable to print error message.")}throw s?.end({success:!1},e),e}))};
/*! @azure/msal-common v15.9.0 2025-07-23 */
class Jn{constructor(e,t,r,n){this.networkInterface=e,this.logger=t,this.performanceClient=r,this.correlationId=n}async detectRegion(e,n){this.performanceClient?.addQueueMeasurement(Qr.RegionDiscoveryDetectRegion,this.correlationId);let i=e;if(i)n.region_source=re;else{const e=Jn.IMDS_OPTIONS;try{const s=await Vn(this.getRegionFromIMDS.bind(this),Qr.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(t.IMDS_VERSION,e);if(s.status===r&&(i=s.body,n.region_source=ne),s.status===o){const t=await Vn(this.getCurrentVersion.bind(this),Qr.RegionDiscoveryGetCurrentVersion,this.logger,this.performanceClient,this.correlationId)(e);if(!t)return n.region_source=te,null;const o=await Vn(this.getRegionFromIMDS.bind(this),Qr.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(t,e);o.status===r&&(i=o.body,n.region_source=ne)}}catch(e){return n.region_source=te,null}}return i||(n.region_source=te),i||null}async getRegionFromIMDS(e,r){return this.performanceClient?.addQueueMeasurement(Qr.RegionDiscoveryGetRegionFromIMDS,this.correlationId),this.networkInterface.sendGetRequestAsync(`${t.IMDS_ENDPOINT}?api-version=${e}&format=text`,r,t.IMDS_TIMEOUT)}async getCurrentVersion(e){this.performanceClient?.addQueueMeasurement(Qr.RegionDiscoveryGetCurrentVersion,this.correlationId);try{const r=await this.networkInterface.sendGetRequestAsync(`${t.IMDS_ENDPOINT}?format=json`,e);return r.status===o&&r.body&&r.body["newest-versions"]&&r.body["newest-versions"].length>0?r.body["newest-versions"][0]:null}catch(e){return null}}}Jn.IMDS_OPTIONS={headers:{Metadata:"true"}};
/*! @azure/msal-common v15.9.0 2025-07-23 */
class Yn{constructor(e,t,r,n,o,i,s,a){this.canonicalAuthority=e,this._canonicalAuthority.validateAsUri(),this.networkInterface=t,this.cacheManager=r,this.authorityOptions=n,this.regionDiscoveryMetadata={region_used:void 0,region_source:void 0,region_outcome:void 0},this.logger=o,this.performanceClient=s,this.correlationId=i,this.managedIdentity=a||!1,this.regionDiscovery=new Jn(t,this.logger,this.performanceClient,this.correlationId)}getAuthorityType(e){if(e.HostNameAndPort.endsWith(t.CIAM_AUTH_URL))return br;const r=e.PathSegments;if(r.length)switch(r[0].toLowerCase()){case t.ADFS:return kr;case t.DSTS:return Sr}return Ar}get authorityType(){return this.getAuthorityType(this.canonicalAuthorityUrlComponents)}get protocolMode(){return this.authorityOptions.protocolMode}get options(){return this.authorityOptions}get canonicalAuthority(){return this._canonicalAuthority.urlString}set canonicalAuthority(e){this._canonicalAuthority=new qr(e),this._canonicalAuthority.validateAsUri(),this._canonicalAuthorityUrlComponents=null}get canonicalAuthorityUrlComponents(){return this._canonicalAuthorityUrlComponents||(this._canonicalAuthorityUrlComponents=this._canonicalAuthority.getUrlComponents()),this._canonicalAuthorityUrlComponents}get hostnameAndPort(){return this.canonicalAuthorityUrlComponents.HostNameAndPort.toLowerCase()}get tenant(){return this.canonicalAuthorityUrlComponents.PathSegments[0]}get authorizationEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.authorization_endpoint);throw pt(ke)}get tokenEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint);throw pt(ke)}get deviceCodeEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint.replace("/token","/devicecode"));throw pt(ke)}get endSessionEndpoint(){if(this.discoveryComplete()){if(!this.metadata.end_session_endpoint)throw pt(nt);return this.replacePath(this.metadata.end_session_endpoint)}throw pt(ke)}get selfSignedJwtAudience(){if(this.discoveryComplete())return this.replacePath(this.metadata.issuer);throw pt(ke)}get jwksUri(){if(this.discoveryComplete())return this.replacePath(this.metadata.jwks_uri);throw pt(ke)}canReplaceTenant(e){return 1===e.PathSegments.length&&!Yn.reservedTenantDomains.has(e.PathSegments[0])&&this.getAuthorityType(e)===Ar&&this.protocolMode!==Rr.OIDC}replaceTenant(e){return e.replace(/{tenant}|{tenantid}/g,this.tenant)}replacePath(e){let t=e;const r=new qr(this.metadata.canonical_authority).getUrlComponents(),n=r.PathSegments;return this.canonicalAuthorityUrlComponents.PathSegments.forEach(((e,o)=>{let i=n[o];if(0===o&&this.canReplaceTenant(r)){const e=new qr(this.metadata.authorization_endpoint).getUrlComponents().PathSegments[0];i!==e&&(this.logger.verbose(`Replacing tenant domain name ${i} with id ${e}`),i=e)}e!==i&&(t=t.replace(`/${i}/`,`/${e}/`))})),this.replaceTenant(t)}get defaultOpenIdConfigurationEndpoint(){const e=this.hostnameAndPort;return this.canonicalAuthority.endsWith("v2.0/")||this.authorityType===kr||this.protocolMode===Rr.OIDC&&!this.isAliasOfKnownMicrosoftAuthority(e)?`${this.canonicalAuthority}.well-known/openid-configuration`:`${this.canonicalAuthority}v2.0/.well-known/openid-configuration`}discoveryComplete(){return!!this.metadata}async resolveEndpointsAsync(){this.performanceClient?.addQueueMeasurement(Qr.AuthorityResolveEndpointsAsync,this.correlationId);const e=this.getCurrentMetadataEntity(),t=await Vn(this.updateCloudDiscoveryMetadata.bind(this),Qr.AuthorityUpdateCloudDiscoveryMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.canonicalAuthority=this.canonicalAuthority.replace(this.hostnameAndPort,e.preferred_network);const r=await Vn(this.updateEndpointMetadata.bind(this),Qr.AuthorityUpdateEndpointMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.updateCachedMetadata(e,t,{source:r}),this.performanceClient?.addFields({cloudDiscoverySource:t,authorityEndpointSource:r},this.correlationId)}getCurrentMetadataEntity(){let e=this.cacheManager.getAuthorityMetadataByAlias(this.hostnameAndPort);return e||(e={aliases:[],preferred_cache:this.hostnameAndPort,preferred_network:this.hostnameAndPort,canonical_authority:this.canonicalAuthority,authorization_endpoint:"",token_endpoint:"",end_session_endpoint:"",issuer:"",aliasesFromNetwork:!1,endpointsFromNetwork:!1,expiresAt:xt(),jwks_uri:""}),e}updateCachedMetadata(e,t,r){t!==G&&r?.source!==G&&(e.expiresAt=xt(),e.canonical_authority=this.canonicalAuthority);const n=this.cacheManager.generateAuthorityMetadataCacheKey(e.preferred_cache);this.cacheManager.setAuthorityMetadata(n,e),this.metadata=e}async updateEndpointMetadata(e){this.performanceClient?.addQueueMeasurement(Qr.AuthorityUpdateEndpointMetadata,this.correlationId);const t=this.updateEndpointMetadataFromLocalSources(e);if(t){if(t.source===Q&&this.authorityOptions.azureRegionConfiguration?.azureRegion&&t.metadata){Dt(e,await Vn(this.updateMetadataWithRegionalInformation.bind(this),Qr.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(t.metadata),!1),e.canonical_authority=this.canonicalAuthority}return t.source}let r=await Vn(this.getEndpointMetadataFromNetwork.bind(this),Qr.AuthorityGetEndpointMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(r)return this.authorityOptions.azureRegionConfiguration?.azureRegion&&(r=await Vn(this.updateMetadataWithRegionalInformation.bind(this),Qr.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(r)),Dt(e,r,!0),$;throw pt(be,this.defaultOpenIdConfigurationEndpoint)}updateEndpointMetadataFromLocalSources(e){this.logger.verbose("Attempting to get endpoint metadata from authority configuration");const t=this.getEndpointMetadataFromConfig();if(t)return this.logger.verbose("Found endpoint metadata in authority configuration"),Dt(e,t,!1),{source:K};if(this.logger.verbose("Did not find endpoint metadata in the config... Attempting to get endpoint metadata from the hardcoded values."),this.authorityOptions.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get endpoint metadata from the network metadata cache.");else{const t=this.getEndpointMetadataFromHardcodedValues();if(t)return Dt(e,t,!1),{source:Q,metadata:t};this.logger.verbose("Did not find endpoint metadata in hardcoded values... Attempting to get endpoint metadata from the network metadata cache.")}const r=Ft(e);return this.isAuthoritySameType(e)&&e.endpointsFromNetwork&&!r?(this.logger.verbose("Found endpoint metadata in the cache."),{source:G}):(r&&this.logger.verbose("The metadata entity is expired."),null)}isAuthoritySameType(e){return new qr(e.canonical_authority).getUrlComponents().PathSegments.length===this.canonicalAuthorityUrlComponents.PathSegments.length}getEndpointMetadataFromConfig(){if(this.authorityOptions.authorityMetadata)try{return JSON.parse(this.authorityOptions.authorityMetadata)}catch(e){throw mr(er)}return null}async getEndpointMetadataFromNetwork(){this.performanceClient?.addQueueMeasurement(Qr.AuthorityGetEndpointMetadataFromNetwork,this.correlationId);const e={},t=this.defaultOpenIdConfigurationEndpoint;this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: attempting to retrieve OAuth endpoints from ${t}`);try{const r=await this.networkInterface.sendGetRequestAsync(t,e),n=
/*! @azure/msal-common v15.9.0 2025-07-23 */
function(e){return e.hasOwnProperty("authorization_endpoint")&&e.hasOwnProperty("token_endpoint")&&e.hasOwnProperty("issuer")&&e.hasOwnProperty("jwks_uri")}
/*! @azure/msal-common v15.9.0 2025-07-23 */(r.body);return n?r.body:(this.logger.verbose("Authority.getEndpointMetadataFromNetwork: could not parse response as OpenID configuration"),null)}catch(e){return this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: ${e}`),null}}getEndpointMetadataFromHardcodedValues(){return this.hostnameAndPort in Nr?Nr[this.hostnameAndPort]:null}async updateMetadataWithRegionalInformation(e){this.performanceClient?.addQueueMeasurement(Qr.AuthorityUpdateMetadataWithRegionalInformation,this.correlationId);const r=this.authorityOptions.azureRegionConfiguration?.azureRegion;if(r){if(r!==t.AZURE_REGION_AUTO_DISCOVER_FLAG)return this.regionDiscoveryMetadata.region_outcome=oe,this.regionDiscoveryMetadata.region_used=r,Yn.replaceWithRegionalInformation(e,r);const n=await Vn(this.regionDiscovery.detectRegion.bind(this.regionDiscovery),Qr.RegionDiscoveryDetectRegion,this.logger,this.performanceClient,this.correlationId)(this.authorityOptions.azureRegionConfiguration?.environmentRegion,this.regionDiscoveryMetadata);if(n)return this.regionDiscoveryMetadata.region_outcome=ie,this.regionDiscoveryMetadata.region_used=n,Yn.replaceWithRegionalInformation(e,n);this.regionDiscoveryMetadata.region_outcome=se}return e}async updateCloudDiscoveryMetadata(e){this.performanceClient?.addQueueMeasurement(Qr.AuthorityUpdateCloudDiscoveryMetadata,this.correlationId);const t=this.updateCloudDiscoveryMetadataFromLocalSources(e);if(t)return t;const r=await Vn(this.getCloudDiscoveryMetadataFromNetwork.bind(this),Qr.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(r)return Bt(e,r,!0),$;throw mr(tr)}updateCloudDiscoveryMetadataFromLocalSources(e){this.logger.verbose("Attempting to get cloud discovery metadata  from authority configuration"),this.logger.verbosePii(`Known Authorities: ${this.authorityOptions.knownAuthorities||t.NOT_APPLICABLE}`),this.logger.verbosePii(`Authority Metadata: ${this.authorityOptions.authorityMetadata||t.NOT_APPLICABLE}`),this.logger.verbosePii(`Canonical Authority: ${e.canonical_authority||t.NOT_APPLICABLE}`);const r=this.getCloudDiscoveryMetadataFromConfig();if(r)return this.logger.verbose("Found cloud discovery metadata in authority configuration"),Bt(e,r,!1),K;if(this.logger.verbose("Did not find cloud discovery metadata in the config... Attempting to get cloud discovery metadata from the hardcoded values."),this.options.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded cloud discovery metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get cloud discovery metadata from the network metadata cache.");else{const t=(n=this.hostnameAndPort,xr(Lr.metadata,n));if(t)return this.logger.verbose("Found cloud discovery metadata from hardcoded values."),Bt(e,t,!1),Q;this.logger.verbose("Did not find cloud discovery metadata in hardcoded values... Attempting to get cloud discovery metadata from the network metadata cache.")}var n;const o=Ft(e);return this.isAuthoritySameType(e)&&e.aliasesFromNetwork&&!o?(this.logger.verbose("Found cloud discovery metadata in the cache."),G):(o&&this.logger.verbose("The metadata entity is expired."),null)}getCloudDiscoveryMetadataFromConfig(){if(this.authorityType===br)return this.logger.verbose("CIAM authorities do not support cloud discovery metadata, generate the aliases from authority host."),Yn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort);if(this.authorityOptions.cloudDiscoveryMetadata){this.logger.verbose("The cloud discovery metadata has been provided as a network response, in the config.");try{this.logger.verbose("Attempting to parse the cloud discovery metadata.");const e=xr(JSON.parse(this.authorityOptions.cloudDiscoveryMetadata).metadata,this.hostnameAndPort);if(this.logger.verbose("Parsed the cloud discovery metadata."),e)return this.logger.verbose("There is returnable metadata attached to the parsed cloud discovery metadata."),e;this.logger.verbose("There is no metadata attached to the parsed cloud discovery metadata.")}catch(e){throw this.logger.verbose("Unable to parse the cloud discovery metadata. Throwing Invalid Cloud Discovery Metadata Error."),mr(Zt)}}return this.isInKnownAuthorities()?(this.logger.verbose("The host is included in knownAuthorities. Creating new cloud discovery metadata from the host."),Yn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)):null}async getCloudDiscoveryMetadataFromNetwork(){this.performanceClient?.addQueueMeasurement(Qr.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.correlationId);const e=`${t.AAD_INSTANCE_DISCOVERY_ENDPT}${this.canonicalAuthority}oauth2/v2.0/authorize`,r={};let n=null;try{const o=await this.networkInterface.sendGetRequestAsync(e,r);let i,s;if(function(e){return e.hasOwnProperty("tenant_discovery_endpoint")&&e.hasOwnProperty("metadata")}
/*! @azure/msal-common v15.9.0 2025-07-23 */(o.body))i=o.body,s=i.metadata,this.logger.verbosePii(`tenant_discovery_endpoint is: ${i.tenant_discovery_endpoint}`);else{if(!function(e){return e.hasOwnProperty("error")&&e.hasOwnProperty("error_description")}(o.body))return this.logger.error("AAD did not return a CloudInstanceDiscoveryResponse or CloudInstanceDiscoveryErrorResponse"),null;if(this.logger.warning(`A CloudInstanceDiscoveryErrorResponse was returned. The cloud instance discovery network request's status code is: ${o.status}`),i=o.body,i.error===t.INVALID_INSTANCE)return this.logger.error("The CloudInstanceDiscoveryErrorResponse error is invalid_instance."),null;this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error is ${i.error}`),this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error description is ${i.error_description}`),this.logger.warning("Setting the value of the CloudInstanceDiscoveryMetadata (returned from the network) to []"),s=[]}this.logger.verbose("Attempting to find a match between the developer's authority and the CloudInstanceDiscoveryMetadata returned from the network request."),n=xr(s,this.hostnameAndPort)}catch(e){if(e instanceof Ce)this.logger.error(`There was a network error while attempting to get the cloud discovery instance metadata.\nError: ${e.errorCode}\nError Description: ${e.errorMessage}`);else{const t=e;this.logger.error(`A non-MSALJS error was thrown while attempting to get the cloud instance discovery metadata.\nError: ${t.name}\nError Description: ${t.message}`)}return null}return n||(this.logger.warning("The developer's authority was not found within the CloudInstanceDiscoveryMetadata returned from the network request."),this.logger.verbose("Creating custom Authority for custom domain scenario."),n=Yn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)),n}isInKnownAuthorities(){return this.authorityOptions.knownAuthorities.filter((e=>e&&qr.getDomainFromUrl(e).toLowerCase()===this.hostnameAndPort)).length>0}static generateAuthority(e,r){let n;if(r&&r.azureCloudInstance!==wt.None){const e=r.tenant?r.tenant:t.DEFAULT_COMMON_TENANT;n=`${r.azureCloudInstance}/${e}/`}return n||e}static createCloudDiscoveryMetadataFromHost(e){return{preferred_network:e,preferred_cache:e,aliases:[e]}}getPreferredCache(){if(this.managedIdentity)return t.DEFAULT_AUTHORITY_HOST;if(this.discoveryComplete())return this.metadata.preferred_cache;throw pt(ke)}isAlias(e){return this.metadata.aliases.indexOf(e)>-1}isAliasOfKnownMicrosoftAuthority(e){return Ur.has(e)}static isPublicCloudAuthority(e){return t.KNOWN_PUBLIC_CLOUDS.indexOf(e)>=0}static buildRegionalAuthorityString(e,r,n){const o=new qr(e);o.validateAsUri();const i=o.getUrlComponents();let s=`${r}.${i.HostNameAndPort}`;this.isPublicCloudAuthority(i.HostNameAndPort)&&(s=`${r}.${t.REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX}`);const a=qr.constructAuthorityUriFromObject({...o.getUrlComponents(),HostNameAndPort:s}).urlString;return n?`${a}?${n}`:a}static replaceWithRegionalInformation(e,t){const r={...e};return r.authorization_endpoint=Yn.buildRegionalAuthorityString(r.authorization_endpoint,t),r.token_endpoint=Yn.buildRegionalAuthorityString(r.token_endpoint,t),r.end_session_endpoint&&(r.end_session_endpoint=Yn.buildRegionalAuthorityString(r.end_session_endpoint,t)),r}static transformCIAMAuthority(e){let r=e;const n=new qr(e).getUrlComponents();if(0===n.PathSegments.length&&n.HostNameAndPort.endsWith(t.CIAM_AUTH_URL)){r=`${r}${n.HostNameAndPort.split(".")[0]}${t.AAD_TENANT_DOMAIN_SUFFIX}`}return r}}function Xn(e){return e.endsWith(t.FORWARD_SLASH)?e:`${e}${t.FORWARD_SLASH}`}function Zn(e){const t=e.cloudDiscoveryMetadata;let r;if(t)try{r=JSON.parse(t)}catch(e){throw mr(Zt)}return{canonicalAuthority:e.authority?Xn(e.authority):void 0,knownAuthorities:e.knownAuthorities,cloudDiscoveryMetadata:r}}
/*! @azure/msal-common v15.9.0 2025-07-23 */async function eo(e,t,r,n,o,i,s){s?.addQueueMeasurement(Qr.AuthorityFactoryCreateDiscoveredInstance,i);const a=Yn.transformCIAMAuthority(Xn(e)),c=new Yn(a,t,r,n,o,i,s);try{return await Vn(c.resolveEndpointsAsync.bind(c),Qr.AuthorityResolveEndpointsAsync,o,s,i)(),c}catch(e){throw pt(ke)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */Yn.reservedTenantDomains=new Set(["{tenant}","{tenantid}",I,A,T]);class to extends Ce{constructor(e,t,r,n,o){super(e,t,r),this.name="ServerError",this.errorNo=n,this.status=o,Object.setPrototypeOf(this,to.prototype)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */function ro(e,t,r){return{clientId:e,authority:t.authority,scopes:t.scopes,homeAccountIdentifier:r,claims:t.claims,authenticationScheme:t.authenticationScheme,resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,sshKid:t.sshKid,embeddedClientId:t.embeddedClientId||t.tokenBodyParameters?.clientId}}
/*! @azure/msal-common v15.9.0 2025-07-23 */class no{static generateThrottlingStorageKey(e){return`${Y}.${JSON.stringify(e)}`}static preProcess(e,r,n){const o=no.generateThrottlingStorageKey(r),i=e.getThrottlingCache(o);if(i){if(i.throttleTime<Date.now())return void e.removeItem(o,n);throw new to(i.errorCodes?.join(" ")||t.EMPTY_STRING,i.errorMessage,i.subError)}}static postProcess(e,t,r,n){if(no.checkResponseStatus(r)||no.checkResponseForRetryAfter(r)){const o={throttleTime:no.calculateThrottleTime(parseInt(r.headers[p])),error:r.body.error,errorCodes:r.body.error_codes,errorMessage:r.body.error_description,subError:r.body.suberror};e.setThrottlingCache(no.generateThrottlingStorageKey(t),o,n)}}static checkResponseStatus(e){return 429===e.status||e.status>=500&&e.status<600}static checkResponseForRetryAfter(e){return!!e.headers&&(e.headers.hasOwnProperty(p)&&(e.status<200||e.status>=300))}static calculateThrottleTime(e){const t=e<=0?0:e,r=Date.now()/1e3;return Math.floor(1e3*Math.min(r+(t||V),r+J))}static removeThrottle(e,t,r,n){const o=ro(t,r,n),i=this.generateThrottlingStorageKey(o);e.removeItem(i,r.correlationId)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */class oo extends Ce{constructor(e,t,r){super(e.errorCode,e.errorMessage,e.subError),Object.setPrototypeOf(this,oo.prototype),this.name="NetworkError",this.error=e,this.httpStatus=t,this.responseHeaders=r}}function io(e,t,r,n){return e.errorMessage=`${e.errorMessage}, additionalErrorInfo: error.name:${n?.name}, error.message:${n?.message}`,new oo(e,t,r)}
/*! @azure/msal-common v15.9.0 2025-07-23 */class so{constructor(e,t){this.config=function({authOptions:e,systemOptions:t,loggerOptions:r,cacheOptions:n,storageInterface:o,networkInterface:i,cryptoInterface:s,clientCredentials:a,libraryInfo:c,telemetry:l,serverTelemetryManager:h,persistencePlugin:d,serializableCache:u}){const g={...en,...r};return{authOptions:(p=e,{clientCapabilities:[],azureCloudOptions:sn,skipAuthorityMetadataCache:!1,instanceAware:!1,encodeExtraQueryParams:!1,...p}),systemOptions:{...Zr,...t},loggerOptions:g,cacheOptions:{...tn,...n},storageInterface:o||new $r(e.clientId,mt,new yt(g),new Xr),networkInterface:i||rn,cryptoInterface:s||mt,clientCredentials:a||on,libraryInfo:{...nn,...c},telemetry:{...an,...l},serverTelemetryManager:h||null,persistencePlugin:d||null,serializableCache:u||null};var p}(e),this.logger=new yt(this.config.loggerOptions,Ct,vt),this.cryptoUtils=this.config.cryptoInterface,this.cacheManager=this.config.storageInterface,this.networkClient=this.config.networkInterface,this.serverTelemetryManager=this.config.serverTelemetryManager,this.authority=this.config.authOptions.authority,this.performanceClient=t}createTokenRequestHeaders(e){const r={};if(r[u]=t.URL_FORM_CONTENT_TYPE,!this.config.systemOptions.preventCorsPreflight&&e)switch(e.type){case ln:try{const t=vr(e.credential);r[m]=`Oid:${t.uid}@${t.utid}`}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case hn:r[m]=`UPN: ${e.credential}`}return r}async executePostToTokenEndpoint(e,t,r,n,o,i){i&&this.performanceClient?.addQueueMeasurement(i,o);const s=await this.sendPostRequest(n,e,{body:t,headers:r},o);return this.config.serverTelemetryManager&&s.status<500&&429!==s.status&&this.config.serverTelemetryManager.clearTelemetryCache(),s}async sendPostRequest(e,t,r,n){let o;no.preProcess(this.cacheManager,e,n);try{o=await Vn(this.networkClient.sendPostRequestAsync.bind(this.networkClient),Qr.NetworkClientSendPostRequestAsync,this.logger,this.performanceClient,n)(t,r);const e=o.headers||{};this.performanceClient?.addFields({refreshTokenSize:o.body.refresh_token?.length||0,httpVerToken:e[v]||"",requestId:e[C]||""},n)}catch(e){if(e instanceof oo){const t=e.responseHeaders;throw t&&this.performanceClient?.addFields({httpVerToken:t[v]||"",requestId:t[C]||"",contentTypeHeader:t[u]||void 0,contentLengthHeader:t[g]||void 0,httpStatus:e.httpStatus},n),e.error}throw e instanceof Ce?e:pt(Se)}return no.postProcess(this.cacheManager,e,o,n),o}async updateAuthority(e,t){this.performanceClient?.addQueueMeasurement(Qr.UpdateTokenEndpointAuthority,t);const r=`https://${e}/${this.authority.tenant}/`,n=await eo(r,this.networkClient,this.cacheManager,this.authority.options,this.logger,t,this.performanceClient);this.authority=n}createTokenQueryParameters(e){const t=new Map;return e.embeddedClientId&&jn(t,this.config.authOptions.clientId,this.config.authOptions.redirectUri),e.tokenQueryParameters&&Fn(t,e.tokenQueryParameters),Pn(t,e.correlationId),wn(t,e.correlationId,this.performanceClient),Or(t)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */const ao="no_tokens_found",co="native_account_unavailable",lo="refresh_token_expired",ho="ux_not_allowed",uo="interaction_required",go="consent_required",po="login_required",mo="bad_token";var fo=Object.freeze({__proto__:null,badToken:mo,consentRequired:go,interactionRequired:uo,loginRequired:po,nativeAccountUnavailable:co,noTokensFound:ao,refreshTokenExpired:lo,uxNotAllowed:ho});
/*! @azure/msal-common v15.9.0 2025-07-23 */const yo=[uo,go,po,mo,ho],Co=["message_only","additional_action","basic_action","user_password_expired","consent_required","bad_token"],vo={[ao]:"No refresh token found in the cache. Please sign-in.",[co]:"The requested account is not available in the native broker. It may have been deleted or logged out. Please sign-in again using an interactive API.",[lo]:"Refresh token has expired.",[mo]:"Identity provider returned bad_token due to an expired or invalid refresh token. Please invoke an interactive API to resolve.",[ho]:"`canShowUI` flag in Edge was set to false. User interaction required on web page. Please invoke an interactive API to resolve."},wo={noTokensFoundError:{code:ao,desc:vo[ao]},native_account_unavailable:{code:co,desc:vo[co]},bad_token:{code:mo,desc:vo[mo]}};class Io extends Ce{constructor(e,r,n,o,i,s,a,c){super(e,r,n),Object.setPrototypeOf(this,Io.prototype),this.timestamp=o||t.EMPTY_STRING,this.traceId=i||t.EMPTY_STRING,this.correlationId=s||t.EMPTY_STRING,this.claims=a||t.EMPTY_STRING,this.name="InteractionRequiredAuthError",this.errorNo=c}}function To(e,t,r){const n=!!e&&yo.indexOf(e)>-1,o=!!r&&Co.indexOf(r)>-1,i=!!t&&yo.some((e=>t.indexOf(e)>-1));return n||i||o}function Ao(e){return new Io(e,vo[e])}
/*! @azure/msal-common v15.9.0 2025-07-23 */class ko{static setRequestState(e,r,n){const o=ko.generateLibraryState(e,n);return r?`${o}${t.RESOURCE_DELIM}${r}`:o}static generateLibraryState(e,t){if(!e)throw pt(We);const r={id:e.createNewGuid()};t&&(r.meta=t);const n=JSON.stringify(r);return e.base64Encode(n)}static parseRequestState(e,r){if(!e)throw pt(We);if(!r)throw pt(Re);try{const n=r.split(t.RESOURCE_DELIM),o=n[0],i=n.length>1?n.slice(1).join(t.RESOURCE_DELIM):t.EMPTY_STRING,s=e.base64Decode(o),a=JSON.parse(s);return{userRequestState:i||t.EMPTY_STRING,libraryState:a}}catch(e){throw pt(Re)}}}
/*! @azure/msal-common v15.9.0 2025-07-23 */const So="sw";class bo{constructor(e,t){this.cryptoUtils=e,this.performanceClient=t}async generateCnf(e,t){this.performanceClient?.addQueueMeasurement(Qr.PopTokenGenerateCnf,e.correlationId);const r=await Vn(this.generateKid.bind(this),Qr.PopTokenGenerateCnf,t,this.performanceClient,e.correlationId)(e),n=this.cryptoUtils.base64UrlEncode(JSON.stringify(r));return{kid:r.kid,reqCnfString:n}}async generateKid(e){this.performanceClient?.addQueueMeasurement(Qr.PopTokenGenerateKid,e.correlationId);return{kid:await this.cryptoUtils.getPublicKeyThumbprint(e),xms_ksl:So}}async signPopToken(e,t,r){return this.signPayload(e,t,r)}async signPayload(e,t,r,n){const{resourceRequestMethod:o,resourceRequestUri:i,shrClaims:s,shrNonce:a,shrOptions:c}=r,l=i?new qr(i):void 0,h=l?.getUrlComponents();return this.cryptoUtils.signJwt({at:e,ts:At(),m:o?.toUpperCase(),u:h?.HostNameAndPort,nonce:a||this.cryptoUtils.createNewGuid(),p:h?.AbsolutePath,q:h?.QueryString?[[],h.QueryString]:void 0,client_claims:s||void 0,...n},t,c,r.correlationId)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */class Eo{constructor(e,t){this.cache=e,this.hasChanged=t}get cacheHasChanged(){return this.hasChanged}get tokenCache(){return this.cache}}
/*! @azure/msal-common v15.9.0 2025-07-23 */class Ro{constructor(e,t,r,n,o,i,s){this.clientId=e,this.cacheStorage=t,this.cryptoObj=r,this.logger=n,this.serializableCache=o,this.persistencePlugin=i,this.performanceClient=s}validateTokenResponse(e,r){if(e.error||e.error_description||e.suberror){const o=`Error(s): ${e.error_codes||t.NOT_AVAILABLE} - Timestamp: ${e.timestamp||t.NOT_AVAILABLE} - Description: ${e.error_description||t.NOT_AVAILABLE} - Correlation ID: ${e.correlation_id||t.NOT_AVAILABLE} - Trace ID: ${e.trace_id||t.NOT_AVAILABLE}`,c=e.error_codes?.length?e.error_codes[0]:void 0,l=new to(e.error,o,e.suberror,c,e.status);if(r&&e.status&&e.status>=s&&e.status<=a)return void this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently unavailable and the access token is unable to be refreshed.\n${l}`);if(r&&e.status&&e.status>=n&&e.status<=i)return void this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently available but is unable to refresh the access token.\n${l}`);if(To(e.error,e.error_description,e.suberror))throw new Io(e.error,e.error_description,e.suberror,e.timestamp||t.EMPTY_STRING,e.trace_id||t.EMPTY_STRING,e.correlation_id||t.EMPTY_STRING,e.claims||t.EMPTY_STRING,c);throw l}}async handleServerTokenResponse(e,r,n,o,i,s,a,c,l){let h,d;if(this.performanceClient?.addQueueMeasurement(Qr.HandleServerTokenResponse,e.correlation_id),e.id_token){if(h=It(e.id_token||t.EMPTY_STRING,this.cryptoObj.base64Decode),i&&i.nonce&&h.nonce!==i.nonce)throw pt(Me);if(o.maxAge||0===o.maxAge){const e=h.auth_time;if(!e)throw pt(Oe);Tt(e,o.maxAge)}}this.homeAccountIdentifier=_r.generateHomeAccountId(e.client_info||t.EMPTY_STRING,r.authorityType,this.logger,this.cryptoObj,h),i&&i.state&&(d=ko.parseRequestState(this.cryptoObj,i.state)),e.key_id=e.key_id||o.sshKid||void 0;const u=this.generateCacheRecord(e,r,n,o,h,s,i);let g;try{if(this.persistencePlugin&&this.serializableCache&&(this.logger.verbose("Persistence enabled, calling beforeCacheAccess"),g=new Eo(this.serializableCache,!0),await this.persistencePlugin.beforeCacheAccess(g)),a&&!c&&u.account){const e=u.account.generateAccountKey();if(!this.cacheStorage.getAccount(e,o.correlationId))return this.logger.warning("Account used to refresh tokens not in persistence, refreshed tokens will not be stored in the cache"),await Ro.generateAuthenticationResult(this.cryptoObj,r,u,!1,o,h,d,void 0,l)}await this.cacheStorage.saveCacheRecord(u,o.correlationId,o.storeInCache)}finally{this.persistencePlugin&&this.serializableCache&&g&&(this.logger.verbose("Persistence enabled, calling afterCacheAccess"),await this.persistencePlugin.afterCacheAccess(g))}return Ro.generateAuthenticationResult(this.cryptoObj,r,u,!1,o,h,d,e,l)}generateCacheRecord(e,t,r,n,o,i,s){const a=t.getPreferredCache();if(!a)throw pt(Qe);const c=Er(o);let l,h;e.id_token&&o&&(l=_t(this.homeAccountIdentifier,a,e.id_token,this.clientId,c||""),h=_o(this.cacheStorage,t,this.homeAccountIdentifier,this.cryptoObj.base64Decode,n.correlationId,o,e.client_info,a,c,s,void 0,this.logger));let d=null;if(e.access_token){const o=e.scope?yr.fromString(e.scope):new yr(n.scopes||[]),s=("string"==typeof e.expires_in?parseInt(e.expires_in,10):e.expires_in)||0,l=("string"==typeof e.ext_expires_in?parseInt(e.ext_expires_in,10):e.ext_expires_in)||0,h=("string"==typeof e.refresh_in?parseInt(e.refresh_in,10):e.refresh_in)||void 0,u=r+s,g=u+l,p=h&&h>0?r+h:void 0;d=Pt(this.homeAccountIdentifier,a,e.access_token,this.clientId,c||t.tenant||"",o.printScopes(),u,g,this.cryptoObj.base64Decode,p,e.token_type,i,e.key_id,n.claims,n.requestedClaimsHash)}let u=null;if(e.refresh_token){let t;if(e.refresh_token_expires_in){t=r+("string"==typeof e.refresh_token_expires_in?parseInt(e.refresh_token_expires_in,10):e.refresh_token_expires_in)}u=Mt(this.homeAccountIdentifier,a,e.refresh_token,this.clientId,e.foci,i,t)}let g=null;return e.foci&&(g={clientId:this.clientId,environment:a,familyId:e.foci}),{account:h,idToken:l,accessToken:d,refreshToken:u,appMetadata:g}}static async generateAuthenticationResult(e,r,n,o,i,s,a,c,l){let h,d,u=t.EMPTY_STRING,g=[],p=null,m=t.EMPTY_STRING;if(n.accessToken){if(n.accessToken.tokenType!==W.POP||i.popKid)u=n.accessToken.secret;else{const t=new bo(e),{secret:r,keyId:o}=n.accessToken;if(!o)throw pt(ot);u=await t.signPopToken(r,o,i)}g=yr.fromString(n.accessToken.target).asArray(),p=St(n.accessToken.expiresOn),h=St(n.accessToken.extendedExpiresOn),n.accessToken.refreshOn&&(d=St(n.accessToken.refreshOn))}n.appMetadata&&(m=n.appMetadata.familyId===B?B:"");const f=s?.oid||s?.sub||"",y=s?.tid||"";c?.spa_accountid&&n.account&&(n.account.nativeAccountId=c?.spa_accountid);const C=n.account?Tr(n.account.getAccountInfo(),void 0,s,n.idToken?.secret):null;return{authority:r.canonicalAuthority,uniqueId:f,tenantId:y,scopes:g,account:C,idToken:n?.idToken?.secret||"",idTokenClaims:s||{},accessToken:u,fromCache:o,expiresOn:p,extExpiresOn:h,refreshOn:d,correlationId:i.correlationId,requestId:l||t.EMPTY_STRING,familyId:m,tokenType:n.accessToken?.tokenType||t.EMPTY_STRING,state:a?a.userRequestState:t.EMPTY_STRING,cloudGraphHostName:n.account?.cloudGraphHostName||t.EMPTY_STRING,msGraphHost:n.account?.msGraphHost||t.EMPTY_STRING,code:c?.spa_code,fromNativeBroker:!1}}}function _o(e,t,r,n,o,i,s,a,c,l,h,d){d?.verbose("setCachedAccount called");const u=e.getAccountKeys().find((e=>e.startsWith(r)));let g=null;u&&(g=e.getAccount(u,o));const p=g||_r.createAccount({homeAccountId:r,idTokenClaims:i,clientInfo:s,environment:a,cloudGraphHostName:l?.cloud_graph_host_name,msGraphHost:l?.msgraph_host,nativeAccountId:h},t,n),m=p.tenantProfiles||[],f=c||p.realm;if(f&&!m.find((e=>e.tenantId===f))){const e=Ir(r,p.localAccountId,f,i);m.push(e)}return p.tenantProfiles=m,p}
/*! @azure/msal-common v15.9.0 2025-07-23 */async function Po(e,t,r){if("string"==typeof e)return e;return e({clientId:t,tokenEndpoint:r})}
/*! @azure/msal-common v15.9.0 2025-07-23 */class Mo extends so{constructor(e,t){super(e,t),this.includeRedirectUri=!0,this.oidcDefaultScopes=this.config.authOptions.authority.options.OIDCOptions?.defaultScopes}async acquireToken(e,t){if(this.performanceClient?.addQueueMeasurement(Qr.AuthClientAcquireToken,e.correlationId),!e.code)throw pt(He);const r=At(),n=await Vn(this.executeTokenRequest.bind(this),Qr.AuthClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(this.authority,e),o=n.headers?.[C],i=new Ro(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin,this.performanceClient);return i.validateTokenResponse(n.body),Vn(i.handleServerTokenResponse.bind(i),Qr.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(n.body,this.authority,r,e,t,void 0,void 0,void 0,o)}getLogoutUri(e){if(!e)throw mr(Jt);const t=this.createLogoutUrlQueryString(e);return qr.appendQueryString(this.authority.endSessionEndpoint,t)}async executeTokenRequest(e,t){this.performanceClient?.addQueueMeasurement(Qr.AuthClientExecuteTokenRequest,t.correlationId);const r=this.createTokenQueryParameters(t),n=qr.appendQueryString(e.tokenEndpoint,r),o=await Vn(this.createTokenRequestBody.bind(this),Qr.AuthClientCreateTokenRequestBody,this.logger,this.performanceClient,t.correlationId)(t);let i;if(t.clientInfo)try{const e=Cr(t.clientInfo,this.cryptoUtils.base64Decode);i={credential:`${e.uid}${H}${e.utid}`,type:ln}}catch(e){this.logger.verbose("Could not parse client info for CCS Header: "+e)}const s=this.createTokenRequestHeaders(i||t.ccsCredential),a=ro(this.config.authOptions.clientId,t);return Vn(this.executePostToTokenEndpoint.bind(this),Qr.AuthorizationCodeClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,t.correlationId)(n,o,s,a,t.correlationId,Qr.AuthorizationCodeClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){this.performanceClient?.addQueueMeasurement(Qr.AuthClientCreateTokenRequestBody,e.correlationId);const t=new Map;if(An(t,e.embeddedClientId||e.tokenBodyParameters?.[dn]||this.config.authOptions.clientId),this.includeRedirectUri)kn(t,e.redirectUri);else if(!e.redirectUri)throw mr(zt);if(Tn(t,e.scopes,!0,this.oidcDefaultScopes),function(e,t){e.set("code",t)}(t,e.code),Mn(t,this.config.libraryInfo),On(t,this.config.telemetry.application),Qn(t),this.serverTelemetryManager&&!cn(this.config)&&$n(t,this.serverTelemetryManager),e.codeVerifier&&function(e,t){e.set("code_verifier",t)}(t,e.codeVerifier),this.config.clientCredentials.clientSecret&&Ln(t,this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const r=this.config.clientCredentials.clientAssertion;Un(t,await Po(r.assertion,this.config.authOptions.clientId,e.resourceRequestUri)),Hn(t,r.assertionType)}if(xn(t,M),Dn(t),e.authenticationScheme===W.POP){const r=new bo(this.cryptoUtils,this.performanceClient);let n;if(e.popKid)n=this.cryptoUtils.encodeKid(e.popKid);else{n=(await Vn(r.generateCnf.bind(r),Qr.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString}Kn(t,n)}else if(e.authenticationScheme===W.SSH){if(!e.sshJwk)throw mr(rr);Gn(t,e.sshJwk)}let r;if((!fr.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&_n(t,e.claims,this.config.authOptions.clientCapabilities),e.clientInfo)try{const t=Cr(e.clientInfo,this.cryptoUtils.base64Decode);r={credential:`${t.uid}${H}${t.utid}`,type:ln}}catch(e){this.logger.verbose("Could not parse client info for CCS Header: "+e)}else r=e.ccsCredential;if(this.config.systemOptions.preventCorsPreflight&&r)switch(r.type){case ln:try{En(t,vr(r.credential))}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case hn:bn(t,r.credential)}return e.embeddedClientId&&jn(t,this.config.authOptions.clientId,this.config.authOptions.redirectUri),e.tokenBodyParameters&&Fn(t,e.tokenBodyParameters),!e.enableSpaAuthorizationCode||e.tokenBodyParameters&&e.tokenBodyParameters[mn]||Fn(t,{[mn]:"1"}),wn(t,e.correlationId,this.performanceClient),Or(t)}createLogoutUrlQueryString(e){const t=new Map;return e.postLogoutRedirectUri&&function(e,t){e.set("post_logout_redirect_uri",t)}(t,e.postLogoutRedirectUri),e.correlationId&&Pn(t,e.correlationId),e.idTokenHint&&function(e,t){e.set("id_token_hint",t)}(t,e.idTokenHint),e.state&&qn(t,e.state),e.logoutHint&&function(e,t){e.set("logout_hint",t)}(t,e.logoutHint),e.extraQueryParameters&&Fn(t,e.extraQueryParameters),this.config.authOptions.instanceAware&&Bn(t),Or(t,this.config.authOptions.encodeExtraQueryParams,e.extraQueryParameters)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */class Oo extends so{constructor(e,t){super(e,t)}async acquireToken(e){this.performanceClient?.addQueueMeasurement(Qr.RefreshTokenClientAcquireToken,e.correlationId);const t=At(),r=await Vn(this.executeTokenRequest.bind(this),Qr.RefreshTokenClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(e,this.authority),n=r.headers?.[C],o=new Ro(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin);return o.validateTokenResponse(r.body),Vn(o.handleServerTokenResponse.bind(o),Qr.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(r.body,this.authority,t,e,void 0,void 0,!0,e.forceCache,n)}async acquireTokenByRefreshToken(e){if(!e)throw mr(Vt);if(this.performanceClient?.addQueueMeasurement(Qr.RefreshTokenClientAcquireTokenByRefreshToken,e.correlationId),!e.account)throw pt(Ge);if(this.cacheManager.isAppMetadataFOCI(e.account.environment))try{return await Vn(this.acquireTokenWithCachedRefreshToken.bind(this),Qr.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!0)}catch(t){const r=t instanceof Io&&t.errorCode===ao,n=t instanceof to&&t.errorCode===Z&&t.subError===ee;if(r||n)return Vn(this.acquireTokenWithCachedRefreshToken.bind(this),Qr.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1);throw t}return Vn(this.acquireTokenWithCachedRefreshToken.bind(this),Qr.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1)}async acquireTokenWithCachedRefreshToken(e,t){this.performanceClient?.addQueueMeasurement(Qr.RefreshTokenClientAcquireTokenWithCachedRefreshToken,e.correlationId);const r=Wn(this.cacheManager.getRefreshToken.bind(this.cacheManager),Qr.CacheManagerGetRefreshToken,this.logger,this.performanceClient,e.correlationId)(e.account,t,e.correlationId,void 0,this.performanceClient);if(!r)throw Ao(ao);if(r.expiresOn&&bt(r.expiresOn,e.refreshTokenExpirationOffsetSeconds||300))throw this.performanceClient?.addFields({rtExpiresOnMs:Number(r.expiresOn)},e.correlationId),Ao(lo);const n={...e,refreshToken:r.secret,authenticationScheme:e.authenticationScheme||W.BEARER,ccsCredential:{credential:e.account.homeAccountId,type:ln}};try{return await Vn(this.acquireToken.bind(this),Qr.RefreshTokenClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(n)}catch(t){if(t instanceof Io&&(this.performanceClient?.addFields({rtExpiresOnMs:Number(r.expiresOn)},e.correlationId),t.subError===mo)){this.logger.verbose("acquireTokenWithRefreshToken: bad refresh token, removing from cache");const t=Rt(r);this.cacheManager.removeRefreshToken(t,e.correlationId)}throw t}}async executeTokenRequest(e,t){this.performanceClient?.addQueueMeasurement(Qr.RefreshTokenClientExecuteTokenRequest,e.correlationId);const r=this.createTokenQueryParameters(e),n=qr.appendQueryString(t.tokenEndpoint,r),o=await Vn(this.createTokenRequestBody.bind(this),Qr.RefreshTokenClientCreateTokenRequestBody,this.logger,this.performanceClient,e.correlationId)(e),i=this.createTokenRequestHeaders(e.ccsCredential),s=ro(this.config.authOptions.clientId,e);return Vn(this.executePostToTokenEndpoint.bind(this),Qr.RefreshTokenClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,e.correlationId)(n,o,i,s,e.correlationId,Qr.RefreshTokenClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){this.performanceClient?.addQueueMeasurement(Qr.RefreshTokenClientCreateTokenRequestBody,e.correlationId);const t=new Map;if(An(t,e.embeddedClientId||e.tokenBodyParameters?.[dn]||this.config.authOptions.clientId),e.redirectUri&&kn(t,e.redirectUri),Tn(t,e.scopes,!0,this.config.authOptions.authority.options.OIDCOptions?.defaultScopes),xn(t,O),Dn(t),Mn(t,this.config.libraryInfo),On(t,this.config.telemetry.application),Qn(t),this.serverTelemetryManager&&!cn(this.config)&&$n(t,this.serverTelemetryManager),function(e,t){e.set("refresh_token",t)}(t,e.refreshToken),this.config.clientCredentials.clientSecret&&Ln(t,this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const r=this.config.clientCredentials.clientAssertion;Un(t,await Po(r.assertion,this.config.authOptions.clientId,e.resourceRequestUri)),Hn(t,r.assertionType)}if(e.authenticationScheme===W.POP){const r=new bo(this.cryptoUtils,this.performanceClient);let n;if(e.popKid)n=this.cryptoUtils.encodeKid(e.popKid);else{n=(await Vn(r.generateCnf.bind(r),Qr.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString}Kn(t,n)}else if(e.authenticationScheme===W.SSH){if(!e.sshJwk)throw mr(rr);Gn(t,e.sshJwk)}if((!fr.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&_n(t,e.claims,this.config.authOptions.clientCapabilities),this.config.systemOptions.preventCorsPreflight&&e.ccsCredential)switch(e.ccsCredential.type){case ln:try{En(t,vr(e.ccsCredential.credential))}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case hn:bn(t,e.ccsCredential.credential)}return e.embeddedClientId&&jn(t,this.config.authOptions.clientId,this.config.authOptions.redirectUri),e.tokenBodyParameters&&Fn(t,e.tokenBodyParameters),wn(t,e.correlationId,this.performanceClient),Or(t)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */class qo extends so{constructor(e,t){super(e,t)}async acquireCachedToken(e){this.performanceClient?.addQueueMeasurement(Qr.SilentFlowClientAcquireCachedToken,e.correlationId);let t=ae;if(e.forceRefresh||!this.config.cacheOptions.claimsBasedCachingEnabled&&!fr.isEmptyObj(e.claims))throw this.setCacheOutcome(ce,e.correlationId),pt(Xe);if(!e.account)throw pt(Ge);const r=e.account.tenantId||function(e){const t=new qr(e).getUrlComponents(),r=t.PathSegments.slice(-1)[0]?.toLowerCase();switch(r){case I:case T:case A:return;default:return r}}(e.authority),n=this.cacheManager.getTokenKeys(),o=this.cacheManager.getAccessToken(e.account,e,n,r);if(!o)throw this.setCacheOutcome(le,e.correlationId),pt(Xe);if(Et(o.cachedAt)||bt(o.expiresOn,this.config.systemOptions.tokenRenewalOffsetSeconds))throw this.setCacheOutcome(he,e.correlationId),pt(Xe);o.refreshOn&&bt(o.refreshOn,0)&&(t=de);const i=e.authority||this.authority.getPreferredCache(),s={account:this.cacheManager.readAccountFromCache(e.account,e.correlationId),accessToken:o,idToken:this.cacheManager.getIdToken(e.account,e.correlationId,n,r,this.performanceClient),refreshToken:null,appMetadata:this.cacheManager.readAppMetadataFromCache(i)};return this.setCacheOutcome(t,e.correlationId),this.config.serverTelemetryManager&&this.config.serverTelemetryManager.incrementCacheHits(),[await Vn(this.generateResultFromCacheRecord.bind(this),Qr.SilentFlowClientGenerateResultFromCacheRecord,this.logger,this.performanceClient,e.correlationId)(s,e),t]}setCacheOutcome(e,t){this.serverTelemetryManager?.setCacheOutcome(e),this.performanceClient?.addFields({cacheOutcome:e},t),e!==ae&&this.logger.info(`Token refresh is required due to cache outcome: ${e}`)}async generateResultFromCacheRecord(e,t){let r;if(this.performanceClient?.addQueueMeasurement(Qr.SilentFlowClientGenerateResultFromCacheRecord,t.correlationId),e.idToken&&(r=It(e.idToken.secret,this.config.cryptoInterface.base64Decode)),t.maxAge||0===t.maxAge){const e=r?.auth_time;if(!e)throw pt(Oe);Tt(e,t.maxAge)}return Ro.generateAuthenticationResult(this.cryptoUtils,this.authority,e,!0,t,r)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */const No={sendGetRequestAsync:()=>Promise.reject(pt(ct)),sendPostRequestAsync:()=>Promise.reject(pt(ct))};
/*! @azure/msal-common v15.9.0 2025-07-23 */function Lo(e,t,r,n){const o=t.correlationId,i=new Map;An(i,t.embeddedClientId||t.extraQueryParameters?.[dn]||e.clientId);if(Tn(i,[...t.scopes||[],...t.extraScopesToConsent||[]],!0,e.authority.options.OIDCOptions?.defaultScopes),kn(i,t.redirectUri),Pn(i,o),function(e,t){e.set("response_mode",t||P)}(i,t.responseMode),Dn(i),t.prompt&&(!function(e,t){e.set("prompt",t)}(i,t.prompt),n?.addFields({prompt:t.prompt},o)),t.domainHint&&(!function(e,t){e.set("domain_hint",t)}(i,t.domainHint),n?.addFields({domainHintFromRequest:!0},o)),t.prompt!==b.SELECT_ACCOUNT)if(t.sid&&t.prompt===b.NONE)r.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from request"),Rn(i,t.sid),n?.addFields({sidFromRequest:!0},o);else if(t.account){const e=(s=t.account,s.idTokenClaims?.sid||null);let a=function(e){return e.idTokenClaims?.login_hint||null}
/*! @azure/msal-common v15.9.0 2025-07-23 */(t.account);if(a&&t.domainHint&&(r.warning('AuthorizationCodeClient.createAuthCodeUrlQueryString: "domainHint" param is set, skipping opaque "login_hint" claim. Please consider not passing domainHint'),a=null),a){r.verbose("createAuthCodeUrlQueryString: login_hint claim present on account"),Sn(i,a),n?.addFields({loginHintFromClaim:!0},o);try{En(i,vr(t.account.homeAccountId))}catch(e){r.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(e&&t.prompt===b.NONE){r.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from account"),Rn(i,e),n?.addFields({sidFromClaim:!0},o);try{En(i,vr(t.account.homeAccountId))}catch(e){r.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(t.loginHint)r.verbose("createAuthCodeUrlQueryString: Adding login_hint from request"),Sn(i,t.loginHint),bn(i,t.loginHint),n?.addFields({loginHintFromRequest:!0},o);else if(t.account.username){r.verbose("createAuthCodeUrlQueryString: Adding login_hint from account"),Sn(i,t.account.username),n?.addFields({loginHintFromUpn:!0},o);try{En(i,vr(t.account.homeAccountId))}catch(e){r.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}}else t.loginHint&&(r.verbose("createAuthCodeUrlQueryString: No account, adding login_hint from request"),Sn(i,t.loginHint),bn(i,t.loginHint),n?.addFields({loginHintFromRequest:!0},o));else r.verbose("createAuthCodeUrlQueryString: Prompt is select_account, ignoring account hints");var s;return t.nonce&&function(e,t){e.set("nonce",t)}(i,t.nonce),t.state&&qn(i,t.state),(t.claims||e.clientCapabilities&&e.clientCapabilities.length>0)&&_n(i,t.claims,e.clientCapabilities),t.embeddedClientId&&jn(i,e.clientId,e.redirectUri),!e.instanceAware||t.extraQueryParameters&&Object.keys(t.extraQueryParameters).includes(vn)||Bn(i),i}function Uo(e,t,r,n){const o=Or(t,r,n);return qr.appendQueryString(e.authorizationEndpoint,o)}function Ho(e,t){if(!e.state||!t)throw e.state?pt(Pe,"Cached State"):pt(Pe,"Server State");let r,n;try{r=decodeURIComponent(e.state)}catch(t){throw pt(Re,e.state)}try{n=decodeURIComponent(t)}catch(t){throw pt(Re,e.state)}if(r!==n)throw pt(_e);if(e.error||e.error_description||e.suberror){const t=function(e){const t="code=",r=e.error_uri?.lastIndexOf(t);return r&&r>=0?e.error_uri?.substring(r+t.length):void 0}(e);if(To(e.error,e.error_description,e.suberror))throw new Io(e.error||"",e.error_description,e.suberror,e.timestamp||"",e.trace_id||"",e.correlation_id||"",e.claims||"",t);throw new to(e.error||"",e.error_description,e.suberror,t)}}function xo(e){const{skus:t,libraryName:r,libraryVersion:n,extensionName:o,extensionVersion:i}=e,s=new Map([[0,[r,n]],[2,[o,i]]]);let a=[];if(t?.length){if(a=t.split(","),a.length<4)return t}else a=Array.from({length:4},(()=>"|"));return s.forEach(((e,t)=>{2===e.length&&e[0]?.length&&e[1]?.length&&function(e){const{skuArr:t,index:r,skuName:n,skuVersion:o}=e;if(r>=t.length)return;t[r]=[n,o].join("|")}({skuArr:a,index:t,skuName:e[0],skuVersion:e[1]})})),a.join(",")}class Do{constructor(e,r){this.cacheOutcome=ae,this.cacheManager=r,this.apiId=e.apiId,this.correlationId=e.correlationId,this.wrapperSKU=e.wrapperSKU||t.EMPTY_STRING,this.wrapperVer=e.wrapperVer||t.EMPTY_STRING,this.telemetryCacheKey=j.CACHE_KEY+U+e.clientId}generateCurrentRequestHeaderValue(){const e=`${this.apiId}${j.VALUE_SEPARATOR}${this.cacheOutcome}`,t=[this.wrapperSKU,this.wrapperVer],r=this.getNativeBrokerErrorCode();r?.length&&t.push(`broker_error=${r}`);const n=t.join(j.VALUE_SEPARATOR),o=[e,this.getRegionDiscoveryFields()].join(j.VALUE_SEPARATOR);return[j.SCHEMA_VERSION,o,n].join(j.CATEGORY_SEPARATOR)}generateLastRequestHeaderValue(){const e=this.getLastRequests(),t=Do.maxErrorsToSend(e),r=e.failedRequests.slice(0,2*t).join(j.VALUE_SEPARATOR),n=e.errors.slice(0,t).join(j.VALUE_SEPARATOR),o=e.errors.length,i=[o,t<o?j.OVERFLOW_TRUE:j.OVERFLOW_FALSE].join(j.VALUE_SEPARATOR);return[j.SCHEMA_VERSION,e.cacheHits,r,n,i].join(j.CATEGORY_SEPARATOR)}cacheFailedRequest(e){const t=this.getLastRequests();t.errors.length>=j.MAX_CACHED_ERRORS&&(t.failedRequests.shift(),t.failedRequests.shift(),t.errors.shift()),t.failedRequests.push(this.apiId,this.correlationId),e instanceof Error&&e&&e.toString()?e instanceof Ce?e.subError?t.errors.push(e.subError):e.errorCode?t.errors.push(e.errorCode):t.errors.push(e.toString()):t.errors.push(e.toString()):t.errors.push(j.UNKNOWN_ERROR),this.cacheManager.setServerTelemetry(this.telemetryCacheKey,t,this.correlationId)}incrementCacheHits(){const e=this.getLastRequests();return e.cacheHits+=1,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,e,this.correlationId),e.cacheHits}getLastRequests(){return this.cacheManager.getServerTelemetry(this.telemetryCacheKey)||{failedRequests:[],errors:[],cacheHits:0}}clearTelemetryCache(){const e=this.getLastRequests(),t=Do.maxErrorsToSend(e);if(t===e.errors.length)this.cacheManager.removeItem(this.telemetryCacheKey,this.correlationId);else{const r={failedRequests:e.failedRequests.slice(2*t),errors:e.errors.slice(t),cacheHits:0};this.cacheManager.setServerTelemetry(this.telemetryCacheKey,r,this.correlationId)}}static maxErrorsToSend(e){let r,n=0,o=0;const i=e.errors.length;for(r=0;r<i;r++){const i=e.failedRequests[2*r]||t.EMPTY_STRING,s=e.failedRequests[2*r+1]||t.EMPTY_STRING,a=e.errors[r]||t.EMPTY_STRING;if(o+=i.toString().length+s.toString().length+a.length+3,!(o<j.MAX_LAST_HEADER_BYTES))break;n+=1}return n}getRegionDiscoveryFields(){const e=[];return e.push(this.regionUsed||t.EMPTY_STRING),e.push(this.regionSource||t.EMPTY_STRING),e.push(this.regionOutcome||t.EMPTY_STRING),e.join(",")}updateRegionDiscoveryMetadata(e){this.regionUsed=e.region_used,this.regionSource=e.region_source,this.regionOutcome=e.region_outcome}setCacheOutcome(e){this.cacheOutcome=e}setNativeBrokerErrorCode(e){const t=this.getLastRequests();t.nativeBrokerErrorCode=e,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,t,this.correlationId)}getNativeBrokerErrorCode(){return this.getLastRequests().nativeBrokerErrorCode}clearNativeBrokerErrorCode(){const e=this.getLastRequests();delete e.nativeBrokerErrorCode,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,e,this.correlationId)}static makeExtraSkuString(e){return xo(e)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */const Bo="missing_kid_error",Fo="missing_alg_error",zo={[Bo]:"The JOSE Header for the requested JWT, JWS or JWK object requires a keyId to be configured as the 'kid' header claim. No 'kid' value was provided.",[Fo]:"The JOSE Header for the requested JWT, JWS or JWK object requires an algorithm to be specified as the 'alg' header claim. No 'alg' value was provided."};class Ko extends Ce{constructor(e,t){super(e,t),this.name="JoseHeaderError",Object.setPrototypeOf(this,Ko.prototype)}}function Go(e){return new Ko(e,zo[e])}
/*! @azure/msal-common v15.9.0 2025-07-23 */class $o{constructor(e){this.typ=e.typ,this.alg=e.alg,this.kid=e.kid}static getShrHeaderString(e){if(!e.kid)throw Go(Bo);if(!e.alg)throw Go(Fo);const t=new $o({typ:e.typ||ue.Pop,kid:e.kid,alg:e.alg});return JSON.stringify(t)}}
/*! @azure/msal-common v15.9.0 2025-07-23 */function Qo(e,t,r,n=5){if(e instanceof Error)return e instanceof Ce?(r.errorCode=e.errorCode,r.subErrorCode=e.subError,void((e instanceof to||e instanceof Io)&&(r.serverErrorNo=e.errorNo))):void(e instanceof zr?r.errorCode=e.errorCode:r.errorStack?.length?t.trace("PerformanceClient.addErrorStack: Stack already exist",r.correlationId):e.stack?.length?(e.stack&&(r.errorStack=function(e,t){if(t<0)return[];const r=e.split("\n")||[],n=[],o=r[0];o.startsWith("TypeError: Cannot read property")||o.startsWith("TypeError: Cannot read properties of")||o.startsWith("TypeError: Cannot set property")||o.startsWith("TypeError: Cannot set properties of")||o.endsWith("is not a function")?n.push(jo(o)):(o.startsWith("SyntaxError")||o.startsWith("TypeError"))&&n.push(jo(o.replace(/['].*[']|["].*["]/g,"<redacted>")));for(let e=1;e<r.length&&!(n.length>=t);e++){const t=r[e];n.push(jo(t))}return n}(e.stack,n)),r.errorName=e.name):t.trace("PerformanceClient.addErrorStack: Input stack is empty",r.correlationId));t.trace("PerformanceClient.addErrorStack: Input error is not instance of Error",r.correlationId)}function jo(e){const t=e.lastIndexOf(" ")+1;if(t<1)return e;const r=e.substring(t);let n=r.lastIndexOf("/");return n=n<0?r.lastIndexOf("\\"):n,n>=0?(e.substring(0,t)+"("+r.substring(n+1)+(")"===r.charAt(r.length-1)?"":")")).trimStart():e.trimStart()}class Wo{constructor(e,t,r,n,o,i,s,a){this.authority=t,this.libraryName=n,this.libraryVersion=o,this.applicationTelemetry=i,this.clientId=e,this.logger=r,this.callbacks=new Map,this.eventsByCorrelationId=new Map,this.eventStack=new Map,this.queueMeasurements=new Map,this.preQueueTimeByCorrelationId=new Map,this.intFields=s||new Set;for(const e of Jr)this.intFields.add(e);this.abbreviations=a||new Map;for(const[e,t]of jr)this.abbreviations.set(e,t)}startPerformanceMeasurement(e,t){return{}}getPreQueueTime(e,t){const r=this.preQueueTimeByCorrelationId.get(t);if(r){if(r.name===e)return r.time;this.logger.trace(`PerformanceClient.getPreQueueTime: no pre-queue time found for ${e}, unable to add queue measurement`)}else this.logger.trace(`PerformanceClient.getPreQueueTime: no pre-queue times found for correlationId: ${t}, unable to add queue measurement`)}calculateQueuedTime(e,t){return e<1?(this.logger.trace(`PerformanceClient: preQueueTime should be a positive integer and not ${e}`),0):t<1?(this.logger.trace(`PerformanceClient: currentTime should be a positive integer and not ${t}`),0):t<e?(this.logger.trace("PerformanceClient: currentTime is less than preQueueTime, check how time is being retrieved"),0):t-e}addQueueMeasurement(e,t,r,n){if(!t)return void this.logger.trace(`PerformanceClient.addQueueMeasurement: correlationId not provided for ${e}, cannot add queue measurement`);if(0===r)this.logger.trace(`PerformanceClient.addQueueMeasurement: queue time provided for ${e} is ${r}`);else if(!r)return void this.logger.trace(`PerformanceClient.addQueueMeasurement: no queue time provided for ${e}`);const o={eventName:e,queueTime:n?0:r,manuallyCompleted:n},i=this.queueMeasurements.get(t);if(i)i.push(o),this.queueMeasurements.set(t,i);else{this.logger.trace(`PerformanceClient.addQueueMeasurement: adding correlationId ${t} to queue measurements`);const e=[o];this.queueMeasurements.set(t,e)}this.preQueueTimeByCorrelationId.delete(t)}startMeasurement(e,t){const r=t||this.generateId();t||this.logger.info(`PerformanceClient: No correlation id provided for ${e}, generating`,r),this.logger.trace(`PerformanceClient: Performance measurement started for ${e}`,r);const n={eventId:this.generateId(),status:Wr,authority:this.authority,libraryName:this.libraryName,libraryVersion:this.libraryVersion,clientId:this.clientId,name:e,startTimeMs:Date.now(),correlationId:r,appName:this.applicationTelemetry?.appName,appVersion:this.applicationTelemetry?.appVersion};var o,i,s;return this.cacheEventByCorrelationId(n),o=n,i=this.abbreviations,(s=this.eventStack.get(r))&&s.push({name:i.get(o.name)||o.name}),{end:(e,t)=>this.endMeasurement({...n,...e},t),discard:()=>this.discardMeasurements(n.correlationId),add:e=>this.addFields(e,n.correlationId),increment:e=>this.incrementFields(e,n.correlationId),event:n,measurement:new Yr}}endMeasurement(e,t){const r=this.eventsByCorrelationId.get(e.correlationId);if(!r)return this.logger.trace(`PerformanceClient: Measurement not found for ${e.eventId}`,e.correlationId),null;const n=e.eventId===r.eventId;let o={totalQueueTime:0,totalQueueCount:0,manuallyCompletedCount:0};e.durationMs=Math.round(e.durationMs||this.getDurationMs(e.startTimeMs));const i=JSON.stringify(function(e,t,r,n){if(!r?.length)return;const o=e=>e.length?e[e.length-1]:void 0,i=t.get(e.name)||e.name,s=o(r);if(s?.name!==i)return;const a=r?.pop();if(!a)return;const c=n instanceof Ce?n.errorCode:n instanceof Error?n.name:void 0,l=n instanceof Ce?n.subError:void 0;c&&a.childErr!==c&&(a.err=c,l&&(a.subErr=l)),delete a.name,delete a.childErr;const h={...a,dur:e.durationMs};e.success||(h.fail=1);const d=o(r);if(!d)return{[i]:h};let u;if(c&&(d.childErr=c),d[i]){const e=Object.keys(d).filter((e=>e.startsWith(i))).length;u=`${i}_${e+1}`}else u=i;return d[u]=h,d}(e,this.abbreviations,this.eventStack.get(r.correlationId),t));if(n?(o=this.getQueueInfo(e.correlationId),this.discardMeasurements(r.correlationId)):r.incompleteSubMeasurements?.delete(e.eventId),this.logger.trace(`PerformanceClient: Performance measurement ended for ${e.name}: ${e.durationMs} ms`,e.correlationId),t&&Qo(t,this.logger,r),!n)return r[e.name+"DurationMs"]=Math.floor(e.durationMs),{...r};n&&!t&&(r.errorCode||r.subErrorCode)&&(this.logger.trace(`PerformanceClient: Remove error and sub-error codes for root event ${e.name} as intermediate error was successfully handled`,e.correlationId),r.errorCode=void 0,r.subErrorCode=void 0);let s={...r,...e},a=0;return s.incompleteSubMeasurements?.forEach((t=>{this.logger.trace(`PerformanceClient: Incomplete submeasurement ${t.name} found for ${e.name}`,s.correlationId),a++})),s.incompleteSubMeasurements=void 0,s={...s,queuedTimeMs:o.totalQueueTime,queuedCount:o.totalQueueCount,queuedManuallyCompletedCount:o.manuallyCompletedCount,status:Vr,incompleteSubsCount:a,context:i},this.truncateIntegralFields(s),this.emitEvents([s],e.correlationId),s}addFields(e,t){this.logger.trace("PerformanceClient: Updating static fields");const r=this.eventsByCorrelationId.get(t);r?this.eventsByCorrelationId.set(t,{...r,...e}):this.logger.trace("PerformanceClient: Event not found for",t)}incrementFields(e,t){this.logger.trace("PerformanceClient: Updating counters");const r=this.eventsByCorrelationId.get(t);if(r)for(const t in e){if(r.hasOwnProperty(t)){if(isNaN(Number(r[t])))return}else r[t]=0;r[t]+=e[t]}else this.logger.trace("PerformanceClient: Event not found for",t)}cacheEventByCorrelationId(e){const t=this.eventsByCorrelationId.get(e.correlationId);t?(this.logger.trace(`PerformanceClient: Performance measurement for ${e.name} added/updated`,e.correlationId),t.incompleteSubMeasurements=t.incompleteSubMeasurements||new Map,t.incompleteSubMeasurements.set(e.eventId,{name:e.name,startTimeMs:e.startTimeMs})):(this.logger.trace(`PerformanceClient: Performance measurement for ${e.name} started`,e.correlationId),this.eventsByCorrelationId.set(e.correlationId,{...e}),this.eventStack.set(e.correlationId,[]))}getQueueInfo(e){const t=this.queueMeasurements.get(e);t||this.logger.trace(`PerformanceClient: no queue measurements found for for correlationId: ${e}`);let r=0,n=0,o=0;return t?.forEach((e=>{r+=e.queueTime,n++,o+=e.manuallyCompleted?1:0})),{totalQueueTime:r,totalQueueCount:n,manuallyCompletedCount:o}}discardMeasurements(e){this.logger.trace("PerformanceClient: Performance measurements discarded",e),this.eventsByCorrelationId.delete(e),this.logger.trace("PerformanceClient: QueueMeasurements discarded",e),this.queueMeasurements.delete(e),this.logger.trace("PerformanceClient: Pre-queue times discarded",e),this.preQueueTimeByCorrelationId.delete(e),this.logger.trace("PerformanceClient: Event stack discarded",e),this.eventStack.delete(e)}addPerformanceCallback(e){for(const[t,r]of this.callbacks)if(r.toString()===e.toString())return this.logger.warning(`PerformanceClient: Performance callback is already registered with id: ${t}`),t;const t=this.generateId();return this.callbacks.set(t,e),this.logger.verbose(`PerformanceClient: Performance callback registered with id: ${t}`),t}removePerformanceCallback(e){const t=this.callbacks.delete(e);return t?this.logger.verbose(`PerformanceClient: Performance callback ${e} removed.`):this.logger.verbose(`PerformanceClient: Performance callback ${e} not removed.`),t}emitEvents(e,t){this.logger.verbose("PerformanceClient: Emitting performance events",t),this.callbacks.forEach(((r,n)=>{this.logger.trace(`PerformanceClient: Emitting event to callback ${n}`,t),r.apply(null,[e])}))}truncateIntegralFields(e){this.intFields.forEach((t=>{t in e&&"number"==typeof e[t]&&(e[t]=Math.floor(e[t]))}))}getDurationMs(e){const t=Date.now()-e;return t<0?t:0}}const Vo="pkce_not_created",Jo="ear_jwk_empty",Yo="ear_jwe_empty",Xo="crypto_nonexistent",Zo="empty_navigate_uri",ei="hash_empty_error",ti="no_state_in_hash",ri="hash_does_not_contain_known_properties",ni="unable_to_parse_state",oi="state_interaction_type_mismatch",ii="interaction_in_progress",si="popup_window_error",ai="empty_window_error",ci="user_cancelled",li="monitor_popup_timeout",hi="monitor_window_timeout",di="redirect_in_iframe",ui="block_iframe_reload",gi="block_nested_popups",pi="iframe_closed_prematurely",mi="silent_logout_unsupported",fi="no_account_error",yi="silent_prompt_value_error",Ci="no_token_request_cache_error",vi="unable_to_parse_token_request_cache_error",wi="auth_request_not_set_error",Ii="invalid_cache_type",Ti="non_browser_environment",Ai="database_not_open",ki="no_network_connectivity",Si="post_request_failed",bi="get_request_failed",Ei="failed_to_parse_response",Ri="unable_to_load_token",_i="crypto_key_not_found",Pi="auth_code_required",Mi="auth_code_or_nativeAccountId_required",Oi="spa_code_and_nativeAccountId_present",qi="database_unavailable",Ni="unable_to_acquire_token_from_native_platform",Li="native_handshake_timeout",Ui="native_extension_not_installed",Hi="native_connection_not_established",xi="uninitialized_public_client_application",Di="native_prompt_not_supported",Bi="invalid_base64_string",Fi="invalid_pop_token_request",zi="failed_to_build_headers",Ki="failed_to_parse_headers",Gi="failed_to_decrypt_ear_response",$i="timed_out";var Qi=Object.freeze({__proto__:null,authCodeOrNativeAccountIdRequired:Mi,authCodeRequired:Pi,authRequestNotSetError:wi,blockIframeReload:ui,blockNestedPopups:gi,cryptoKeyNotFound:_i,cryptoNonExistent:Xo,databaseNotOpen:Ai,databaseUnavailable:qi,earJweEmpty:Yo,earJwkEmpty:Jo,emptyNavigateUri:Zo,emptyWindowError:ai,failedToBuildHeaders:zi,failedToDecryptEarResponse:Gi,failedToParseHeaders:Ki,failedToParseResponse:Ei,getRequestFailed:bi,hashDoesNotContainKnownProperties:ri,hashEmptyError:ei,iframeClosedPrematurely:pi,interactionInProgress:ii,invalidBase64String:Bi,invalidCacheType:Ii,invalidPopTokenRequest:Fi,monitorPopupTimeout:li,monitorWindowTimeout:hi,nativeConnectionNotEstablished:Hi,nativeExtensionNotInstalled:Ui,nativeHandshakeTimeout:Li,nativePromptNotSupported:Di,noAccountError:fi,noNetworkConnectivity:ki,noStateInHash:ti,noTokenRequestCacheError:Ci,nonBrowserEnvironment:Ti,pkceNotCreated:Vo,popupWindowError:si,postRequestFailed:Si,redirectInIframe:di,silentLogoutUnsupported:mi,silentPromptValueError:yi,spaCodeAndNativeAccountIdPresent:Oi,stateInteractionTypeMismatch:oi,timedOut:$i,unableToAcquireTokenFromNativePlatform:Ni,unableToLoadToken:Ri,unableToParseState:ni,unableToParseTokenRequestCacheError:vi,uninitializedPublicClientApplication:xi,userCancelled:ci});const ji="For more visit: aka.ms/msaljs/browser-errors",Wi={[Vo]:"The PKCE code challenge and verifier could not be generated.",[Jo]:"No EAR encryption key provided. This is unexpected.",[Yo]:"Server response does not contain ear_jwe property. This is unexpected.",[Xo]:"The crypto object or function is not available.",[Zo]:"Navigation URI is empty. Please check stack trace for more info.",[ei]:`Hash value cannot be processed because it is empty. Please verify that your redirectUri is not clearing the hash. ${ji}`,[ti]:"Hash does not contain state. Please verify that the request originated from msal.",[ri]:`Hash does not contain known properites. Please verify that your redirectUri is not changing the hash.  ${ji}`,[ni]:"Unable to parse state. Please verify that the request originated from msal.",[oi]:"Hash contains state but the interaction type does not match the caller.",[ii]:`Interaction is currently in progress. Please ensure that this interaction has been completed before calling an interactive API.   ${ji}`,[si]:"Error opening popup window. This can happen if you are using IE or if popups are blocked in the browser.",[ai]:"window.open returned null or undefined window object.",[ci]:"User cancelled the flow.",[li]:`Token acquisition in popup failed due to timeout.  ${ji}`,[hi]:`Token acquisition in iframe failed due to timeout.  ${ji}`,[di]:"Redirects are not supported for iframed or brokered applications. Please ensure you are using MSAL.js in a top frame of the window if using the redirect APIs, or use the popup APIs.",[ui]:`Request was blocked inside an iframe because MSAL detected an authentication response.  ${ji}`,[gi]:"Request was blocked inside a popup because MSAL detected it was running in a popup.",[pi]:"The iframe being monitored was closed prematurely.",[mi]:"Silent logout not supported. Please call logoutRedirect or logoutPopup instead.",[fi]:"No account object provided to acquireTokenSilent and no active account has been set. Please call setActiveAccount or provide an account on the request.",[yi]:"The value given for the prompt value is not valid for silent requests - must be set to 'none' or 'no_session'.",[Ci]:"No token request found in cache.",[vi]:"The cached token request could not be parsed.",[wi]:"Auth Request not set. Please ensure initiateAuthRequest was called from the InteractionHandler",[Ii]:"Invalid cache type",[Ti]:"Login and token requests are not supported in non-browser environments.",[Ai]:"Database is not open!",[ki]:"No network connectivity. Check your internet connection.",[Si]:"Network request failed: If the browser threw a CORS error, check that the redirectUri is registered in the Azure App Portal as type 'SPA'",[bi]:"Network request failed. Please check the network trace to determine root cause.",[Ei]:"Failed to parse network response. Check network trace.",[Ri]:"Error loading token to cache.",[_i]:"Cryptographic Key or Keypair not found in browser storage.",[Pi]:"An authorization code must be provided (as the `code` property on the request) to this flow.",[Mi]:"An authorization code or nativeAccountId must be provided to this flow.",[Oi]:"Request cannot contain both spa code and native account id.",[qi]:"IndexedDB, which is required for persistent cryptographic key storage, is unavailable. This may be caused by browser privacy features which block persistent storage in third-party contexts.",[Ni]:`Unable to acquire token from native platform.  ${ji}`,[Li]:"Timed out while attempting to establish connection to browser extension",[Ui]:"Native extension is not installed. If you think this is a mistake call the initialize function.",[Hi]:`Connection to native platform has not been established. Please install a compatible browser extension and run initialize().  ${ji}`,[xi]:`You must call and await the initialize function before attempting to call any other MSAL API.  ${ji}`,[Di]:"The provided prompt is not supported by the native platform. This request should be routed to the web based flow.",[Bi]:"Invalid base64 encoded string.",[Fi]:"Invalid PoP token request. The request should not have both a popKid value and signPopToken set to true.",[zi]:"Failed to build request headers object.",[Ki]:"Failed to parse response headers",[Gi]:"Failed to decrypt ear response",[$i]:"The request timed out."},Vi={pkceNotGenerated:{code:Vo,desc:Wi[Vo]},cryptoDoesNotExist:{code:Xo,desc:Wi[Xo]},emptyNavigateUriError:{code:Zo,desc:Wi[Zo]},hashEmptyError:{code:ei,desc:Wi[ei]},hashDoesNotContainStateError:{code:ti,desc:Wi[ti]},hashDoesNotContainKnownPropertiesError:{code:ri,desc:Wi[ri]},unableToParseStateError:{code:ni,desc:Wi[ni]},stateInteractionTypeMismatchError:{code:oi,desc:Wi[oi]},interactionInProgress:{code:ii,desc:Wi[ii]},popupWindowError:{code:si,desc:Wi[si]},emptyWindowError:{code:ai,desc:Wi[ai]},userCancelledError:{code:ci,desc:Wi[ci]},monitorPopupTimeoutError:{code:li,desc:Wi[li]},monitorIframeTimeoutError:{code:hi,desc:Wi[hi]},redirectInIframeError:{code:di,desc:Wi[di]},blockTokenRequestsInHiddenIframeError:{code:ui,desc:Wi[ui]},blockAcquireTokenInPopupsError:{code:gi,desc:Wi[gi]},iframeClosedPrematurelyError:{code:pi,desc:Wi[pi]},silentLogoutUnsupportedError:{code:mi,desc:Wi[mi]},noAccountError:{code:fi,desc:Wi[fi]},silentPromptValueError:{code:yi,desc:Wi[yi]},noTokenRequestCacheError:{code:Ci,desc:Wi[Ci]},unableToParseTokenRequestCacheError:{code:vi,desc:Wi[vi]},authRequestNotSet:{code:wi,desc:Wi[wi]},invalidCacheType:{code:Ii,desc:Wi[Ii]},notInBrowserEnvironment:{code:Ti,desc:Wi[Ti]},databaseNotOpen:{code:Ai,desc:Wi[Ai]},noNetworkConnectivity:{code:ki,desc:Wi[ki]},postRequestFailed:{code:Si,desc:Wi[Si]},getRequestFailed:{code:bi,desc:Wi[bi]},failedToParseNetworkResponse:{code:Ei,desc:Wi[Ei]},unableToLoadTokenError:{code:Ri,desc:Wi[Ri]},signingKeyNotFoundInStorage:{code:_i,desc:Wi[_i]},authCodeRequired:{code:Pi,desc:Wi[Pi]},authCodeOrNativeAccountRequired:{code:Mi,desc:Wi[Mi]},spaCodeAndNativeAccountPresent:{code:Oi,desc:Wi[Oi]},databaseUnavailable:{code:qi,desc:Wi[qi]},unableToAcquireTokenFromNativePlatform:{code:Ni,desc:Wi[Ni]},nativeHandshakeTimeout:{code:Li,desc:Wi[Li]},nativeExtensionNotInstalled:{code:Ui,desc:Wi[Ui]},nativeConnectionNotEstablished:{code:Hi,desc:Wi[Hi]},uninitializedPublicClientApplication:{code:xi,desc:Wi[xi]},nativePromptNotSupported:{code:Di,desc:Wi[Di]},invalidBase64StringError:{code:Bi,desc:Wi[Bi]},invalidPopTokenRequest:{code:Fi,desc:Wi[Fi]}};class Ji extends Ce{constructor(e,t){super(e,Wi[e],t),Object.setPrototypeOf(this,Ji.prototype),this.name="BrowserAuthError"}}function Yi(e,t){return new Ji(e,t)}const Xi="invalid_grant",Zi=483,es=600,ts="msal",rs=30,ns="msal.js.browser",os="53ee284d-920a-4b59-9d30-a60315b26836",is="ppnbnpeolgkicgegkbkbjmhlideopiji",ss="MATS",as="MicrosoftEntra",cs="DOM API",ls="get-token-and-sign-out",hs="PlatformAuthDOMHandler",ds="PlatformAuthExtensionHandler",us="Handshake",gs="HandshakeResponse",ps="GetToken",ms="Response",fs={LocalStorage:"localStorage",SessionStorage:"sessionStorage",MemoryStorage:"memoryStorage"},ys="GET",Cs="POST",vs="signin",ws="signout",Is="request.origin",Ts="urlHash",As="request.params",ks="code.verifier",Ss="interaction.status",bs="request.native",Es="msal.account.keys",Rs="msal.token.keys",_s="msal.version",Ps="wrapper.sku",Ms="wrapper.version",Os={acquireTokenRedirect:861,acquireTokenPopup:862,ssoSilent:863,acquireTokenSilent_authCode:864,handleRedirectPromise:865,acquireTokenByCode:866,acquireTokenSilent_silentFlow:61,logout:961,logoutPopup:962};var qs;e.InteractionType=void 0,(qs=e.InteractionType||(e.InteractionType={})).Redirect="redirect",qs.Popup="popup",qs.Silent="silent",qs.None="none";const Ns={Startup:"startup",Login:"login",Logout:"logout",AcquireToken:"acquireToken",SsoSilent:"ssoSilent",HandleRedirect:"handleRedirect",None:"none"},Ls={scopes:h},Us="msal.db",Hs=`${Us}.keys`,xs={Default:0,AccessToken:1,AccessTokenAndRefreshToken:2,RefreshToken:3,RefreshTokenAndNetwork:4,Skip:5},Ds=[xs.Default,xs.Skip,xs.RefreshTokenAndNetwork],Bs="msal.browser.platform.auth.dom";function Fs(e){return encodeURIComponent(Ks(e).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_"))}function zs(e){return Gs(e).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_")}function Ks(e){return Gs((new TextEncoder).encode(e))}function Gs(e){const t=Array.from(e,(e=>String.fromCodePoint(e))).join("");return btoa(t)}function $s(e){return(new TextDecoder).decode(Qs(e))}function Qs(e){let t=e.replace(/-/g,"+").replace(/_/g,"/");switch(t.length%4){case 0:break;case 2:t+="==";break;case 3:t+="=";break;default:throw Yi(Bi)}const r=atob(t);return Uint8Array.from(r,(e=>e.codePointAt(0)||0))}const js="AES-GCM",Ws="HKDF",Vs="SHA-256",Js=new Uint8Array([1,0,1]),Ys="0123456789abcdef",Xs=new Uint32Array(1),Zs="raw",ea="encrypt",ta="decrypt",ra={name:"RSASSA-PKCS1-v1_5",hash:Vs,modulusLength:2048,publicExponent:Js};async function na(e,t,r){t?.addQueueMeasurement(Qr.Sha256Digest,r);const n=(new TextEncoder).encode(e);return window.crypto.subtle.digest(Vs,n)}function oa(e){return window.crypto.getRandomValues(e)}function ia(){return window.crypto.getRandomValues(Xs),Xs[0]}function sa(){const e=Date.now(),t=1024*ia()+(1023&ia()),r=new Uint8Array(16),n=Math.trunc(t/2**30),o=t&2**30-1,i=ia();r[0]=e/2**40,r[1]=e/2**32,r[2]=e/2**24,r[3]=e/65536,r[4]=e/256,r[5]=e,r[6]=112|n>>>8,r[7]=n,r[8]=128|o>>>24,r[9]=o>>>16,r[10]=o>>>8,r[11]=o,r[12]=i>>>24,r[13]=i>>>16,r[14]=i>>>8,r[15]=i;let s="";for(let e=0;e<r.length;e++)s+=Ys.charAt(r[e]>>>4),s+=Ys.charAt(15&r[e]),3!==e&&5!==e&&7!==e&&9!==e||(s+="-");return s}async function aa(e){return window.crypto.subtle.exportKey("jwk",e)}async function ca(){const e=await ha(),t={alg:"dir",kty:"oct",k:zs(new Uint8Array(e))};return Ks(JSON.stringify(t))}async function la(e,t){const r=t.split(".");if(5!==r.length)throw Yi(Gi,"jwe_length");const n=await async function(e){const t=$s(e),r=Qs(JSON.parse(t).k);return window.crypto.subtle.importKey(Zs,r,js,!1,[ta])}(e).catch((()=>{throw Yi(Gi,"import_key")}));try{const e=(new TextEncoder).encode(r[0]),t=Qs(r[2]),o=Qs(r[3]),i=Qs(r[4]),s=8*i.byteLength,a=new Uint8Array(o.length+i.length);a.set(o),a.set(i,o.length);const c=await window.crypto.subtle.decrypt({name:js,iv:t,tagLength:s,additionalData:e},n,a);return(new TextDecoder).decode(c)}catch(e){throw Yi(Gi,"decrypt")}}async function ha(){const e=await window.crypto.subtle.generateKey({name:js,length:256},!0,[ea,ta]);return window.crypto.subtle.exportKey(Zs,e)}async function da(e){return window.crypto.subtle.importKey(Zs,e,Ws,!1,["deriveKey"])}async function ua(e,t,r){return window.crypto.subtle.deriveKey({name:Ws,salt:t,hash:Vs,info:(new TextEncoder).encode(r)},e,{name:js,length:256},!1,[ea,ta])}async function ga(e,t,r){const n=(new TextEncoder).encode(t),o=window.crypto.getRandomValues(new Uint8Array(16)),i=await ua(e,o,r),s=await window.crypto.subtle.encrypt({name:js,iv:new Uint8Array(12)},i,n);return{data:zs(new Uint8Array(s)),nonce:zs(o)}}async function pa(e,t,r,n){const o=Qs(n),i=await ua(e,Qs(t),r),s=await window.crypto.subtle.decrypt({name:js,iv:new Uint8Array(12)},i,o);return(new TextDecoder).decode(s)}async function ma(e){const t=await na(e);return zs(new Uint8Array(t))}const fa="storage_not_supported",ya="stubbed_public_client_application_called",Ca="in_mem_redirect_unavailable";var va=Object.freeze({__proto__:null,inMemRedirectUnavailable:Ca,storageNotSupported:fa,stubbedPublicClientApplicationCalled:ya});const wa={[fa]:"Given storage configuration option was not supported.",[ya]:"Stub instance of Public Client Application was called. If using msal-react, please ensure context is not used without a provider. For more visit: aka.ms/msaljs/browser-errors",[Ca]:"Redirect cannot be supported. In-memory storage was selected and storeAuthStateInCookie=false, which would cause the library to be unable to handle the incoming hash. If you would like to use the redirect API, please use session/localStorage or set storeAuthStateInCookie=true."},Ia={storageNotSupportedError:{code:fa,desc:wa[fa]},stubPcaInstanceCalled:{code:ya,desc:wa[ya]},inMemRedirectUnavailable:{code:Ca,desc:wa[Ca]}};class Ta extends Ce{constructor(e,t){super(e,t),this.name="BrowserConfigurationAuthError",Object.setPrototypeOf(this,Ta.prototype)}}function Aa(e){return new Ta(e,wa[e])}function ka(e){e.location.hash="","function"==typeof e.history.replaceState&&e.history.replaceState(null,"",`${e.location.origin}${e.location.pathname}${e.location.search}`)}function Sa(e){const t=e.split("#");t.shift(),window.location.hash=t.length>0?t.join("#"):""}function ba(){return window.parent!==window}function Ea(){return"undefined"!=typeof window&&!!window.opener&&window.opener!==window&&"string"==typeof window.name&&0===window.name.indexOf(`${ts}.`)}function Ra(){return"undefined"!=typeof window&&window.location?window.location.href.split("?")[0].split("#")[0]:""}function _a(){const e=new qr(window.location.href).getUrlComponents();return`${e.Protocol}//${e.HostNameAndPort}/`}function Pa(){if(qr.hashContainsKnownProperties(window.location.hash)&&ba())throw Yi(ui)}function Ma(e){if(ba()&&!e)throw Yi(di)}function Oa(){if(Ea())throw Yi(gi)}function qa(){if("undefined"==typeof window)throw Yi(Ti)}function Na(e){if(!e)throw Yi(xi)}function La(e){qa(),Pa(),Oa(),Na(e)}function Ua(e,t){if(La(e),Ma(t.system.allowRedirectInIframe),t.cache.cacheLocation===fs.MemoryStorage&&!t.cache.storeAuthStateInCookie)throw Aa(Ca)}function Ha(e){const t=document.createElement("link");t.rel="preconnect",t.href=new URL(e).origin,t.crossOrigin="anonymous",document.head.appendChild(t),window.setTimeout((()=>{try{document.head.removeChild(t)}catch{}}),1e4)}function xa(){return sa()}var Da=Object.freeze({__proto__:null,blockAPICallsBeforeInitialize:Na,blockAcquireTokenInPopups:Oa,blockNonBrowserEnvironment:qa,blockRedirectInIframe:Ma,blockReloadInHiddenIframes:Pa,clearHash:ka,createGuid:xa,getCurrentUri:Ra,getHomepage:_a,invoke:Wn,invokeAsync:Vn,isInIframe:ba,isInPopup:Ea,preconnect:Ha,preflightCheck:La,redirectPreflightCheck:Ua,replaceHash:Sa});class Ba{navigateInternal(e,t){return Ba.defaultNavigateWindow(e,t)}navigateExternal(e,t){return Ba.defaultNavigateWindow(e,t)}static defaultNavigateWindow(e,t){return t.noHistory?window.location.replace(e):window.location.assign(e),new Promise(((e,r)=>{setTimeout((()=>{r(Yi($i,"failed_to_redirect"))}),t.timeout)}))}}class Fa{async sendGetRequestAsync(e,t){let r,n={},o=0;const i=za(t);try{r=await fetch(e,{method:ys,headers:i})}catch(e){throw io(Yi(window.navigator.onLine?bi:ki),void 0,void 0,e)}n=Ka(r.headers);try{return o=r.status,{headers:n,body:await r.json(),status:o}}catch(e){throw io(Yi(Ei),o,n,e)}}async sendPostRequestAsync(e,t){const r=t&&t.body||"",n=za(t);let o,i=0,s={};try{o=await fetch(e,{method:Cs,headers:n,body:r})}catch(e){throw io(Yi(window.navigator.onLine?Si:ki),void 0,void 0,e)}s=Ka(o.headers);try{return i=o.status,{headers:s,body:await o.json(),status:i}}catch(e){throw io(Yi(Ei),i,s,e)}}}function za(e){try{const t=new Headers;if(!e||!e.headers)return t;const r=e.headers;return Object.entries(r).forEach((([e,r])=>{t.append(e,r)})),t}catch(e){throw io(Yi(zi),void 0,void 0,e)}}function Ka(e){try{const t={};return e.forEach(((e,r)=>{t[r]=e})),t}catch(e){throw Yi(Ki)}}const Ga=1e4;const $a="@azure/msal-browser",Qa="4.16.0";class ja{static loggerCallback(t,r){switch(t){case e.LogLevel.Error:return void console.error(r);case e.LogLevel.Info:return void console.info(r);case e.LogLevel.Verbose:return void console.debug(r);case e.LogLevel.Warning:return void console.warn(r);default:return void console.log(r)}}constructor(r){let n;this.browserEnvironment="undefined"!=typeof window,this.config=function({auth:r,cache:n,system:o,telemetry:i},s){const a={clientId:t.EMPTY_STRING,authority:`${t.DEFAULT_AUTHORITY}`,knownAuthorities:[],cloudDiscoveryMetadata:t.EMPTY_STRING,authorityMetadata:t.EMPTY_STRING,redirectUri:"undefined"!=typeof window?Ra():"",postLogoutRedirectUri:t.EMPTY_STRING,navigateToLoginRequestUrl:!0,clientCapabilities:[],protocolMode:Rr.AAD,OIDCOptions:{serverResponseType:_.FRAGMENT,defaultScopes:[t.OPENID_SCOPE,t.PROFILE_SCOPE,t.OFFLINE_ACCESS_SCOPE]},azureCloudOptions:{azureCloudInstance:wt.None,tenant:t.EMPTY_STRING},skipAuthorityMetadataCache:!1,supportsNestedAppAuth:!1,instanceAware:!1,encodeExtraQueryParams:!1},c={cacheLocation:fs.SessionStorage,temporaryCacheLocation:fs.SessionStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!(!n||n.cacheLocation!==fs.LocalStorage),claimsBasedCachingEnabled:!1},l={loggerCallback:()=>{},logLevel:e.LogLevel.Info,piiLoggingEnabled:!1},h={...{...Zr,loggerOptions:l,networkClient:s?new Fa:No,navigationClient:new Ba,loadFrameTimeout:0,windowHashTimeout:o?.loadFrameTimeout||6e4,iframeHashTimeout:o?.loadFrameTimeout||Ga,navigateFrameWait:0,redirectNavigationTimeout:3e4,asyncPopups:!1,allowRedirectInIframe:!1,allowPlatformBroker:!1,nativeBrokerHandshakeTimeout:o?.nativeBrokerHandshakeTimeout||2e3,pollIntervalMilliseconds:rs},...o,loggerOptions:o?.loggerOptions||l},d={application:{appName:t.EMPTY_STRING,appVersion:t.EMPTY_STRING},client:new Xr};r?.protocolMode!==Rr.OIDC&&r?.OIDCOptions&&new yt(h.loggerOptions).warning(JSON.stringify(mr(sr)));if(r?.protocolMode&&r.protocolMode===Rr.OIDC&&h?.allowPlatformBroker)throw mr(ar);return{auth:{...a,...r,OIDCOptions:{...a.OIDCOptions,...r?.OIDCOptions}},cache:{...c,...n},system:h,telemetry:{...d,...i}}}(r,this.browserEnvironment);try{n=window[fs.SessionStorage]}catch(e){}const o=n?.getItem("msal.browser.log.level"),i=n?.getItem("msal.browser.log.pii")?.toLowerCase(),s="true"===i||"false"!==i&&void 0,a={...this.config.system.loggerOptions},c=o&&Object.keys(e.LogLevel).includes(o)?e.LogLevel[o]:void 0;c&&(a.loggerCallback=ja.loggerCallback,a.logLevel=c),void 0!==s&&(a.piiLoggingEnabled=s),this.logger=new yt(a,$a,Qa),this.available=!1}getConfig(){return this.config}getLogger(){return this.logger}isAvailable(){return this.available}isBrowserEnvironment(){return this.browserEnvironment}}const Wa="USER_INTERACTION_REQUIRED",Va="USER_CANCEL",Ja="NO_NETWORK",Ya="TRANSIENT_ERROR",Xa="PERSISTENT_ERROR",Za="DISABLED",ec="ACCOUNT_UNAVAILABLE",tc="NESTED_APP_AUTH_UNAVAILABLE";class rc{static async initializeNestedAppAuthBridge(){if(void 0===window)throw new Error("window is undefined");if(void 0===window.nestedAppAuthBridge)throw new Error("window.nestedAppAuthBridge is undefined");try{window.nestedAppAuthBridge.addEventListener("message",(e=>{const t="string"==typeof e?e:e.data,r=JSON.parse(t),n=rc.bridgeRequests.find((e=>e.requestId===r.requestId));void 0!==n&&(rc.bridgeRequests.splice(rc.bridgeRequests.indexOf(n),1),r.success?n.resolve(r):n.reject(r.error))}));const e=await new Promise(((e,t)=>{const r=rc.buildRequest("GetInitContext"),n={requestId:r.requestId,method:r.method,resolve:e,reject:t};rc.bridgeRequests.push(n),window.nestedAppAuthBridge.postMessage(JSON.stringify(r))}));return rc.validateBridgeResultOrThrow(e.initContext)}catch(e){throw window.console.log(e),e}}getTokenInteractive(e){return this.getToken("GetTokenPopup",e)}getTokenSilent(e){return this.getToken("GetToken",e)}async getToken(e,t){const r=await this.sendRequest(e,{tokenParams:t});return{token:rc.validateBridgeResultOrThrow(r.token),account:rc.validateBridgeResultOrThrow(r.account)}}getHostCapabilities(){return this.capabilities??null}getAccountContext(){return this.accountContext?this.accountContext:null}static buildRequest(e,t){return{messageType:"NestedAppAuthRequest",method:e,requestId:sa(),sendTime:Date.now(),clientLibrary:ns,clientLibraryVersion:Qa,...t}}sendRequest(e,t){const r=rc.buildRequest(e,t);return new Promise(((e,t)=>{const n={requestId:r.requestId,method:r.method,resolve:e,reject:t};rc.bridgeRequests.push(n),window.nestedAppAuthBridge.postMessage(JSON.stringify(r))}))}static validateBridgeResultOrThrow(e){if(void 0===e){throw{status:tc}}return e}constructor(e,t,r,n){this.sdkName=e,this.sdkVersion=t,this.accountContext=r,this.capabilities=n}static async create(){const e=await rc.initializeNestedAppAuthBridge();return new rc(e.sdkName,e.sdkVersion,e.accountContext,e.capabilities)}}rc.bridgeRequests=[];class nc extends ja{constructor(){super(...arguments),this.bridgeProxy=void 0,this.accountContext=null}getModuleName(){return nc.MODULE_NAME}getId(){return nc.ID}getBridgeProxy(){return this.bridgeProxy}async initialize(){try{if("undefined"!=typeof window){"function"==typeof window.__initializeNestedAppAuth&&await window.__initializeNestedAppAuth();const e=await rc.create();this.accountContext=e.getAccountContext(),this.bridgeProxy=e,this.available=void 0!==e}}catch(e){this.logger.infoPii(`Could not initialize Nested App Auth bridge (${e})`)}return this.logger.info(`Nested App Auth Bridge available: ${this.available}`),this.available}}nc.MODULE_NAME="",nc.ID="NestedAppOperatingContext";class oc extends ja{getModuleName(){return oc.MODULE_NAME}getId(){return oc.ID}async initialize(){return this.available="undefined"!=typeof window,this.available}}oc.MODULE_NAME="",oc.ID="StandardOperatingContext";class ic{constructor(){this.dbName=Us,this.version=1,this.tableName=Hs,this.dbOpen=!1}async open(){return new Promise(((e,t)=>{const r=window.indexedDB.open(this.dbName,this.version);r.addEventListener("upgradeneeded",(e=>{e.target.result.createObjectStore(this.tableName)})),r.addEventListener("success",(t=>{const r=t;this.db=r.target.result,this.dbOpen=!0,e()})),r.addEventListener("error",(()=>t(Yi(qi))))}))}closeConnection(){const e=this.db;e&&this.dbOpen&&(e.close(),this.dbOpen=!1)}async validateDbIsOpen(){if(!this.dbOpen)return this.open()}async getItem(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(Yi(Ai));const n=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).get(e);n.addEventListener("success",(e=>{const r=e;this.closeConnection(),t(r.target.result)})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async setItem(e,t){return await this.validateDbIsOpen(),new Promise(((r,n)=>{if(!this.db)return n(Yi(Ai));const o=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).put(t,e);o.addEventListener("success",(()=>{this.closeConnection(),r()})),o.addEventListener("error",(e=>{this.closeConnection(),n(e)}))}))}async removeItem(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(Yi(Ai));const n=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).delete(e);n.addEventListener("success",(()=>{this.closeConnection(),t()})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async getKeys(){return await this.validateDbIsOpen(),new Promise(((e,t)=>{if(!this.db)return t(Yi(Ai));const r=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).getAllKeys();r.addEventListener("success",(t=>{const r=t;this.closeConnection(),e(r.target.result)})),r.addEventListener("error",(e=>{this.closeConnection(),t(e)}))}))}async containsKey(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(Yi(Ai));const n=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).count(e);n.addEventListener("success",(e=>{const r=e;this.closeConnection(),t(1===r.target.result)})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async deleteDatabase(){return this.db&&this.dbOpen&&this.closeConnection(),new Promise(((e,t)=>{const r=window.indexedDB.deleteDatabase(Us),n=setTimeout((()=>t(!1)),200);r.addEventListener("success",(()=>(clearTimeout(n),e(!0)))),r.addEventListener("blocked",(()=>(clearTimeout(n),e(!0)))),r.addEventListener("error",(()=>(clearTimeout(n),t(!1))))}))}}class sc{constructor(){this.cache=new Map}async initialize(){}getItem(e){return this.cache.get(e)||null}getUserData(e){return this.getItem(e)}setItem(e,t){this.cache.set(e,t)}async setUserData(e,t){this.setItem(e,t)}removeItem(e){this.cache.delete(e)}getKeys(){const e=[];return this.cache.forEach(((t,r)=>{e.push(r)})),e}containsKey(e){return this.cache.has(e)}clear(){this.cache.clear()}}class ac{constructor(e){this.inMemoryCache=new sc,this.indexedDBCache=new ic,this.logger=e}handleDatabaseAccessError(e){if(!(e instanceof Ji&&e.errorCode===qi))throw e;this.logger.error("Could not access persistent storage. This may be caused by browser privacy features which block persistent storage in third-party contexts.")}async getItem(e){const t=this.inMemoryCache.getItem(e);if(!t)try{return this.logger.verbose("Queried item not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.getItem(e)}catch(e){this.handleDatabaseAccessError(e)}return t}async setItem(e,t){this.inMemoryCache.setItem(e,t);try{await this.indexedDBCache.setItem(e,t)}catch(e){this.handleDatabaseAccessError(e)}}async removeItem(e){this.inMemoryCache.removeItem(e);try{await this.indexedDBCache.removeItem(e)}catch(e){this.handleDatabaseAccessError(e)}}async getKeys(){const e=this.inMemoryCache.getKeys();if(0===e.length)try{return this.logger.verbose("In-memory cache is empty, now querying persistent storage."),await this.indexedDBCache.getKeys()}catch(e){this.handleDatabaseAccessError(e)}return e}async containsKey(e){const t=this.inMemoryCache.containsKey(e);if(!t)try{return this.logger.verbose("Key not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.containsKey(e)}catch(e){this.handleDatabaseAccessError(e)}return t}clearInMemory(){this.logger.verbose("Deleting in-memory keystore"),this.inMemoryCache.clear(),this.logger.verbose("In-memory keystore deleted")}async clearPersistent(){try{this.logger.verbose("Deleting persistent keystore");const e=await this.indexedDBCache.deleteDatabase();return e&&this.logger.verbose("Persistent keystore deleted"),e}catch(e){return this.handleDatabaseAccessError(e),!1}}}class cc{constructor(e,t,r){this.logger=e,function(e){if(!window)throw Yi(Ti);if(!window.crypto)throw Yi(Xo);if(!e&&!window.crypto.subtle)throw Yi(Xo,"crypto_subtle_undefined")}(r??!1),this.cache=new ac(this.logger),this.performanceClient=t}createNewGuid(){return sa()}base64Encode(e){return Ks(e)}base64Decode(e){return $s(e)}base64UrlEncode(e){return Fs(e)}encodeKid(e){return this.base64UrlEncode(JSON.stringify({kid:e}))}async getPublicKeyThumbprint(e){const t=this.performanceClient?.startMeasurement(Qr.CryptoOptsGetPublicKeyThumbprint,e.correlationId),r=await async function(e,t){return window.crypto.subtle.generateKey(ra,e,t)}(cc.EXTRACTABLE,cc.POP_KEY_USAGES),n=await aa(r.publicKey),o=lc({e:n.e,kty:n.kty,n:n.n}),i=await this.hashString(o),s=await aa(r.privateKey),a=await async function(e,t,r){return window.crypto.subtle.importKey("jwk",e,ra,t,r)}(s,!1,["sign"]);return await this.cache.setItem(i,{privateKey:a,publicKey:r.publicKey,requestMethod:e.resourceRequestMethod,requestUri:e.resourceRequestUri}),t&&t.end({success:!0}),i}async removeTokenBindingKey(e){await this.cache.removeItem(e);if(await this.cache.containsKey(e))throw pt(rt)}async clearKeystore(){this.cache.clearInMemory();try{return await this.cache.clearPersistent(),!0}catch(e){return e instanceof Error?this.logger.error(`Clearing keystore failed with error: ${e.message}`):this.logger.error("Clearing keystore failed with unknown error"),!1}}async signJwt(e,t,r,n){const o=this.performanceClient?.startMeasurement(Qr.CryptoOptsSignJwt,n),i=await this.cache.getItem(t);if(!i)throw Yi(_i);const s=await aa(i.publicKey),a=lc(s),c=Fs(JSON.stringify({kid:t})),l=Fs($o.getShrHeaderString({...r?.header,alg:s.alg,kid:c}));e.cnf={jwk:JSON.parse(a)};const h=`${l}.${Fs(JSON.stringify(e))}`,d=(new TextEncoder).encode(h),u=await async function(e,t){return window.crypto.subtle.sign(ra,e,t)}(i.privateKey,d),g=`${h}.${zs(new Uint8Array(u))}`;return o&&o.end({success:!0}),g}async hashString(e){return ma(e)}}function lc(e){return JSON.stringify(e,Object.keys(e).sort())}cc.POP_KEY_USAGES=["sign","verify"],cc.EXTRACTABLE=!0;const hc=864e5,dc="Lax",uc="None";class gc{initialize(){return Promise.resolve()}getItem(e){const t=`${encodeURIComponent(e)}`,r=document.cookie.split(";");for(let e=0;e<r.length;e++){const n=r[e],[o,...i]=decodeURIComponent(n).trim().split("="),s=i.join("=");if(o===t)return s}return""}getUserData(){throw pt(ct)}setItem(e,t,r,n=!0,o=dc){let i=`${encodeURIComponent(e)}=${encodeURIComponent(t)};path=/;SameSite=${o};`;if(r){const e=function(e){const t=new Date,r=new Date(t.getTime()+e*hc);return r.toUTCString()}(r);i+=`expires=${e};`}(n||o===uc)&&(i+="Secure;"),document.cookie=i}async setUserData(){return Promise.reject(pt(ct))}removeItem(e){this.setItem(e,"",-1)}getKeys(){const e=document.cookie.split(";"),t=[];return e.forEach((e=>{const r=decodeURIComponent(e).trim().split("=");t.push(r[0])})),t}containsKey(e){return this.getKeys().includes(e)}}function pc(e){const t=e.getItem(Es);return t?JSON.parse(t):[]}function mc(e,t){const r=t.getItem(`${Rs}.${e}`);if(r){const e=JSON.parse(r);if(e&&e.hasOwnProperty("idToken")&&e.hasOwnProperty("accessToken")&&e.hasOwnProperty("refreshToken"))return e}return{idToken:[],accessToken:[],refreshToken:[]}}const fc="msal.cache.encryption";class yc{constructor(e,t,r){if(!window.localStorage)throw Aa(fa);this.memoryStorage=new sc,this.initialized=!1,this.clientId=e,this.logger=t,this.performanceClient=r,this.broadcast=new BroadcastChannel("msal.broadcast.cache")}async initialize(e){const t=new gc,r=t.getItem(fc);let n={key:"",id:""};if(r)try{n=JSON.parse(r)}catch(e){}if(n.key&&n.id){const t=Wn(Qs,Qr.Base64Decode,this.logger,this.performanceClient,e)(n.key);this.encryptionCookie={id:n.id,key:await Vn(da,Qr.GenerateHKDF,this.logger,this.performanceClient,e)(t)},await Vn(this.importExistingCache.bind(this),Qr.ImportExistingCache,this.logger,this.performanceClient,e)(e)}else{this.clear();const r=sa(),n=await Vn(ha,Qr.GenerateBaseKey,this.logger,this.performanceClient,e)(),o=Wn(zs,Qr.UrlEncodeArr,this.logger,this.performanceClient,e)(new Uint8Array(n));this.encryptionCookie={id:r,key:await Vn(da,Qr.GenerateHKDF,this.logger,this.performanceClient,e)(n)};const i={id:r,key:o};t.setItem(fc,JSON.stringify(i),0,!0,uc)}this.broadcast.addEventListener("message",this.updateCache.bind(this)),this.initialized=!0}getItem(e){return window.localStorage.getItem(e)}getUserData(e){if(!this.initialized)throw Yi(xi);return this.memoryStorage.getItem(e)}setItem(e,t){window.localStorage.setItem(e,t)}async setUserData(e,t,r,n){if(!this.initialized||!this.encryptionCookie)throw Yi(xi);const{data:o,nonce:i}=await Vn(ga,Qr.Encrypt,this.logger,this.performanceClient,r)(this.encryptionCookie.key,t,this.getContext(e)),s={id:this.encryptionCookie.id,nonce:i,data:o,lastUpdatedAt:n};this.memoryStorage.setItem(e,t),this.setItem(e,JSON.stringify(s)),this.broadcast.postMessage({key:e,value:t,context:this.getContext(e)})}removeItem(e){this.memoryStorage.containsKey(e)&&(this.memoryStorage.removeItem(e),this.broadcast.postMessage({key:e,value:null,context:this.getContext(e)})),window.localStorage.removeItem(e)}getKeys(){return Object.keys(window.localStorage)}containsKey(e){return window.localStorage.hasOwnProperty(e)}clear(){this.memoryStorage.clear();pc(this).forEach((e=>this.removeItem(e)));const e=mc(this.clientId,this);e.idToken.forEach((e=>this.removeItem(e))),e.accessToken.forEach((e=>this.removeItem(e))),e.refreshToken.forEach((e=>this.removeItem(e))),this.getKeys().forEach((e=>{(e.startsWith(t.CACHE_PREFIX)||-1!==e.indexOf(this.clientId))&&this.removeItem(e)}))}async importExistingCache(e){if(!this.encryptionCookie)return;let t=pc(this);t=await this.importArray(t,e),this.setItem(Es,JSON.stringify(t));const r=mc(this.clientId,this);r.idToken=await this.importArray(r.idToken,e),r.accessToken=await this.importArray(r.accessToken,e),r.refreshToken=await this.importArray(r.refreshToken,e),this.setItem(`${Rs}.${this.clientId}`,JSON.stringify(r))}async getItemFromEncryptedCache(e,t){if(!this.encryptionCookie)return null;const r=this.getItem(e);if(!r)return null;let n;try{n=JSON.parse(r)}catch(e){return null}return n.id&&n.nonce&&n.data?n.id!==this.encryptionCookie.id?(this.performanceClient.incrementFields({encryptedCacheExpiredCount:1},t),null):Vn(pa,Qr.Decrypt,this.logger,this.performanceClient,t)(this.encryptionCookie.key,n.nonce,this.getContext(e),n.data):(this.performanceClient.incrementFields({unencryptedCacheCount:1},t),null)}async importArray(e,t){const r=[],n=[];return e.forEach((e=>{const o=this.getItemFromEncryptedCache(e,t).then((t=>{t?(this.memoryStorage.setItem(e,t),r.push(e)):this.removeItem(e)}));n.push(o)})),await Promise.all(n),r}getContext(e){let t="";return e.includes(this.clientId)&&(t=this.clientId),t}updateCache(e){this.logger.trace("Updating internal cache from broadcast event");const t=this.performanceClient.startMeasurement(Qr.LocalStorageUpdated);t.add({isBackground:!0});const{key:r,value:n,context:o}=e.data;return r?o&&o!==this.clientId?(this.logger.trace(`Ignoring broadcast event from clientId: ${o}`),void t.end({success:!1,errorCode:"contextMismatch"})):(n?(this.memoryStorage.setItem(r,n),this.logger.verbose("Updated item in internal cache")):(this.memoryStorage.removeItem(r),this.logger.verbose("Removed item from internal cache")),void t.end({success:!0})):(this.logger.error("Broadcast event missing key"),void t.end({success:!1,errorCode:"noKey"}))}}class Cc{constructor(){if(!window.sessionStorage)throw Aa(fa)}async initialize(){}getItem(e){return window.sessionStorage.getItem(e)}getUserData(e){return this.getItem(e)}setItem(e,t){window.sessionStorage.setItem(e,t)}async setUserData(e,t){this.setItem(e,t)}removeItem(e){window.sessionStorage.removeItem(e)}getKeys(){return Object.keys(window.sessionStorage)}containsKey(e){return window.sessionStorage.hasOwnProperty(e)}}const vc={INITIALIZE_START:"msal:initializeStart",INITIALIZE_END:"msal:initializeEnd",ACCOUNT_ADDED:"msal:accountAdded",ACCOUNT_REMOVED:"msal:accountRemoved",ACTIVE_ACCOUNT_CHANGED:"msal:activeAccountChanged",LOGIN_START:"msal:loginStart",LOGIN_SUCCESS:"msal:loginSuccess",LOGIN_FAILURE:"msal:loginFailure",ACQUIRE_TOKEN_START:"msal:acquireTokenStart",ACQUIRE_TOKEN_SUCCESS:"msal:acquireTokenSuccess",ACQUIRE_TOKEN_FAILURE:"msal:acquireTokenFailure",ACQUIRE_TOKEN_NETWORK_START:"msal:acquireTokenFromNetworkStart",SSO_SILENT_START:"msal:ssoSilentStart",SSO_SILENT_SUCCESS:"msal:ssoSilentSuccess",SSO_SILENT_FAILURE:"msal:ssoSilentFailure",ACQUIRE_TOKEN_BY_CODE_START:"msal:acquireTokenByCodeStart",ACQUIRE_TOKEN_BY_CODE_SUCCESS:"msal:acquireTokenByCodeSuccess",ACQUIRE_TOKEN_BY_CODE_FAILURE:"msal:acquireTokenByCodeFailure",HANDLE_REDIRECT_START:"msal:handleRedirectStart",HANDLE_REDIRECT_END:"msal:handleRedirectEnd",POPUP_OPENED:"msal:popupOpened",LOGOUT_START:"msal:logoutStart",LOGOUT_SUCCESS:"msal:logoutSuccess",LOGOUT_FAILURE:"msal:logoutFailure",LOGOUT_END:"msal:logoutEnd",RESTORE_FROM_BFCACHE:"msal:restoreFromBFCache",BROKER_CONNECTION_ESTABLISHED:"msal:brokerConnectionEstablished"};class wc extends Gr{constructor(e,t,r,n,o,i,s){super(e,r,n,o,s),this.cacheConfig=t,this.logger=n,this.internalStorage=new sc,this.browserStorage=Ic(e,t.cacheLocation,n,o),this.temporaryCacheStorage=Ic(e,t.temporaryCacheLocation,n,o),this.cookieStorage=new gc,this.eventHandler=i}async initialize(e){await this.browserStorage.initialize(e),this.trackVersionChanges(e)}trackVersionChanges(e){const t=this.browserStorage.getItem(_s);t&&(this.logger.info(`MSAL.js was last initialized by version: ${t}`),this.performanceClient.addFields({previousLibraryVersion:t},e)),t!==Qa&&this.setItem(_s,Qa,e)}validateAndParseJson(e){try{const t=JSON.parse(e);return t&&"object"==typeof t?t:null}catch(e){return null}}setItem(e,t,r){let n=[];for(let o=0;o<=20;o++)try{this.browserStorage.setItem(e,t),o>0&&this.removeAccessTokenKeys(n.slice(0,o),r);break}catch(i){const s=Kr(i);if(!(s.errorCode===Dr&&o<20))throw s;if(n.length||(n=e===`${Rs}.${this.clientId}`?JSON.parse(t).accessToken:this.getTokenKeys().accessToken),n.length<=o)throw s;this.removeAccessToken(n[o],r,!1)}}async setUserData(e,t,r,n){let o=[];for(let i=0;i<=20;i++)try{await Vn(this.browserStorage.setUserData.bind(this.browserStorage),Qr.SetUserData,this.logger,this.performanceClient)(e,t,r,n),i>0&&this.removeAccessTokenKeys(o.slice(0,i),r);break}catch(e){const t=Kr(e);if(!(t.errorCode===Dr&&i<20))throw t;if(o.length||(o=this.getTokenKeys().accessToken),o.length<=i)throw t;this.removeAccessToken(o[i],r,!1)}}getAccount(e,t){this.logger.trace("BrowserCacheManager.getAccount called");const r=this.browserStorage.getUserData(e);if(!r)return this.removeAccountKeyFromMap(e,t),null;const n=this.validateAndParseJson(r);return n&&_r.isAccountEntity(n)?Gr.toObject(new _r,n):null}async setAccount(e,t){this.logger.trace("BrowserCacheManager.setAccount called");const r=e.generateAccountKey(),n=Date.now().toString();e.lastUpdatedAt=n,await this.setUserData(r,JSON.stringify(e),t,n);const o=this.addAccountKeyToMap(r,t);this.cacheConfig.cacheLocation===fs.LocalStorage&&o&&this.eventHandler.emitEvent(vc.ACCOUNT_ADDED,void 0,e.getAccountInfo())}getAccountKeys(){return pc(this.browserStorage)}addAccountKeyToMap(e,t){this.logger.trace("BrowserCacheManager.addAccountKeyToMap called"),this.logger.tracePii(`BrowserCacheManager.addAccountKeyToMap called with key: ${e}`);const r=this.getAccountKeys();return-1===r.indexOf(e)?(r.push(e),this.setItem(Es,JSON.stringify(r),t),this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key added"),!0):(this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key already exists in map"),!1)}removeAccountKeyFromMap(e,t){this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap called"),this.logger.tracePii(`BrowserCacheManager.removeAccountKeyFromMap called with key: ${e}`);const r=this.getAccountKeys(),n=r.indexOf(e);if(n>-1){if(r.splice(n,1),0===r.length)return void this.removeItem(Es);this.setItem(Es,JSON.stringify(r),t),this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap account key removed")}else this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap key not found in existing map")}removeAccount(e,t){super.removeAccount(e,t),this.removeAccountKeyFromMap(e,t)}removeAccountContext(e,t){super.removeAccountContext(e,t),this.cacheConfig.cacheLocation===fs.LocalStorage&&this.eventHandler.emitEvent(vc.ACCOUNT_REMOVED,void 0,e.getAccountInfo())}removeIdToken(e,t){super.removeIdToken(e,t);const r=this.getTokenKeys(),n=r.idToken.indexOf(e);n>-1&&(this.logger.info("idToken removed from tokenKeys map"),r.idToken.splice(n,1),this.setTokenKeys(r,t))}removeAccessToken(e,t,r=!0){super.removeAccessToken(e,t),r&&this.removeAccessTokenKeys([e],t)}removeAccessTokenKeys(e,t){this.logger.trace("removeAccessTokenKey called");const r=this.getTokenKeys();let n=0;if(e.forEach((e=>{const t=r.accessToken.indexOf(e);t>-1&&(r.accessToken.splice(t,1),n++)})),n>0)return this.logger.info(`removed ${n} accessToken keys from tokenKeys map`),void this.setTokenKeys(r,t)}removeRefreshToken(e,t){super.removeRefreshToken(e,t);const r=this.getTokenKeys(),n=r.refreshToken.indexOf(e);n>-1&&(this.logger.info("refreshToken removed from tokenKeys map"),r.refreshToken.splice(n,1),this.setTokenKeys(r,t))}getTokenKeys(){return mc(this.clientId,this.browserStorage)}setTokenKeys(e,t){0!==e.idToken.length||0!==e.accessToken.length||0!==e.refreshToken.length?this.setItem(`${Rs}.${this.clientId}`,JSON.stringify(e),t):this.removeItem(`${Rs}.${this.clientId}`)}getIdTokenCredential(e,t){const r=this.browserStorage.getUserData(e);if(!r)return this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),this.removeIdToken(e,t),null;const n=this.validateAndParseJson(r);return n&&((o=n)&&Ot(o)&&o.hasOwnProperty("realm")&&o.credentialType===x.ID_TOKEN)?(this.logger.trace("BrowserCacheManager.getIdTokenCredential: cache hit"),n):(this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),null);var o}async setIdTokenCredential(e,t){this.logger.trace("BrowserCacheManager.setIdTokenCredential called");const r=Rt(e),n=Date.now().toString();e.lastUpdatedAt=n,await this.setUserData(r,JSON.stringify(e),t,n);const o=this.getTokenKeys();-1===o.idToken.indexOf(r)&&(this.logger.info("BrowserCacheManager: addTokenKey - idToken added to map"),o.idToken.push(r),this.setTokenKeys(o,t))}getAccessTokenCredential(e,t){const r=this.browserStorage.getUserData(e);if(!r)return this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),this.removeAccessTokenKeys([e],t),null;const n=this.validateAndParseJson(r);return n&&(o=n)&&Ot(o)&&o.hasOwnProperty("realm")&&o.hasOwnProperty("target")&&(o.credentialType===x.ACCESS_TOKEN||o.credentialType===x.ACCESS_TOKEN_WITH_AUTH_SCHEME)?(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: cache hit"),n):(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),null);var o}async setAccessTokenCredential(e,t){this.logger.trace("BrowserCacheManager.setAccessTokenCredential called");const r=Rt(e),n=Date.now().toString();e.lastUpdatedAt=n,await this.setUserData(r,JSON.stringify(e),t,n);const o=this.getTokenKeys(),i=o.accessToken.indexOf(r);-1!==i&&o.accessToken.splice(i,1),this.logger.trace(`access token ${-1===i?"added to":"updated in"} map`),o.accessToken.push(r),this.setTokenKeys(o,t)}getRefreshTokenCredential(e,t){const r=this.browserStorage.getUserData(e);if(!r)return this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),this.removeRefreshToken(e,t),null;const n=this.validateAndParseJson(r);return n&&(o=n)&&Ot(o)&&o.credentialType===x.REFRESH_TOKEN?(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: cache hit"),n):(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),null);var o}async setRefreshTokenCredential(e,t){this.logger.trace("BrowserCacheManager.setRefreshTokenCredential called");const r=Rt(e),n=Date.now().toString();e.lastUpdatedAt=n,await this.setUserData(r,JSON.stringify(e),t,n);const o=this.getTokenKeys();-1===o.refreshToken.indexOf(r)&&(this.logger.info("BrowserCacheManager: addTokenKey - refreshToken added to map"),o.refreshToken.push(r),this.setTokenKeys(o,t))}getAppMetadata(e){const t=this.browserStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&(n=e,(o=r)&&0===n.indexOf(D)&&o.hasOwnProperty("clientId")&&o.hasOwnProperty("environment"))?(this.logger.trace("BrowserCacheManager.getAppMetadata: cache hit"),r):(this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null);var n,o}setAppMetadata(e,t){this.logger.trace("BrowserCacheManager.setAppMetadata called");const r=function({environment:e,clientId:t}){return[D,e,t].join(U).toLowerCase()}(e);this.setItem(r,JSON.stringify(e),t)}getServerTelemetry(e){const t=this.browserStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){const r=0===e.indexOf(j.CACHE_KEY);let n=!0;return t&&(n=t.hasOwnProperty("failedRequests")&&t.hasOwnProperty("errors")&&t.hasOwnProperty("cacheHits")),r&&n}(e,r)?(this.logger.trace("BrowserCacheManager.getServerTelemetry: cache hit"),r):(this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null)}setServerTelemetry(e,t,r){this.logger.trace("BrowserCacheManager.setServerTelemetry called"),this.setItem(e,JSON.stringify(t),r)}getAuthorityMetadata(e){const t=this.internalStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAuthorityMetadata: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){return!!t&&0===e.indexOf(F)&&t.hasOwnProperty("aliases")&&t.hasOwnProperty("preferred_cache")&&t.hasOwnProperty("preferred_network")&&t.hasOwnProperty("canonical_authority")&&t.hasOwnProperty("authorization_endpoint")&&t.hasOwnProperty("token_endpoint")&&t.hasOwnProperty("issuer")&&t.hasOwnProperty("aliasesFromNetwork")&&t.hasOwnProperty("endpointsFromNetwork")&&t.hasOwnProperty("expiresAt")&&t.hasOwnProperty("jwks_uri")}(e,r)?(this.logger.trace("BrowserCacheManager.getAuthorityMetadata: cache hit"),r):null}getAuthorityMetadataKeys(){return this.internalStorage.getKeys().filter((e=>this.isAuthorityMetadata(e)))}setWrapperMetadata(e,t){this.internalStorage.setItem(Ps,e),this.internalStorage.setItem(Ms,t)}getWrapperMetadata(){return[this.internalStorage.getItem(Ps)||t.EMPTY_STRING,this.internalStorage.getItem(Ms)||t.EMPTY_STRING]}setAuthorityMetadata(e,t){this.logger.trace("BrowserCacheManager.setAuthorityMetadata called"),this.internalStorage.setItem(e,JSON.stringify(t))}getActiveAccount(e){const t=this.generateCacheKey(w),r=this.browserStorage.getItem(t);if(!r)return this.logger.trace("BrowserCacheManager.getActiveAccount: No active account filters found"),null;const n=this.validateAndParseJson(r);return n?(this.logger.trace("BrowserCacheManager.getActiveAccount: Active account filters schema found"),this.getAccountInfoFilteredBy({homeAccountId:n.homeAccountId,localAccountId:n.localAccountId,tenantId:n.tenantId},e)):(this.logger.trace("BrowserCacheManager.getActiveAccount: No active account found"),null)}setActiveAccount(e,t){const r=this.generateCacheKey(w);if(e){this.logger.verbose("setActiveAccount: Active account set");const n={homeAccountId:e.homeAccountId,localAccountId:e.localAccountId,tenantId:e.tenantId,lastUpdatedAt:At().toString()};this.setItem(r,JSON.stringify(n),t)}else this.logger.verbose("setActiveAccount: No account passed, active account not set"),this.browserStorage.removeItem(r);this.eventHandler.emitEvent(vc.ACTIVE_ACCOUNT_CHANGED)}getThrottlingCache(e){const t=this.browserStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){let r=!1;e&&(r=0===e.indexOf(Y));let n=!0;return t&&(n=t.hasOwnProperty("throttleTime")),r&&n}(e,r)?(this.logger.trace("BrowserCacheManager.getThrottlingCache: cache hit"),r):(this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null)}setThrottlingCache(e,t,r){this.logger.trace("BrowserCacheManager.setThrottlingCache called"),this.setItem(e,JSON.stringify(t),r)}getTemporaryCache(e,t){const r=t?this.generateCacheKey(e):e;if(this.cacheConfig.storeAuthStateInCookie){const e=this.cookieStorage.getItem(r);if(e)return this.logger.trace("BrowserCacheManager.getTemporaryCache: storeAuthStateInCookies set to true, retrieving from cookies"),e}const n=this.temporaryCacheStorage.getItem(r);if(!n){if(this.cacheConfig.cacheLocation===fs.LocalStorage){const e=this.browserStorage.getItem(r);if(e)return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item found in local storage"),e}return this.logger.trace("BrowserCacheManager.getTemporaryCache: No cache item found in local storage"),null}return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item returned"),n}setTemporaryCache(e,t,r){const n=r?this.generateCacheKey(e):e;this.temporaryCacheStorage.setItem(n,t),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.setTemporaryCache: storeAuthStateInCookie set to true, setting item cookie"),this.cookieStorage.setItem(n,t,void 0,this.cacheConfig.secureCookies))}removeItem(e){this.browserStorage.removeItem(e)}removeTemporaryItem(e){this.temporaryCacheStorage.removeItem(e),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.removeItem: storeAuthStateInCookie is true, clearing item cookie"),this.cookieStorage.removeItem(e))}getKeys(){return this.browserStorage.getKeys()}clear(e){this.removeAllAccounts(e),this.removeAppMetadata(e),this.temporaryCacheStorage.getKeys().forEach((e=>{-1===e.indexOf(t.CACHE_PREFIX)&&-1===e.indexOf(this.clientId)||this.removeTemporaryItem(e)})),this.browserStorage.getKeys().forEach((e=>{-1===e.indexOf(t.CACHE_PREFIX)&&-1===e.indexOf(this.clientId)||this.browserStorage.removeItem(e)})),this.internalStorage.clear()}clearTokensAndKeysWithClaims(e){this.performanceClient.addQueueMeasurement(Qr.ClearTokensAndKeysWithClaims,e);const t=this.getTokenKeys();let r=0;t.accessToken.forEach((t=>{const n=this.getAccessTokenCredential(t,e);n?.requestedClaimsHash&&t.includes(n.requestedClaimsHash.toLowerCase())&&(this.removeAccessToken(t,e),r++)})),r>0&&this.logger.warning(`${r} access tokens with claims in the cache keys have been removed from the cache.`)}generateCacheKey(e){return this.validateAndParseJson(e)?JSON.stringify(e):fr.startsWith(e,t.CACHE_PREFIX)?e:`${t.CACHE_PREFIX}.${this.clientId}.${e}`}resetRequestCache(){this.logger.trace("BrowserCacheManager.resetRequestCache called"),this.removeTemporaryItem(this.generateCacheKey(As)),this.removeTemporaryItem(this.generateCacheKey(ks)),this.removeTemporaryItem(this.generateCacheKey(Is)),this.removeTemporaryItem(this.generateCacheKey(Ts)),this.removeTemporaryItem(this.generateCacheKey(bs)),this.setInteractionInProgress(!1)}cacheAuthorizeRequest(e,t){this.logger.trace("BrowserCacheManager.cacheAuthorizeRequest called");const r=Ks(JSON.stringify(e));if(this.setTemporaryCache(As,r,!0),t){const e=Ks(t);this.setTemporaryCache(ks,e,!0)}}getCachedRequest(){this.logger.trace("BrowserCacheManager.getCachedRequest called");const e=this.getTemporaryCache(As,!0);if(!e)throw Yi(Ci);const t=this.getTemporaryCache(ks,!0);let r,n="";try{r=JSON.parse($s(e)),t&&(n=$s(t))}catch(t){throw this.logger.errorPii(`Attempted to parse: ${e}`),this.logger.error(`Parsing cached token request threw with error: ${t}`),Yi(vi)}return[r,n]}getCachedNativeRequest(){this.logger.trace("BrowserCacheManager.getCachedNativeRequest called");const e=this.getTemporaryCache(bs,!0);if(!e)return this.logger.trace("BrowserCacheManager.getCachedNativeRequest: No cached native request found"),null;const t=this.validateAndParseJson(e);return t||(this.logger.error("BrowserCacheManager.getCachedNativeRequest: Unable to parse native request"),null)}isInteractionInProgress(e){const t=this.getInteractionInProgress()?.clientId;return e?t===this.clientId:!!t}getInteractionInProgress(){const e=`${t.CACHE_PREFIX}.${Ss}`,r=this.getTemporaryCache(e,!1);try{return r?JSON.parse(r):null}catch(t){return this.logger.error("Cannot parse interaction status. Removing temporary cache items and clearing url hash. Retrying interaction should fix the error"),this.removeTemporaryItem(e),this.resetRequestCache(),ka(window),null}}setInteractionInProgress(e,r=vs){const n=`${t.CACHE_PREFIX}.${Ss}`;if(e){if(this.getInteractionInProgress())throw Yi(ii);this.setTemporaryCache(n,JSON.stringify({clientId:this.clientId,type:r}),!1)}else e||this.getInteractionInProgress()?.clientId!==this.clientId||this.removeTemporaryItem(n)}async hydrateCache(e,t){const r=_t(e.account?.homeAccountId,e.account?.environment,e.idToken,this.clientId,e.tenantId);let n;t.claims&&(n=await this.cryptoImpl.hashString(t.claims));const o={idToken:r,accessToken:Pt(e.account?.homeAccountId,e.account.environment,e.accessToken,this.clientId,e.tenantId,e.scopes.join(" "),e.expiresOn?kt(e.expiresOn):0,e.extExpiresOn?kt(e.extExpiresOn):0,$s,void 0,e.tokenType,void 0,t.sshKid,t.claims,n)};return this.saveCacheRecord(o,e.correlationId)}async saveCacheRecord(e,t,r){try{await super.saveCacheRecord(e,t,r)}catch(e){if(e instanceof zr&&this.performanceClient&&t)try{const e=this.getTokenKeys();this.performanceClient.addFields({cacheRtCount:e.refreshToken.length,cacheIdCount:e.idToken.length,cacheAtCount:e.accessToken.length},t)}catch(e){}throw e}}}function Ic(e,t,r,n){try{switch(t){case fs.LocalStorage:return new yc(e,r,n);case fs.SessionStorage:return new Cc}}catch(e){r.error(e)}return new sc}const Tc=(e,t,r,n)=>new wc(e,{cacheLocation:fs.MemoryStorage,temporaryCacheLocation:fs.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1},mt,t,r,n);function Ac(e,t,r,n,o){return e.verbose("getAllAccounts called"),r?t.getAllAccounts(o||{},n):[]}function kc(e,t,r,n){if(t.trace("getAccount called"),0===Object.keys(e).length)return t.warning("getAccount: No accountFilter provided"),null;const o=r.getAccountInfoFilteredBy(e,n);return o?(t.verbose("getAccount: Account matching provided filter found, returning"),o):(t.verbose("getAccount: No matching account found, returning null"),null)}function Sc(e,t,r,n){if(t.trace("getAccountByUsername called"),!e)return t.warning("getAccountByUsername: No username provided"),null;const o=r.getAccountInfoFilteredBy({username:e},n);return o?(t.verbose("getAccountByUsername: Account matching username found, returning"),t.verbosePii(`getAccountByUsername: Returning signed-in accounts matching username: ${e}`),o):(t.verbose("getAccountByUsername: No matching account found, returning null"),null)}function bc(e,t,r,n){if(t.trace("getAccountByHomeId called"),!e)return t.warning("getAccountByHomeId: No homeAccountId provided"),null;const o=r.getAccountInfoFilteredBy({homeAccountId:e},n);return o?(t.verbose("getAccountByHomeId: Account matching homeAccountId found, returning"),t.verbosePii(`getAccountByHomeId: Returning signed-in accounts matching homeAccountId: ${e}`),o):(t.verbose("getAccountByHomeId: No matching account found, returning null"),null)}function Ec(e,t,r,n){if(t.trace("getAccountByLocalId called"),!e)return t.warning("getAccountByLocalId: No localAccountId provided"),null;const o=r.getAccountInfoFilteredBy({localAccountId:e},n);return o?(t.verbose("getAccountByLocalId: Account matching localAccountId found, returning"),t.verbosePii(`getAccountByLocalId: Returning signed-in accounts matching localAccountId: ${e}`),o):(t.verbose("getAccountByLocalId: No matching account found, returning null"),null)}function Rc(e,t,r){t.setActiveAccount(e,r)}function _c(e,t){return e.getActiveAccount(t)}class Pc{constructor(e){this.eventCallbacks=new Map,this.logger=e||new yt({}),"undefined"!=typeof BroadcastChannel&&(this.broadcastChannel=new BroadcastChannel("msal.broadcast.event")),this.invokeCrossTabCallbacks=this.invokeCrossTabCallbacks.bind(this)}addEventCallback(e,t,r){if("undefined"!=typeof window){const n=r||xa();return this.eventCallbacks.has(n)?(this.logger.error(`Event callback with id: ${n} is already registered. Please provide a unique id or remove the existing callback and try again.`),null):(this.eventCallbacks.set(n,[e,t||[]]),this.logger.verbose(`Event callback registered with id: ${n}`),n)}return null}removeEventCallback(e){this.eventCallbacks.delete(e),this.logger.verbose(`Event callback ${e} removed.`)}emitEvent(e,t,r,n){const o={eventType:e,interactionType:t||null,payload:r||null,error:n||null,timestamp:Date.now()};switch(e){case vc.ACCOUNT_ADDED:case vc.ACCOUNT_REMOVED:case vc.ACTIVE_ACCOUNT_CHANGED:this.broadcastChannel?.postMessage(o);break;default:this.invokeCallbacks(o)}}invokeCallbacks(e){this.eventCallbacks.forEach((([t,r],n)=>{(0===r.length||r.includes(e.eventType))&&(this.logger.verbose(`Emitting event to callback ${n}: ${e.eventType}`),t.apply(null,[e]))}))}invokeCrossTabCallbacks(e){const t=e.data;this.invokeCallbacks(t)}subscribeCrossTab(){this.broadcastChannel?.addEventListener("message",this.invokeCrossTabCallbacks)}unsubscribeCrossTab(){this.broadcastChannel?.removeEventListener("message",this.invokeCrossTabCallbacks)}}class Mc{constructor(e,t,r,n,o,i,s,a,c){this.config=e,this.browserStorage=t,this.browserCrypto=r,this.networkClient=this.config.system.networkClient,this.eventHandler=o,this.navigationClient=i,this.platformAuthProvider=a,this.correlationId=c||sa(),this.logger=n.clone(ns,Qa,this.correlationId),this.performanceClient=s}async clearCacheOnLogout(e,t){if(t){_r.accountInfoIsEqual(t,this.browserStorage.getActiveAccount(e),!1)&&(this.logger.verbose("Setting active account to null"),this.browserStorage.setActiveAccount(null,e));try{this.browserStorage.removeAccount(_r.generateAccountCacheKey(t),e),this.logger.verbose("Cleared cache items belonging to the account provided in the logout request.")}catch(e){this.logger.error("Account provided in logout request was not found. Local cache unchanged.")}}else try{this.logger.verbose("No account provided in logout request, clearing all cache items.",this.correlationId),this.browserStorage.clear(e),await this.browserCrypto.clearKeystore()}catch(e){this.logger.error("Attempted to clear all MSAL cache items and failed. Local cache unchanged.")}}getRedirectUri(e){this.logger.verbose("getRedirectUri called");const t=e||this.config.auth.redirectUri;return qr.getAbsoluteUrl(t,Ra())}initializeServerTelemetryManager(e,t){this.logger.verbose("initializeServerTelemetryManager called");const r={clientId:this.config.auth.clientId,correlationId:this.correlationId,apiId:e,forceRefresh:t||!1,wrapperSKU:this.browserStorage.getWrapperMetadata()[0],wrapperVer:this.browserStorage.getWrapperMetadata()[1]};return new Do(r,this.browserStorage)}async getDiscoveredAuthority(e){const{account:t}=e,r=e.requestExtraQueryParameters&&e.requestExtraQueryParameters.hasOwnProperty("instance_aware")?e.requestExtraQueryParameters.instance_aware:void 0;this.performanceClient.addQueueMeasurement(Qr.StandardInteractionClientGetDiscoveredAuthority,this.correlationId);const n={protocolMode:this.config.auth.protocolMode,OIDCOptions:this.config.auth.OIDCOptions,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache},o=e.requestAuthority||this.config.auth.authority,i=r?.length?"true"===r:this.config.auth.instanceAware,s=t&&i?this.config.auth.authority.replace(qr.getDomainFromUrl(o),t.environment):o,a=Yn.generateAuthority(s,e.requestAzureCloudOptions||this.config.auth.azureCloudOptions),c=await Vn(eo,Qr.AuthorityFactoryCreateDiscoveredInstance,this.logger,this.performanceClient,this.correlationId)(a,this.config.system.networkClient,this.browserStorage,n,this.logger,this.correlationId,this.performanceClient);if(t&&!c.isAlias(t.environment))throw mr(cr);return c}}async function Oc(e,t,r,n){r.addQueueMeasurement(Qr.InitializeBaseRequest,e.correlationId);const o=e.authority||t.auth.authority,i=[...e&&e.scopes||[]],s={...e,correlationId:e.correlationId,authority:o,scopes:i};if(s.authenticationScheme){if(s.authenticationScheme===W.SSH){if(!e.sshJwk)throw mr(rr);if(!e.sshKid)throw mr(nr)}n.verbose(`Authentication Scheme set to "${s.authenticationScheme}" as configured in Auth request`)}else s.authenticationScheme=W.BEARER,n.verbose('Authentication Scheme wasn\'t explicitly set in request, defaulting to "Bearer" request');return t.cache.claimsBasedCachingEnabled&&e.claims&&!fr.isEmptyObj(e.claims)&&(s.requestedClaimsHash=await ma(e.claims)),s}async function qc(e,t,r,n,o){n.addQueueMeasurement(Qr.InitializeSilentRequest,e.correlationId);const i=await Vn(Oc,Qr.InitializeBaseRequest,o,n,e.correlationId)(e,r,n,o);return{...e,...i,account:t,forceRefresh:e.forceRefresh||!1}}function Nc(e,t){let r;const n=e.httpMethod;if(t===Rr.EAR){if(r=n||l,r!==l)throw mr(lr)}else r=n||c;if(e.authorizePostBodyParameters&&r!==l)throw mr(hr);return r}class Lc extends Mc{initializeLogoutRequest(e){this.logger.verbose("initializeLogoutRequest called",e?.correlationId);const t={correlationId:this.correlationId||sa(),...e};if(e)if(e.logoutHint)this.logger.verbose("logoutHint has already been set in logoutRequest");else if(e.account){const r=this.getLogoutHintFromIdTokenClaims(e.account);r&&(this.logger.verbose("Setting logoutHint to login_hint ID Token Claim value for the account provided"),t.logoutHint=r)}else this.logger.verbose("logoutHint was not set and account was not passed into logout request, logoutHint will not be set");else this.logger.verbose("logoutHint will not be set since no logout request was configured");return e&&null===e.postLogoutRedirectUri?this.logger.verbose("postLogoutRedirectUri passed as null, not setting post logout redirect uri",t.correlationId):e&&e.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to uri set on logout request",t.correlationId),t.postLogoutRedirectUri=qr.getAbsoluteUrl(e.postLogoutRedirectUri,Ra())):null===this.config.auth.postLogoutRedirectUri?this.logger.verbose("postLogoutRedirectUri configured as null and no uri set on request, not passing post logout redirect",t.correlationId):this.config.auth.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to configured uri",t.correlationId),t.postLogoutRedirectUri=qr.getAbsoluteUrl(this.config.auth.postLogoutRedirectUri,Ra())):(this.logger.verbose("Setting postLogoutRedirectUri to current page",t.correlationId),t.postLogoutRedirectUri=qr.getAbsoluteUrl(Ra(),Ra())),t}getLogoutHintFromIdTokenClaims(e){const t=e.idTokenClaims;if(t){if(t.login_hint)return t.login_hint;this.logger.verbose("The ID Token Claims tied to the provided account do not contain a login_hint claim, logoutHint will not be added to logout request")}else this.logger.verbose("The provided account does not contain ID Token Claims, logoutHint will not be added to logout request");return null}async createAuthCodeClient(e){this.performanceClient.addQueueMeasurement(Qr.StandardInteractionClientCreateAuthCodeClient,this.correlationId);const t=await Vn(this.getClientConfiguration.bind(this),Qr.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)(e);return new Mo(t,this.performanceClient)}async getClientConfiguration(e){const{serverTelemetryManager:r,requestAuthority:n,requestAzureCloudOptions:o,requestExtraQueryParameters:i,account:s}=e;this.performanceClient.addQueueMeasurement(Qr.StandardInteractionClientGetClientConfiguration,this.correlationId);const a=await Vn(this.getDiscoveredAuthority.bind(this),Qr.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,this.correlationId)({requestAuthority:n,requestAzureCloudOptions:o,requestExtraQueryParameters:i,account:s}),c=this.config.system.loggerOptions;return{authOptions:{clientId:this.config.auth.clientId,authority:a,clientCapabilities:this.config.auth.clientCapabilities,redirectUri:this.config.auth.redirectUri},systemOptions:{tokenRenewalOffsetSeconds:this.config.system.tokenRenewalOffsetSeconds,preventCorsPreflight:!0},loggerOptions:{loggerCallback:c.loggerCallback,piiLoggingEnabled:c.piiLoggingEnabled,logLevel:c.logLevel,correlationId:this.correlationId},cacheOptions:{claimsBasedCachingEnabled:this.config.cache.claimsBasedCachingEnabled},cryptoInterface:this.browserCrypto,networkInterface:this.networkClient,storageInterface:this.browserStorage,serverTelemetryManager:r,libraryInfo:{sku:ns,version:Qa,cpu:t.EMPTY_STRING,os:t.EMPTY_STRING},telemetry:this.config.telemetry}}async initializeAuthorizationRequest(e,r){this.performanceClient.addQueueMeasurement(Qr.StandardInteractionClientInitializeAuthorizationRequest,this.correlationId);const n=this.getRedirectUri(e.redirectUri),o={interactionType:r},i=ko.setRequestState(this.browserCrypto,e&&e.state||t.EMPTY_STRING,o),s={...await Vn(Oc,Qr.InitializeBaseRequest,this.logger,this.performanceClient,this.correlationId)({...e,correlationId:this.correlationId},this.config,this.performanceClient,this.logger),redirectUri:n,state:i,nonce:e.nonce||sa(),responseMode:this.config.auth.OIDCOptions.serverResponseType},a={...s,httpMethod:Nc(s,this.config.auth.protocolMode)};if(e.loginHint||e.sid)return a;const c=e.account||this.browserStorage.getActiveAccount(this.correlationId);return c&&(this.logger.verbose("Setting validated request account",this.correlationId),this.logger.verbosePii(`Setting validated request account: ${c.homeAccountId}`,this.correlationId),a.account=c),a}}function Uc(e,t,r){const n=Mr(e);if(!n)throw Pr(e)?(r.error(`A ${t} is present in the iframe but it does not contain known properties. It's likely that the ${t} has been replaced by code running on the redirectUri page.`),r.errorPii(`The ${t} detected is: ${e}`),Yi(ri)):(r.error(`The request has returned to the redirectUri but a ${t} is not present. It's likely that the ${t} has been removed or the page has been redirected by code running on the redirectUri page.`),Yi(ei));return n}function Hc(e,t,r){if(!e.state)throw Yi(ti);const n=function(e,t){if(!t)return null;try{return ko.parseRequestState(e,t).libraryState.meta}catch(e){throw pt(Re)}}(t,e.state);if(!n)throw Yi(ni);if(n.interactionType!==r)throw Yi(oi)}class xc{constructor(e,t,r,n,o){this.authModule=e,this.browserStorage=t,this.authCodeRequest=r,this.logger=n,this.performanceClient=o}async handleCodeResponse(e,t){let r;this.performanceClient.addQueueMeasurement(Qr.HandleCodeResponse,t.correlationId);try{r=function(e,t){if(Ho(e,t),!e.code)throw pt(tt);return e}(e,t.state)}catch(e){throw e instanceof to&&e.subError===ci?Yi(ci):e}return Vn(this.handleCodeResponseFromServer.bind(this),Qr.HandleCodeResponseFromServer,this.logger,this.performanceClient,t.correlationId)(r,t)}async handleCodeResponseFromServer(e,t,r=!0){if(this.performanceClient.addQueueMeasurement(Qr.HandleCodeResponseFromServer,t.correlationId),this.logger.trace("InteractionHandler.handleCodeResponseFromServer called"),this.authCodeRequest.code=e.code,e.cloud_instance_host_name&&await Vn(this.authModule.updateAuthority.bind(this.authModule),Qr.UpdateTokenEndpointAuthority,this.logger,this.performanceClient,t.correlationId)(e.cloud_instance_host_name,t.correlationId),r&&(e.nonce=t.nonce||void 0),e.state=t.state,e.client_info)this.authCodeRequest.clientInfo=e.client_info;else{const e=this.createCcsCredentials(t);e&&(this.authCodeRequest.ccsCredential=e)}return await Vn(this.authModule.acquireToken.bind(this.authModule),Qr.AuthClientAcquireToken,this.logger,this.performanceClient,t.correlationId)(this.authCodeRequest,e)}createCcsCredentials(e){return e.account?{credential:e.account.homeAccountId,type:ln}:e.loginHint?{credential:e.loginHint,type:hn}:null}}const Dc="user_switch",Bc={[Dc]:"User attempted to switch accounts in the native broker, which is not allowed. All new accounts must sign-in through the standard web flow first, please try again."};class Fc extends Ce{constructor(e,t,r){super(e,t),Object.setPrototypeOf(this,Fc.prototype),this.name="NativeAuthError",this.ext=r}}function zc(e){return!(!e.ext||!e.ext.status||"PERSISTENT_ERROR"!==e.ext.status&&"DISABLED"!==e.ext.status)||(!(!e.ext||!e.ext.error||-2147186943!==e.ext.error)||"ContentError"===e.errorCode)}function Kc(e,t,r){if(r&&r.status)switch(r.status){case"ACCOUNT_UNAVAILABLE":return Ao(co);case"USER_INTERACTION_REQUIRED":return new Io(e,t);case"USER_CANCEL":return Yi(ci);case"NO_NETWORK":return Yi(ki);case"UX_NOT_ALLOWED":return Ao(ho)}return new Fc(e,Bc[e]||t,r)}class Gc extends Lc{async acquireToken(e){this.performanceClient.addQueueMeasurement(Qr.SilentCacheClientAcquireToken,e.correlationId);const t=this.initializeServerTelemetryManager(Os.acquireTokenSilent_silentFlow),r=await Vn(this.getClientConfiguration.bind(this),Qr.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:t,requestAuthority:e.authority,requestAzureCloudOptions:e.azureCloudOptions,account:e.account}),n=new qo(r,this.performanceClient);this.logger.verbose("Silent auth client created");try{const t=(await Vn(n.acquireCachedToken.bind(n),Qr.SilentFlowClientAcquireCachedToken,this.logger,this.performanceClient,e.correlationId)(e))[0];return this.performanceClient.addFields({fromCache:!0},e.correlationId),t}catch(e){throw e instanceof Ji&&e.errorCode===_i&&this.logger.verbose("Signing keypair for bound access token not found. Refreshing bound access token and generating a new crypto keypair."),e}}logout(e){this.logger.verbose("logoutRedirect called");const t=this.initializeLogoutRequest(e);return this.clearCacheOnLogout(t.correlationId,t?.account)}}class $c extends Mc{constructor(e,t,r,n,o,i,s,a,c,l,h,d){super(e,t,r,n,o,i,a,c,d),this.apiId=s,this.accountId=l,this.platformAuthProvider=c,this.nativeStorageManager=h,this.silentCacheClient=new Gc(e,this.nativeStorageManager,r,n,o,i,a,c,d);const u=this.platformAuthProvider.getExtensionName();this.skus=Do.makeExtraSkuString({libraryName:ns,libraryVersion:Qa,extensionName:u,extensionVersion:this.platformAuthProvider.getExtensionVersion()})}addRequestSKUs(e){e.extraParameters={...e.extraParameters,[fn]:this.skus}}async acquireToken(e,t){this.performanceClient.addQueueMeasurement(Qr.NativeInteractionClientAcquireToken,e.correlationId),this.logger.trace("NativeInteractionClient - acquireToken called.");const r=this.performanceClient.startMeasurement(Qr.NativeInteractionClientAcquireToken,e.correlationId),n=At(),o=this.initializeServerTelemetryManager(this.apiId);try{const i=await this.initializeNativeRequest(e);try{const e=await this.acquireTokensFromCache(this.accountId,i);return r.end({success:!0,isNativeBroker:!1,fromCache:!0}),e}catch(e){if(t===xs.AccessToken)throw this.logger.info("MSAL internal Cache does not contain tokens, return error as per cache policy"),e;this.logger.info("MSAL internal Cache does not contain tokens, proceed to make a native call")}const s=await this.platformAuthProvider.sendMessage(i);return await this.handleNativeResponse(s,i,n).then((e=>(r.end({success:!0,isNativeBroker:!0,requestId:e.requestId}),o.clearNativeBrokerErrorCode(),e))).catch((e=>{throw r.end({success:!1,errorCode:e.errorCode,subErrorCode:e.subError,isNativeBroker:!0}),e}))}catch(e){throw e instanceof Fc&&o.setNativeBrokerErrorCode(e.errorCode),e}}createSilentCacheRequest(e,t){return{authority:e.authority,correlationId:this.correlationId,scopes:yr.fromString(e.scope).asArray(),account:t,forceRefresh:!1}}async acquireTokensFromCache(e,t){if(!e)throw this.logger.warning("NativeInteractionClient:acquireTokensFromCache - No nativeAccountId provided"),pt(je);const r=this.browserStorage.getBaseAccountInfo({nativeAccountId:e},this.correlationId);if(!r)throw pt(je);try{const e=this.createSilentCacheRequest(t,r),n=await this.silentCacheClient.acquireToken(e),o={...r,idTokenClaims:n?.idTokenClaims,idToken:n?.idToken};return{...n,account:o}}catch(e){throw e}}async acquireTokenRedirect(e,t){this.logger.trace("NativeInteractionClient - acquireTokenRedirect called.");const{...r}=e;delete r.onRedirectNavigate;const n=await this.initializeNativeRequest(r);try{await this.platformAuthProvider.sendMessage(n)}catch(e){if(e instanceof Fc){if(this.initializeServerTelemetryManager(this.apiId).setNativeBrokerErrorCode(e.errorCode),zc(e))throw e}}this.browserStorage.setTemporaryCache(bs,JSON.stringify(n),!0);const o={apiId:Os.acquireTokenRedirect,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},i=this.config.auth.navigateToLoginRequestUrl?window.location.href:this.getRedirectUri(e.redirectUri);t.end({success:!0}),await this.navigationClient.navigateExternal(i,o)}async handleRedirectPromise(e,t){if(this.logger.trace("NativeInteractionClient - handleRedirectPromise called."),!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const r=this.browserStorage.getCachedNativeRequest();if(!r)return this.logger.verbose("NativeInteractionClient - handleRedirectPromise called but there is no cached request, returning null."),e&&t&&e?.addFields({errorCode:"no_cached_request"},t),null;const{prompt:n,...o}=r;n&&this.logger.verbose("NativeInteractionClient - handleRedirectPromise called and prompt was included in the original request, removing prompt from cached request to prevent second interaction with native broker window."),this.browserStorage.removeItem(this.browserStorage.generateCacheKey(bs));const i=At();try{this.logger.verbose("NativeInteractionClient - handleRedirectPromise sending message to native broker.");const e=await this.platformAuthProvider.sendMessage(o),t=await this.handleNativeResponse(e,o,i);return this.initializeServerTelemetryManager(this.apiId).clearNativeBrokerErrorCode(),t}catch(e){throw e}}logout(){return this.logger.trace("NativeInteractionClient - logout called."),Promise.reject("Logout not implemented yet")}async handleNativeResponse(e,t,r){this.logger.trace("NativeInteractionClient - handleNativeResponse called.");const n=It(e.id_token,$s),o=this.createHomeAccountIdentifier(e,n),i=this.browserStorage.getAccountInfoFilteredBy({nativeAccountId:t.accountId},this.correlationId)?.homeAccountId;if(t.extraParameters?.child_client_id&&e.account.id!==t.accountId)this.logger.info("handleNativeServerResponse: Double broker flow detected, ignoring accountId mismatch");else if(o!==i&&e.account.id!==t.accountId)throw Kc(Dc);const s=await this.getDiscoveredAuthority({requestAuthority:t.authority}),a=_o(this.browserStorage,s,o,$s,this.correlationId,n,e.client_info,void 0,n.tid,void 0,e.account.id,this.logger);e.expires_in=Number(e.expires_in);const c=await this.generateAuthenticationResult(e,t,n,a,s.canonicalAuthority,r);return await this.cacheAccount(a,this.correlationId),await this.cacheNativeTokens(e,t,o,n,e.access_token,c.tenantId,r),c}createHomeAccountIdentifier(e,r){return _r.generateHomeAccountId(e.client_info||t.EMPTY_STRING,Ar,this.logger,this.browserCrypto,r)}generateScopes(e,t){return t?yr.fromString(t):yr.fromString(e)}async generatePopAccessToken(e,t){if(t.tokenType===W.POP&&t.signPopToken){if(e.shr)return this.logger.trace("handleNativeServerResponse: SHR is enabled in native layer"),e.shr;const r=new bo(this.browserCrypto),n={resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,shrNonce:t.shrNonce};if(!t.keyId)throw pt(ot);return r.signPopToken(e.access_token,t.keyId,n)}return e.access_token}async generateAuthenticationResult(e,r,n,o,i,s){const a=this.addTelemetryFromNativeResponse(e.properties.MATS),c=this.generateScopes(r.scope,e.scope),l=e.account.properties||{},h=l.UID||n.oid||n.sub||t.EMPTY_STRING,d=l.TenantId||n.tid||t.EMPTY_STRING,u=Tr(o.getAccountInfo(),void 0,n,e.id_token);u.nativeAccountId!==e.account.id&&(u.nativeAccountId=e.account.id);const g=await this.generatePopAccessToken(e,r),p=r.tokenType===W.POP?W.POP:W.BEARER;return{authority:i,uniqueId:h,tenantId:d,scopes:c.asArray(),account:u,idToken:e.id_token,idTokenClaims:n,accessToken:g,fromCache:!!a&&this.isResponseFromCache(a),expiresOn:St(s+e.expires_in),tokenType:p,correlationId:this.correlationId,state:e.state,fromNativeBroker:!0}}async cacheAccount(e,t){await this.browserStorage.setAccount(e,this.correlationId),this.browserStorage.removeAccountContext(e,t)}cacheNativeTokens(e,r,n,o,i,s,a){const c=_t(n,r.authority,e.id_token||"",r.clientId,o.tid||""),l=a+(r.tokenType===W.POP?t.SHR_NONCE_VALIDITY:("string"==typeof e.expires_in?parseInt(e.expires_in,10):e.expires_in)||0),h=this.generateScopes(e.scope,r.scope),d={idToken:c,accessToken:Pt(n,r.authority,i,r.clientId,o.tid||s,h.printScopes(),l,0,$s,void 0,r.tokenType,void 0,r.keyId)};return this.nativeStorageManager.saveCacheRecord(d,this.correlationId,r.storeInCache)}getExpiresInValue(e,r){return e===W.POP?t.SHR_NONCE_VALIDITY:("string"==typeof r?parseInt(r,10):r)||0}addTelemetryFromNativeResponse(e){const t=this.getMATSFromResponse(e);return t?(this.performanceClient.addFields({extensionId:this.platformAuthProvider.getExtensionId(),extensionVersion:this.platformAuthProvider.getExtensionVersion(),matsBrokerVersion:t.broker_version,matsAccountJoinOnStart:t.account_join_on_start,matsAccountJoinOnEnd:t.account_join_on_end,matsDeviceJoin:t.device_join,matsPromptBehavior:t.prompt_behavior,matsApiErrorCode:t.api_error_code,matsUiVisible:t.ui_visible,matsSilentCode:t.silent_code,matsSilentBiSubCode:t.silent_bi_sub_code,matsSilentMessage:t.silent_message,matsSilentStatus:t.silent_status,matsHttpStatus:t.http_status,matsHttpEventCount:t.http_event_count},this.correlationId),t):null}getMATSFromResponse(e){if(e)try{return JSON.parse(e)}catch(e){this.logger.error("NativeInteractionClient - Error parsing MATS telemetry, returning null instead")}return null}isResponseFromCache(e){return void 0===e.is_cached?(this.logger.verbose("NativeInteractionClient - MATS telemetry does not contain field indicating if response was served from cache. Returning false."),!1):!!e.is_cached}async initializeNativeRequest(e){this.logger.trace("NativeInteractionClient - initializeNativeRequest called");const t=await this.getCanonicalAuthority(e),{scopes:r,...n}=e,o=new yr(r||[]);o.appendScopes(h);const i={...n,accountId:this.accountId,clientId:this.config.auth.clientId,authority:t.urlString,scope:o.printScopes(),redirectUri:this.getRedirectUri(e.redirectUri),prompt:this.getPrompt(e.prompt),correlationId:this.correlationId,tokenType:e.authenticationScheme,windowTitleSubstring:document.title,extraParameters:{...e.extraQueryParameters,...e.tokenQueryParameters},extendedExpiryToken:!1,keyId:e.popKid};if(i.signPopToken&&e.popKid)throw Yi(Fi);if(this.handleExtraBrokerParams(i),i.extraParameters=i.extraParameters||{},i.extraParameters.telemetry=ss,e.authenticationScheme===W.POP){const t={resourceRequestUri:e.resourceRequestUri,resourceRequestMethod:e.resourceRequestMethod,shrClaims:e.shrClaims,shrNonce:e.shrNonce},r=new bo(this.browserCrypto);let n;if(i.keyId)n=this.browserCrypto.base64UrlEncode(JSON.stringify({kid:i.keyId})),i.signPopToken=!1;else{const o=await Vn(r.generateCnf.bind(r),Qr.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(t,this.logger);n=o.reqCnfString,i.keyId=o.kid,i.signPopToken=!0}i.reqCnf=n}return this.addRequestSKUs(i),i}async getCanonicalAuthority(e){const t=e.authority||this.config.auth.authority;e.account&&await this.getDiscoveredAuthority({requestAuthority:t,requestAzureCloudOptions:e.azureCloudOptions,account:e.account});const r=new qr(t);return r.validateAsUri(),r}getPrompt(e){switch(this.apiId){case Os.ssoSilent:case Os.acquireTokenSilent_silentFlow:return this.logger.trace("initializeNativeRequest: silent request sets prompt to none"),b.NONE}if(e)switch(e){case b.NONE:case b.CONSENT:case b.LOGIN:return this.logger.trace("initializeNativeRequest: prompt is compatible with native flow"),e;default:throw this.logger.trace(`initializeNativeRequest: prompt = ${e} is not compatible with native flow`),Yi(Di)}else this.logger.trace("initializeNativeRequest: prompt was not provided")}handleExtraBrokerParams(e){const t=e.extraParameters&&e.extraParameters.hasOwnProperty(yn)&&e.extraParameters.hasOwnProperty(Cn)&&e.extraParameters.hasOwnProperty(dn);if(!e.embeddedClientId&&!t)return;let r="";const n=e.redirectUri;e.embeddedClientId?(e.redirectUri=this.config.auth.redirectUri,r=e.embeddedClientId):e.extraParameters&&(e.redirectUri=e.extraParameters[Cn],r=e.extraParameters[dn]),e.extraParameters={child_client_id:r,child_redirect_uri:n},this.performanceClient?.addFields({embeddedClientId:r,embeddedRedirectUri:n},e.correlationId)}}async function Qc(e,t,r,n,o){const i=Lo({...e.auth,authority:t},r,n,o);if(Mn(i,{sku:ns,version:Qa,os:"",cpu:""}),e.auth.protocolMode!==Rr.OIDC&&On(i,e.telemetry.application),r.platformBroker&&(function(e){e.set("nativebroker","1")}(i),r.authenticationScheme===W.POP)){const e=new cc(n,o),t=new bo(e);let s;if(r.popKid)s=e.encodeKid(r.popKid);else{s=(await Vn(t.generateCnf.bind(t),Qr.PopTokenGenerateCnf,n,o,r.correlationId)(r,n)).reqCnfString}Kn(i,s)}return wn(i,r.correlationId,o),i}async function jc(e,r,n,o,i){if(!n.codeChallenge)throw mr(Xt);const s=await Vn(Qc,Qr.GetStandardParams,o,i,n.correlationId)(e,r,n,o,i);return In(s,E),Nn(s,n.codeChallenge,t.S256_CODE_CHALLENGE_METHOD),Fn(s,n.extraQueryParameters||{}),Uo(r,s,e.auth.encodeExtraQueryParams,n.extraQueryParameters)}async function Wc(e,t,r,n,o,i){if(!n.earJwk)throw Yi(Jo);const s=await Qc(t,r,n,o,i);In(s,R),function(e,t){e.set("ear_jwk",encodeURIComponent(t)),e.set("ear_jwe_crypto","eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0")}(s,n.earJwk);const a=new Map;Fn(a,n.extraQueryParameters||{});return Jc(e,Uo(r,a,t.auth.encodeExtraQueryParams,n.extraQueryParameters),s)}async function Vc(e,r,n,o,i,s){const a=await Qc(r,n,o,i,s);In(a,E),Nn(a,o.codeChallenge,o.codeChallengeMethod||t.S256_CODE_CHALLENGE_METHOD),function(e,t){Object.entries(t).forEach((([t,r])=>{r&&e.set(t,r)}))}(a,o.authorizePostBodyParameters||{});const c=new Map;Fn(c,o.extraQueryParameters||{});return Jc(e,Uo(n,c,r.auth.encodeExtraQueryParams,o.extraQueryParameters),a)}function Jc(e,t,r){const n=e.createElement("form");return n.method="post",n.action=t,r.forEach(((t,r)=>{const o=e.createElement("input");o.hidden=!0,o.name=r,o.value=t,n.appendChild(o)})),e.body.appendChild(n),n}async function Yc(e,t,r,n,o,i,s,a,c,l){if(a.verbose("Account id found, calling WAM for token"),!l)throw Yi(Hi);const h=new cc(a,c),d=new $c(n,o,h,a,s,n.system.navigationClient,r,c,l,t,i,e.correlationId),{userRequestState:u}=ko.parseRequestState(h,e.state);return Vn(d.acquireToken.bind(d),Qr.NativeInteractionClientAcquireToken,a,c,e.correlationId)({...e,state:u,prompt:void 0})}async function Xc(e,t,r,n,o,i,s,a,c,l,h,d){if(no.removeThrottle(s,o.auth.clientId,e),t.accountId)return Vn(Yc,Qr.HandleResponsePlatformBroker,l,h,e.correlationId)(e,t.accountId,n,o,s,a,c,l,h,d);const u={...e,code:t.code||"",codeVerifier:r},g=new xc(i,s,u,l,h);return await Vn(g.handleCodeResponse.bind(g),Qr.HandleCodeResponse,l,h,e.correlationId)(t,e)}async function Zc(e,t,r,n,o,i,s,a,c,l,h){if(no.removeThrottle(i,n.auth.clientId,e),Ho(t,e.state),!t.ear_jwe)throw Yi(Yo);if(!e.earJwk)throw Yi(Jo);const d=JSON.parse(await Vn(la,Qr.DecryptEarResponse,c,l,e.correlationId)(e.earJwk,t.ear_jwe));if(d.accountId)return Vn(Yc,Qr.HandleResponsePlatformBroker,c,l,e.correlationId)(e,d.accountId,r,n,i,s,a,c,l,h);const u=new Ro(n.auth.clientId,i,new cc(c,l),c,null,null,l);u.validateTokenResponse(d);const g={code:"",state:e.state,nonce:e.nonce,client_info:d.client_info,cloud_graph_host_name:d.cloud_graph_host_name,cloud_instance_host_name:d.cloud_instance_host_name,cloud_instance_name:d.cloud_instance_name,msgraph_host:d.msgraph_host};return await Vn(u.handleServerTokenResponse.bind(u),Qr.HandleServerTokenResponse,c,l,e.correlationId)(d,o,At(),e,g,void 0,void 0,void 0,void 0)}async function el(e,t,r){e.addQueueMeasurement(Qr.GeneratePkceCodes,r);const n=Wn(tl,Qr.GenerateCodeVerifier,t,e,r)(e,t,r);return{verifier:n,challenge:await Vn(rl,Qr.GenerateCodeChallengeFromVerifier,t,e,r)(n,e,t,r)}}function tl(e,t,r){try{const n=new Uint8Array(32);Wn(oa,Qr.GetRandomValues,t,e,r)(n);return zs(n)}catch(e){throw Yi(Vo)}}async function rl(e,t,r,n){t.addQueueMeasurement(Qr.GenerateCodeChallengeFromVerifier,n);try{const o=await Vn(na,Qr.Sha256Digest,r,t,n)(e,t,n);return zs(new Uint8Array(o))}catch(e){throw Yi(Vo)}}class nl{constructor(e,t,r,n){this.logger=e,this.handshakeTimeoutMs=t,this.extensionId=n,this.resolvers=new Map,this.handshakeResolvers=new Map,this.messageChannel=new MessageChannel,this.windowListener=this.onWindowMessage.bind(this),this.performanceClient=r,this.handshakeEvent=r.startMeasurement(Qr.NativeMessageHandlerHandshake),this.platformAuthType=ds}async sendMessage(e){this.logger.trace(this.platformAuthType+" - sendMessage called.");const t={method:ps,request:e},r={channel:os,extensionId:this.extensionId,responseId:sa(),body:t};this.logger.trace(this.platformAuthType+" - Sending request to browser extension"),this.logger.tracePii(this.platformAuthType+` - Sending request to browser extension: ${JSON.stringify(r)}`),this.messageChannel.port1.postMessage(r);const n=await new Promise(((e,t)=>{this.resolvers.set(r.responseId,{resolve:e,reject:t})}));return this.validatePlatformBrokerResponse(n)}static async createProvider(e,t,r){e.trace("PlatformAuthExtensionHandler - createProvider called.");try{const n=new nl(e,t,r,is);return await n.sendHandshakeRequest(),n}catch(n){const o=new nl(e,t,r);return await o.sendHandshakeRequest(),o}}async sendHandshakeRequest(){this.logger.trace(this.platformAuthType+" - sendHandshakeRequest called."),window.addEventListener("message",this.windowListener,!1);const e={channel:os,extensionId:this.extensionId,responseId:sa(),body:{method:us}};return this.handshakeEvent.add({extensionId:this.extensionId,extensionHandshakeTimeoutMs:this.handshakeTimeoutMs}),this.messageChannel.port1.onmessage=e=>{this.onChannelMessage(e)},window.postMessage(e,window.origin,[this.messageChannel.port2]),new Promise(((t,r)=>{this.handshakeResolvers.set(e.responseId,{resolve:t,reject:r}),this.timeoutId=window.setTimeout((()=>{window.removeEventListener("message",this.windowListener,!1),this.messageChannel.port1.close(),this.messageChannel.port2.close(),this.handshakeEvent.end({extensionHandshakeTimedOut:!0,success:!1}),r(Yi(Li)),this.handshakeResolvers.delete(e.responseId)}),this.handshakeTimeoutMs)}))}onWindowMessage(e){if(this.logger.trace(this.platformAuthType+" - onWindowMessage called"),e.source!==window)return;const t=e.data;if(t.channel&&t.channel===os&&(!t.extensionId||t.extensionId===this.extensionId)&&t.body.method===us){const e=this.handshakeResolvers.get(t.responseId);if(!e)return void this.logger.trace(this.platformAuthType+`.onWindowMessage - resolver can't be found for request ${t.responseId}`);this.logger.verbose(t.extensionId?`Extension with id: ${t.extensionId} not installed`:"No extension installed"),clearTimeout(this.timeoutId),this.messageChannel.port1.close(),this.messageChannel.port2.close(),window.removeEventListener("message",this.windowListener,!1),this.handshakeEvent.end({success:!1,extensionInstalled:!1}),e.reject(Yi(Ui))}}onChannelMessage(e){this.logger.trace(this.platformAuthType+" - onChannelMessage called.");const t=e.data,r=this.resolvers.get(t.responseId),n=this.handshakeResolvers.get(t.responseId);try{const e=t.body.method;if(e===ms){if(!r)return;const e=t.body.response;if(this.logger.trace(this.platformAuthType+" - Received response from browser extension"),this.logger.tracePii(this.platformAuthType+` - Received response from browser extension: ${JSON.stringify(e)}`),"Success"!==e.status)r.reject(Kc(e.code,e.description,e.ext));else{if(!e.result)throw ve(ge,"Event does not contain result.");e.result.code&&e.result.description?r.reject(Kc(e.result.code,e.result.description,e.result.ext)):r.resolve(e.result)}this.resolvers.delete(t.responseId)}else if(e===gs){if(!n)return void this.logger.trace(this.platformAuthType+`.onChannelMessage - resolver can't be found for request ${t.responseId}`);clearTimeout(this.timeoutId),window.removeEventListener("message",this.windowListener,!1),this.extensionId=t.extensionId,this.extensionVersion=t.body.version,this.logger.verbose(this.platformAuthType+` - Received HandshakeResponse from extension: ${this.extensionId}`),this.handshakeEvent.end({extensionInstalled:!0,success:!0}),n.resolve(),this.handshakeResolvers.delete(t.responseId)}}catch(t){this.logger.error("Error parsing response from WAM Extension"),this.logger.errorPii(`Error parsing response from WAM Extension: ${t}`),this.logger.errorPii(`Unable to parse ${e}`),r?r.reject(t):n&&n.reject(t)}}validatePlatformBrokerResponse(e){if(e.hasOwnProperty("access_token")&&e.hasOwnProperty("id_token")&&e.hasOwnProperty("client_info")&&e.hasOwnProperty("account")&&e.hasOwnProperty("scope")&&e.hasOwnProperty("expires_in"))return e;throw ve(ge,"Response missing expected properties.")}getExtensionId(){return this.extensionId}getExtensionVersion(){return this.extensionVersion}getExtensionName(){return this.getExtensionId()===is?"chrome":this.getExtensionId()?.length?"unknown":void 0}}class ol{constructor(e,t,r){this.logger=e,this.performanceClient=t,this.correlationId=r,this.platformAuthType=hs}static async createProvider(e,t,r){if(e.trace("PlatformAuthDOMHandler: createProvider called"),window.navigator?.platformAuthentication){const n=await window.navigator.platformAuthentication.getSupportedContracts(as);if(n?.includes(ls))return e.trace("Platform auth api available in DOM"),new ol(e,t,r)}}getExtensionId(){return as}getExtensionVersion(){return""}getExtensionName(){return cs}async sendMessage(e){this.logger.trace(this.platformAuthType+" - Sending request to browser DOM API");try{const t=this.initializePlatformDOMRequest(e),r=await window.navigator.platformAuthentication.executeGetToken(t);return this.validatePlatformBrokerResponse(r)}catch(e){throw this.logger.error(this.platformAuthType+" - executeGetToken DOM API error"),e}}initializePlatformDOMRequest(e){this.logger.trace(this.platformAuthType+" - initializeNativeDOMRequest called");const{accountId:t,clientId:r,authority:n,scope:o,redirectUri:i,correlationId:s,state:a,storeInCache:c,embeddedClientId:l,extraParameters:h,...d}=e,u=this.getDOMExtraParams(d);return{accountId:t,brokerId:this.getExtensionId(),authority:n,clientId:r,correlationId:s||this.correlationId,extraParameters:{...h,...u},isSecurityTokenService:!1,redirectUri:i,scope:o,state:a,storeInCache:c,embeddedClientId:l}}validatePlatformBrokerResponse(e){if(e.hasOwnProperty("isSuccess")){if(e.hasOwnProperty("accessToken")&&e.hasOwnProperty("idToken")&&e.hasOwnProperty("clientInfo")&&e.hasOwnProperty("account")&&e.hasOwnProperty("scopes")&&e.hasOwnProperty("expiresIn"))return this.logger.trace(this.platformAuthType+" - platform broker returned successful and valid response"),this.convertToPlatformBrokerResponse(e);if(e.hasOwnProperty("error")){const t=e;if(!1===t.isSuccess&&t.error&&t.error.code)throw this.logger.trace(this.platformAuthType+" - platform broker returned error response"),Kc(t.error.code,t.error.description,{error:parseInt(t.error.errorCode),protocol_error:t.error.protocolError,status:t.error.status,properties:t.error.properties})}}throw ve(ge,"Response missing expected properties.")}convertToPlatformBrokerResponse(e){this.logger.trace(this.platformAuthType+" - convertToNativeResponse called");return{access_token:e.accessToken,id_token:e.idToken,client_info:e.clientInfo,account:e.account,expires_in:e.expiresIn,scope:e.scopes,state:e.state||"",properties:e.properties||{},extendedLifetimeToken:e.extendedLifetimeToken??!1,shr:e.proofOfPossessionPayload}}getDOMExtraParams(e){return{...Object.entries(e).reduce(((e,[t,r])=>(e[t]=String(r),e)),{})}}}async function il(e,t,r,n){e.trace("getPlatformAuthProvider called",r);const o=function(){let e;try{return e=window[fs.SessionStorage],"true"===e?.getItem(Bs)}catch(e){return!1}}();let i;e.trace("Has client allowed platform auth via DOM API: "+o);try{o&&(i=await ol.createProvider(e,t,r)),i||(e.trace("Platform auth via DOM API not available, checking for extension"),i=await nl.createProvider(e,n||2e3,t))}catch(t){e.trace("Platform auth not available",t)}return i}function sl(e,t,r,n){if(t.trace("isPlatformAuthAllowed called"),!e.system.allowPlatformBroker)return t.trace("isPlatformAuthAllowed: allowPlatformBroker is not enabled, returning false"),!1;if(!r)return t.trace("isPlatformAuthAllowed: Platform auth provider is not initialized, returning false"),!1;if(n)switch(n){case W.BEARER:case W.POP:return t.trace("isPlatformAuthAllowed: authenticationScheme is supported, returning true"),!0;default:return t.trace("isPlatformAuthAllowed: authenticationScheme is not supported, returning false"),!1}return!0}class al extends Lc{constructor(e,t,r,n,o,i,s,a,c,l){super(e,t,r,n,o,i,s,c,l),this.unloadWindow=this.unloadWindow.bind(this),this.nativeStorage=a,this.eventHandler=o}acquireToken(e,t){let r;try{if(r={popupName:this.generatePopupName(e.scopes||h,e.authority||this.config.auth.authority),popupWindowAttributes:e.popupWindowAttributes||{},popupWindowParent:e.popupWindowParent??window},this.performanceClient.addFields({isAsyncPopup:this.config.system.asyncPopups},this.correlationId),this.config.system.asyncPopups)return this.logger.verbose("asyncPopups set to true, acquiring token"),this.acquireTokenPopupAsync(e,r,t);{const n={...e,httpMethod:Nc(e,this.config.auth.protocolMode)};return this.logger.verbose("asyncPopup set to false, opening popup before acquiring token"),r.popup=this.openSizedPopup("about:blank",r),this.acquireTokenPopupAsync(n,r,t)}}catch(e){return Promise.reject(e)}}logout(e){try{this.logger.verbose("logoutPopup called");const t=this.initializeLogoutRequest(e),r={popupName:this.generateLogoutPopupName(t),popupWindowAttributes:e?.popupWindowAttributes||{},popupWindowParent:e?.popupWindowParent??window},n=e&&e.authority,o=e&&e.mainWindowRedirectUri;return this.config.system.asyncPopups?(this.logger.verbose("asyncPopups set to true"),this.logoutPopupAsync(t,r,n,o)):(this.logger.verbose("asyncPopup set to false, opening popup"),r.popup=this.openSizedPopup("about:blank",r),this.logoutPopupAsync(t,r,n,o))}catch(e){return Promise.reject(e)}}async acquireTokenPopupAsync(t,r,n){this.logger.verbose("acquireTokenPopupAsync called");const o=await Vn(this.initializeAuthorizationRequest.bind(this),Qr.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(t,e.InteractionType.Popup);r.popup&&Ha(o.authority);const i=sl(this.config,this.logger,this.platformAuthProvider,t.authenticationScheme);return o.platformBroker=i,this.config.auth.protocolMode===Rr.EAR?this.executeEarFlow(o,r):this.executeCodeFlow(o,r,n)}async executeCodeFlow(t,r,n){const o=t.correlationId,i=this.initializeServerTelemetryManager(Os.acquireTokenPopup),s=n||await Vn(el,Qr.GeneratePkceCodes,this.logger,this.performanceClient,o)(this.performanceClient,this.logger,o),a={...t,codeChallenge:s.challenge};try{const n=await Vn(this.createAuthCodeClient.bind(this),Qr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,o)({serverTelemetryManager:i,requestAuthority:a.authority,requestAzureCloudOptions:a.azureCloudOptions,requestExtraQueryParameters:a.extraQueryParameters,account:a.account});if(a.httpMethod===l)return await this.executeCodeFlowWithPost(a,r,n,s.verifier);{const i=await Vn(jc,Qr.GetAuthCodeUrl,this.logger,this.performanceClient,o)(this.config,n.authority,a,this.logger,this.performanceClient),c=this.initiateAuthRequest(i,r);this.eventHandler.emitEvent(vc.POPUP_OPENED,e.InteractionType.Popup,{popupWindow:c},null);const l=await this.monitorPopupForHash(c,r.popupWindowParent),h=Wn(Uc,Qr.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(l,this.config.auth.OIDCOptions.serverResponseType,this.logger);return await Vn(Xc,Qr.HandleResponseCode,this.logger,this.performanceClient,o)(t,h,s.verifier,Os.acquireTokenPopup,this.config,n,this.browserStorage,this.nativeStorage,this.eventHandler,this.logger,this.performanceClient,this.platformAuthProvider)}}catch(e){throw r.popup?.close(),e instanceof Ce&&(e.setCorrelationId(this.correlationId),i.cacheFailedRequest(e)),e}}async executeEarFlow(e,t){const r=e.correlationId,n=await Vn(this.getDiscoveredAuthority.bind(this),Qr.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,r)({requestAuthority:e.authority,requestAzureCloudOptions:e.azureCloudOptions,requestExtraQueryParameters:e.extraQueryParameters,account:e.account}),o=await Vn(ca,Qr.GenerateEarKey,this.logger,this.performanceClient,r)(),i={...e,earJwk:o},s=t.popup||this.openPopup("about:blank",t);(await Wc(s.document,this.config,n,i,this.logger,this.performanceClient)).submit();const a=await Vn(this.monitorPopupForHash.bind(this),Qr.SilentHandlerMonitorIframeForHash,this.logger,this.performanceClient,r)(s,t.popupWindowParent),c=Wn(Uc,Qr.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(a,this.config.auth.OIDCOptions.serverResponseType,this.logger);return Vn(Zc,Qr.HandleResponseEar,this.logger,this.performanceClient,r)(i,c,Os.acquireTokenPopup,this.config,n,this.browserStorage,this.nativeStorage,this.eventHandler,this.logger,this.performanceClient,this.platformAuthProvider)}async executeCodeFlowWithPost(e,t,r,n){const o=e.correlationId,i=await Vn(this.getDiscoveredAuthority.bind(this),Qr.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,o)({requestAuthority:e.authority,requestAzureCloudOptions:e.azureCloudOptions,requestExtraQueryParameters:e.extraQueryParameters,account:e.account}),s=t.popup||this.openPopup("about:blank",t);(await Vc(s.document,this.config,i,e,this.logger,this.performanceClient)).submit();const a=await Vn(this.monitorPopupForHash.bind(this),Qr.SilentHandlerMonitorIframeForHash,this.logger,this.performanceClient,o)(s,t.popupWindowParent),c=Wn(Uc,Qr.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(a,this.config.auth.OIDCOptions.serverResponseType,this.logger);return Vn(Xc,Qr.HandleResponseCode,this.logger,this.performanceClient,o)(e,c,n,Os.acquireTokenPopup,this.config,r,this.browserStorage,this.nativeStorage,this.eventHandler,this.logger,this.performanceClient,this.platformAuthProvider)}async logoutPopupAsync(t,r,n,o){this.logger.verbose("logoutPopupAsync called"),this.eventHandler.emitEvent(vc.LOGOUT_START,e.InteractionType.Popup,t);const i=this.initializeServerTelemetryManager(Os.logoutPopup);try{await this.clearCacheOnLogout(this.correlationId,t.account);const s=await Vn(this.createAuthCodeClient.bind(this),Qr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:i,requestAuthority:n,account:t.account||void 0});try{s.authority.endSessionEndpoint}catch{if(t.account?.homeAccountId&&t.postLogoutRedirectUri&&s.authority.protocolMode===Rr.OIDC){if(this.browserStorage.removeAccount(t.account?.homeAccountId,this.correlationId),this.eventHandler.emitEvent(vc.LOGOUT_SUCCESS,e.InteractionType.Popup,t),o){const e={apiId:Os.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},t=qr.getAbsoluteUrl(o,Ra());await this.navigationClient.navigateInternal(t,e)}return void r.popup?.close()}}const a=s.getLogoutUri(t);this.eventHandler.emitEvent(vc.LOGOUT_SUCCESS,e.InteractionType.Popup,t);const c=this.openPopup(a,r);if(this.eventHandler.emitEvent(vc.POPUP_OPENED,e.InteractionType.Popup,{popupWindow:c},null),await this.monitorPopupForHash(c,r.popupWindowParent).catch((()=>{})),o){const e={apiId:Os.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},t=qr.getAbsoluteUrl(o,Ra());this.logger.verbose("Redirecting main window to url specified in the request"),this.logger.verbosePii(`Redirecting main window to: ${t}`),await this.navigationClient.navigateInternal(t,e)}else this.logger.verbose("No main window navigation requested")}catch(t){throw r.popup?.close(),t instanceof Ce&&(t.setCorrelationId(this.correlationId),i.cacheFailedRequest(t)),this.eventHandler.emitEvent(vc.LOGOUT_FAILURE,e.InteractionType.Popup,null,t),this.eventHandler.emitEvent(vc.LOGOUT_END,e.InteractionType.Popup),t}this.eventHandler.emitEvent(vc.LOGOUT_END,e.InteractionType.Popup)}initiateAuthRequest(e,t){if(e)return this.logger.infoPii(`Navigate to: ${e}`),this.openPopup(e,t);throw this.logger.error("Navigate url is empty"),Yi(Zo)}monitorPopupForHash(e,t){return new Promise(((t,r)=>{this.logger.verbose("PopupHandler.monitorPopupForHash - polling started");const n=setInterval((()=>{if(e.closed)return this.logger.error("PopupHandler.monitorPopupForHash - window closed"),clearInterval(n),void r(Yi(ci));let o="";try{o=e.location.href}catch(e){}if(!o||"about:blank"===o)return;clearInterval(n);let i="";const s=this.config.auth.OIDCOptions.serverResponseType;e&&(i=s===_.QUERY?e.location.search:e.location.hash),this.logger.verbose("PopupHandler.monitorPopupForHash - popup window is on same origin as caller"),t(i)}),this.config.system.pollIntervalMilliseconds)})).finally((()=>{this.cleanPopup(e,t)}))}openPopup(e,t){try{let r;if(t.popup?(r=t.popup,this.logger.verbosePii(`Navigating popup window to: ${e}`),r.location.assign(e)):void 0===t.popup&&(this.logger.verbosePii(`Opening popup window to: ${e}`),r=this.openSizedPopup(e,t)),!r)throw Yi(ai);return r.focus&&r.focus(),this.currentWindow=r,t.popupWindowParent.addEventListener("beforeunload",this.unloadWindow),r}catch(e){throw this.logger.error("error opening popup "+e.message),Yi(si)}}openSizedPopup(e,{popupName:t,popupWindowAttributes:r,popupWindowParent:n}){const o=n.screenLeft?n.screenLeft:n.screenX,i=n.screenTop?n.screenTop:n.screenY,s=n.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,a=n.innerHeight||document.documentElement.clientHeight||document.body.clientHeight;let c=r.popupSize?.width,l=r.popupSize?.height,h=r.popupPosition?.top,d=r.popupPosition?.left;return(!c||c<0||c>s)&&(this.logger.verbose("Default popup window width used. Window width not configured or invalid."),c=Zi),(!l||l<0||l>a)&&(this.logger.verbose("Default popup window height used. Window height not configured or invalid."),l=es),(!h||h<0||h>a)&&(this.logger.verbose("Default popup window top position used. Window top not configured or invalid."),h=Math.max(0,a/2-es/2+i)),(!d||d<0||d>s)&&(this.logger.verbose("Default popup window left position used. Window left not configured or invalid."),d=Math.max(0,s/2-Zi/2+o)),n.open(e,t,`width=${c}, height=${l}, top=${h}, left=${d}, scrollbars=yes`)}unloadWindow(e){this.currentWindow&&this.currentWindow.close(),e.preventDefault()}cleanPopup(e,t){e.close(),t.removeEventListener("beforeunload",this.unloadWindow)}generatePopupName(e,t){return`${ts}.${this.config.auth.clientId}.${e.join("-")}.${t}.${this.correlationId}`}generateLogoutPopupName(e){const t=e.account&&e.account.homeAccountId;return`${ts}.${this.config.auth.clientId}.${t}.${this.correlationId}`}}class cl extends Lc{constructor(e,t,r,n,o,i,s,a,c,l){super(e,t,r,n,o,i,s,c,l),this.nativeStorage=a}async acquireToken(t){const r=await Vn(this.initializeAuthorizationRequest.bind(this),Qr.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(t,e.InteractionType.Redirect);r.platformBroker=sl(this.config,this.logger,this.platformAuthProvider,t.authenticationScheme);const n=t=>{t.persisted&&(this.logger.verbose("Page was restored from back/forward cache. Clearing temporary cache."),this.browserStorage.resetRequestCache(),this.eventHandler.emitEvent(vc.RESTORE_FROM_BFCACHE,e.InteractionType.Redirect))},o=this.getRedirectStartPage(t.redirectStartPage);this.logger.verbosePii(`Redirect start page: ${o}`),this.browserStorage.setTemporaryCache(Is,o,!0),window.addEventListener("pageshow",n);try{this.config.auth.protocolMode===Rr.EAR?await this.executeEarFlow(r):await this.executeCodeFlow(r,t.onRedirectNavigate)}catch(e){throw e instanceof Ce&&e.setCorrelationId(this.correlationId),window.removeEventListener("pageshow",n),e}}async executeCodeFlow(e,t){const r=e.correlationId,n=this.initializeServerTelemetryManager(Os.acquireTokenRedirect),o=await Vn(el,Qr.GeneratePkceCodes,this.logger,this.performanceClient,r)(this.performanceClient,this.logger,r),i={...e,codeChallenge:o.challenge};this.browserStorage.cacheAuthorizeRequest(i,o.verifier);try{if(i.httpMethod===l)return await this.executeCodeFlowWithPost(i);{const r=await Vn(this.createAuthCodeClient.bind(this),Qr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:i.authority,requestAzureCloudOptions:i.azureCloudOptions,requestExtraQueryParameters:i.extraQueryParameters,account:i.account}),o=await Vn(jc,Qr.GetAuthCodeUrl,this.logger,this.performanceClient,e.correlationId)(this.config,r.authority,i,this.logger,this.performanceClient);return await this.initiateAuthRequest(o,t)}}catch(e){throw e instanceof Ce&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),e}}async executeEarFlow(e){const t=e.correlationId,r=await Vn(this.getDiscoveredAuthority.bind(this),Qr.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,t)({requestAuthority:e.authority,requestAzureCloudOptions:e.azureCloudOptions,requestExtraQueryParameters:e.extraQueryParameters,account:e.account}),n=await Vn(ca,Qr.GenerateEarKey,this.logger,this.performanceClient,t)(),o={...e,earJwk:n};this.browserStorage.cacheAuthorizeRequest(o);return(await Wc(document,this.config,r,o,this.logger,this.performanceClient)).submit(),new Promise(((e,t)=>{setTimeout((()=>{t(Yi($i,"failed_to_redirect"))}),this.config.system.redirectNavigationTimeout)}))}async executeCodeFlowWithPost(e){const t=e.correlationId,r=await Vn(this.getDiscoveredAuthority.bind(this),Qr.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,t)({requestAuthority:e.authority,requestAzureCloudOptions:e.azureCloudOptions,requestExtraQueryParameters:e.extraQueryParameters,account:e.account});this.browserStorage.cacheAuthorizeRequest(e);return(await Vc(document,this.config,r,e,this.logger,this.performanceClient)).submit(),new Promise(((e,t)=>{setTimeout((()=>{t(Yi($i,"failed_to_redirect"))}),this.config.system.redirectNavigationTimeout)}))}async handleRedirectPromise(e="",r,n,o){const i=this.initializeServerTelemetryManager(Os.handleRedirectPromise);try{const[s,a]=this.getRedirectResponse(e||"");if(!s)return this.logger.info("handleRedirectPromise did not detect a response as a result of a redirect. Cleaning temporary cache."),this.browserStorage.resetRequestCache(),"back_forward"!==function(){if("undefined"==typeof window||void 0===window.performance||"function"!=typeof window.performance.getEntriesByType)return;const e=window.performance.getEntriesByType("navigation"),t=e.length?e[0]:void 0;return t?.type}()?o.event.errorCode="no_server_response":this.logger.verbose("Back navigation event detected. Muting no_server_response error"),null;const c=this.browserStorage.getTemporaryCache(Is,!0)||t.EMPTY_STRING,l=qr.removeHashFromUrl(c);if(l===qr.removeHashFromUrl(window.location.href)&&this.config.auth.navigateToLoginRequestUrl){this.logger.verbose("Current page is loginRequestUrl, handling response"),c.indexOf("#")>-1&&Sa(c);return await this.handleResponse(s,r,n,i)}if(!this.config.auth.navigateToLoginRequestUrl)return this.logger.verbose("NavigateToLoginRequestUrl set to false, handling response"),await this.handleResponse(s,r,n,i);if(!ba()||this.config.system.allowRedirectInIframe){this.browserStorage.setTemporaryCache(Ts,a,!0);const e={apiId:Os.handleRedirectPromise,timeout:this.config.system.redirectNavigationTimeout,noHistory:!0};let t=!0;if(c&&"null"!==c)this.logger.verbose(`Navigating to loginRequestUrl: ${c}`),t=await this.navigationClient.navigateInternal(c,e);else{const r=_a();this.browserStorage.setTemporaryCache(Is,r,!0),this.logger.warning("Unable to get valid login request url from cache, redirecting to home page"),t=await this.navigationClient.navigateInternal(r,e)}if(!t)return await this.handleResponse(s,r,n,i)}return null}catch(e){throw e instanceof Ce&&(e.setCorrelationId(this.correlationId),i.cacheFailedRequest(e)),e}}getRedirectResponse(t){this.logger.verbose("getRedirectResponseHash called");let r=t;r||(r=this.config.auth.OIDCOptions.serverResponseType===_.QUERY?window.location.search:window.location.hash);let n=Mr(r);if(n){try{Hc(n,this.browserCrypto,e.InteractionType.Redirect)}catch(e){return e instanceof Ce&&this.logger.error(`Interaction type validation failed due to ${e.errorCode}: ${e.errorMessage}`),[null,""]}return ka(window),this.logger.verbose("Hash contains known properties, returning response hash"),[n,r]}const o=this.browserStorage.getTemporaryCache(Ts,!0);return this.browserStorage.removeItem(this.browserStorage.generateCacheKey(Ts)),o&&(n=Mr(o),n)?(this.logger.verbose("Hash does not contain known properties, returning cached hash"),[n,o]):[null,""]}async handleResponse(e,t,r,n){if(!e.state)throw Yi(ti);if(e.ear_jwe){const r=await Vn(this.getDiscoveredAuthority.bind(this),Qr.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,t.correlationId)({requestAuthority:t.authority,requestAzureCloudOptions:t.azureCloudOptions,requestExtraQueryParameters:t.extraQueryParameters,account:t.account});return Vn(Zc,Qr.HandleResponseEar,this.logger,this.performanceClient,t.correlationId)(t,e,Os.acquireTokenRedirect,this.config,r,this.browserStorage,this.nativeStorage,this.eventHandler,this.logger,this.performanceClient,this.platformAuthProvider)}const o=await Vn(this.createAuthCodeClient.bind(this),Qr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:t.authority});return Vn(Xc,Qr.HandleResponseCode,this.logger,this.performanceClient,t.correlationId)(t,e,r,Os.acquireTokenRedirect,this.config,o,this.browserStorage,this.nativeStorage,this.eventHandler,this.logger,this.performanceClient,this.platformAuthProvider)}async initiateAuthRequest(e,t){if(this.logger.verbose("RedirectHandler.initiateAuthRequest called"),e){this.logger.infoPii(`RedirectHandler.initiateAuthRequest: Navigate to: ${e}`);const r={apiId:Os.acquireTokenRedirect,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},n=t||this.config.auth.onRedirectNavigate;if("function"==typeof n){this.logger.verbose("RedirectHandler.initiateAuthRequest: Invoking onRedirectNavigate callback");return!1!==n(e)?(this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate did not return false, navigating"),void await this.navigationClient.navigateExternal(e,r)):void this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate returned false, stopping navigation")}return this.logger.verbose("RedirectHandler.initiateAuthRequest: Navigating window to navigate url"),void await this.navigationClient.navigateExternal(e,r)}throw this.logger.info("RedirectHandler.initiateAuthRequest: Navigate url is empty"),Yi(Zo)}async logout(t){this.logger.verbose("logoutRedirect called");const r=this.initializeLogoutRequest(t),n=this.initializeServerTelemetryManager(Os.logout);try{this.eventHandler.emitEvent(vc.LOGOUT_START,e.InteractionType.Redirect,t),await this.clearCacheOnLogout(this.correlationId,r.account);const o={apiId:Os.logout,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},i=await Vn(this.createAuthCodeClient.bind(this),Qr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:t&&t.authority,requestExtraQueryParameters:t?.extraQueryParameters,account:t&&t.account||void 0});if(i.authority.protocolMode===Rr.OIDC)try{i.authority.endSessionEndpoint}catch{if(r.account?.homeAccountId)return this.browserStorage.removeAccount(r.account?.homeAccountId,this.correlationId),void this.eventHandler.emitEvent(vc.LOGOUT_SUCCESS,e.InteractionType.Redirect,r)}const s=i.getLogoutUri(r);if(this.eventHandler.emitEvent(vc.LOGOUT_SUCCESS,e.InteractionType.Redirect,r),!t||"function"!=typeof t.onRedirectNavigate)return this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0,ws),void await this.navigationClient.navigateExternal(s,o);if(!1!==t.onRedirectNavigate(s))return this.logger.verbose("Logout onRedirectNavigate did not return false, navigating"),this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0,ws),void await this.navigationClient.navigateExternal(s,o);this.browserStorage.setInteractionInProgress(!1),this.logger.verbose("Logout onRedirectNavigate returned false, stopping navigation")}catch(t){throw t instanceof Ce&&(t.setCorrelationId(this.correlationId),n.cacheFailedRequest(t)),this.eventHandler.emitEvent(vc.LOGOUT_FAILURE,e.InteractionType.Redirect,null,t),this.eventHandler.emitEvent(vc.LOGOUT_END,e.InteractionType.Redirect),t}this.eventHandler.emitEvent(vc.LOGOUT_END,e.InteractionType.Redirect)}getRedirectStartPage(e){const t=e||window.location.href;return qr.getAbsoluteUrl(t,Ra())}}async function ll(e,t,r,n,o){if(t.addQueueMeasurement(Qr.SilentHandlerInitiateAuthRequest,n),!e)throw r.info("Navigate url is empty"),Yi(Zo);return o?Vn(gl,Qr.SilentHandlerLoadFrame,r,t,n)(e,o,t,n):Wn(pl,Qr.SilentHandlerLoadFrameSync,r,t,n)(e)}async function hl(e,t,r,n,o){const i=ml();if(!i.contentDocument)throw"No document associated with iframe!";return(await Vc(i.contentDocument,e,t,r,n,o)).submit(),i}async function dl(e,t,r,n,o){const i=ml();if(!i.contentDocument)throw"No document associated with iframe!";return(await Wc(i.contentDocument,e,t,r,n,o)).submit(),i}async function ul(e,t,r,n,o,i,s){return n.addQueueMeasurement(Qr.SilentHandlerMonitorIframeForHash,i),new Promise(((n,i)=>{t<Ga&&o.warning(`system.loadFrameTimeout or system.iframeHashTimeout set to lower (${t}ms) than the default (10000ms). This may result in timeouts.`);const a=window.setTimeout((()=>{window.clearInterval(c),i(Yi(hi))}),t),c=window.setInterval((()=>{let t="";const r=e.contentWindow;try{t=r?r.location.href:""}catch(e){}if(!t||"about:blank"===t)return;let o="";r&&(o=s===_.QUERY?r.location.search:r.location.hash),window.clearTimeout(a),window.clearInterval(c),n(o)}),r)})).finally((()=>{Wn(fl,Qr.RemoveHiddenIframe,o,n,i)(e)}))}function gl(e,t,r,n){return r.addQueueMeasurement(Qr.SilentHandlerLoadFrame,n),new Promise(((r,n)=>{const o=ml();window.setTimeout((()=>{o?(o.src=e,r(o)):n("Unable to load iframe")}),t)}))}function pl(e){const t=ml();return t.src=e,t}function ml(){const e=document.createElement("iframe");return e.className="msalSilentIframe",e.style.visibility="hidden",e.style.position="absolute",e.style.width=e.style.height="0",e.style.border="0",e.setAttribute("sandbox","allow-scripts allow-same-origin allow-forms"),document.body.appendChild(e),e}function fl(e){document.body===e.parentNode&&document.body.removeChild(e)}class yl extends Lc{constructor(e,t,r,n,o,i,s,a,c,l,h){super(e,t,r,n,o,i,a,l,h),this.apiId=s,this.nativeStorage=c}async acquireToken(t){this.performanceClient.addQueueMeasurement(Qr.SilentIframeClientAcquireToken,t.correlationId),t.loginHint||t.sid||t.account&&t.account.username||this.logger.warning("No user hint provided. The authorization server may need more information to complete this request.");const r={...t};r.prompt?r.prompt!==b.NONE&&r.prompt!==b.NO_SESSION&&(this.logger.warning(`SilentIframeClient. Replacing invalid prompt ${r.prompt} with ${b.NONE}`),r.prompt=b.NONE):r.prompt=b.NONE;const n=await Vn(this.initializeAuthorizationRequest.bind(this),Qr.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(r,e.InteractionType.Silent);return n.platformBroker=sl(this.config,this.logger,this.platformAuthProvider,n.authenticationScheme),Ha(n.authority),this.config.auth.protocolMode===Rr.EAR?this.executeEarFlow(n):this.executeCodeFlow(n)}async executeCodeFlow(e){let t;const r=this.initializeServerTelemetryManager(this.apiId);try{return t=await Vn(this.createAuthCodeClient.bind(this),Qr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,e.correlationId)({serverTelemetryManager:r,requestAuthority:e.authority,requestAzureCloudOptions:e.azureCloudOptions,requestExtraQueryParameters:e.extraQueryParameters,account:e.account}),await Vn(this.silentTokenHelper.bind(this),Qr.SilentIframeClientTokenHelper,this.logger,this.performanceClient,e.correlationId)(t,e)}catch(n){if(n instanceof Ce&&(n.setCorrelationId(this.correlationId),r.cacheFailedRequest(n)),!(t&&n instanceof Ce&&n.errorCode===Xi))throw n;return this.performanceClient.addFields({retryError:n.errorCode},this.correlationId),await Vn(this.silentTokenHelper.bind(this),Qr.SilentIframeClientTokenHelper,this.logger,this.performanceClient,this.correlationId)(t,e)}}async executeEarFlow(e){const t=e.correlationId,r=await Vn(this.getDiscoveredAuthority.bind(this),Qr.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,t)({requestAuthority:e.authority,requestAzureCloudOptions:e.azureCloudOptions,requestExtraQueryParameters:e.extraQueryParameters,account:e.account}),n=await Vn(ca,Qr.GenerateEarKey,this.logger,this.performanceClient,t)(),o={...e,earJwk:n},i=await Vn(dl,Qr.SilentHandlerInitiateAuthRequest,this.logger,this.performanceClient,t)(this.config,r,o,this.logger,this.performanceClient),s=this.config.auth.OIDCOptions.serverResponseType,a=await Vn(ul,Qr.SilentHandlerMonitorIframeForHash,this.logger,this.performanceClient,t)(i,this.config.system.iframeHashTimeout,this.config.system.pollIntervalMilliseconds,this.performanceClient,this.logger,t,s),c=Wn(Uc,Qr.DeserializeResponse,this.logger,this.performanceClient,t)(a,s,this.logger);return Vn(Zc,Qr.HandleResponseEar,this.logger,this.performanceClient,t)(o,c,this.apiId,this.config,r,this.browserStorage,this.nativeStorage,this.eventHandler,this.logger,this.performanceClient,this.platformAuthProvider)}logout(){return Promise.reject(Yi(mi))}async silentTokenHelper(e,t){const r=t.correlationId;this.performanceClient.addQueueMeasurement(Qr.SilentIframeClientTokenHelper,r);const n=await Vn(el,Qr.GeneratePkceCodes,this.logger,this.performanceClient,r)(this.performanceClient,this.logger,r),o={...t,codeChallenge:n.challenge};let i;if(t.httpMethod===l)i=await Vn(hl,Qr.SilentHandlerInitiateAuthRequest,this.logger,this.performanceClient,r)(this.config,e.authority,o,this.logger,this.performanceClient);else{const t=await Vn(jc,Qr.GetAuthCodeUrl,this.logger,this.performanceClient,r)(this.config,e.authority,o,this.logger,this.performanceClient);i=await Vn(ll,Qr.SilentHandlerInitiateAuthRequest,this.logger,this.performanceClient,r)(t,this.performanceClient,this.logger,r,this.config.system.navigateFrameWait)}const s=this.config.auth.OIDCOptions.serverResponseType,a=await Vn(ul,Qr.SilentHandlerMonitorIframeForHash,this.logger,this.performanceClient,r)(i,this.config.system.iframeHashTimeout,this.config.system.pollIntervalMilliseconds,this.performanceClient,this.logger,r,s),c=Wn(Uc,Qr.DeserializeResponse,this.logger,this.performanceClient,r)(a,s,this.logger);return Vn(Xc,Qr.HandleResponseCode,this.logger,this.performanceClient,r)(t,c,n.verifier,this.apiId,this.config,e,this.browserStorage,this.nativeStorage,this.eventHandler,this.logger,this.performanceClient,this.platformAuthProvider)}}class Cl extends Lc{async acquireToken(e){this.performanceClient.addQueueMeasurement(Qr.SilentRefreshClientAcquireToken,e.correlationId);const t=await Vn(Oc,Qr.InitializeBaseRequest,this.logger,this.performanceClient,e.correlationId)(e,this.config,this.performanceClient,this.logger),r={...e,...t};e.redirectUri&&(r.redirectUri=this.getRedirectUri(e.redirectUri));const n=this.initializeServerTelemetryManager(Os.acquireTokenSilent_silentFlow),o=await this.createRefreshTokenClient({serverTelemetryManager:n,authorityUrl:r.authority,azureCloudOptions:r.azureCloudOptions,account:r.account});return Vn(o.acquireTokenByRefreshToken.bind(o),Qr.RefreshTokenClientAcquireTokenByRefreshToken,this.logger,this.performanceClient,e.correlationId)(r).catch((e=>{throw e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e),e}))}logout(){return Promise.reject(Yi(mi))}async createRefreshTokenClient(e){const t=await Vn(this.getClientConfiguration.bind(this),Qr.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:e.serverTelemetryManager,requestAuthority:e.authorityUrl,requestAzureCloudOptions:e.azureCloudOptions,requestExtraQueryParameters:e.extraQueryParameters,account:e.account});return new Oo(t,this.performanceClient)}}class vl{constructor(e,t,r,n){this.isBrowserEnvironment="undefined"!=typeof window,this.config=e,this.storage=t,this.logger=r,this.cryptoObj=n}async loadExternalTokens(e,t,r){if(!this.isBrowserEnvironment)throw Yi(Ti);const n=e.correlationId||sa(),o=t.id_token?It(t.id_token,$s):void 0,i={protocolMode:this.config.auth.protocolMode,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache},s=e.authority?new Yn(Yn.generateAuthority(e.authority,e.azureCloudOptions),this.config.system.networkClient,this.storage,i,this.logger,e.correlationId||sa()):void 0,a=await this.loadAccount(e,r.clientInfo||t.client_info||"",n,o,s),c=await this.loadIdToken(t,a.homeAccountId,a.environment,a.realm,n),l=await this.loadAccessToken(e,t,a.homeAccountId,a.environment,a.realm,r,n),h=await this.loadRefreshToken(t,a.homeAccountId,a.environment,n);return this.generateAuthenticationResult(e,{account:a,idToken:c,accessToken:l,refreshToken:h},o,s)}async loadAccount(e,t,r,n,o){if(this.logger.verbose("TokenCache - loading account"),e.account){const t=_r.createFromAccountInfo(e.account);return await this.storage.setAccount(t,r),t}if(!o||!t&&!n)throw this.logger.error("TokenCache - if an account is not provided on the request, authority and either clientInfo or idToken must be provided instead."),Yi(Ri);const i=_r.generateHomeAccountId(t,o.authorityType,this.logger,this.cryptoObj,n),s=n?.tid,a=_o(this.storage,o,i,$s,r,n,t,o.hostnameAndPort,s,void 0,void 0,this.logger);return await this.storage.setAccount(a,r),a}async loadIdToken(e,t,r,n,o){if(!e.id_token)return this.logger.verbose("TokenCache - no id token found in response"),null;this.logger.verbose("TokenCache - loading id token");const i=_t(t,r,e.id_token,this.config.auth.clientId,n);return await this.storage.setIdTokenCredential(i,o),i}async loadAccessToken(e,t,r,n,o,i,s){if(!t.access_token)return this.logger.verbose("TokenCache - no access token found in response"),null;if(!t.expires_in)return this.logger.error("TokenCache - no expiration set on the access token. Cannot add it to the cache."),null;if(!(t.scope||e.scopes&&e.scopes.length))return this.logger.error("TokenCache - scopes not specified in the request or response. Cannot add token to the cache."),null;this.logger.verbose("TokenCache - loading access token");const a=t.scope?yr.fromString(t.scope):new yr(e.scopes),c=i.expiresOn||t.expires_in+At(),l=i.extendedExpiresOn||(t.ext_expires_in||t.expires_in)+At(),h=Pt(r,n,t.access_token,this.config.auth.clientId,o,a.printScopes(),c,l,$s);return await this.storage.setAccessTokenCredential(h,s),h}async loadRefreshToken(e,t,r,n){if(!e.refresh_token)return this.logger.verbose("TokenCache - no refresh token found in response"),null;this.logger.verbose("TokenCache - loading refresh token");const o=Mt(t,r,e.refresh_token,this.config.auth.clientId,e.foci,void 0,e.refresh_token_expires_in);return await this.storage.setRefreshTokenCredential(o,n),o}generateAuthenticationResult(e,t,r,n){let o,i="",s=[],a=null;t?.accessToken&&(i=t.accessToken.secret,s=yr.fromString(t.accessToken.target).asArray(),a=St(t.accessToken.expiresOn),o=St(t.accessToken.extendedExpiresOn));const c=t.account;return{authority:n?n.canonicalAuthority:"",uniqueId:t.account.localAccountId,tenantId:t.account.realm,scopes:s,account:c.getAccountInfo(),idToken:t.idToken?.secret||"",idTokenClaims:r||{},accessToken:i,fromCache:!0,expiresOn:a,correlationId:e.correlationId||"",requestId:"",extExpiresOn:o,familyId:t.refreshToken?.familyId||"",tokenType:t?.accessToken?.tokenType||"",state:e.state||"",cloudGraphHostName:c.cloudGraphHostName||"",msGraphHost:c.msGraphHost||"",fromNativeBroker:!1}}}class wl extends Mo{constructor(e){super(e),this.includeRedirectUri=!1}}class Il extends Lc{constructor(e,t,r,n,o,i,s,a,c,l){super(e,t,r,n,o,i,a,c,l),this.apiId=s}async acquireToken(t){if(!t.code)throw Yi(Pi);const r=await Vn(this.initializeAuthorizationRequest.bind(this),Qr.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(t,e.InteractionType.Silent),n=this.initializeServerTelemetryManager(this.apiId);try{const e={...r,code:t.code},o=await Vn(this.getClientConfiguration.bind(this),Qr.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,t.correlationId)({serverTelemetryManager:n,requestAuthority:r.authority,requestAzureCloudOptions:r.azureCloudOptions,requestExtraQueryParameters:r.extraQueryParameters,account:r.account}),i=new wl(o);this.logger.verbose("Auth code client created");const s=new xc(i,this.browserStorage,e,this.logger,this.performanceClient);return await Vn(s.handleCodeResponseFromServer.bind(s),Qr.HandleCodeResponseFromServer,this.logger,this.performanceClient,t.correlationId)({code:t.code,msgraph_host:t.msGraphHost,cloud_graph_host_name:t.cloudGraphHostName,cloud_instance_host_name:t.cloudInstanceHostName},r,!1)}catch(e){throw e instanceof Ce&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),e}}logout(){return Promise.reject(Yi(mi))}}function Tl(e){const t=e?.idTokenClaims;return t?.tfp||t?.acr?"B2C":t?.tid?"9188040d-6c67-4c5b-b112-36a304b66dad"===t?.tid?"MSA":"AAD":void 0}function Al(e,t){try{La(e)}catch(e){throw t.end({success:!1},e),e}}class kl{constructor(e){this.operatingContext=e,this.isBrowserEnvironment=this.operatingContext.isBrowserEnvironment(),this.config=e.getConfig(),this.initialized=!1,this.logger=this.operatingContext.getLogger(),this.networkClient=this.config.system.networkClient,this.navigationClient=this.config.system.navigationClient,this.redirectResponse=new Map,this.hybridAuthCodeResponses=new Map,this.performanceClient=this.config.telemetry.client,this.browserCrypto=this.isBrowserEnvironment?new cc(this.logger,this.performanceClient):mt,this.eventHandler=new Pc(this.logger),this.browserStorage=this.isBrowserEnvironment?new wc(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,this.performanceClient,this.eventHandler,Zn(this.config.auth)):Tc(this.config.auth.clientId,this.logger,this.performanceClient,this.eventHandler);const t={cacheLocation:fs.MemoryStorage,temporaryCacheLocation:fs.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1};this.nativeInternalStorage=new wc(this.config.auth.clientId,t,this.browserCrypto,this.logger,this.performanceClient,this.eventHandler),this.tokenCache=new vl(this.config,this.browserStorage,this.logger,this.browserCrypto),this.activeSilentTokenRequests=new Map,this.trackPageVisibility=this.trackPageVisibility.bind(this),this.trackPageVisibilityWithMeasurement=this.trackPageVisibilityWithMeasurement.bind(this)}static async createController(e,t){const r=new kl(e);return await r.initialize(t),r}trackPageVisibility(e){e&&(this.logger.info("Perf: Visibility change detected"),this.performanceClient.incrementFields({visibilityChangeCount:1},e))}async initialize(e,t){if(this.logger.trace("initialize called"),this.initialized)return void this.logger.info("initialize has already been called, exiting early.");if(!this.isBrowserEnvironment)return this.logger.info("in non-browser environment, exiting early."),this.initialized=!0,void this.eventHandler.emitEvent(vc.INITIALIZE_END);const r=e?.correlationId||this.getRequestCorrelationId(),n=this.config.system.allowPlatformBroker,o=this.performanceClient.startMeasurement(Qr.InitializeClientApplication,r);if(this.eventHandler.emitEvent(vc.INITIALIZE_START),!t)try{this.logMultipleInstances(o)}catch{}if(await Vn(this.browserStorage.initialize.bind(this.browserStorage),Qr.InitializeCache,this.logger,this.performanceClient,r)(r),n)try{this.platformAuthProvider=await il(this.logger,this.performanceClient,r,this.config.system.nativeBrokerHandshakeTimeout)}catch(e){this.logger.verbose(e)}this.config.cache.claimsBasedCachingEnabled||(this.logger.verbose("Claims-based caching is disabled. Clearing the previous cache with claims"),Wn(this.browserStorage.clearTokensAndKeysWithClaims.bind(this.browserStorage),Qr.ClearTokensAndKeysWithClaims,this.logger,this.performanceClient,r)(r)),this.config.system.asyncPopups&&await this.preGeneratePkceCodes(r),this.initialized=!0,this.eventHandler.emitEvent(vc.INITIALIZE_END),o.end({allowPlatformBroker:n,success:!0})}async handleRedirectPromise(e){if(this.logger.verbose("handleRedirectPromise called"),Na(this.initialized),this.isBrowserEnvironment){const t=e||"";let r=this.redirectResponse.get(t);return void 0===r?(r=this.handleRedirectPromiseInternal(e),this.redirectResponse.set(t,r),this.logger.verbose("handleRedirectPromise has been called for the first time, storing the promise")):this.logger.verbose("handleRedirectPromise has been called previously, returning the result from the first call"),r}return this.logger.verbose("handleRedirectPromise returns null, not browser environment"),null}async handleRedirectPromiseInternal(t){if(!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const r=this.browserStorage.getInteractionInProgress()?.type;if(r===ws)return this.logger.verbose("handleRedirectPromise removing interaction_in_progress flag and returning null after sign-out"),this.browserStorage.setInteractionInProgress(!1),Promise.resolve(null);const n=this.getAllAccounts(),o=this.browserStorage.getCachedNativeRequest(),i=o&&this.platformAuthProvider&&!t;let s,a;this.eventHandler.emitEvent(vc.HANDLE_REDIRECT_START,e.InteractionType.Redirect);try{if(i&&this.platformAuthProvider){s=this.performanceClient.startMeasurement(Qr.AcquireTokenRedirect,o?.correlationId||""),this.logger.trace("handleRedirectPromise - acquiring token from native platform");const e=new $c(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Os.handleRedirectPromise,this.performanceClient,this.platformAuthProvider,o.accountId,this.nativeInternalStorage,o.correlationId);a=Vn(e.handleRedirectPromise.bind(e),Qr.HandleNativeRedirectPromiseMeasurement,this.logger,this.performanceClient,s.event.correlationId)(this.performanceClient,s.event.correlationId)}else{const[e,r]=this.browserStorage.getCachedRequest(),n=e.correlationId;s=this.performanceClient.startMeasurement(Qr.AcquireTokenRedirect,n),this.logger.trace("handleRedirectPromise - acquiring token from web flow");const o=this.createRedirectClient(n);a=Vn(o.handleRedirectPromise.bind(o),Qr.HandleRedirectPromiseMeasurement,this.logger,this.performanceClient,s.event.correlationId)(t,e,r,s)}}catch(e){throw this.browserStorage.resetRequestCache(),e}return a.then((t=>{if(t){this.browserStorage.resetRequestCache();n.length<this.getAllAccounts().length?(this.eventHandler.emitEvent(vc.LOGIN_SUCCESS,e.InteractionType.Redirect,t),this.logger.verbose("handleRedirectResponse returned result, login success")):(this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Redirect,t),this.logger.verbose("handleRedirectResponse returned result, acquire token success")),s.end({success:!0,accountType:Tl(t.account)})}else s.event.errorCode?s.end({success:!1}):s.discard();return this.eventHandler.emitEvent(vc.HANDLE_REDIRECT_END,e.InteractionType.Redirect),t})).catch((t=>{this.browserStorage.resetRequestCache();const r=t;throw n.length>0?this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Redirect,null,r):this.eventHandler.emitEvent(vc.LOGIN_FAILURE,e.InteractionType.Redirect,null,r),this.eventHandler.emitEvent(vc.HANDLE_REDIRECT_END,e.InteractionType.Redirect),s.end({success:!1},r),t}))}async acquireTokenRedirect(t){const r=this.getRequestCorrelationId(t);this.logger.verbose("acquireTokenRedirect called",r);const n=this.performanceClient.startMeasurement(Qr.AcquireTokenPreRedirect,r);n.add({accountType:Tl(t.account),scenarioId:t.scenarioId});const o=t.onRedirectNavigate;if(o)t.onRedirectNavigate=e=>{const t="function"==typeof o?o(e):void 0;return!1!==t?n.end({success:!0}):n.discard(),t};else{const e=this.config.auth.onRedirectNavigate;this.config.auth.onRedirectNavigate=t=>{const r="function"==typeof e?e(t):void 0;return!1!==r?n.end({success:!0}):n.discard(),r}}const i=this.getAllAccounts().length>0;try{let o;if(Ua(this.initialized,this.config),this.browserStorage.setInteractionInProgress(!0,vs),i?this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_START,e.InteractionType.Redirect,t):this.eventHandler.emitEvent(vc.LOGIN_START,e.InteractionType.Redirect,t),this.platformAuthProvider&&this.canUsePlatformBroker(t)){o=new $c(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Os.acquireTokenRedirect,this.performanceClient,this.platformAuthProvider,this.getNativeAccountId(t),this.nativeInternalStorage,r).acquireTokenRedirect(t,n).catch((e=>{if(e instanceof Fc&&zc(e)){this.platformAuthProvider=void 0;return this.createRedirectClient(r).acquireToken(t)}if(e instanceof Io){this.logger.verbose("acquireTokenRedirect - Resolving interaction required error thrown by native broker by falling back to web flow");return this.createRedirectClient(r).acquireToken(t)}throw e}))}else{o=this.createRedirectClient(r).acquireToken(t)}return await o}catch(t){throw this.browserStorage.resetRequestCache(),n.end({success:!1},t),i?this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Redirect,null,t):this.eventHandler.emitEvent(vc.LOGIN_FAILURE,e.InteractionType.Redirect,null,t),t}}acquireTokenPopup(t){const r=this.getRequestCorrelationId(t),n=this.performanceClient.startMeasurement(Qr.AcquireTokenPopup,r);n.add({scenarioId:t.scenarioId,accountType:Tl(t.account)});try{this.logger.verbose("acquireTokenPopup called",r),Al(this.initialized,n),this.browserStorage.setInteractionInProgress(!0,vs)}catch(e){return Promise.reject(e)}const o=this.getAllAccounts();let i;o.length>0?this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_START,e.InteractionType.Popup,t):this.eventHandler.emitEvent(vc.LOGIN_START,e.InteractionType.Popup,t);const s=this.getPreGeneratedPkceCodes(r);if(this.canUsePlatformBroker(t))i=this.acquireTokenNative({...t,correlationId:r},Os.acquireTokenPopup).then((e=>(n.end({success:!0,isNativeBroker:!0,accountType:Tl(e.account)}),e))).catch((e=>{if(e instanceof Fc&&zc(e)){this.platformAuthProvider=void 0;return this.createPopupClient(r).acquireToken(t,s)}if(e instanceof Io){this.logger.verbose("acquireTokenPopup - Resolving interaction required error thrown by native broker by falling back to web flow");return this.createPopupClient(r).acquireToken(t,s)}throw e}));else{i=this.createPopupClient(r).acquireToken(t,s)}return i.then((t=>(o.length<this.getAllAccounts().length?this.eventHandler.emitEvent(vc.LOGIN_SUCCESS,e.InteractionType.Popup,t):this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Popup,t),n.end({success:!0,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:Tl(t.account)}),t))).catch((t=>(o.length>0?this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Popup,null,t):this.eventHandler.emitEvent(vc.LOGIN_FAILURE,e.InteractionType.Popup,null,t),n.end({success:!1},t),Promise.reject(t)))).finally((async()=>{this.browserStorage.setInteractionInProgress(!1),this.config.system.asyncPopups&&await this.preGeneratePkceCodes(r)}))}trackPageVisibilityWithMeasurement(){const e=this.ssoSilentMeasurement||this.acquireTokenByCodeAsyncMeasurement;e&&(this.logger.info("Perf: Visibility change detected in ",e.event.name),e.increment({visibilityChangeCount:1}))}async ssoSilent(t){const r=this.getRequestCorrelationId(t),n={...t,prompt:t.prompt,correlationId:r};let o;if(this.ssoSilentMeasurement=this.performanceClient.startMeasurement(Qr.SsoSilent,r),this.ssoSilentMeasurement?.add({scenarioId:t.scenarioId,accountType:Tl(t.account)}),Al(this.initialized,this.ssoSilentMeasurement),this.ssoSilentMeasurement?.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement),this.logger.verbose("ssoSilent called",r),this.eventHandler.emitEvent(vc.SSO_SILENT_START,e.InteractionType.Silent,n),this.canUsePlatformBroker(n))o=this.acquireTokenNative(n,Os.ssoSilent).catch((e=>{if(e instanceof Fc&&zc(e)){this.platformAuthProvider=void 0;return this.createSilentIframeClient(n.correlationId).acquireToken(n)}throw e}));else{o=this.createSilentIframeClient(n.correlationId).acquireToken(n)}return o.then((t=>(this.eventHandler.emitEvent(vc.SSO_SILENT_SUCCESS,e.InteractionType.Silent,t),this.ssoSilentMeasurement?.end({success:!0,isNativeBroker:t.fromNativeBroker,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:Tl(t.account)}),t))).catch((t=>{throw this.eventHandler.emitEvent(vc.SSO_SILENT_FAILURE,e.InteractionType.Silent,null,t),this.ssoSilentMeasurement?.end({success:!1},t),t})).finally((()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)}))}async acquireTokenByCode(t){const r=this.getRequestCorrelationId(t);this.logger.trace("acquireTokenByCode called",r);const n=this.performanceClient.startMeasurement(Qr.AcquireTokenByCode,r);Al(this.initialized,n),this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_BY_CODE_START,e.InteractionType.Silent,t),n.add({scenarioId:t.scenarioId});try{if(t.code&&t.nativeAccountId)throw Yi(Oi);if(t.code){const o=t.code;let i=this.hybridAuthCodeResponses.get(o);return i?(this.logger.verbose("Existing acquireTokenByCode request found",r),n.discard()):(this.logger.verbose("Initiating new acquireTokenByCode request",r),i=this.acquireTokenByCodeAsync({...t,correlationId:r}).then((t=>(this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_BY_CODE_SUCCESS,e.InteractionType.Silent,t),this.hybridAuthCodeResponses.delete(o),n.end({success:!0,isNativeBroker:t.fromNativeBroker,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:Tl(t.account)}),t))).catch((t=>{throw this.hybridAuthCodeResponses.delete(o),this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_BY_CODE_FAILURE,e.InteractionType.Silent,null,t),n.end({success:!1},t),t})),this.hybridAuthCodeResponses.set(o,i)),await i}if(t.nativeAccountId){if(this.canUsePlatformBroker(t,t.nativeAccountId)){const e=await this.acquireTokenNative({...t,correlationId:r},Os.acquireTokenByCode,t.nativeAccountId).catch((e=>{throw e instanceof Fc&&zc(e)&&(this.platformAuthProvider=void 0),e}));return n.end({accountType:Tl(e.account),success:!0}),e}throw Yi(Ni)}throw Yi(Mi)}catch(t){throw this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_BY_CODE_FAILURE,e.InteractionType.Silent,null,t),n.end({success:!1},t),t}}async acquireTokenByCodeAsync(e){this.logger.trace("acquireTokenByCodeAsync called",e.correlationId),this.acquireTokenByCodeAsyncMeasurement=this.performanceClient.startMeasurement(Qr.AcquireTokenByCodeAsync,e.correlationId),this.acquireTokenByCodeAsyncMeasurement?.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement);const t=this.createSilentAuthCodeClient(e.correlationId);return await t.acquireToken(e).then((e=>(this.acquireTokenByCodeAsyncMeasurement?.end({success:!0,fromCache:e.fromCache,isNativeBroker:e.fromNativeBroker}),e))).catch((e=>{throw this.acquireTokenByCodeAsyncMeasurement?.end({success:!1},e),e})).finally((()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)}))}async acquireTokenFromCache(e,t){switch(this.performanceClient.addQueueMeasurement(Qr.AcquireTokenFromCache,e.correlationId),t){case xs.Default:case xs.AccessToken:case xs.AccessTokenAndRefreshToken:const t=this.createSilentCacheClient(e.correlationId);return Vn(t.acquireToken.bind(t),Qr.SilentCacheClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e);default:throw pt(Xe)}}async acquireTokenByRefreshToken(e,t){switch(this.performanceClient.addQueueMeasurement(Qr.AcquireTokenByRefreshToken,e.correlationId),t){case xs.Default:case xs.AccessTokenAndRefreshToken:case xs.RefreshToken:case xs.RefreshTokenAndNetwork:const t=this.createSilentRefreshClient(e.correlationId);return Vn(t.acquireToken.bind(t),Qr.SilentRefreshClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e);default:throw pt(Xe)}}async acquireTokenBySilentIframe(e){this.performanceClient.addQueueMeasurement(Qr.AcquireTokenBySilentIframe,e.correlationId);const t=this.createSilentIframeClient(e.correlationId);return Vn(t.acquireToken.bind(t),Qr.SilentIframeClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e)}async logout(e){const t=this.getRequestCorrelationId(e);return this.logger.warning("logout API is deprecated and will be removed in msal-browser v3.0.0. Use logoutRedirect instead.",t),this.logoutRedirect({correlationId:t,...e})}async logoutRedirect(e){const t=this.getRequestCorrelationId(e);Ua(this.initialized,this.config),this.browserStorage.setInteractionInProgress(!0,ws);return this.createRedirectClient(t).logout(e)}logoutPopup(e){try{const t=this.getRequestCorrelationId(e);La(this.initialized),this.browserStorage.setInteractionInProgress(!0,ws);return this.createPopupClient(t).logout(e).finally((()=>{this.browserStorage.setInteractionInProgress(!1)}))}catch(e){return Promise.reject(e)}}async clearCache(e){if(!this.isBrowserEnvironment)return void this.logger.info("in non-browser environment, returning early.");const t=this.getRequestCorrelationId(e);return this.createSilentCacheClient(t).logout(e)}getAllAccounts(e){const t=this.getRequestCorrelationId();return Ac(this.logger,this.browserStorage,this.isBrowserEnvironment,t,e)}getAccount(e){const t=this.getRequestCorrelationId();return kc(e,this.logger,this.browserStorage,t)}getAccountByUsername(e){const t=this.getRequestCorrelationId();return Sc(e,this.logger,this.browserStorage,t)}getAccountByHomeId(e){const t=this.getRequestCorrelationId();return bc(e,this.logger,this.browserStorage,t)}getAccountByLocalId(e){const t=this.getRequestCorrelationId();return Ec(e,this.logger,this.browserStorage,t)}setActiveAccount(e){const t=this.getRequestCorrelationId();Rc(e,this.browserStorage,t)}getActiveAccount(){const e=this.getRequestCorrelationId();return _c(this.browserStorage,e)}async hydrateCache(e,t){this.logger.verbose("hydrateCache called");const r=_r.createFromAccountInfo(e.account,e.cloudGraphHostName,e.msGraphHost);return await this.browserStorage.setAccount(r,e.correlationId),e.fromNativeBroker?(this.logger.verbose("Response was from native broker, storing in-memory"),this.nativeInternalStorage.hydrateCache(e,t)):this.browserStorage.hydrateCache(e,t)}async acquireTokenNative(e,t,r,n){if(this.logger.trace("acquireTokenNative called"),!this.platformAuthProvider)throw Yi(Hi);return new $c(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,t,this.performanceClient,this.platformAuthProvider,r||this.getNativeAccountId(e),this.nativeInternalStorage,e.correlationId).acquireToken(e,n)}canUsePlatformBroker(e,t){if(this.logger.trace("canUsePlatformBroker called"),!this.platformAuthProvider)return this.logger.trace("canUsePlatformBroker: platform broker unavilable, returning false"),!1;if(!sl(this.config,this.logger,this.platformAuthProvider,e.authenticationScheme))return this.logger.trace("canUsePlatformBroker: isBrokerAvailable returned false, returning false"),!1;if(e.prompt)switch(e.prompt){case b.NONE:case b.CONSENT:case b.LOGIN:this.logger.trace("canUsePlatformBroker: prompt is compatible with platform broker flow");break;default:return this.logger.trace(`canUsePlatformBroker: prompt = ${e.prompt} is not compatible with platform broker flow, returning false`),!1}return!(!t&&!this.getNativeAccountId(e))||(this.logger.trace("canUsePlatformBroker: nativeAccountId is not available, returning false"),!1)}getNativeAccountId(e){const t=e.account||this.getAccount({loginHint:e.loginHint,sid:e.sid})||this.getActiveAccount();return t&&t.nativeAccountId||""}createPopupClient(e){return new al(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.platformAuthProvider,e)}createRedirectClient(e){return new cl(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.platformAuthProvider,e)}createSilentIframeClient(e){return new yl(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Os.ssoSilent,this.performanceClient,this.nativeInternalStorage,this.platformAuthProvider,e)}createSilentCacheClient(e){return new Gc(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.platformAuthProvider,e)}createSilentRefreshClient(e){return new Cl(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.platformAuthProvider,e)}createSilentAuthCodeClient(e){return new Il(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Os.acquireTokenByCode,this.performanceClient,this.platformAuthProvider,e)}addEventCallback(e,t){return this.eventHandler.addEventCallback(e,t)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){return qa(),this.performanceClient.addPerformanceCallback(e)}removePerformanceCallback(e){return this.performanceClient.removePerformanceCallback(e)}enableAccountStorageEvents(){this.config.cache.cacheLocation===fs.LocalStorage?this.eventHandler.subscribeCrossTab():this.logger.info("Account storage events are only available when cacheLocation is set to localStorage")}disableAccountStorageEvents(){this.config.cache.cacheLocation===fs.LocalStorage?this.eventHandler.unsubscribeCrossTab():this.logger.info("Account storage events are only available when cacheLocation is set to localStorage")}getTokenCache(){return this.tokenCache}getLogger(){return this.logger}setLogger(e){this.logger=e}initializeWrapperLibrary(e,t){this.browserStorage.setWrapperMetadata(e,t)}setNavigationClient(e){this.navigationClient=e}getConfiguration(){return this.config}getPerformanceClient(){return this.performanceClient}isBrowserEnv(){return this.isBrowserEnvironment}getRequestCorrelationId(e){return e?.correlationId?e.correlationId:this.isBrowserEnvironment?sa():t.EMPTY_STRING}async loginRedirect(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginRedirect called",t),this.acquireTokenRedirect({correlationId:t,...e||Ls})}loginPopup(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginPopup called",t),this.acquireTokenPopup({correlationId:t,...e||Ls})}async acquireTokenSilent(e){const t=this.getRequestCorrelationId(e),r=this.performanceClient.startMeasurement(Qr.AcquireTokenSilent,t);r.add({cacheLookupPolicy:e.cacheLookupPolicy,scenarioId:e.scenarioId}),Al(this.initialized,r),this.logger.verbose("acquireTokenSilent called",t);const n=e.account||this.getActiveAccount();if(!n)throw Yi(fi);return r.add({accountType:Tl(n)}),this.acquireTokenSilentDeduped(e,n,t).then((n=>(r.end({success:!0,fromCache:n.fromCache,isNativeBroker:n.fromNativeBroker,accessTokenSize:n.accessToken.length,idTokenSize:n.idToken.length}),{...n,state:e.state,correlationId:t}))).catch((e=>{throw e instanceof Ce&&e.setCorrelationId(t),r.end({success:!1},e),e}))}async acquireTokenSilentDeduped(e,t,r){const n=ro(this.config.auth.clientId,{...e,authority:e.authority||this.config.auth.authority},t.homeAccountId),o=JSON.stringify(n),i=this.activeSilentTokenRequests.get(o);if(void 0===i){this.logger.verbose("acquireTokenSilent called for the first time, storing active request",r),this.performanceClient.addFields({deduped:!1},r);const n=Vn(this.acquireTokenSilentAsync.bind(this),Qr.AcquireTokenSilentAsync,this.logger,this.performanceClient,r)({...e,correlationId:r},t);return this.activeSilentTokenRequests.set(o,n),n.finally((()=>{this.activeSilentTokenRequests.delete(o)}))}return this.logger.verbose("acquireTokenSilent has been called previously, returning the result from the first call",r),this.performanceClient.addFields({deduped:!0},r),i}async acquireTokenSilentAsync(t,r){const n=()=>this.trackPageVisibility(t.correlationId);this.performanceClient.addQueueMeasurement(Qr.AcquireTokenSilentAsync,t.correlationId),this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_START,e.InteractionType.Silent,t),t.correlationId&&this.performanceClient.incrementFields({visibilityChangeCount:0},t.correlationId),document.addEventListener("visibilitychange",n);const o=await Vn(qc,Qr.InitializeSilentRequest,this.logger,this.performanceClient,t.correlationId)(t,r,this.config,this.performanceClient,this.logger),i=t.cacheLookupPolicy||xs.Default;return this.acquireTokenSilentNoIframe(o,i).catch((async e=>{const t=function(e,t){const r=!(e instanceof Io&&e.subError!==mo),n=e.errorCode===Xi||e.errorCode===Xe,o=r&&n||e.errorCode===ao||e.errorCode===lo,i=Ds.includes(t);return o&&i}(e,i);if(t){if(this.activeIframeRequest){if(i!==xs.Skip){const[t,r]=this.activeIframeRequest;this.logger.verbose(`Iframe request is already in progress, awaiting resolution for request with correlationId: ${r}`,o.correlationId);const n=this.performanceClient.startMeasurement(Qr.AwaitConcurrentIframe,o.correlationId);n.add({awaitIframeCorrelationId:r});const s=await t;if(n.end({success:s}),s)return this.logger.verbose(`Parallel iframe request with correlationId: ${r} succeeded. Retrying cache and/or RT redemption`,o.correlationId),this.acquireTokenSilentNoIframe(o,i);throw this.logger.info(`Iframe request with correlationId: ${r} failed. Interaction is required.`),e}return this.logger.warning("Another iframe request is currently in progress and CacheLookupPolicy is set to Skip. This may result in degraded performance and/or reliability for both calls. Please consider changing the CacheLookupPolicy to take advantage of request queuing and token cache.",o.correlationId),Vn(this.acquireTokenBySilentIframe.bind(this),Qr.AcquireTokenBySilentIframe,this.logger,this.performanceClient,o.correlationId)(o)}{let e;return this.activeIframeRequest=[new Promise((t=>{e=t})),o.correlationId],this.logger.verbose("Refresh token expired/invalid or CacheLookupPolicy is set to Skip, attempting acquire token by iframe.",o.correlationId),Vn(this.acquireTokenBySilentIframe.bind(this),Qr.AcquireTokenBySilentIframe,this.logger,this.performanceClient,o.correlationId)(o).then((t=>(e(!0),t))).catch((t=>{throw e(!1),t})).finally((()=>{this.activeIframeRequest=void 0}))}}throw e})).then((r=>(this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,r),t.correlationId&&this.performanceClient.addFields({fromCache:r.fromCache,isNativeBroker:r.fromNativeBroker},t.correlationId),r))).catch((t=>{throw this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null,t),t})).finally((()=>{document.removeEventListener("visibilitychange",n)}))}async acquireTokenSilentNoIframe(t,r){return sl(this.config,this.logger,this.platformAuthProvider,t.authenticationScheme)&&t.account.nativeAccountId?(this.logger.verbose("acquireTokenSilent - attempting to acquire token from native platform"),this.acquireTokenNative(t,Os.acquireTokenSilent_silentFlow,t.account.nativeAccountId,r).catch((async e=>{if(e instanceof Fc&&zc(e))throw this.logger.verbose("acquireTokenSilent - native platform unavailable, falling back to web flow"),this.platformAuthProvider=void 0,pt(Xe);throw e}))):(this.logger.verbose("acquireTokenSilent - attempting to acquire token from web flow"),r===xs.AccessToken&&this.logger.verbose("acquireTokenSilent - cache lookup policy set to AccessToken, attempting to acquire token from local cache"),Vn(this.acquireTokenFromCache.bind(this),Qr.AcquireTokenFromCache,this.logger,this.performanceClient,t.correlationId)(t,r).catch((n=>{if(r===xs.AccessToken)throw n;return this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_NETWORK_START,e.InteractionType.Silent,t),Vn(this.acquireTokenByRefreshToken.bind(this),Qr.AcquireTokenByRefreshToken,this.logger,this.performanceClient,t.correlationId)(t,r)})))}async preGeneratePkceCodes(e){return this.logger.verbose("Generating new PKCE codes"),this.pkceCode=await Vn(el,Qr.GeneratePkceCodes,this.logger,this.performanceClient,e)(this.performanceClient,this.logger,e),Promise.resolve()}getPreGeneratedPkceCodes(e){this.logger.verbose("Attempting to pick up pre-generated PKCE codes");const t=this.pkceCode?{...this.pkceCode}:void 0;return this.pkceCode=void 0,this.logger.verbose((t?"Found":"Did not find")+" pre-generated PKCE codes"),this.performanceClient.addFields({usePreGeneratedPkce:!!t},e),t}logMultipleInstances(e){const t=this.config.auth.clientId;if(!window)return;window.msal=window.msal||{},window.msal.clientIds=window.msal.clientIds||[];window.msal.clientIds.length>0&&this.logger.verbose("There is already an instance of MSAL.js in the window."),window.msal.clientIds.push(t),function(e,t,r){const n=window.msal?.clientIds||[],o=n.length,i=n.filter((t=>t===e)).length;i>1&&r.warning("There is already an instance of MSAL.js in the window with the same client id."),t.add({msalInstanceCount:o,sameClientIdInstanceCount:i})}(t,e,this.logger)}}class Sl{constructor(e,t,r,n){this.clientId=e,this.clientCapabilities=t,this.crypto=r,this.logger=n}toNaaTokenRequest(e){let t;t=void 0===e.extraQueryParameters?new Map:new Map(Object.entries(e.extraQueryParameters));const r=e.correlationId||this.crypto.createNewGuid(),n=zn(e.claims,this.clientCapabilities),o=e.scopes||h;return{platformBrokerId:e.account?.homeAccountId,clientId:this.clientId,authority:e.authority,scope:o.join(" "),correlationId:r,claims:fr.isEmptyObj(n)?void 0:n,state:e.state,authenticationScheme:e.authenticationScheme||W.BEARER,extraParameters:t}}fromNaaTokenResponse(e,t,r){if(!t.token.id_token||!t.token.access_token)throw pt(Ae);const n=St(r+(t.token.expires_in||0)),o=It(t.token.id_token,this.crypto.base64Decode),i=this.fromNaaAccountInfo(t.account,t.token.id_token,o),s=t.token.scope||e.scope;return{authority:t.token.authority||i.environment,uniqueId:i.localAccountId,tenantId:i.tenantId,scopes:s.split(" "),account:i,idToken:t.token.id_token,idTokenClaims:o,accessToken:t.token.access_token,fromCache:!1,expiresOn:n,tokenType:e.authenticationScheme||W.BEARER,correlationId:e.correlationId,extExpiresOn:n,state:e.state}}fromNaaAccountInfo(e,t,r){const n=r||e.idTokenClaims,o=e.localAccountId||n?.oid||n?.sub||"",i=e.tenantId||n?.tid||"",s=e.homeAccountId||`${o}.${i}`,a=e.username||n?.preferred_username||"",c=e.name||n?.name,l=new Map,h=Ir(s,o,i,n);l.set(i,h);return{homeAccountId:s,environment:e.environment,tenantId:i,username:a,localAccountId:o,name:c,idToken:t,idTokenClaims:n,tenantProfiles:l}}fromBridgeError(e){if(!function(e){return void 0!==e.status}(e))return new Ce("unknown_error","An unknown error occurred");switch(e.status){case Va:return new gt(st);case Ja:return new gt(it);case ec:return new gt(je);case Za:return new gt(lt);case tc:return new gt(e.code||lt,e.description);case Ya:case Xa:return new to(e.code,e.description);case Wa:return new Io(e.code,e.description);default:return new Ce(e.code,e.description)}}toAuthenticationResultFromCache(e,t,r,n,o){if(!t||!r)throw pt(Ae);const i=It(t.secret,this.crypto.base64Decode),s=r.target||n.scopes.join(" ");return{authority:r.environment||e.environment,uniqueId:e.localAccountId,tenantId:e.tenantId,scopes:s.split(" "),account:e,idToken:t.secret,idTokenClaims:i||{},accessToken:r.secret,fromCache:!0,expiresOn:St(r.expiresOn),extExpiresOn:St(r.extendedExpiresOn),tokenType:n.authenticationScheme||W.BEARER,correlationId:o,state:n.state}}}const bl={code:"unsupported_method",desc:"This method is not supported in nested app environment."};class El extends Ce{constructor(e,t){super(e,t),Object.setPrototypeOf(this,El.prototype),this.name="NestedAppAuthError"}static createUnsupportedError(){return new El(bl.code,bl.desc)}}class Rl{constructor(e){this.operatingContext=e;const t=this.operatingContext.getBridgeProxy();if(void 0===t)throw new Error("unexpected: bridgeProxy is undefined");this.bridgeProxy=t,this.config=e.getConfig(),this.logger=this.operatingContext.getLogger(),this.performanceClient=this.config.telemetry.client,this.browserCrypto=e.isBrowserEnvironment()?new cc(this.logger,this.performanceClient,!0):mt,this.eventHandler=new Pc(this.logger),this.browserStorage=this.operatingContext.isBrowserEnvironment()?new wc(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,this.performanceClient,this.eventHandler,Zn(this.config.auth)):Tc(this.config.auth.clientId,this.logger,this.performanceClient,this.eventHandler),this.nestedAppAuthAdapter=new Sl(this.config.auth.clientId,this.config.auth.clientCapabilities,this.browserCrypto,this.logger);const r=this.bridgeProxy.getAccountContext();this.currentAccountContext=r||null}static async createController(e){const t=new Rl(e);return Promise.resolve(t)}async initialize(e,t){const r=e?.correlationId||sa();return await this.browserStorage.initialize(r),Promise.resolve()}ensureValidRequest(e){return e?.correlationId?e:{...e,correlationId:this.browserCrypto.createNewGuid()}}async acquireTokenInteractive(t){const r=this.ensureValidRequest(t);this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_START,e.InteractionType.Popup,r);const n=this.performanceClient.startMeasurement(Qr.AcquireTokenPopup,r.correlationId);n?.add({nestedAppAuthRequest:!0});try{const o=this.nestedAppAuthAdapter.toNaaTokenRequest(r),i=At(),s=await this.bridgeProxy.getTokenInteractive(o),a={...this.nestedAppAuthAdapter.fromNaaTokenResponse(o,s,i)};try{await this.hydrateCache(a,t)}catch(e){this.logger.warningPii(`Failed to hydrate cache. Error: ${e}`,r.correlationId)}return this.currentAccountContext={homeAccountId:a.account.homeAccountId,environment:a.account.environment,tenantId:a.account.tenantId},this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Popup,a),n.add({accessTokenSize:a.accessToken.length,idTokenSize:a.idToken.length}),n.end({success:!0,requestId:a.requestId}),a}catch(t){const r=t instanceof Ce?t:this.nestedAppAuthAdapter.fromBridgeError(t);throw this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Popup,null,t),n.end({success:!1},t),r}}async acquireTokenSilentInternal(t){const r=this.ensureValidRequest(t);this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_START,e.InteractionType.Silent,r);const n=await this.acquireTokenFromCache(r);if(n)return this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,n),n;const o=this.performanceClient.startMeasurement(Qr.SsoSilent,r.correlationId);o?.increment({visibilityChangeCount:0}),o?.add({nestedAppAuthRequest:!0});try{const n=this.nestedAppAuthAdapter.toNaaTokenRequest(r),i=At(),s=await this.bridgeProxy.getTokenSilent(n),a=this.nestedAppAuthAdapter.fromNaaTokenResponse(n,s,i);try{await this.hydrateCache(a,t)}catch(e){this.logger.warningPii(`Failed to hydrate cache. Error: ${e}`,r.correlationId)}return this.currentAccountContext={homeAccountId:a.account.homeAccountId,environment:a.account.environment,tenantId:a.account.tenantId},this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,a),o?.add({accessTokenSize:a.accessToken.length,idTokenSize:a.idToken.length}),o?.end({success:!0,requestId:a.requestId}),a}catch(t){const r=t instanceof Ce?t:this.nestedAppAuthAdapter.fromBridgeError(t);throw this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null,t),o?.end({success:!1},t),r}}async acquireTokenFromCache(t){const r=this.performanceClient.startMeasurement(Qr.AcquireTokenSilent,t.correlationId);if(r?.add({nestedAppAuthRequest:!0}),t.claims)return this.logger.verbose("Claims are present in the request, skipping cache lookup"),null;if(t.forceRefresh)return this.logger.verbose("forceRefresh is set to true, skipping cache lookup"),null;let n=null;switch(t.cacheLookupPolicy||(t.cacheLookupPolicy=xs.Default),t.cacheLookupPolicy){case xs.Default:case xs.AccessToken:case xs.AccessTokenAndRefreshToken:n=await this.acquireTokenFromCacheInternal(t);break;default:return null}return n?(this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,n),r?.add({accessTokenSize:n?.accessToken.length,idTokenSize:n?.idToken.length}),r?.end({success:!0}),n):(this.logger.warning("Cached tokens are not found for the account, proceeding with silent token request."),this.eventHandler.emitEvent(vc.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null),r?.end({success:!1}),null)}async acquireTokenFromCacheInternal(e){const t=this.bridgeProxy.getAccountContext()||this.currentAccountContext;let r=null;const n=e.correlationId||this.browserCrypto.createNewGuid();if(t&&(r=kc(t,this.logger,this.browserStorage,n)),!r)return this.logger.verbose("No active account found, falling back to the host"),Promise.resolve(null);this.logger.verbose("active account found, attempting to acquire token silently");const o={...e,correlationId:e.correlationId||this.browserCrypto.createNewGuid(),authority:e.authority||r.environment,scopes:e.scopes?.length?e.scopes:[...h]},i=this.browserStorage.getTokenKeys(),s=this.browserStorage.getAccessToken(r,o,i,r.tenantId);if(!s)return this.logger.verbose("No cached access token found"),Promise.resolve(null);if(Et(s.cachedAt)||bt(s.expiresOn,this.config.system.tokenRenewalOffsetSeconds))return this.logger.verbose("Cached access token has expired"),Promise.resolve(null);const a=this.browserStorage.getIdToken(r,o.correlationId,i,r.tenantId,this.performanceClient);return a?this.nestedAppAuthAdapter.toAuthenticationResultFromCache(r,a,s,o,o.correlationId):(this.logger.verbose("No cached id token found"),Promise.resolve(null))}async acquireTokenPopup(e){return this.acquireTokenInteractive(e)}acquireTokenRedirect(e){throw El.createUnsupportedError()}async acquireTokenSilent(e){return this.acquireTokenSilentInternal(e)}acquireTokenByCode(e){throw El.createUnsupportedError()}acquireTokenNative(e,t,r){throw El.createUnsupportedError()}acquireTokenByRefreshToken(e,t){throw El.createUnsupportedError()}addEventCallback(e,t){return this.eventHandler.addEventCallback(e,t)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){throw El.createUnsupportedError()}removePerformanceCallback(e){throw El.createUnsupportedError()}enableAccountStorageEvents(){throw El.createUnsupportedError()}disableAccountStorageEvents(){throw El.createUnsupportedError()}getAllAccounts(e){const t=this.browserCrypto.createNewGuid();return Ac(this.logger,this.browserStorage,this.isBrowserEnv(),t,e)}getAccount(e){const t=this.browserCrypto.createNewGuid();return kc(e,this.logger,this.browserStorage,t)}getAccountByUsername(e){const t=this.browserCrypto.createNewGuid();return Sc(e,this.logger,this.browserStorage,t)}getAccountByHomeId(e){const t=this.browserCrypto.createNewGuid();return bc(e,this.logger,this.browserStorage,t)}getAccountByLocalId(e){const t=this.browserCrypto.createNewGuid();return Ec(e,this.logger,this.browserStorage,t)}setActiveAccount(e){const t=this.browserCrypto.createNewGuid();return Rc(e,this.browserStorage,t)}getActiveAccount(){const e=this.browserCrypto.createNewGuid();return _c(this.browserStorage,e)}handleRedirectPromise(e){return Promise.resolve(null)}loginPopup(e){return this.acquireTokenInteractive(e||Ls)}loginRedirect(e){throw El.createUnsupportedError()}logout(e){throw El.createUnsupportedError()}logoutRedirect(e){throw El.createUnsupportedError()}logoutPopup(e){throw El.createUnsupportedError()}ssoSilent(e){return this.acquireTokenSilentInternal(e)}getTokenCache(){throw El.createUnsupportedError()}getLogger(){return this.logger}setLogger(e){this.logger=e}initializeWrapperLibrary(e,t){}setNavigationClient(e){this.logger.warning("setNavigationClient is not supported in nested app auth")}getConfiguration(){return this.config}isBrowserEnv(){return this.operatingContext.isBrowserEnvironment()}getBrowserCrypto(){return this.browserCrypto}getPerformanceClient(){throw El.createUnsupportedError()}getRedirectResponse(){throw El.createUnsupportedError()}async clearCache(e){throw El.createUnsupportedError()}async hydrateCache(e,t){this.logger.verbose("hydrateCache called");const r=_r.createFromAccountInfo(e.account,e.cloudGraphHostName,e.msGraphHost);return await this.browserStorage.setAccount(r,e.correlationId),this.browserStorage.hydrateCache(e,t)}}async function _l(e){const t=new oc(e),r=new nc(e),n=[t.initialize(),r.initialize()];return await Promise.all(n),r.isAvailable()&&e.auth.supportsNestedAppAuth?Rl.createController(r):t.isAvailable()?kl.createController(t):null}class Pl{static async createPublicClientApplication(e){const t=await async function(e,t){const r=new oc(e);return await r.initialize(),kl.createController(r,t)}(e);return new Pl(e,t)}constructor(e,t){this.isBroker=!1,this.controller=t||new kl(new oc(e))}async initialize(e){return this.controller.initialize(e,this.isBroker)}async acquireTokenPopup(e){return this.controller.acquireTokenPopup(e)}acquireTokenRedirect(e){return this.controller.acquireTokenRedirect(e)}acquireTokenSilent(e){return this.controller.acquireTokenSilent(e)}acquireTokenByCode(e){return this.controller.acquireTokenByCode(e)}addEventCallback(e,t){return this.controller.addEventCallback(e,t)}removeEventCallback(e){return this.controller.removeEventCallback(e)}addPerformanceCallback(e){return this.controller.addPerformanceCallback(e)}removePerformanceCallback(e){return this.controller.removePerformanceCallback(e)}enableAccountStorageEvents(){this.controller.enableAccountStorageEvents()}disableAccountStorageEvents(){this.controller.disableAccountStorageEvents()}getAccount(e){return this.controller.getAccount(e)}getAccountByHomeId(e){return this.controller.getAccountByHomeId(e)}getAccountByLocalId(e){return this.controller.getAccountByLocalId(e)}getAccountByUsername(e){return this.controller.getAccountByUsername(e)}getAllAccounts(e){return this.controller.getAllAccounts(e)}handleRedirectPromise(e){return this.controller.handleRedirectPromise(e)}loginPopup(e){return this.controller.loginPopup(e)}loginRedirect(e){return this.controller.loginRedirect(e)}logout(e){return this.controller.logout(e)}logoutRedirect(e){return this.controller.logoutRedirect(e)}logoutPopup(e){return this.controller.logoutPopup(e)}ssoSilent(e){return this.controller.ssoSilent(e)}getTokenCache(){return this.controller.getTokenCache()}getLogger(){return this.controller.getLogger()}setLogger(e){this.controller.setLogger(e)}setActiveAccount(e){this.controller.setActiveAccount(e)}getActiveAccount(){return this.controller.getActiveAccount()}initializeWrapperLibrary(e,t){return this.controller.initializeWrapperLibrary(e,t)}setNavigationClient(e){this.controller.setNavigationClient(e)}getConfiguration(){return this.controller.getConfiguration()}async hydrateCache(e,t){return this.controller.hydrateCache(e,t)}clearCache(e){return this.controller.clearCache(e)}}async function Ml(e){const t=new Pl(e);return await t.initialize(),t}class Ol{constructor(e){this.initialized=!1,this.operatingContext=e,this.isBrowserEnvironment=this.operatingContext.isBrowserEnvironment(),this.config=e.getConfig(),this.logger=e.getLogger(),this.performanceClient=this.config.telemetry.client,this.browserCrypto=this.isBrowserEnvironment?new cc(this.logger,this.performanceClient):mt,this.eventHandler=new Pc(this.logger),this.browserStorage=this.isBrowserEnvironment?new wc(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,this.performanceClient,this.eventHandler,void 0):Tc(this.config.auth.clientId,this.logger,this.performanceClient,this.eventHandler)}getBrowserStorage(){return this.browserStorage}getAccount(e){return null}getAccountByHomeId(e){return null}getAccountByLocalId(e){return null}getAccountByUsername(e){return null}getAllAccounts(){return[]}initialize(){return this.initialized=!0,Promise.resolve()}acquireTokenPopup(e){return Na(this.initialized),qa(),{}}acquireTokenRedirect(e){return Na(this.initialized),qa(),Promise.resolve()}acquireTokenSilent(e){return Na(this.initialized),qa(),{}}acquireTokenByCode(e){return Na(this.initialized),qa(),{}}acquireTokenNative(e,t,r){return Na(this.initialized),qa(),{}}acquireTokenByRefreshToken(e,t){return Na(this.initialized),qa(),{}}addEventCallback(e,t){return null}removeEventCallback(e){}addPerformanceCallback(e){return Na(this.initialized),qa(),""}removePerformanceCallback(e){return Na(this.initialized),qa(),!0}enableAccountStorageEvents(){Na(this.initialized),qa()}disableAccountStorageEvents(){Na(this.initialized),qa()}handleRedirectPromise(e){return Na(this.initialized),Promise.resolve(null)}loginPopup(e){return Na(this.initialized),qa(),{}}loginRedirect(e){return Na(this.initialized),qa(),{}}logout(e){return Na(this.initialized),qa(),{}}logoutRedirect(e){return Na(this.initialized),qa(),{}}logoutPopup(e){return Na(this.initialized),qa(),{}}ssoSilent(e){return Na(this.initialized),qa(),{}}getTokenCache(){return Na(this.initialized),qa(),{}}getLogger(){return this.logger}setLogger(e){Na(this.initialized),qa()}setActiveAccount(e){Na(this.initialized),qa()}getActiveAccount(){return Na(this.initialized),qa(),null}initializeWrapperLibrary(e,t){this.browserStorage.setWrapperMetadata(e,t)}setNavigationClient(e){Na(this.initialized),qa()}getConfiguration(){return this.config}isBrowserEnv(){return Na(this.initialized),qa(),!0}getBrowserCrypto(){return Na(this.initialized),qa(),{}}getPerformanceClient(){return Na(this.initialized),qa(),{}}getRedirectResponse(){return Na(this.initialized),qa(),{}}async clearCache(e){Na(this.initialized),qa()}async hydrateCache(e,t){Na(this.initialized),qa()}}class ql extends ja{getId(){return ql.ID}getModuleName(){return ql.MODULE_NAME}async initialize(){return!0}}ql.MODULE_NAME="",ql.ID="UnknownOperatingContext";class Nl{static async createPublicClientApplication(e){const t=await _l(e);let r;return r=null!==t?new Nl(e,t):new Nl(e),r}constructor(e,t){if(this.configuration=e,t)this.controller=t;else{const t=new ql(e);this.controller=new Ol(t)}}async initialize(){if(this.controller instanceof Ol){const e=await _l(this.configuration);return null!==e&&(this.controller=e),this.controller.initialize()}return Promise.resolve()}async acquireTokenPopup(e){return this.controller.acquireTokenPopup(e)}acquireTokenRedirect(e){return this.controller.acquireTokenRedirect(e)}acquireTokenSilent(e){return this.controller.acquireTokenSilent(e)}acquireTokenByCode(e){return this.controller.acquireTokenByCode(e)}addEventCallback(e,t){return this.controller.addEventCallback(e,t)}removeEventCallback(e){return this.controller.removeEventCallback(e)}addPerformanceCallback(e){return this.controller.addPerformanceCallback(e)}removePerformanceCallback(e){return this.controller.removePerformanceCallback(e)}enableAccountStorageEvents(){this.controller.enableAccountStorageEvents()}disableAccountStorageEvents(){this.controller.disableAccountStorageEvents()}getAccount(e){return this.controller.getAccount(e)}getAccountByHomeId(e){return this.controller.getAccountByHomeId(e)}getAccountByLocalId(e){return this.controller.getAccountByLocalId(e)}getAccountByUsername(e){return this.controller.getAccountByUsername(e)}getAllAccounts(e){return this.controller.getAllAccounts(e)}handleRedirectPromise(e){return this.controller.handleRedirectPromise(e)}loginPopup(e){return this.controller.loginPopup(e)}loginRedirect(e){return this.controller.loginRedirect(e)}logout(e){return this.controller.logout(e)}logoutRedirect(e){return this.controller.logoutRedirect(e)}logoutPopup(e){return this.controller.logoutPopup(e)}ssoSilent(e){return this.controller.ssoSilent(e)}getTokenCache(){return this.controller.getTokenCache()}getLogger(){return this.controller.getLogger()}setLogger(e){this.controller.setLogger(e)}setActiveAccount(e){this.controller.setActiveAccount(e)}getActiveAccount(){return this.controller.getActiveAccount()}initializeWrapperLibrary(e,t){return this.controller.initializeWrapperLibrary(e,t)}setNavigationClient(e){this.controller.setNavigationClient(e)}getConfiguration(){return this.controller.getConfiguration()}async hydrateCache(e,t){return this.controller.hydrateCache(e,t)}clearCache(e){return this.controller.clearCache(e)}}const Ll={initialize:()=>Promise.reject(Aa(ya)),acquireTokenPopup:()=>Promise.reject(Aa(ya)),acquireTokenRedirect:()=>Promise.reject(Aa(ya)),acquireTokenSilent:()=>Promise.reject(Aa(ya)),acquireTokenByCode:()=>Promise.reject(Aa(ya)),getAllAccounts:()=>[],getAccount:()=>null,getAccountByHomeId:()=>null,getAccountByUsername:()=>null,getAccountByLocalId:()=>null,handleRedirectPromise:()=>Promise.reject(Aa(ya)),loginPopup:()=>Promise.reject(Aa(ya)),loginRedirect:()=>Promise.reject(Aa(ya)),logout:()=>Promise.reject(Aa(ya)),logoutRedirect:()=>Promise.reject(Aa(ya)),logoutPopup:()=>Promise.reject(Aa(ya)),ssoSilent:()=>Promise.reject(Aa(ya)),addEventCallback:()=>null,removeEventCallback:()=>{},addPerformanceCallback:()=>"",removePerformanceCallback:()=>!1,enableAccountStorageEvents:()=>{},disableAccountStorageEvents:()=>{},getTokenCache:()=>{throw Aa(ya)},getLogger:()=>{throw Aa(ya)},setLogger:()=>{},setActiveAccount:()=>{},getActiveAccount:()=>null,initializeWrapperLibrary:()=>{},setNavigationClient:()=>{},getConfiguration:()=>{throw Aa(ya)},hydrateCache:()=>Promise.reject(Aa(ya)),clearCache:()=>Promise.reject(Aa(ya))};function Ul(){let e;try{e=window[fs.SessionStorage];const t=e?.getItem("msal.browser.performance.enabled");if(1===Number(t))return Promise.resolve().then((function(){return Bl}))}catch(e){}}function Hl(){return"undefined"!=typeof window&&void 0!==window.performance&&"function"==typeof window.performance.now}function xl(e){if(e&&Hl())return Math.round(window.performance.now()-e)}class Dl{constructor(e,t){this.correlationId=t,this.measureName=Dl.makeMeasureName(e,t),this.startMark=Dl.makeStartMark(e,t),this.endMark=Dl.makeEndMark(e,t)}static makeMeasureName(e,t){return`msal.measure.${e}.${t}`}static makeStartMark(e,t){return`msal.start.${e}.${t}`}static makeEndMark(e,t){return`msal.end.${e}.${t}`}static supportsBrowserPerformance(){return"undefined"!=typeof window&&void 0!==window.performance&&"function"==typeof window.performance.mark&&"function"==typeof window.performance.measure&&"function"==typeof window.performance.clearMarks&&"function"==typeof window.performance.clearMeasures&&"function"==typeof window.performance.getEntriesByName}static flushMeasurements(e,t){if(Dl.supportsBrowserPerformance())try{t.forEach((t=>{const r=Dl.makeMeasureName(t.name,e);window.performance.getEntriesByName(r,"measure").length>0&&(window.performance.clearMeasures(r),window.performance.clearMarks(Dl.makeStartMark(r,e)),window.performance.clearMarks(Dl.makeEndMark(r,e)))}))}catch(e){}}startMeasurement(){if(Dl.supportsBrowserPerformance())try{window.performance.mark(this.startMark)}catch(e){}}endMeasurement(){if(Dl.supportsBrowserPerformance())try{window.performance.mark(this.endMark),window.performance.measure(this.measureName,this.startMark,this.endMark)}catch(e){}}flushMeasurement(){if(Dl.supportsBrowserPerformance())try{const e=window.performance.getEntriesByName(this.measureName,"measure");if(e.length>0){const t=e[0].duration;return window.performance.clearMeasures(this.measureName),window.performance.clearMarks(this.startMark),window.performance.clearMarks(this.endMark),t}}catch(e){}return null}}var Bl=Object.freeze({__proto__:null,BrowserPerformanceMeasurement:Dl});e.AccountEntity=_r,e.ApiId=Os,e.AuthError=Ce,e.AuthErrorCodes=me,e.AuthErrorMessage=ye,e.AuthenticationHeaderParser=class{constructor(e){this.headers=e}getShrNonce(){const e=this.headers[y];if(e){const t=this.parseChallenges(e);if(t.nextnonce)return t.nextnonce;throw mr(ir)}const t=this.headers[f];if(t){const e=this.parseChallenges(t);if(e.nonce)return e.nonce;throw mr(ir)}throw mr(or)}parseChallenges(e){const r=e.indexOf(" "),n=e.substr(r+1).split(","),o={};return n.forEach((e=>{const[r,n]=e.split("=");o[r]=unescape(n.replace(/['"]+/g,t.EMPTY_STRING))})),o}}
/*! @azure/msal-common v15.9.0 2025-07-23 */,e.AuthenticationScheme=W,e.AzureCloudInstance=wt,e.BrowserAuthError=Ji,e.BrowserAuthErrorCodes=Qi,e.BrowserAuthErrorMessage=Vi,e.BrowserCacheLocation=fs,e.BrowserConfigurationAuthError=Ta,e.BrowserConfigurationAuthErrorCodes=va,e.BrowserConfigurationAuthErrorMessage=Ia,e.BrowserPerformanceClient=class extends Wo{constructor(e,r,n){super(e.auth.clientId,e.auth.authority||`${t.DEFAULT_AUTHORITY}`,new yt(e.system?.loggerOptions||{},$a,Qa),$a,Qa,e.telemetry?.application||{appName:"",appVersion:""},r,n)}generateId(){return sa()}getPageVisibility(){return document.visibilityState?.toString()||null}deleteIncompleteSubMeasurements(e){Ul()?.then((t=>{const r=this.eventsByCorrelationId.get(e.event.correlationId),n=r&&r.eventId===e.event.eventId,o=[];n&&r?.incompleteSubMeasurements&&r.incompleteSubMeasurements.forEach((e=>{o.push({...e})})),t.BrowserPerformanceMeasurement.flushMeasurements(e.event.correlationId,o)}))}startMeasurement(e,t){const r=this.getPageVisibility(),n=super.startMeasurement(e,t),o=Hl()?window.performance.now():void 0,i=Ul()?.then((t=>new t.BrowserPerformanceMeasurement(e,n.event.correlationId)));return i?.then((e=>e.startMeasurement())),{...n,end:(e,t)=>{const s=n.end({...e,startPageVisibility:r,endPageVisibility:this.getPageVisibility(),durationMs:xl(o)},t);return i?.then((e=>e.endMeasurement())),this.deleteIncompleteSubMeasurements(n),s},discard:()=>{n.discard(),i?.then((e=>e.flushMeasurement())),this.deleteIncompleteSubMeasurements(n)}}}setPreQueueTime(e,t){if(!Hl())return void this.logger.trace(`BrowserPerformanceClient: window performance API not available, unable to set telemetry queue time for ${e}`);if(!t)return void this.logger.trace(`BrowserPerformanceClient: correlationId for ${e} not provided, unable to set telemetry queue time`);const r=this.preQueueTimeByCorrelationId.get(t);r&&(this.logger.trace(`BrowserPerformanceClient: Incomplete pre-queue ${r.name} found`,t),this.addQueueMeasurement(r.name,t,void 0,!0)),this.preQueueTimeByCorrelationId.set(t,{name:e,time:window.performance.now()})}addQueueMeasurement(e,t,r,n){if(!Hl())return void this.logger.trace(`BrowserPerformanceClient: window performance API not available, unable to add queue measurement for ${e}`);if(!t)return void this.logger.trace(`BrowserPerformanceClient: correlationId for ${e} not provided, unable to add queue measurement`);const o=super.getPreQueueTime(e,t);if(!o)return;const i=window.performance.now(),s=r||super.calculateQueuedTime(o,i);return super.addQueueMeasurement(e,t,s,n)}},e.BrowserPerformanceMeasurement=Dl,e.BrowserUtils=Da,e.CacheLookupPolicy=xs,e.ClientAuthError=gt,e.ClientAuthErrorCodes=ht,e.ClientAuthErrorMessage=ut,e.ClientConfigurationError=pr,e.ClientConfigurationErrorCodes=dr,e.ClientConfigurationErrorMessage=gr,e.DEFAULT_IFRAME_TIMEOUT_MS=Ga,e.EventHandler=Pc,e.EventMessageUtils=class{static getInteractionStatusFromEvent(t,r){switch(t.eventType){case vc.LOGIN_START:return Ns.Login;case vc.SSO_SILENT_START:return Ns.SsoSilent;case vc.ACQUIRE_TOKEN_START:if(t.interactionType===e.InteractionType.Redirect||t.interactionType===e.InteractionType.Popup)return Ns.AcquireToken;break;case vc.HANDLE_REDIRECT_START:return Ns.HandleRedirect;case vc.LOGOUT_START:return Ns.Logout;case vc.SSO_SILENT_SUCCESS:case vc.SSO_SILENT_FAILURE:if(r&&r!==Ns.SsoSilent)break;return Ns.None;case vc.LOGOUT_END:if(r&&r!==Ns.Logout)break;return Ns.None;case vc.HANDLE_REDIRECT_END:if(r&&r!==Ns.HandleRedirect)break;return Ns.None;case vc.LOGIN_SUCCESS:case vc.LOGIN_FAILURE:case vc.ACQUIRE_TOKEN_SUCCESS:case vc.ACQUIRE_TOKEN_FAILURE:case vc.RESTORE_FROM_BFCACHE:if(t.interactionType===e.InteractionType.Redirect||t.interactionType===e.InteractionType.Popup){if(r&&r!==Ns.Login&&r!==Ns.AcquireToken)break;return Ns.None}}return null}},e.EventType=vc,e.InteractionRequiredAuthError=Io,e.InteractionRequiredAuthErrorCodes=fo,e.InteractionRequiredAuthErrorMessage=wo,e.InteractionStatus=Ns,e.JsonWebTokenTypes=ue,e.LocalStorage=yc,e.Logger=yt,e.MemoryStorage=sc,e.NavigationClient=Ba,e.OIDC_DEFAULT_SCOPES=h,e.PerformanceEvents=Qr,e.PromptValue=b,e.ProtocolMode=Rr,e.PublicClientApplication=Pl,e.PublicClientNext=Nl,e.ServerError=to,e.ServerResponseType=_,e.SessionStorage=Cc,e.SignedHttpRequest=class{constructor(e,t){const r=t&&t.loggerOptions||{};this.logger=new yt(r,$a,Qa),this.cryptoOps=new cc(this.logger),this.popTokenGenerator=new bo(this.cryptoOps),this.shrParameters=e}async generatePublicKeyThumbprint(){const{kid:e}=await this.popTokenGenerator.generateKid(this.shrParameters);return e}async signRequest(e,t,r){return this.popTokenGenerator.signPayload(e,t,this.shrParameters,r)}async removeKeys(e){return this.cryptoOps.removeTokenBindingKey(e).then((()=>!0)).catch((e=>{if(e instanceof gt&&e.errorCode===rt)return!1;throw e}))}},e.StringUtils=fr,e.StubPerformanceClient=Xr,e.UrlString=qr,e.WrapperSKU={React:"@azure/msal-react",Angular:"@azure/msal-angular"},e.createNestablePublicClientApplication=async function(e){const t=new nc(e);if(await t.initialize(),t.isAvailable()){const r=new Rl(t),n=new Pl(e,r);return await n.initialize(),n}return Ml(e)},e.createStandardPublicClientApplication=Ml,e.isPlatformBrokerAvailable=async function(e,t,r){const n=new yt(e||{},$a,Qa);n.trace("isPlatformBrokerAvailable called");const o=t||new Xr;return"undefined"==typeof window?(n.trace("Non-browser environment detected, returning false"),!1):!!await il(n,o,r||sa())},e.stubbedPublicClientApplication=Ll,e.version=Qa}));
