/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import org.a11y.brlapi.ConnectionBase;
import org.a11y.brlapi.OperandException;
import org.a11y.brlapi.ParameterComponent;
import org.a11y.brlapi.ParameterWatcher;
import org.a11y.brlapi.Parse;
import org.a11y.brlapi.SemanticException;
import org.a11y.brlapi.Strings;
import org.a11y.brlapi.SyntaxException;

public abstract class Parameter
extends ParameterComponent {
    private final ConnectionBase clientConnection;
    private String parameterLabel = null;
    private String parameterName = null;

    protected Parameter(ConnectionBase connectionBase) {
        this.clientConnection = connectionBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabel() {
        Parameter parameter = this;
        synchronized (parameter) {
            if (this.parameterLabel == null) {
                this.parameterLabel = Strings.wordify(Strings.replaceAll(this.getClass().getSimpleName(), "Parameter$", ""));
            }
        }
        return this.parameterLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Parameter parameter = this;
        synchronized (parameter) {
            if (this.parameterName == null) {
                this.parameterName = Parameter.toOperandName(this.getLabel());
            }
        }
        return this.parameterName;
    }

    public abstract int getParameter();

    public abstract boolean isGlobal();

    public boolean isHidable() {
        return false;
    }

    protected final Object getValue(long l) {
        return this.clientConnection.getParameter(this.getParameter(), l, this.isGlobal());
    }

    protected final Object getValue() {
        return this.getValue(0L);
    }

    protected final void setValue(long l, Object object) {
        this.clientConnection.setParameter(this.getParameter(), l, this.isGlobal(), object);
    }

    public Object get(long l) {
        return null;
    }

    public String toString(long l) {
        return Parameter.toString(this.get(l));
    }

    public Object get() {
        return this.get(0L);
    }

    public String toString() {
        return Parameter.toString(this.get());
    }

    public final boolean isSettable() {
        return this instanceof Settable;
    }

    protected final String getParseDescription() {
        return this.getName() + " value";
    }

    public void set(long l, String string) throws OperandException {
        if (!this.isSettable()) {
            throw new SemanticException("parameter is not settable: %s", this.getName());
        }
        if (this instanceof StringSettable) {
            StringSettable stringSettable = (StringSettable)((Object)this);
            stringSettable.set(l, string);
            return;
        }
        if (this instanceof BooleanSettable) {
            BooleanSettable booleanSettable = (BooleanSettable)((Object)this);
            booleanSettable.set(l, Parse.asBoolean(this.getParseDescription(), string));
            return;
        }
        if (this instanceof ByteSettable) {
            ByteSettable byteSettable = (ByteSettable)((Object)this);
            byteSettable.set(l, Parse.asByte(this.getParseDescription(), string, byteSettable.getMinimum(), byteSettable.getMaximum()));
            return;
        }
        if (this instanceof ShortSettable) {
            ShortSettable shortSettable = (ShortSettable)((Object)this);
            shortSettable.set(l, Parse.asShort(this.getParseDescription(), string, shortSettable.getMinimum(), shortSettable.getMaximum()));
            return;
        }
        if (this instanceof IntSettable) {
            IntSettable intSettable = (IntSettable)((Object)this);
            intSettable.set(l, Parse.asInt(this.getParseDescription(), string, intSettable.getMinimum(), intSettable.getMaximum()));
            return;
        }
        if (this instanceof LongSettable) {
            LongSettable longSettable = (LongSettable)((Object)this);
            longSettable.set(l, Parse.asLong(this.getParseDescription(), string, longSettable.getMinimum(), longSettable.getMaximum()));
            return;
        }
        Class clazz = Settable.class;
        for (Class<?> clazz2 : this.getClass().getInterfaces()) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            clazz = clazz2;
            break;
        }
        throw new UnsupportedOperationException(String.format("set not supported: %s: %s", this.getName(), clazz.getSimpleName()));
    }

    public void set(String string) throws OperandException {
        this.set(0L, string);
    }

    public final WatcherHandle watch(long l, ParameterWatcher parameterWatcher) {
        return new WatcherHandle(this.clientConnection.watchParameter(this.getParameter(), l, this.isGlobal(), parameterWatcher));
    }

    public final WatcherHandle watch(ParameterWatcher parameterWatcher) {
        return this.watch(0L, parameterWatcher);
    }

    public static interface Settable {
    }

    public static interface StringSettable
    extends Settable {
        public void set(long var1, String var3) throws SyntaxException;
    }

    public static interface BooleanSettable
    extends Settable {
        public void set(long var1, boolean var3);
    }

    public static interface ByteSettable
    extends Settable {
        public void set(long var1, byte var3);

        default public byte getMinimum() {
            return 0;
        }

        default public byte getMaximum() {
            return 127;
        }
    }

    public static interface ShortSettable
    extends Settable {
        public void set(long var1, short var3);

        default public short getMinimum() {
            return 0;
        }

        default public short getMaximum() {
            return Short.MAX_VALUE;
        }
    }

    public static interface IntSettable
    extends Settable {
        public void set(long var1, int var3);

        default public int getMinimum() {
            return 0;
        }

        default public int getMaximum() {
            return Integer.MAX_VALUE;
        }
    }

    public static interface LongSettable
    extends Settable {
        public void set(long var1, long var3);

        default public long getMinimum() {
            return 0L;
        }

        default public long getMaximum() {
            return Long.MAX_VALUE;
        }
    }

    public static final class WatcherHandle
    implements AutoCloseable {
        private long watchIdentifier;

        private WatcherHandle(long l) {
            this.watchIdentifier = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            WatcherHandle watcherHandle = this;
            synchronized (watcherHandle) {
                if (this.watchIdentifier != 0L) {
                    ConnectionBase.unwatchParameter(this.watchIdentifier);
                    this.watchIdentifier = 0L;
                }
            }
        }
    }
}

