﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace ConfigService
{
namespace Model
{
  enum class ResourceType
  {
    NOT_SET,
    AWS_EC2_CustomerGateway,
    AWS_EC2_EIP,
    AWS_EC2_Host,
    AWS_EC2_Instance,
    AWS_EC2_InternetGateway,
    AWS_EC2_NetworkAcl,
    AWS_EC2_NetworkInterface,
    AWS_EC2_RouteTable,
    AWS_EC2_SecurityGroup,
    AWS_EC2_Subnet,
    AWS_CloudTrail_Trail,
    AWS_EC2_Volume,
    AWS_EC2_VPC,
    AWS_EC2_VPNConnection,
    AWS_EC2_VPNGateway,
    AWS_EC2_RegisteredHAInstance,
    AWS_EC2_NatGateway,
    AWS_EC2_EgressOnlyInternetGateway,
    AWS_EC2_VPCEndpoint,
    AWS_EC2_VPCEndpointService,
    AWS_EC2_FlowLog,
    AWS_EC2_VPCPeeringConnection,
    AWS_Elasticsearch_Domain,
    AWS_IAM_Group,
    AWS_IAM_Policy,
    AWS_IAM_Role,
    AWS_IAM_User,
    AWS_ElasticLoadBalancingV2_LoadBalancer,
    AWS_ACM_Certificate,
    AWS_RDS_DBInstance,
    AWS_RDS_DBSubnetGroup,
    AWS_RDS_DBSecurityGroup,
    AWS_RDS_DBSnapshot,
    AWS_RDS_DBCluster,
    AWS_RDS_DBClusterSnapshot,
    AWS_RDS_EventSubscription,
    AWS_S3_Bucket,
    AWS_S3_AccountPublicAccessBlock,
    AWS_Redshift_Cluster,
    AWS_Redshift_ClusterSnapshot,
    AWS_Redshift_ClusterParameterGroup,
    AWS_Redshift_ClusterSecurityGroup,
    AWS_Redshift_ClusterSubnetGroup,
    AWS_Redshift_EventSubscription,
    AWS_SSM_ManagedInstanceInventory,
    AWS_CloudWatch_Alarm,
    AWS_CloudFormation_Stack,
    AWS_ElasticLoadBalancing_LoadBalancer,
    AWS_AutoScaling_AutoScalingGroup,
    AWS_AutoScaling_LaunchConfiguration,
    AWS_AutoScaling_ScalingPolicy,
    AWS_AutoScaling_ScheduledAction,
    AWS_DynamoDB_Table,
    AWS_CodeBuild_Project,
    AWS_WAF_RateBasedRule,
    AWS_WAF_Rule,
    AWS_WAF_RuleGroup,
    AWS_WAF_WebACL,
    AWS_WAFRegional_RateBasedRule,
    AWS_WAFRegional_Rule,
    AWS_WAFRegional_RuleGroup,
    AWS_WAFRegional_WebACL,
    AWS_CloudFront_Distribution,
    AWS_CloudFront_StreamingDistribution,
    AWS_Lambda_Function,
    AWS_NetworkFirewall_Firewall,
    AWS_NetworkFirewall_FirewallPolicy,
    AWS_NetworkFirewall_RuleGroup,
    AWS_ElasticBeanstalk_Application,
    AWS_ElasticBeanstalk_ApplicationVersion,
    AWS_ElasticBeanstalk_Environment,
    AWS_WAFv2_WebACL,
    AWS_WAFv2_RuleGroup,
    AWS_WAFv2_IPSet,
    AWS_WAFv2_RegexPatternSet,
    AWS_WAFv2_ManagedRuleSet,
    AWS_XRay_EncryptionConfig,
    AWS_SSM_AssociationCompliance,
    AWS_SSM_PatchCompliance,
    AWS_Shield_Protection,
    AWS_ShieldRegional_Protection,
    AWS_Config_ConformancePackCompliance,
    AWS_Config_ResourceCompliance,
    AWS_ApiGateway_Stage,
    AWS_ApiGateway_RestApi,
    AWS_ApiGatewayV2_Stage,
    AWS_ApiGatewayV2_Api,
    AWS_CodePipeline_Pipeline,
    AWS_ServiceCatalog_CloudFormationProvisionedProduct,
    AWS_ServiceCatalog_CloudFormationProduct,
    AWS_ServiceCatalog_Portfolio,
    AWS_SQS_Queue,
    AWS_KMS_Key,
    AWS_QLDB_Ledger,
    AWS_SecretsManager_Secret,
    AWS_SNS_Topic,
    AWS_SSM_FileData,
    AWS_Backup_BackupPlan,
    AWS_Backup_BackupSelection,
    AWS_Backup_BackupVault,
    AWS_Backup_RecoveryPoint,
    AWS_ECR_Repository,
    AWS_ECS_Cluster,
    AWS_ECS_Service,
    AWS_ECS_TaskDefinition,
    AWS_EFS_AccessPoint,
    AWS_EFS_FileSystem,
    AWS_EKS_Cluster,
    AWS_OpenSearch_Domain,
    AWS_EC2_TransitGateway,
    AWS_Kinesis_Stream,
    AWS_Kinesis_StreamConsumer,
    AWS_CodeDeploy_Application,
    AWS_CodeDeploy_DeploymentConfig,
    AWS_CodeDeploy_DeploymentGroup,
    AWS_EC2_LaunchTemplate,
    AWS_ECR_PublicRepository,
    AWS_GuardDuty_Detector,
    AWS_EMR_SecurityConfiguration,
    AWS_SageMaker_CodeRepository,
    AWS_Route53Resolver_ResolverEndpoint,
    AWS_Route53Resolver_ResolverRule,
    AWS_Route53Resolver_ResolverRuleAssociation,
    AWS_DMS_ReplicationSubnetGroup,
    AWS_DMS_EventSubscription,
    AWS_MSK_Cluster,
    AWS_StepFunctions_Activity,
    AWS_WorkSpaces_Workspace,
    AWS_WorkSpaces_ConnectionAlias,
    AWS_SageMaker_Model,
    AWS_ElasticLoadBalancingV2_Listener,
    AWS_StepFunctions_StateMachine,
    AWS_Batch_JobQueue,
    AWS_Batch_ComputeEnvironment,
    AWS_AccessAnalyzer_Analyzer,
    AWS_Athena_WorkGroup,
    AWS_Athena_DataCatalog,
    AWS_Detective_Graph,
    AWS_GlobalAccelerator_Accelerator,
    AWS_GlobalAccelerator_EndpointGroup,
    AWS_GlobalAccelerator_Listener,
    AWS_EC2_TransitGatewayAttachment,
    AWS_EC2_TransitGatewayRouteTable,
    AWS_DMS_Certificate,
    AWS_AppConfig_Application,
    AWS_AppSync_GraphQLApi,
    AWS_DataSync_LocationSMB,
    AWS_DataSync_LocationFSxLustre,
    AWS_DataSync_LocationS3,
    AWS_DataSync_LocationEFS,
    AWS_DataSync_Task,
    AWS_DataSync_LocationNFS,
    AWS_EC2_NetworkInsightsAccessScopeAnalysis,
    AWS_EKS_FargateProfile,
    AWS_Glue_Job,
    AWS_GuardDuty_ThreatIntelSet,
    AWS_GuardDuty_IPSet,
    AWS_SageMaker_Workteam,
    AWS_SageMaker_NotebookInstanceLifecycleConfig,
    AWS_ServiceDiscovery_Service,
    AWS_ServiceDiscovery_PublicDnsNamespace,
    AWS_SES_ContactList,
    AWS_SES_ConfigurationSet,
    AWS_Route53_HostedZone,
    AWS_IoTEvents_Input,
    AWS_IoTEvents_DetectorModel,
    AWS_IoTEvents_AlarmModel,
    AWS_ServiceDiscovery_HttpNamespace,
    AWS_Events_EventBus,
    AWS_ImageBuilder_ContainerRecipe,
    AWS_ImageBuilder_DistributionConfiguration,
    AWS_ImageBuilder_InfrastructureConfiguration,
    AWS_DataSync_LocationObjectStorage,
    AWS_DataSync_LocationHDFS,
    AWS_Glue_Classifier,
    AWS_Route53RecoveryReadiness_Cell,
    AWS_Route53RecoveryReadiness_ReadinessCheck,
    AWS_ECR_RegistryPolicy,
    AWS_Backup_ReportPlan,
    AWS_Lightsail_Certificate,
    AWS_RUM_AppMonitor,
    AWS_Events_Endpoint,
    AWS_SES_ReceiptRuleSet,
    AWS_Events_Archive,
    AWS_Events_ApiDestination,
    AWS_Lightsail_Disk,
    AWS_FIS_ExperimentTemplate,
    AWS_DataSync_LocationFSxWindows,
    AWS_SES_ReceiptFilter,
    AWS_GuardDuty_Filter,
    AWS_SES_Template,
    AWS_AmazonMQ_Broker,
    AWS_AppConfig_Environment,
    AWS_AppConfig_ConfigurationProfile,
    AWS_Cloud9_EnvironmentEC2,
    AWS_EventSchemas_Registry,
    AWS_EventSchemas_RegistryPolicy,
    AWS_EventSchemas_Discoverer,
    AWS_FraudDetector_Label,
    AWS_FraudDetector_EntityType,
    AWS_FraudDetector_Variable,
    AWS_FraudDetector_Outcome,
    AWS_IoT_Authorizer,
    AWS_IoT_SecurityProfile,
    AWS_IoT_RoleAlias,
    AWS_IoT_Dimension,
    AWS_IoTAnalytics_Datastore,
    AWS_Lightsail_Bucket,
    AWS_Lightsail_StaticIp,
    AWS_MediaPackage_PackagingGroup,
    AWS_Route53RecoveryReadiness_RecoveryGroup,
    AWS_ResilienceHub_ResiliencyPolicy,
    AWS_Transfer_Workflow,
    AWS_EKS_IdentityProviderConfig,
    AWS_EKS_Addon,
    AWS_Glue_MLTransform,
    AWS_IoT_Policy,
    AWS_IoT_MitigationAction,
    AWS_IoTTwinMaker_Workspace,
    AWS_IoTTwinMaker_Entity,
    AWS_IoTAnalytics_Dataset,
    AWS_IoTAnalytics_Pipeline,
    AWS_IoTAnalytics_Channel,
    AWS_IoTSiteWise_Dashboard,
    AWS_IoTSiteWise_Project,
    AWS_IoTSiteWise_Portal,
    AWS_IoTSiteWise_AssetModel,
    AWS_IVS_Channel,
    AWS_IVS_RecordingConfiguration,
    AWS_IVS_PlaybackKeyPair,
    AWS_KinesisAnalyticsV2_Application,
    AWS_RDS_GlobalCluster,
    AWS_S3_MultiRegionAccessPoint,
    AWS_DeviceFarm_TestGridProject,
    AWS_Budgets_BudgetsAction,
    AWS_Lex_Bot,
    AWS_CodeGuruReviewer_RepositoryAssociation,
    AWS_IoT_CustomMetric,
    AWS_Route53Resolver_FirewallDomainList,
    AWS_RoboMaker_RobotApplicationVersion,
    AWS_EC2_TrafficMirrorSession,
    AWS_IoTSiteWise_Gateway,
    AWS_Lex_BotAlias,
    AWS_LookoutMetrics_Alert,
    AWS_IoT_AccountAuditConfiguration,
    AWS_EC2_TrafficMirrorTarget,
    AWS_S3_StorageLens,
    AWS_IoT_ScheduledAudit,
    AWS_Events_Connection,
    AWS_EventSchemas_Schema,
    AWS_MediaPackage_PackagingConfiguration,
    AWS_KinesisVideo_SignalingChannel,
    AWS_AppStream_DirectoryConfig,
    AWS_LookoutVision_Project,
    AWS_Route53RecoveryControl_Cluster,
    AWS_Route53RecoveryControl_SafetyRule,
    AWS_Route53RecoveryControl_ControlPanel,
    AWS_Route53RecoveryControl_RoutingControl,
    AWS_Route53RecoveryReadiness_ResourceSet,
    AWS_RoboMaker_SimulationApplication,
    AWS_RoboMaker_RobotApplication,
    AWS_HealthLake_FHIRDatastore,
    AWS_Pinpoint_Segment,
    AWS_Pinpoint_ApplicationSettings,
    AWS_Events_Rule,
    AWS_EC2_DHCPOptions,
    AWS_EC2_NetworkInsightsPath,
    AWS_EC2_TrafficMirrorFilter,
    AWS_EC2_IPAM,
    AWS_IoTTwinMaker_Scene,
    AWS_NetworkManager_TransitGatewayRegistration,
    AWS_CustomerProfiles_Domain,
    AWS_AutoScaling_WarmPool,
    AWS_Connect_PhoneNumber,
    AWS_AppConfig_DeploymentStrategy,
    AWS_AppFlow_Flow,
    AWS_AuditManager_Assessment,
    AWS_CloudWatch_MetricStream,
    AWS_DeviceFarm_InstanceProfile,
    AWS_DeviceFarm_Project,
    AWS_EC2_EC2Fleet,
    AWS_EC2_SubnetRouteTableAssociation,
    AWS_ECR_PullThroughCacheRule,
    AWS_GroundStation_Config,
    AWS_ImageBuilder_ImagePipeline,
    AWS_IoT_FleetMetric,
    AWS_IoTWireless_ServiceProfile,
    AWS_NetworkManager_Device,
    AWS_NetworkManager_GlobalNetwork,
    AWS_NetworkManager_Link,
    AWS_NetworkManager_Site,
    AWS_Panorama_Package,
    AWS_Pinpoint_App,
    AWS_Redshift_ScheduledAction,
    AWS_Route53Resolver_FirewallRuleGroupAssociation,
    AWS_SageMaker_AppImageConfig,
    AWS_SageMaker_Image,
    AWS_ECS_TaskSet,
    AWS_Cassandra_Keyspace,
    AWS_Signer_SigningProfile,
    AWS_Amplify_App,
    AWS_AppMesh_VirtualNode,
    AWS_AppMesh_VirtualService,
    AWS_AppRunner_VpcConnector,
    AWS_AppStream_Application,
    AWS_CodeArtifact_Repository,
    AWS_EC2_PrefixList,
    AWS_EC2_SpotFleet,
    AWS_Evidently_Project,
    AWS_Forecast_Dataset,
    AWS_IAM_SAMLProvider,
    AWS_IAM_ServerCertificate,
    AWS_Pinpoint_Campaign,
    AWS_Pinpoint_InAppTemplate,
    AWS_SageMaker_Domain,
    AWS_Transfer_Agreement,
    AWS_Transfer_Connector,
    AWS_KinesisFirehose_DeliveryStream,
    AWS_Amplify_Branch,
    AWS_AppIntegrations_EventIntegration,
    AWS_AppMesh_Route,
    AWS_Athena_PreparedStatement,
    AWS_EC2_IPAMScope,
    AWS_Evidently_Launch,
    AWS_Forecast_DatasetGroup,
    AWS_GreengrassV2_ComponentVersion,
    AWS_GroundStation_MissionProfile,
    AWS_MediaConnect_FlowEntitlement,
    AWS_MediaConnect_FlowVpcInterface,
    AWS_MediaTailor_PlaybackConfiguration,
    AWS_MSK_Configuration,
    AWS_Personalize_Dataset,
    AWS_Personalize_Schema,
    AWS_Personalize_Solution,
    AWS_Pinpoint_EmailTemplate,
    AWS_Pinpoint_EventStream,
    AWS_ResilienceHub_App,
    AWS_ACMPCA_CertificateAuthority,
    AWS_AppConfig_HostedConfigurationVersion,
    AWS_AppMesh_VirtualGateway,
    AWS_AppMesh_VirtualRouter,
    AWS_AppRunner_Service,
    AWS_CustomerProfiles_ObjectType,
    AWS_DMS_Endpoint,
    AWS_EC2_CapacityReservation,
    AWS_EC2_ClientVpnEndpoint,
    AWS_Kendra_Index,
    AWS_KinesisVideo_Stream,
    AWS_Logs_Destination,
    AWS_Pinpoint_EmailChannel,
    AWS_S3_AccessPoint,
    AWS_NetworkManager_CustomerGatewayAssociation,
    AWS_NetworkManager_LinkAssociation,
    AWS_IoTWireless_MulticastGroup,
    AWS_Personalize_DatasetGroup,
    AWS_IoTTwinMaker_ComponentType,
    AWS_CodeBuild_ReportGroup,
    AWS_SageMaker_FeatureGroup,
    AWS_MSK_BatchScramSecret,
    AWS_AppStream_Stack,
    AWS_IoT_JobTemplate,
    AWS_IoTWireless_FuotaTask,
    AWS_IoT_ProvisioningTemplate,
    AWS_InspectorV2_Filter,
    AWS_Route53Resolver_ResolverQueryLoggingConfigAssociation,
    AWS_ServiceDiscovery_Instance,
    AWS_Transfer_Certificate,
    AWS_MediaConnect_FlowSource,
    AWS_APS_RuleGroupsNamespace,
    AWS_CodeGuruProfiler_ProfilingGroup,
    AWS_Route53Resolver_ResolverQueryLoggingConfig,
    AWS_Batch_SchedulingPolicy,
    AWS_ACMPCA_CertificateAuthorityActivation,
    AWS_AppMesh_GatewayRoute,
    AWS_AppMesh_Mesh,
    AWS_Connect_Instance,
    AWS_Connect_QuickConnect,
    AWS_EC2_CarrierGateway,
    AWS_EC2_IPAMPool,
    AWS_EC2_TransitGatewayConnect,
    AWS_EC2_TransitGatewayMulticastDomain,
    AWS_ECS_CapacityProvider,
    AWS_IAM_InstanceProfile,
    AWS_IoT_CACertificate,
    AWS_IoTTwinMaker_SyncJob,
    AWS_KafkaConnect_Connector,
    AWS_Lambda_CodeSigningConfig,
    AWS_NetworkManager_ConnectPeer,
    AWS_ResourceExplorer2_Index,
    AWS_AppStream_Fleet,
    AWS_Cognito_UserPool,
    AWS_Cognito_UserPoolClient,
    AWS_Cognito_UserPoolGroup,
    AWS_EC2_NetworkInsightsAccessScope,
    AWS_EC2_NetworkInsightsAnalysis,
    AWS_Grafana_Workspace,
    AWS_GroundStation_DataflowEndpointGroup,
    AWS_ImageBuilder_ImageRecipe,
    AWS_KMS_Alias,
    AWS_M2_Environment,
    AWS_QuickSight_DataSource,
    AWS_QuickSight_Template,
    AWS_QuickSight_Theme,
    AWS_RDS_OptionGroup,
    AWS_Redshift_EndpointAccess,
    AWS_Route53Resolver_FirewallRuleGroup,
    AWS_SSM_Document,
    AWS_AppConfig_ExtensionAssociation,
    AWS_AppIntegrations_Application,
    AWS_AppSync_ApiCache,
    AWS_Bedrock_Guardrail,
    AWS_Bedrock_KnowledgeBase,
    AWS_Cognito_IdentityPool,
    AWS_Connect_Rule,
    AWS_Connect_User,
    AWS_EC2_ClientVpnTargetNetworkAssociation,
    AWS_EC2_EIPAssociation,
    AWS_EC2_IPAMResourceDiscovery,
    AWS_EC2_IPAMResourceDiscoveryAssociation,
    AWS_EC2_InstanceConnectEndpoint,
    AWS_EC2_SnapshotBlockPublicAccess,
    AWS_EC2_VPCBlockPublicAccessExclusion,
    AWS_EC2_VPCBlockPublicAccessOptions,
    AWS_EC2_VPCEndpointConnectionNotification,
    AWS_EC2_VPNConnectionRoute,
    AWS_Evidently_Segment,
    AWS_IAM_OIDCProvider,
    AWS_InspectorV2_Activation,
    AWS_MSK_ClusterPolicy,
    AWS_MSK_VpcConnection,
    AWS_MediaConnect_Gateway,
    AWS_MemoryDB_SubnetGroup,
    AWS_OpenSearchServerless_Collection,
    AWS_OpenSearchServerless_VpcEndpoint,
    AWS_Redshift_EndpointAuthorization,
    AWS_Route53Profiles_Profile,
    AWS_S3_StorageLensGroup,
    AWS_S3Express_BucketPolicy,
    AWS_S3Express_DirectoryBucket,
    AWS_SageMaker_InferenceExperiment,
    AWS_SecurityHub_Standard,
    AWS_Transfer_Profile
  };

namespace ResourceTypeMapper
{
AWS_CONFIGSERVICE_API ResourceType GetResourceTypeForName(const Aws::String& name);

AWS_CONFIGSERVICE_API Aws::String GetNameForResourceType(ResourceType value);
} // namespace ResourceTypeMapper
} // namespace Model
} // namespace ConfigService
} // namespace Aws
