﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securitylake/SecurityLake_EXPORTS.h>
#include <aws/securitylake/SecurityLakeRequest.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securitylake/model/DataLakeConfiguration.h>
#include <utility>

namespace Aws
{
namespace SecurityLake
{
namespace Model
{

  /**
   */
  class UpdateDataLakeRequest : public SecurityLakeRequest
  {
  public:
    AWS_SECURITYLAKE_API UpdateDataLakeRequest() = default;

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "UpdateDataLake"; }

    AWS_SECURITYLAKE_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>Specifies the Region or Regions that will contribute data to the rollup
     * region.</p>
     */
    inline const Aws::Vector<DataLakeConfiguration>& GetConfigurations() const { return m_configurations; }
    inline bool ConfigurationsHasBeenSet() const { return m_configurationsHasBeenSet; }
    template<typename ConfigurationsT = Aws::Vector<DataLakeConfiguration>>
    void SetConfigurations(ConfigurationsT&& value) { m_configurationsHasBeenSet = true; m_configurations = std::forward<ConfigurationsT>(value); }
    template<typename ConfigurationsT = Aws::Vector<DataLakeConfiguration>>
    UpdateDataLakeRequest& WithConfigurations(ConfigurationsT&& value) { SetConfigurations(std::forward<ConfigurationsT>(value)); return *this;}
    template<typename ConfigurationsT = DataLakeConfiguration>
    UpdateDataLakeRequest& AddConfigurations(ConfigurationsT&& value) { m_configurationsHasBeenSet = true; m_configurations.emplace_back(std::forward<ConfigurationsT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) used to create and update the Glue table. This
     * table contains partitions generated by the ingestion and normalization of Amazon
     * Web Services log sources and custom sources.</p>
     */
    inline const Aws::String& GetMetaStoreManagerRoleArn() const { return m_metaStoreManagerRoleArn; }
    inline bool MetaStoreManagerRoleArnHasBeenSet() const { return m_metaStoreManagerRoleArnHasBeenSet; }
    template<typename MetaStoreManagerRoleArnT = Aws::String>
    void SetMetaStoreManagerRoleArn(MetaStoreManagerRoleArnT&& value) { m_metaStoreManagerRoleArnHasBeenSet = true; m_metaStoreManagerRoleArn = std::forward<MetaStoreManagerRoleArnT>(value); }
    template<typename MetaStoreManagerRoleArnT = Aws::String>
    UpdateDataLakeRequest& WithMetaStoreManagerRoleArn(MetaStoreManagerRoleArnT&& value) { SetMetaStoreManagerRoleArn(std::forward<MetaStoreManagerRoleArnT>(value)); return *this;}
    ///@}
  private:

    Aws::Vector<DataLakeConfiguration> m_configurations;
    bool m_configurationsHasBeenSet = false;

    Aws::String m_metaStoreManagerRoleArn;
    bool m_metaStoreManagerRoleArnHasBeenSet = false;
  };

} // namespace Model
} // namespace SecurityLake
} // namespace Aws
