﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/opensearch/OpenSearchService_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace OpenSearchService
{
namespace Model
{
  enum class RolesKeyIdCOption
  {
    NOT_SET,
    GroupName,
    GroupId
  };

namespace RolesKeyIdCOptionMapper
{
AWS_OPENSEARCHSERVICE_API RolesKeyIdCOption GetRolesKeyIdCOptionForName(const Aws::String& name);

AWS_OPENSEARCHSERVICE_API Aws::String GetNameForRolesKeyIdCOption(RolesKeyIdCOption value);
} // namespace RolesKeyIdCOptionMapper
} // namespace Model
} // namespace OpenSearchService
} // namespace Aws
