﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/DateTime.h>
#include <aws/inspector2/model/CvssScore.h>
#include <aws/inspector2/model/VulnerablePackage.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Inspector2
{
namespace Model
{

  /**
   * <p>Information about a package vulnerability finding.</p><p><h3>See Also:</h3>  
   * <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/PackageVulnerabilityDetails">AWS
   * API Reference</a></p>
   */
  class PackageVulnerabilityDetails
  {
  public:
    AWS_INSPECTOR2_API PackageVulnerabilityDetails() = default;
    AWS_INSPECTOR2_API PackageVulnerabilityDetails(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API PackageVulnerabilityDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>An object that contains details about the CVSS score of a finding.</p>
     */
    inline const Aws::Vector<CvssScore>& GetCvss() const { return m_cvss; }
    inline bool CvssHasBeenSet() const { return m_cvssHasBeenSet; }
    template<typename CvssT = Aws::Vector<CvssScore>>
    void SetCvss(CvssT&& value) { m_cvssHasBeenSet = true; m_cvss = std::forward<CvssT>(value); }
    template<typename CvssT = Aws::Vector<CvssScore>>
    PackageVulnerabilityDetails& WithCvss(CvssT&& value) { SetCvss(std::forward<CvssT>(value)); return *this;}
    template<typename CvssT = CvssScore>
    PackageVulnerabilityDetails& AddCvss(CvssT&& value) { m_cvssHasBeenSet = true; m_cvss.emplace_back(std::forward<CvssT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>One or more URLs that contain details about this vulnerability type.</p>
     */
    inline const Aws::Vector<Aws::String>& GetReferenceUrls() const { return m_referenceUrls; }
    inline bool ReferenceUrlsHasBeenSet() const { return m_referenceUrlsHasBeenSet; }
    template<typename ReferenceUrlsT = Aws::Vector<Aws::String>>
    void SetReferenceUrls(ReferenceUrlsT&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = std::forward<ReferenceUrlsT>(value); }
    template<typename ReferenceUrlsT = Aws::Vector<Aws::String>>
    PackageVulnerabilityDetails& WithReferenceUrls(ReferenceUrlsT&& value) { SetReferenceUrls(std::forward<ReferenceUrlsT>(value)); return *this;}
    template<typename ReferenceUrlsT = Aws::String>
    PackageVulnerabilityDetails& AddReferenceUrls(ReferenceUrlsT&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.emplace_back(std::forward<ReferenceUrlsT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>One or more vulnerabilities related to the one identified in this
     * finding.</p>
     */
    inline const Aws::Vector<Aws::String>& GetRelatedVulnerabilities() const { return m_relatedVulnerabilities; }
    inline bool RelatedVulnerabilitiesHasBeenSet() const { return m_relatedVulnerabilitiesHasBeenSet; }
    template<typename RelatedVulnerabilitiesT = Aws::Vector<Aws::String>>
    void SetRelatedVulnerabilities(RelatedVulnerabilitiesT&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = std::forward<RelatedVulnerabilitiesT>(value); }
    template<typename RelatedVulnerabilitiesT = Aws::Vector<Aws::String>>
    PackageVulnerabilityDetails& WithRelatedVulnerabilities(RelatedVulnerabilitiesT&& value) { SetRelatedVulnerabilities(std::forward<RelatedVulnerabilitiesT>(value)); return *this;}
    template<typename RelatedVulnerabilitiesT = Aws::String>
    PackageVulnerabilityDetails& AddRelatedVulnerabilities(RelatedVulnerabilitiesT&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.emplace_back(std::forward<RelatedVulnerabilitiesT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline const Aws::String& GetSource() const { return m_source; }
    inline bool SourceHasBeenSet() const { return m_sourceHasBeenSet; }
    template<typename SourceT = Aws::String>
    void SetSource(SourceT&& value) { m_sourceHasBeenSet = true; m_source = std::forward<SourceT>(value); }
    template<typename SourceT = Aws::String>
    PackageVulnerabilityDetails& WithSource(SourceT&& value) { SetSource(std::forward<SourceT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A URL to the source of the vulnerability information.</p>
     */
    inline const Aws::String& GetSourceUrl() const { return m_sourceUrl; }
    inline bool SourceUrlHasBeenSet() const { return m_sourceUrlHasBeenSet; }
    template<typename SourceUrlT = Aws::String>
    void SetSourceUrl(SourceUrlT&& value) { m_sourceUrlHasBeenSet = true; m_sourceUrl = std::forward<SourceUrlT>(value); }
    template<typename SourceUrlT = Aws::String>
    PackageVulnerabilityDetails& WithSourceUrl(SourceUrlT&& value) { SetSourceUrl(std::forward<SourceUrlT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The date and time that this vulnerability was first added to the vendor's
     * database.</p>
     */
    inline const Aws::Utils::DateTime& GetVendorCreatedAt() const { return m_vendorCreatedAt; }
    inline bool VendorCreatedAtHasBeenSet() const { return m_vendorCreatedAtHasBeenSet; }
    template<typename VendorCreatedAtT = Aws::Utils::DateTime>
    void SetVendorCreatedAt(VendorCreatedAtT&& value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt = std::forward<VendorCreatedAtT>(value); }
    template<typename VendorCreatedAtT = Aws::Utils::DateTime>
    PackageVulnerabilityDetails& WithVendorCreatedAt(VendorCreatedAtT&& value) { SetVendorCreatedAt(std::forward<VendorCreatedAtT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The severity the vendor has given to this vulnerability type.</p>
     */
    inline const Aws::String& GetVendorSeverity() const { return m_vendorSeverity; }
    inline bool VendorSeverityHasBeenSet() const { return m_vendorSeverityHasBeenSet; }
    template<typename VendorSeverityT = Aws::String>
    void SetVendorSeverity(VendorSeverityT&& value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity = std::forward<VendorSeverityT>(value); }
    template<typename VendorSeverityT = Aws::String>
    PackageVulnerabilityDetails& WithVendorSeverity(VendorSeverityT&& value) { SetVendorSeverity(std::forward<VendorSeverityT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The date and time the vendor last updated this vulnerability in their
     * database.</p>
     */
    inline const Aws::Utils::DateTime& GetVendorUpdatedAt() const { return m_vendorUpdatedAt; }
    inline bool VendorUpdatedAtHasBeenSet() const { return m_vendorUpdatedAtHasBeenSet; }
    template<typename VendorUpdatedAtT = Aws::Utils::DateTime>
    void SetVendorUpdatedAt(VendorUpdatedAtT&& value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt = std::forward<VendorUpdatedAtT>(value); }
    template<typename VendorUpdatedAtT = Aws::Utils::DateTime>
    PackageVulnerabilityDetails& WithVendorUpdatedAt(VendorUpdatedAtT&& value) { SetVendorUpdatedAt(std::forward<VendorUpdatedAtT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID given to this vulnerability.</p>
     */
    inline const Aws::String& GetVulnerabilityId() const { return m_vulnerabilityId; }
    inline bool VulnerabilityIdHasBeenSet() const { return m_vulnerabilityIdHasBeenSet; }
    template<typename VulnerabilityIdT = Aws::String>
    void SetVulnerabilityId(VulnerabilityIdT&& value) { m_vulnerabilityIdHasBeenSet = true; m_vulnerabilityId = std::forward<VulnerabilityIdT>(value); }
    template<typename VulnerabilityIdT = Aws::String>
    PackageVulnerabilityDetails& WithVulnerabilityId(VulnerabilityIdT&& value) { SetVulnerabilityId(std::forward<VulnerabilityIdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The packages impacted by this vulnerability.</p>
     */
    inline const Aws::Vector<VulnerablePackage>& GetVulnerablePackages() const { return m_vulnerablePackages; }
    inline bool VulnerablePackagesHasBeenSet() const { return m_vulnerablePackagesHasBeenSet; }
    template<typename VulnerablePackagesT = Aws::Vector<VulnerablePackage>>
    void SetVulnerablePackages(VulnerablePackagesT&& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages = std::forward<VulnerablePackagesT>(value); }
    template<typename VulnerablePackagesT = Aws::Vector<VulnerablePackage>>
    PackageVulnerabilityDetails& WithVulnerablePackages(VulnerablePackagesT&& value) { SetVulnerablePackages(std::forward<VulnerablePackagesT>(value)); return *this;}
    template<typename VulnerablePackagesT = VulnerablePackage>
    PackageVulnerabilityDetails& AddVulnerablePackages(VulnerablePackagesT&& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages.emplace_back(std::forward<VulnerablePackagesT>(value)); return *this; }
    ///@}
  private:

    Aws::Vector<CvssScore> m_cvss;
    bool m_cvssHasBeenSet = false;

    Aws::Vector<Aws::String> m_referenceUrls;
    bool m_referenceUrlsHasBeenSet = false;

    Aws::Vector<Aws::String> m_relatedVulnerabilities;
    bool m_relatedVulnerabilitiesHasBeenSet = false;

    Aws::String m_source;
    bool m_sourceHasBeenSet = false;

    Aws::String m_sourceUrl;
    bool m_sourceUrlHasBeenSet = false;

    Aws::Utils::DateTime m_vendorCreatedAt{};
    bool m_vendorCreatedAtHasBeenSet = false;

    Aws::String m_vendorSeverity;
    bool m_vendorSeverityHasBeenSet = false;

    Aws::Utils::DateTime m_vendorUpdatedAt{};
    bool m_vendorUpdatedAtHasBeenSet = false;

    Aws::String m_vulnerabilityId;
    bool m_vulnerabilityIdHasBeenSet = false;

    Aws::Vector<VulnerablePackage> m_vulnerablePackages;
    bool m_vulnerablePackagesHasBeenSet = false;
  };

} // namespace Model
} // namespace Inspector2
} // namespace Aws
