/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;

public class Region
extends Area {
    public Region() {
    }

    public Region(Rect rect) {
        super(new Rectangle(rect.tl.x, rect.tl.y, rect.width(), rect.height()));
    }

    public Region(Region region) {
        super(region);
    }

    public void clear() {
        this.reset();
    }

    public void reset(Rect rect) {
        if (rect.is_empty()) {
            this.clear();
        } else {
            this.clear();
            this.assign_union(new Region(rect));
        }
    }

    public void translate(Point point) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(point.x, point.y);
        this.transform(affineTransform);
    }

    public void assign_intersect(Region region) {
        super.intersect(region);
    }

    public void assign_union(Region region) {
        super.add(region);
    }

    public void assign_subtract(Region region) {
        super.subtract(region);
    }

    public Region intersect(Region region) {
        Region region2 = new Region(this);
        region2.intersect((Area)region);
        return region2;
    }

    public Region union(Region region) {
        Region region2 = new Region(this);
        region2.add(region);
        return region2;
    }

    public Region subtract(Region region) {
        Region region2 = new Region(this);
        region2.subtract((Area)region);
        return region2;
    }

    public boolean is_empty() {
        return this.isEmpty();
    }

    public Rect get_bounding_rect() {
        Rectangle rectangle = this.getBounds();
        return new Rect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }
}

