/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.mrtree.options.EdgeRoutingMode;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.alg.mrtree.options.OrderWeighting;
import org.eclipse.elk.alg.mrtree.options.TreeifyingOrder;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class MrTreeMetaDataProvider
implements ILayoutMetaDataProvider {
    private static final boolean COMPACTION_DEFAULT = false;
    public static final IProperty<Boolean> COMPACTION = new Property<Boolean>("org.eclipse.elk.mrtree.compaction", false, null, null);
    private static final double EDGE_END_TEXTURE_LENGTH_DEFAULT = 7.0;
    public static final IProperty<Double> EDGE_END_TEXTURE_LENGTH = new Property<Double>("org.eclipse.elk.mrtree.edgeEndTextureLength", 7.0, null, null);
    private static final int TREE_LEVEL_DEFAULT = 0;
    private static final Comparable<? super Integer> TREE_LEVEL_LOWER_BOUND = 0;
    public static final IProperty<Integer> TREE_LEVEL = new Property<Integer>("org.eclipse.elk.mrtree.treeLevel", Integer.valueOf(0), TREE_LEVEL_LOWER_BOUND, null);
    private static final int POSITION_CONSTRAINT_DEFAULT = -1;
    public static final IProperty<Integer> POSITION_CONSTRAINT = new Property<Integer>("org.eclipse.elk.mrtree.positionConstraint", -1, null, null);
    private static final OrderWeighting WEIGHTING_DEFAULT = OrderWeighting.MODEL_ORDER;
    public static final IProperty<OrderWeighting> WEIGHTING = new Property<OrderWeighting>("org.eclipse.elk.mrtree.weighting", WEIGHTING_DEFAULT, null, null);
    private static final EdgeRoutingMode EDGE_ROUTING_MODE_DEFAULT = EdgeRoutingMode.AVOID_OVERLAP;
    public static final IProperty<EdgeRoutingMode> EDGE_ROUTING_MODE = new Property<EdgeRoutingMode>("org.eclipse.elk.mrtree.edgeRoutingMode", EDGE_ROUTING_MODE_DEFAULT, null, null);
    private static final TreeifyingOrder SEARCH_ORDER_DEFAULT = TreeifyingOrder.DFS;
    public static final IProperty<TreeifyingOrder> SEARCH_ORDER = new Property<TreeifyingOrder>("org.eclipse.elk.mrtree.searchOrder", SEARCH_ORDER_DEFAULT, null, null);

    @Override
    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.mrtree.compaction").group("").name("Position Constraint").description("Turns on Tree compaction which decreases the size of the whole tree by placing nodes of multiple levels in one large level").defaultValue(false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.mrtree.edgeEndTextureLength").group("").name("Edge End Texture Length").description("Should be set to the length of the texture at the end of an edge. This value can be used to improve the Edge Routing.").defaultValue(7.0).type(LayoutOptionData.Type.DOUBLE).optionClass(Double.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.mrtree.treeLevel").group("").name("Tree Level").description("The index for the tree level the node is in").defaultValue(0).lowerBound(TREE_LEVEL_LOWER_BOUND).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.HIDDEN).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.mrtree.positionConstraint").group("").name("Position Constraint").description("When set to a positive number this option will force the algorithm to place the node to the specified position within the trees layer if weighting is set to constraint").defaultValue(-1).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.mrtree.weighting").group("").name("Weighting of Nodes").description("Which weighting to use when computing a node order.").defaultValue((Object)WEIGHTING_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(OrderWeighting.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.mrtree.edgeRoutingMode").group("").name("Edge Routing Mode").description("Chooses an Edge Routing algorithm.").defaultValue((Object)EDGE_ROUTING_MODE_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(EdgeRoutingMode.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.mrtree.searchOrder").group("").name("Search Order").description("Which search order to use when computing a spanning tree.").defaultValue((Object)SEARCH_ORDER_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(TreeifyingOrder.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        new MrTreeOptions().apply(registry);
    }
}

