/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityFactory;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.dot.Neighborhood;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ISkinParam;

public final class DotData {
    private final EntityFactory entityFactory;
    private final List<Link> links;
    private final Collection<Entity> leafs;
    private final GroupHierarchy groupHierarchy;
    private final Entity topParent;
    private final PortionShower portionShower;

    public Entity getRootGroup() {
        return this.entityFactory.getRootGroup();
    }

    public boolean isDegeneratedWithFewEntities(int nb) {
        return this.entityFactory.groups().size() == 0 && this.getLinks().size() == 0 && this.getLeafs().size() == nb;
    }

    public final boolean isHideEmptyDescriptionForState() {
        return this.entityFactory.isHideEmptyDescriptionForState();
    }

    public UmlDiagramType getUmlDiagramType() {
        return this.entityFactory.getUmlDiagramType();
    }

    public ISkinParam getSkinParam() {
        return this.entityFactory.getSkinParam();
    }

    public DotData(EntityFactory entityFactory, Entity topParent, List<Link> links, Collection<Entity> leafs, GroupHierarchy groupHierarchy, PortionShower portionShower) {
        this.topParent = Objects.requireNonNull(topParent);
        this.links = links;
        this.leafs = leafs;
        this.groupHierarchy = groupHierarchy;
        this.portionShower = portionShower;
        this.entityFactory = entityFactory;
    }

    public GroupHierarchy getGroupHierarchy() {
        return this.groupHierarchy;
    }

    public List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public Collection<Entity> getLeafs() {
        return Collections.unmodifiableCollection(this.leafs);
    }

    public final Entity getTopParent() {
        return this.topParent;
    }

    public boolean isEmpty(Entity g2) {
        return this.groupHierarchy.isEmpty(g2);
    }

    public PortionShower getPortionShower() {
        return this.portionShower;
    }

    public void removeIrrelevantSametail() {
        HashMap<String, Integer> sametails = new HashMap<String, Integer>();
        for (Link link : this.links) {
            String sametail;
            if (link.getType().getDecor2().isExtendsLike()) {
                link.setSametail(link.getEntity1().getUid());
            }
            if ((sametail = link.getSametail()) == null) continue;
            Integer value = (Integer)sametails.get(sametail);
            sametails.put(sametail, value == null ? 1 : value + 1);
        }
        HashSet<String> toremove = new HashSet<String>();
        int limit = this.getSkinParam().groupInheritance();
        for (Map.Entry ent : sametails.entrySet()) {
            String key = (String)ent.getKey();
            if ((Integer)ent.getValue() < limit) {
                toremove.add(key);
                continue;
            }
            ArrayList<Link> some = new ArrayList<Link>();
            for (Link link : this.links) {
                if (!key.equals(link.getSametail())) continue;
                some.add(link);
            }
            Entity leaf = this.getLeaf(key);
            Neighborhood neighborhood = new Neighborhood(leaf, some, this.getLinksOfThisLeaf(leaf));
            leaf.setNeighborhood(neighborhood);
        }
        for (Link link : this.links) {
            String sametail = link.getSametail();
            if (sametail == null || !toremove.contains(sametail)) continue;
            link.setSametail(null);
        }
    }

    private List<Link> getLinksOfThisLeaf(Entity leaf) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.contains(leaf)) continue;
            result.add(link);
        }
        return result;
    }

    private Entity getLeaf(String key) {
        for (Entity entity : this.leafs) {
            if (!entity.getUid().equals(key)) continue;
            return entity;
        }
        return null;
    }
}

