/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.hyperparameter.param;

import ai.djl.training.hyperparameter.param.HpVal;
import ai.djl.training.hyperparameter.param.Hyperparameter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class HpSet
extends Hyperparameter<HpSet> {
    private Map<String, Hyperparameter<?>> hyperParams = new ConcurrentHashMap();

    public HpSet(String name, List<Hyperparameter<?>> hyperParams) {
        super(name);
        for (Hyperparameter<?> hparam : hyperParams) {
            this.add(hparam);
        }
    }

    public HpSet(String name) {
        super(name);
    }

    public void add(Hyperparameter<?> hparam) {
        this.hyperParams.put(hparam.getName(), hparam);
    }

    public Hyperparameter<?> getHParam(String name) {
        return this.hyperParams.get(name);
    }

    @Override
    public HpSet random() {
        HpSet rand = new HpSet(this.name);
        for (Hyperparameter<?> hparam : this.hyperParams.values()) {
            rand.add(new HpVal(hparam.getName(), hparam.random()));
        }
        return rand;
    }

    public String toString() {
        return "HPSet{hyperParams=" + this.hyperParams + ", name='" + this.name + '\'' + '}';
    }
}

