"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SQL_TRANSLATE_ROUTE = exports.SQL_QUERY_ROUTE = exports.PPL_TRANSLATE_ROUTE = exports.PPL_QUERY_ROUTE = exports.FORMAT_TEXT = exports.FORMAT_JSON = exports.FORMAT_CSV = exports.DEFAULT_HEADERS = exports.CLUSTER = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const SQL_TRANSLATE_ROUTE = exports.SQL_TRANSLATE_ROUTE = `/_plugins/_sql/_explain`;
const PPL_TRANSLATE_ROUTE = exports.PPL_TRANSLATE_ROUTE = `/_plugins/_ppl/_explain`;
const SQL_QUERY_ROUTE = exports.SQL_QUERY_ROUTE = `/_plugins/_sql`;
const PPL_QUERY_ROUTE = exports.PPL_QUERY_ROUTE = `/_plugins/_ppl`;
const FORMAT_CSV = exports.FORMAT_CSV = `format=csv`;
const FORMAT_JSON = exports.FORMAT_JSON = `format=json`;
const FORMAT_TEXT = exports.FORMAT_TEXT = `format=raw`;
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json'
};
const CLUSTER = exports.CLUSTER = {
  ADMIN: 'admin',
  SQL: 'opensearch-sql',
  DATA: 'data'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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