function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiPopover } from '../../../popover';
import { formatTimeString } from '../pretty_duration';
import { OuiDatePopoverContent } from './date_popover_content'; // eslint-disable-line import/named

export var OuiDatePopoverButton = function OuiDatePopoverButton(props) {
  var position = props.position,
      isDisabled = props.isDisabled,
      isInvalid = props.isInvalid,
      needsUpdating = props.needsUpdating,
      value = props.value,
      buttonProps = props.buttonProps,
      roundUp = props.roundUp,
      onChange = props.onChange,
      locale = props.locale,
      dateFormat = props.dateFormat,
      utcOffset = props.utcOffset,
      timeFormat = props.timeFormat,
      isOpen = props.isOpen,
      onPopoverToggle = props.onPopoverToggle,
      onPopoverClose = props.onPopoverClose,
      compressed = props.compressed,
      rest = _objectWithoutProperties(props, ["position", "isDisabled", "isInvalid", "needsUpdating", "value", "buttonProps", "roundUp", "onChange", "locale", "dateFormat", "utcOffset", "timeFormat", "isOpen", "onPopoverToggle", "onPopoverClose", "compressed"]);

  var classes = classNames(['ouiDatePopoverButton', "ouiDatePopoverButton--".concat(position), {
    'ouiDatePopoverButton-isSelected': isOpen,
    'ouiDatePopoverButton-isInvalid': isInvalid,
    'ouiDatePopoverButton-needsUpdating': needsUpdating,
    'ouiDatePopoverButton-disabled': isDisabled,
    'ouiDatePopoverButton-compressed': compressed
  }]);
  var title = value;

  if (isInvalid) {
    title = "Invalid date: ".concat(title);
  } else if (needsUpdating) {
    title = "Update needed: ".concat(title);
  }

  var button = /*#__PURE__*/React.createElement("button", _extends({
    onClick: onPopoverToggle,
    className: classes,
    title: title,
    disabled: isDisabled,
    "data-test-subj": "superDatePicker".concat(position, "DatePopoverButton")
  }, buttonProps), formatTimeString(value, dateFormat, roundUp, locale));
  return /*#__PURE__*/React.createElement(OuiPopover, _extends({
    button: button,
    isOpen: isOpen,
    closePopover: onPopoverClose,
    anchorPosition: position === 'start' ? 'downLeft' : 'downRight',
    display: "block",
    panelPaddingSize: "none"
  }, rest), /*#__PURE__*/React.createElement(OuiDatePopoverContent, {
    value: value,
    roundUp: roundUp,
    onChange: onChange,
    dateFormat: dateFormat,
    timeFormat: timeFormat,
    locale: locale,
    position: position,
    utcOffset: utcOffset
  }));
};
OuiDatePopoverButton.propTypes = {
  className: PropTypes.string,
  buttonProps: PropTypes.any,
  dateFormat: PropTypes.string.isRequired,
  isDisabled: PropTypes.bool,
  isInvalid: PropTypes.bool,
  isOpen: PropTypes.bool.isRequired,
  needsUpdating: PropTypes.bool,
  locale: PropTypes.any,
  onChange: PropTypes.any.isRequired,
  onPopoverClose: PropTypes.func.isRequired,
  onPopoverToggle: PropTypes.func.isRequired,
  position: PropTypes.oneOf(["start", "end"]).isRequired,
  roundUp: PropTypes.bool,
  timeFormat: PropTypes.string.isRequired,
  value: PropTypes.string.isRequired,
  utcOffset: PropTypes.number,
  compressed: PropTypes.bool
};
OuiDatePopoverButton.displayName = 'OuiDatePopoverButton';
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */
export { EuiDatePopoverButton } from '../../../../eui_components/date_picker/super_date_picker/date_popover/date_popover_button';