/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.caching;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Optional;
import org.opensearch.ad.caching.ADCacheBuffer;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.ml.ADCheckpointDao;
import org.opensearch.ad.ratelimit.ADCheckpointMaintainWorker;
import org.opensearch.ad.ratelimit.ADCheckpointWriteWorker;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.MemoryTracker;
import org.opensearch.timeseries.caching.PriorityCache;
import org.opensearch.timeseries.caching.PriorityTracker;
import org.opensearch.timeseries.ml.ModelManager;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.ml.Sample;
import org.opensearch.timeseries.model.Config;

public class ADPriorityCache
extends PriorityCache<ThresholdedRandomCutForest, ADIndex, ADIndexManagement, ADCheckpointDao, ADCheckpointWriteWorker, ADCheckpointMaintainWorker, ADCacheBuffer> {
    private ADCheckpointWriteWorker checkpointWriteQueue;
    private ADCheckpointMaintainWorker checkpointMaintainQueue;

    public ADPriorityCache(ADCheckpointDao checkpointDao, int hcDedicatedCacheSize, Setting<TimeValue> checkpointTtl, int maxInactiveStates, MemoryTracker memoryTracker, int numberOfTrees, Clock clock, ClusterService clusterService, Duration modelTtl, ThreadPool threadPool, int maintenanceFreqConstant, Settings settings, Setting<TimeValue> checkpointSavingFreq, ADCheckpointWriteWorker checkpointWriteQueue, ADCheckpointMaintainWorker checkpointMaintainQueue) {
        super(checkpointDao, hcDedicatedCacheSize, checkpointTtl, maxInactiveStates, memoryTracker, numberOfTrees, clock, clusterService, modelTtl, threadPool, "ad-threadpool", maintenanceFreqConstant, settings, checkpointSavingFreq, MemoryTracker.Origin.REAL_TIME_DETECTOR, AnomalyDetectorSettings.AD_DEDICATED_CACHE_SIZE, AnomalyDetectorSettings.AD_MODEL_MAX_SIZE_PERCENTAGE);
        this.checkpointWriteQueue = checkpointWriteQueue;
        this.checkpointMaintainQueue = checkpointMaintainQueue;
    }

    @Override
    protected ADCacheBuffer createEmptyCacheBuffer(Config detector, long memoryConsumptionPerEntity, PriorityTracker tracker) {
        return new ADCacheBuffer(detector.isHighCardinality() ? this.hcDedicatedCacheSize : 1, this.clock, this.memoryTracker, this.checkpointIntervalHrs, this.modelTtl, memoryConsumptionPerEntity, this.checkpointWriteQueue, this.checkpointMaintainQueue, detector.getId(), tracker);
    }

    @Override
    protected ModelState<ThresholdedRandomCutForest> createEmptyModelState(String modelId, String detectorId) {
        return new ModelState<Object>(null, modelId, detectorId, ModelManager.ModelType.TRCF.getName(), this.clock, 0.0f, Optional.empty(), new ArrayDeque<Sample>());
    }

    @Override
    protected boolean isDoorKeeperInCacheEnabled() {
        return ADEnabledSetting.isDoorKeeperInCacheEnabled();
    }
}

