/**
 * SECTION:email-details
 * @short_description: Object representing a email address that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> for details on common parameter names and values.</para>
 *
 * Since: 0.6.0
 */
/**
 * FOLKS_TYPE_EMAIL_FIELD_DETAILS:
 * 
 * The type for <link linkend="FolksEmailFieldDetails"><type>FolksEmailFieldDetails</type></link>.
 */
/**
 * folks_email_field_details_new:
 * @value: (in): &nbsp;.  <para>the value of the field, which should be a valid, non-empty e-mail address </para>
 * @parameters: (in) (allow-none): &nbsp;.  <para>initial parameters. See <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link>. A <code>null</code> value is equivalent to an empty map of parameters. </para>
 * 
 * Create a new EmailFieldDetails.
 * 
 * Returns: <para>a new EmailFieldDetails </para>
 *
 * Since: 0.6.0
 */
/**
 * FolksEmailFieldDetails:
 * 
 * Object representing a email address that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> for details on common parameter names and values.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksEmailFieldDetailsClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-EMAIL-FIELD-DETAILS:CAPS"><literal>FOLKS_TYPE_EMAIL_FIELD_DETAILS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * folks_email_details_change_email_addresses:
 * @self: the <link linkend="FolksEmailDetails"><type>FolksEmailDetails</type></link> instance
 * @email_addresses: (in): &nbsp;.  <para>the new set of e-mail addresses </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s set of e-mail addresses.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksEmailDetails--email-addresses"><type>"email-addresses"</type></link> directly, as this method gives error notification and will only return once the e-mail addresses have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the e-mail addresses failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-email-details-change-email-addresses-finish"><function>folks_email_details_change_email_addresses_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_email_details_change_email_addresses_finish:
 * @self: the <link linkend="FolksEmailDetails"><type>FolksEmailDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s set of e-mail addresses.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksEmailDetails--email-addresses"><type>"email-addresses"</type></link> directly, as this method gives error notification and will only return once the e-mail addresses have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the e-mail addresses failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-email-details-change-email-addresses"><function>folks_email_details_change_email_addresses()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksEmailDetails:email-addresses:
 * 
 * The email addresses of the contact.
 * 
 * <para>Each of the values in this property contains just an e-mail address (e.g. “foo@bar.com”), rather than any other way of formatting an e-mail address (such as “John Smith &amp;lt;foo@bar.com&amp;gt;”).</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_email_details_get_email_addresses:
 * @self: the <link linkend="FolksEmailDetails"><type>FolksEmailDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksEmailDetails--email-addresses"><type>"email-addresses"</type></link> property.
 * 
 * The email addresses of the contact.
 * 
 * <para>Each of the values in this property contains just an e-mail address (e.g. “foo@bar.com”), rather than any other way of formatting an e-mail address (such as “John Smith &amp;lt;foo@bar.com&amp;gt;”).</para>
 * 
 * Returns: the value of the <link linkend="FolksEmailDetails--email-addresses"><type>"email-addresses"</type></link> property
 *
 * Since: 0.6.0
 */
/**
 * folks_email_details_set_email_addresses:
 * @self: the <link linkend="FolksEmailDetails"><type>FolksEmailDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksEmailDetails--email-addresses"><type>"email-addresses"</type></link> property
 * 
 * Set the value of the <link linkend="FolksEmailDetails--email-addresses"><type>"email-addresses"</type></link> property to @value.
 * 
 * The email addresses of the contact.
 * 
 * <para>Each of the values in this property contains just an e-mail address (e.g. “foo@bar.com”), rather than any other way of formatting an e-mail address (such as “John Smith &amp;lt;foo@bar.com&amp;gt;”).</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksEmailDetails:
 * 
 * Interface for classes that have email addresses, such as <link linkend="FolksPersona"><type>FolksPersona</type></link> and <link linkend="FolksIndividual"><type>FolksIndividual</type></link>.
 *
 * Since: 0.3.5
 */
/**
 * FolksEmailDetailsIface:
 * @change_email_addresses: virtual method called by <link linkend="folks-email-details-change-email-addresses"><function>folks_email_details_change_email_addresses()</function></link>
 * @change_email_addresses_finish: asynchronous finish function for <structfield>change_email_addresses</structfield>, called by <link linkend="folks-email-details-change-email-addresses"><function>folks_email_details_change_email_addresses()</function></link>
 * @get_email_addresses: getter method for the abstract property <link linkend="FolksEmailDetails--email-addresses"><type>"email-addresses"</type></link>
 * @set_email_addresses: setter method for the abstract property <link linkend="FolksEmailDetails--email-addresses"><type>"email-addresses"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksEmailDetails"><type>FolksEmailDetails</type></link> implementations.
 */
