/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.RepositorySystemSession;

@Component(role=LegacySupport.class)
public class DefaultLegacySupport
implements LegacySupport {
    private static final ThreadLocal<AtomicReference<MavenSession>> SESSION = new InheritableThreadLocal<AtomicReference<MavenSession>>();

    @Override
    public void setSession(MavenSession session2) {
        AtomicReference<MavenSession> reference = SESSION.get();
        if (reference != null) {
            reference.set(null);
        }
        if (session2 == null && reference != null) {
            SESSION.remove();
        } else {
            SESSION.set(new AtomicReference<MavenSession>(session2));
        }
    }

    @Override
    public MavenSession getSession() {
        AtomicReference<MavenSession> currentSession = SESSION.get();
        return currentSession != null ? currentSession.get() : null;
    }

    @Override
    public RepositorySystemSession getRepositorySession() {
        MavenSession session2 = this.getSession();
        return session2 != null ? session2.getRepositorySession() : null;
    }
}

