# (c) Copyright 2010. CodeWeavers, Inc.

import os

import globtree


class ConstGlobTree(globtree.GlobTree):
    """A globtree object for searching a constant list.

    Use matches('', sequence_of_filenames) to do a search."""
    case_sensitive = True

    def listdir(self, path, filenames):
        # pylint: disable=W0221
        if path == b'':
            return (), filenames
        return (), ()

    def exists(self, path, filenames):
        # pylint: disable=W0221
        return path in filenames


def _get_downloads(filenames, profiles):
    # Cache the ConstGlobTree object
    if 'DownloadGlobTree' not in profiles.userdata:
        downloadglob = ConstGlobTree()
        for profile in profiles.values():
            for glob in profile.app_profile.download_globs:
                downloadglob.add_glob(glob, profile)
        profiles.userdata.setdefault('DownloadGlobTree', downloadglob)
    downloadglob = profiles.userdata['DownloadGlobTree']

    return downloadglob.matches('', filenames)


def find_installers(dirs, profiles):
    dirs = set(dirs) # don't search duplicate dirs twice
    matches = []
    for directory in dirs:
        try:
            filenames = os.listdir(directory)
        except OSError:
            continue
        for filename, _profile in _get_downloads(filenames, profiles):
            path = os.path.join(directory, filename)
            if os.path.isfile(path):
                matches.append(path)
    return matches


def find_profiles(filename, profiles):
    if not os.path.isfile(filename):
        return ()
    _dirname, basename = os.path.split(filename)
    matches = {}
    for _path, profile in _get_downloads((basename,), profiles):
        if profiles[profile.appid].is_for_current_product:
            matches[profile.appid] = profile
    return matches
