/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MailSessionFactory
implements ObjectFactory {
    protected static final String factoryType = "javax.mail.Session";

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        Reference reference = (Reference)object;
        if (!reference.getClassName().equals(factoryType)) {
            return null;
        }
        return AccessController.doPrivileged(() -> {
            RefAddr refAddr;
            Properties properties = new Properties();
            properties.put("mail.transport.protocol", "smtp");
            properties.put("mail.smtp.host", "localhost");
            String string = null;
            Enumeration<RefAddr> enumeration = reference.getAll();
            while (enumeration.hasMoreElements()) {
                refAddr = enumeration.nextElement();
                if ("factory".equals(refAddr.getType())) continue;
                if ("password".equals(refAddr.getType())) {
                    string = (String)refAddr.getContent();
                    continue;
                }
                properties.put(refAddr.getType(), refAddr.getContent());
            }
            refAddr = null;
            if (string != null) {
                String string2 = properties.getProperty("mail.smtp.user");
                if (string2 == null) {
                    string2 = properties.getProperty("mail.user");
                }
                if (string2 != null) {
                    final PasswordAuthentication passwordAuthentication = new PasswordAuthentication(string2, string);
                    refAddr = new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return passwordAuthentication;
                        }
                    };
                }
            }
            return Session.getInstance((Properties)properties, (Authenticator)refAddr);
        });
    }
}

