/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.ast;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.ExperimentalApi;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.CompositeASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.parser.CancellationToken;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/intellij/markdown/ast/ASTNodeBuilder;", "", "text", "", "(Ljava/lang/CharSequence;)V", "cancellationToken", "Lorg/intellij/markdown/parser/CancellationToken;", "(Ljava/lang/CharSequence;Lorg/intellij/markdown/parser/CancellationToken;)V", "getCancellationToken", "()Lorg/intellij/markdown/parser/CancellationToken;", "getText", "()Ljava/lang/CharSequence;", "createCompositeNode", "Lorg/intellij/markdown/ast/CompositeASTNode;", "type", "Lorg/intellij/markdown/IElementType;", "children", "", "Lorg/intellij/markdown/ast/ASTNode;", "createLeafNodes", "startOffset", "", "endOffset", "Companion", "markdown"})
public class ASTNodeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence text;
    @NotNull
    private final CancellationToken cancellationToken;

    @ExperimentalApi
    public ASTNodeBuilder(@NotNull CharSequence text2, @NotNull CancellationToken cancellationToken) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(cancellationToken, "cancellationToken");
        this.text = text2;
        this.cancellationToken = cancellationToken;
    }

    @NotNull
    protected final CharSequence getText() {
        return this.text;
    }

    @NotNull
    protected final CancellationToken getCancellationToken() {
        return this.cancellationToken;
    }

    public ASTNodeBuilder(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        this(text2, CancellationToken.NonCancellable.INSTANCE);
    }

    @NotNull
    public List<ASTNode> createLeafNodes(@NotNull IElementType type2, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter(type2, "type");
        if (Intrinsics.areEqual(type2, MarkdownTokenTypes.WHITE_SPACE)) {
            ArrayList<LeafASTNode> result2 = new ArrayList<LeafASTNode>();
            int lastEol = startOffset;
            while (lastEol < endOffset) {
                this.cancellationToken.checkCancelled();
                int nextEol = Companion.indexOfSubSeq(this.text, lastEol, endOffset, '\n');
                if (nextEol == -1) break;
                if (nextEol > lastEol) {
                    result2.add(new LeafASTNode(MarkdownTokenTypes.WHITE_SPACE, lastEol, nextEol));
                }
                result2.add(new LeafASTNode(MarkdownTokenTypes.EOL, nextEol, nextEol + 1));
                lastEol = nextEol + 1;
            }
            if (endOffset > lastEol) {
                result2.add(new LeafASTNode(MarkdownTokenTypes.WHITE_SPACE, lastEol, endOffset));
            }
            return result2;
        }
        return CollectionsKt.listOf(new LeafASTNode(type2, startOffset, endOffset));
    }

    @NotNull
    public CompositeASTNode createCompositeNode(@NotNull IElementType type2, @NotNull List<? extends ASTNode> children2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(children2, "children");
        this.cancellationToken.checkCancelled();
        IElementType iElementType = type2;
        if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.UNORDERED_LIST) ? true : Intrinsics.areEqual(iElementType, MarkdownElementTypes.ORDERED_LIST)) {
            return new ListCompositeNode(type2, children2);
        }
        if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.LIST_ITEM)) {
            return new ListItemCompositeNode(children2);
        }
        return new CompositeASTNode(type2, children2);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/intellij/markdown/ast/ASTNodeBuilder$Companion;", "", "()V", "indexOfSubSeq", "", "s", "", "from", "to", "c", "", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        public final int indexOfSubSeq(@NotNull CharSequence s, int from, int to, char c) {
            Intrinsics.checkNotNullParameter(s, "s");
            int i = from;
            int n = to - 1;
            if (i <= n) {
                while (true) {
                    if (s.charAt(i) == c) {
                        return i;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

