/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLIOStreamManager {
    private InputStream xmlInputStream;
    private OutputStream xmlOutputStream;
    private String systemId;
    private SAXBuilder xmlBuilder = new SAXBuilder(false);
    private XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());

    public XMLIOStreamManager() {
    }

    public XMLIOStreamManager(InputStream xmlInputStream, OutputStream xmlOutputStream) {
        this.setXMLInputStream(xmlInputStream);
        this.setXMLOutputStream(xmlOutputStream);
    }

    public SAXBuilder getBuilder() {
        return this.xmlBuilder;
    }

    public void setXMLInputStream(InputStream xmlInputStream) {
        this.xmlInputStream = xmlInputStream;
    }

    public void setXMLInputStream(InputStream xmlInputStream, String systemId) {
        this.xmlInputStream = xmlInputStream;
        this.systemId = systemId;
    }

    public void setXMLOutputStream(OutputStream xmlOutputStream) {
        this.xmlOutputStream = xmlOutputStream;
    }

    public Element getRootElement() throws JDOMException, IOException {
        Document outputDoc = this.xmlBuilder.build(this.xmlInputStream, this.systemId);
        return outputDoc.getRootElement();
    }

    public void saveRootElement(Element rootEl) throws IOException {
        this.saveRootElement(rootEl, null);
    }

    public void saveRootElement(Element rootEl, DocType docType) throws IOException {
        Document inputDoc = docType != null ? new Document(rootEl, docType) : new Document(rootEl);
        this.xmlOutputter.output(inputDoc, this.xmlOutputStream);
        this.xmlOutputStream.close();
    }
}

