/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.schema.PreAnalyzedField;

public final class SimplePreAnalyzedParser
implements PreAnalyzedField.PreAnalyzedParser {
    static final String VERSION = "1";
    private static final byte[] EMPTY_BYTES = new byte[0];

    static byte[] hexToBytes(String hex) {
        if (hex == null) {
            return EMPTY_BYTES;
        }
        if ((hex = hex.replaceAll("\\s+", "")).length() == 0) {
            return EMPTY_BYTES;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(hex.length() / 2);
        for (int i = 0; i < hex.length(); ++i) {
            int high = SimplePreAnalyzedParser.charToNibble(hex.charAt(i));
            int low = 0;
            if (i < hex.length() - 1) {
                low = SimplePreAnalyzedParser.charToNibble(hex.charAt(++i));
            }
            byte b = (byte)(high << 4 | low);
            baos.write(b);
        }
        return baos.toByteArray();
    }

    static final int charToNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        throw new RuntimeException("Not a hex character: '" + c + "'");
    }

    static String bytesToHex(byte[] bytes, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            sb.append(Integer.toHexString(256 + (bytes[i] & 0xFF)).substring(1));
        }
        return sb.toString();
    }

    @Override
    public PreAnalyzedField.ParseResult parse(Reader reader, AttributeSource parent) throws IOException {
        int cnt;
        PreAnalyzedField.ParseResult res = new PreAnalyzedField.ParseResult();
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[128];
        while ((cnt = reader.read(buf)) > 0) {
            sb.append(buf, 0, cnt);
        }
        String val = sb.toString();
        if (val.length() == 0) {
            return res;
        }
        int idx = val.indexOf(32);
        if (idx == -1) {
            throw new IOException("Missing VERSION token");
        }
        String version = val.substring(0, idx);
        if (!VERSION.equals(version)) {
            throw new IOException("Unknown VERSION " + version);
        }
        val = val.substring(idx + 1);
        int tsStart = 0;
        boolean hasStored = false;
        StringBuilder storedBuf = new StringBuilder();
        if (val.charAt(0) == '=') {
            hasStored = true;
            if (val.length() > 1) {
                for (int i = 1; i < val.length(); ++i) {
                    char c = val.charAt(i);
                    if (c == '\\') {
                        if (i < val.length() - 1) {
                            if ((c = val.charAt(++i)) == '=') {
                                storedBuf.append('=');
                                continue;
                            }
                            storedBuf.append('\\');
                            storedBuf.append(c);
                            continue;
                        }
                        storedBuf.append(c);
                        continue;
                    }
                    if (c == '=') {
                        tsStart = i + 1;
                        break;
                    }
                    storedBuf.append(c);
                }
                if (tsStart == 0) {
                    throw new IOException("Missing end marker of stored part");
                }
            } else {
                throw new IOException("Unexpected end of stored field");
            }
        }
        if (hasStored) {
            res.str = storedBuf.toString();
        }
        Tok tok = new Tok();
        StringBuilder attName = new StringBuilder();
        StringBuilder attVal = new StringBuilder();
        S s = S.UNDEF;
        int lastPos = 0;
        for (int i = tsStart; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c == ' ') {
                AttributeSource.State state;
                switch (s) {
                    case VALUE: {
                        if (attVal.length() == 0) {
                            throw new IOException("Unexpected character '" + c + "' at position " + i + " - empty value of attribute.");
                        }
                        if (attName.length() <= 0) break;
                        tok.attr.put(attName.toString(), attVal.toString());
                        break;
                    }
                    case NAME: {
                        if (attName.length() <= 0) break;
                        throw new IOException("Unexpected character '" + c + "' at position " + i + " - missing attribute value.");
                    }
                }
                attName.setLength(0);
                attVal.setLength(0);
                if (!(tok.isEmpty() && s != S.NAME || (state = SimplePreAnalyzedParser.createState(parent, tok, lastPos)) == null)) {
                    res.states.add(state.clone());
                }
                s = S.UNDEF;
                tok.reset();
                ++lastPos;
                continue;
            }
            StringBuilder tgt = null;
            switch (s) {
                case TOKEN: {
                    tgt = tok.token;
                    break;
                }
                case NAME: {
                    tgt = attName;
                    break;
                }
                case VALUE: {
                    tgt = attVal;
                    break;
                }
                case UNDEF: {
                    tgt = tok.token;
                    s = S.TOKEN;
                }
            }
            if (c == '\\') {
                if (s == S.TOKEN) {
                    ++lastPos;
                }
                if (i >= val.length() - 1) {
                    tgt.append(c);
                    continue;
                }
                c = val.charAt(++i);
                switch (c) {
                    case ' ': 
                    case ',': 
                    case '=': 
                    case '\\': {
                        tgt.append(c);
                        break;
                    }
                    case 'n': {
                        tgt.append('\n');
                        break;
                    }
                    case 'r': {
                        tgt.append('\r');
                        break;
                    }
                    case 't': {
                        tgt.append('\t');
                        break;
                    }
                    default: {
                        tgt.append('\\');
                        tgt.append(c);
                        ++lastPos;
                        break;
                    }
                }
                continue;
            }
            if (c == ',') {
                if (s == S.TOKEN) {
                    s = S.NAME;
                    continue;
                }
                if (s == S.VALUE) {
                    if (attVal.length() == 0) {
                        throw new IOException("Unexpected character '" + c + "' at position " + i + " - empty value of attribute.");
                    }
                    if (attName.length() > 0 && attVal.length() > 0) {
                        tok.attr.put(attName.toString(), attVal.toString());
                    }
                    attName.setLength(0);
                    attVal.setLength(0);
                    s = S.NAME;
                    continue;
                }
                throw new IOException("Unexpected character '" + c + "' at position " + i + " - missing attribute value.");
            }
            if (c == '=') {
                if (s == S.NAME) {
                    s = S.VALUE;
                    continue;
                }
                throw new IOException("Unexpected character '" + c + "' at position " + i + " - empty value of attribute.");
            }
            tgt.append(c);
            if (s != S.TOKEN) continue;
            ++lastPos;
        }
        if (!tok.isEmpty() || s == S.NAME || s == S.VALUE) {
            AttributeSource.State state;
            if (s == S.VALUE && attName.length() > 0 && attVal.length() > 0) {
                tok.attr.put(attName.toString(), attVal.toString());
            }
            if ((state = SimplePreAnalyzedParser.createState(parent, tok, lastPos)) != null) {
                res.states.add(state.clone());
            }
        }
        return res;
    }

    private static AttributeSource.State createState(AttributeSource a, Tok state, int tokenEnd) {
        a.clearAttributes();
        CharTermAttribute termAtt = (CharTermAttribute)a.addAttribute(CharTermAttribute.class);
        char[] tokChars = state.token.toString().toCharArray();
        termAtt.copyBuffer(tokChars, 0, tokChars.length);
        int tokenStart = tokenEnd - state.token.length();
        for (Map.Entry<String, String> e : state.attr.entrySet()) {
            String k = e.getKey();
            if (k.equals("i")) {
                int incr = Integer.parseInt(e.getValue());
                PositionIncrementAttribute posIncr = (PositionIncrementAttribute)a.addAttribute(PositionIncrementAttribute.class);
                posIncr.setPositionIncrement(incr);
                continue;
            }
            if (k.equals("s")) {
                tokenStart = Integer.parseInt(e.getValue());
                continue;
            }
            if (k.equals("e")) {
                tokenEnd = Integer.parseInt(e.getValue());
                continue;
            }
            if (k.equals("y")) {
                TypeAttribute type = (TypeAttribute)a.addAttribute(TypeAttribute.class);
                type.setType(e.getValue());
                continue;
            }
            if (k.equals("f")) {
                FlagsAttribute flags = (FlagsAttribute)a.addAttribute(FlagsAttribute.class);
                int f = Integer.parseInt(e.getValue(), 16);
                flags.setFlags(f);
                continue;
            }
            if (!k.equals("p")) continue;
            PayloadAttribute p = (PayloadAttribute)a.addAttribute(PayloadAttribute.class);
            byte[] data = SimplePreAnalyzedParser.hexToBytes(e.getValue());
            if (data == null || data.length <= 0) continue;
            p.setPayload(new BytesRef(data));
        }
        OffsetAttribute offset = (OffsetAttribute)a.addAttribute(OffsetAttribute.class);
        offset.setOffset(tokenStart, tokenEnd);
        AttributeSource.State resState = a.captureState();
        a.clearAttributes();
        return resState;
    }

    @Override
    public String toFormattedString(Field f) throws IOException {
        TokenStream ts;
        String s;
        StringBuilder sb = new StringBuilder();
        sb.append("1 ");
        if (f.fieldType().stored() && (s = f.stringValue()) != null) {
            sb.append('=');
            sb.append(s);
            sb.append('=');
        }
        if ((ts = f.tokenStreamValue()) != null) {
            StringBuilder tok = new StringBuilder();
            boolean next = false;
            while (ts.incrementToken()) {
                if (next) {
                    sb.append(' ');
                } else {
                    next = true;
                }
                tok.setLength(0);
                Iterator it = ts.getAttributeClassesIterator();
                String cTerm = null;
                String tTerm = null;
                while (it.hasNext()) {
                    Class cl = (Class)it.next();
                    Attribute att = ts.getAttribute(cl);
                    if (att == null) continue;
                    if (cl.isAssignableFrom(CharTermAttribute.class)) {
                        CharTermAttribute catt = (CharTermAttribute)att;
                        cTerm = this.escape(catt.buffer(), catt.length());
                        continue;
                    }
                    if (cl.isAssignableFrom(TermToBytesRefAttribute.class)) {
                        TermToBytesRefAttribute tatt = (TermToBytesRefAttribute)att;
                        char[] tTermChars = tatt.getBytesRef().utf8ToString().toCharArray();
                        tTerm = this.escape(tTermChars, tTermChars.length);
                        continue;
                    }
                    if (tok.length() > 0) {
                        tok.append(',');
                    }
                    if (cl.isAssignableFrom(FlagsAttribute.class)) {
                        tok.append("f=").append(Integer.toHexString(((FlagsAttribute)att).getFlags()));
                        continue;
                    }
                    if (cl.isAssignableFrom(OffsetAttribute.class)) {
                        tok.append("s=").append(((OffsetAttribute)att).startOffset()).append(",e=").append(((OffsetAttribute)att).endOffset());
                        continue;
                    }
                    if (cl.isAssignableFrom(PayloadAttribute.class)) {
                        BytesRef p = ((PayloadAttribute)att).getPayload();
                        if (p != null && p.length > 0) {
                            tok.append("p=").append(SimplePreAnalyzedParser.bytesToHex(p.bytes, p.offset, p.length));
                            continue;
                        }
                        if (tok.length() <= 0) continue;
                        tok.setLength(tok.length() - 1);
                        continue;
                    }
                    if (cl.isAssignableFrom(PositionIncrementAttribute.class)) {
                        tok.append("i=").append(((PositionIncrementAttribute)att).getPositionIncrement());
                        continue;
                    }
                    if (cl.isAssignableFrom(TypeAttribute.class)) {
                        tok.append("y=").append(this.escape(((TypeAttribute)att).type()));
                        continue;
                    }
                    tok.append(cl.getName()).append('=').append(this.escape(att.toString()));
                }
                String term = null;
                term = cTerm != null ? cTerm : tTerm;
                if (term != null && term.length() > 0) {
                    if (tok.length() > 0) {
                        tok.insert(0, term + ",");
                    } else {
                        tok.insert(0, term);
                    }
                }
                sb.append((CharSequence)tok);
            }
        }
        return sb.toString();
    }

    String escape(String val) {
        return this.escape(val.toCharArray(), val.length());
    }

    String escape(char[] val, int len) {
        if (val == null || len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < len; ++i) {
            switch (val[i]) {
                case ' ': 
                case ',': 
                case '=': 
                case '\\': {
                    sb.append('\\');
                    sb.append(val[i]);
                    continue block6;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block6;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block6;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    continue block6;
                }
                default: {
                    sb.append(val[i]);
                }
            }
        }
        return sb.toString();
    }

    private static enum S {
        TOKEN,
        NAME,
        VALUE,
        UNDEF;

    }

    private static class Tok {
        StringBuilder token = new StringBuilder();
        Map<String, String> attr = new HashMap<String, String>();

        private Tok() {
        }

        public boolean isEmpty() {
            return this.token.length() == 0 && this.attr.size() == 0;
        }

        public void reset() {
            this.token.setLength(0);
            this.attr.clear();
        }

        public String toString() {
            return "tok='" + this.token + "',attr=" + this.attr;
        }
    }
}

