/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.solr.client.solrj.cloud.ShardTerms;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreDescriptor;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkShardTerms
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String collection;
    private final String shard;
    private final String znodePath;
    private final SolrZkClient zkClient;
    private final Set<CoreTermWatcher> listeners = new HashSet<CoreTermWatcher>();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicReference<ShardTerms> terms = new AtomicReference();

    public ZkShardTerms(String collection, String shard, SolrZkClient zkClient) {
        this.znodePath = "/collections/" + collection + "/terms/" + shard;
        this.collection = collection;
        this.shard = shard;
        this.zkClient = zkClient;
        this.ensureTermNodeExist();
        this.refreshTerms();
        this.retryRegisterWatcher();
        assert (ObjectReleaseTracker.track((Object)this));
    }

    public void ensureTermsIsHigher(String leader, Set<String> replicasNeedingRecovery) {
        if (replicasNeedingRecovery.isEmpty()) {
            return;
        }
        this.mutate(terms -> terms.increaseTerms(leader, replicasNeedingRecovery));
    }

    public ShardTerms getShardTerms() {
        return this.terms.get();
    }

    public boolean canBecomeLeader(String coreNodeName) {
        return this.terms.get().canBecomeLeader(coreNodeName);
    }

    public boolean skipSendingUpdatesTo(String coreNodeName) {
        return !this.terms.get().haveHighestTermValue(coreNodeName);
    }

    public boolean registered(String coreNodeName) {
        return this.terms.get().getTerm(coreNodeName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.isClosed.set(true);
        Set<CoreTermWatcher> set = this.listeners;
        synchronized (set) {
            this.listeners.clear();
        }
        assert (ObjectReleaseTracker.release((Object)this));
    }

    Map<String, Long> getTerms() {
        return new HashMap<String, Long>(this.terms.get().getTerms());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(CoreTermWatcher listener) {
        Set<CoreTermWatcher> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeTerm(CoreDescriptor cd) {
        int numListeners;
        Set<CoreTermWatcher> set = this.listeners;
        synchronized (set) {
            this.listeners.removeIf(coreTermWatcher -> !coreTermWatcher.onTermChanged(this.terms.get()));
            numListeners = this.listeners.size();
        }
        return this.removeTerm(cd.getCloudDescriptor().getCoreNodeName()) || numListeners == 0;
    }

    boolean removeTerm(String coreNodeName) {
        ShardTerms newTerms;
        while ((newTerms = this.terms.get().removeTerm(coreNodeName)) != null) {
            try {
                if (!this.saveTerms(newTerms, "removeTerm")) continue;
                return false;
            }
            catch (KeeperException.NoNodeException e) {
                return true;
            }
        }
        return true;
    }

    void registerTerm(String coreNodeName) {
        this.mutate(terms -> terms.registerTerm(coreNodeName));
    }

    public void setTermEqualsToLeader(String coreNodeName) {
        this.mutate(terms -> terms.setTermEqualsToLeader(coreNodeName));
    }

    public void setTermToZero(String coreNodeName) {
        this.mutate(terms -> terms.setTermToZero(coreNodeName));
    }

    public void startRecovering(String coreNodeName) {
        this.mutate(terms -> terms.startRecovering(coreNodeName));
    }

    public void doneRecovering(String coreNodeName) {
        this.mutate(terms -> terms.doneRecovering(coreNodeName));
    }

    public boolean isRecovering(String name) {
        return this.terms.get().isRecovering(name);
    }

    public void ensureHighestTermsAreNotZero() {
        this.mutate(ShardTerms::ensureHighestTermsAreNotZero);
    }

    private void mutate(Function<ShardTerms, ShardTerms> action) {
        ShardTerms newTerms;
        String caller = StackWalker.getInstance().walk(s -> s.skip(1L).findFirst().map(StackWalker.StackFrame::getMethodName).orElse("(unknown)"));
        while ((newTerms = action.apply(this.terms.get())) != null && !this.forceSaveTerms(newTerms, caller)) {
        }
    }

    public long getHighestTerm() {
        return this.terms.get().getMaxTerm();
    }

    public long getTerm(String coreNodeName) {
        Long term = this.terms.get().getTerm(coreNodeName);
        return term == null ? -1L : term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumListeners() {
        Set<CoreTermWatcher> set = this.listeners;
        synchronized (set) {
            return this.listeners.size();
        }
    }

    private boolean forceSaveTerms(ShardTerms newTerms, String action) {
        try {
            return this.saveTerms(newTerms, action);
        }
        catch (KeeperException.NoNodeException e) {
            this.ensureTermNodeExist();
            return false;
        }
    }

    private boolean saveTerms(ShardTerms newTerms, String action) throws KeeperException.NoNodeException {
        byte[] znodeData = Utils.toJSON((Object)newTerms);
        try {
            Stat stat = this.zkClient.setData(this.znodePath, znodeData, newTerms.getVersion(), true);
            this.setNewTerms(new ShardTerms(newTerms, stat.getVersion()));
            log.info("Successful update of terms at {} to {} for {}", new Object[]{this.znodePath, newTerms, action});
            return true;
        }
        catch (KeeperException.BadVersionException e) {
            log.info("Failed to save terms, version is not a match, retrying");
            this.refreshTerms();
        }
        catch (KeeperException.NoNodeException e) {
            throw e;
        }
        catch (InterruptedException | RuntimeException | KeeperException e) {
            SolrZkClient.checkInterrupted((Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while saving shard term for collection: " + this.collection, e);
        }
        return false;
    }

    private void ensureTermNodeExist() {
        String path = "/collections/" + this.collection + "/terms";
        try {
            path = path + "/" + this.shard;
            try {
                HashMap initialTerms = new HashMap();
                this.zkClient.makePath(path, Utils.toJSON(initialTerms), CreateMode.PERSISTENT, true);
            }
            catch (KeeperException.NodeExistsException initialTerms) {}
        }
        catch (InterruptedException | KeeperException e) {
            Throwable cause = SolrZkClient.checkInterrupted((Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating shard term node in Zookeeper for collection: " + this.collection, cause);
        }
    }

    public void refreshTerms() {
        ShardTerms newTerms;
        try {
            Stat stat = new Stat();
            byte[] data = this.zkClient.getData(this.znodePath, null, stat, true);
            newTerms = new ShardTerms((Map)Utils.fromJSON((byte[])data), stat.getVersion());
        }
        catch (InterruptedException | KeeperException e) {
            Throwable cause = SolrZkClient.checkInterrupted((Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error updating shard term for collection: " + this.collection, cause);
        }
        this.setNewTerms(newTerms);
    }

    private void retryRegisterWatcher() {
        while (!this.isClosed.get()) {
            try {
                this.registerWatcher();
                return;
            }
            catch (KeeperException.AuthFailedException | KeeperException.SessionExpiredException e) {
                this.isClosed.set(true);
                log.error("Failed watching shard term for collection: {} due to unrecoverable exception", (Object)this.collection, (Object)e);
                return;
            }
            catch (KeeperException e) {
                log.warn("Failed watching shard term for collection: {}, retrying!", (Object)this.collection, (Object)e);
                try {
                    this.zkClient.getConnectionManager().waitForConnected((long)this.zkClient.getZkClientTimeout());
                }
                catch (TimeoutException te) {
                    if (!Thread.interrupted()) continue;
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error watching shard term for collection: " + this.collection, (Throwable)te);
                }
            }
        }
    }

    private void registerWatcher() throws KeeperException {
        Watcher watcher = event -> {
            if (Watcher.Event.EventType.None == event.getType()) {
                return;
            }
            this.retryRegisterWatcher();
            if (Watcher.Event.EventType.NodeDeleted == event.getType()) {
                return;
            }
            this.refreshTerms();
        };
        try {
            this.zkClient.exists(this.znodePath, watcher, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error watching shard term for collection: " + this.collection, (Throwable)e);
        }
    }

    private void setNewTerms(ShardTerms newTerms) {
        ShardTerms terms;
        boolean isChanged = false;
        while ((terms = this.terms.get()) == null || newTerms.getVersion() > terms.getVersion()) {
            if (!this.terms.compareAndSet(terms, newTerms)) continue;
            isChanged = true;
            break;
        }
        if (isChanged) {
            this.onTermUpdates(newTerms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTermUpdates(ShardTerms newTerms) {
        Set<CoreTermWatcher> set = this.listeners;
        synchronized (set) {
            this.listeners.removeIf(coreTermWatcher -> !coreTermWatcher.onTermChanged(newTerms));
        }
    }

    static interface CoreTermWatcher {
        public boolean onTermChanged(ShardTerms var1);
    }
}

