/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Arrays;
import org.apache.sis.internal.coverage.j2d.RasterFactory;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public class ImageLayout {
    private static final int MIN_TILE_SIZE = 180;
    public static final ImageLayout DEFAULT = new ImageLayout(null, false);
    public static final ImageLayout SIZE_ADJUST = new ImageLayout(null, true);
    private final int preferredTileWidth;
    private final int preferredTileHeight;
    public final boolean isBoundsAdjustmentAllowed;

    public ImageLayout(Dimension dimension, boolean bl) {
        if (dimension != null) {
            this.preferredTileWidth = dimension.width;
            this.preferredTileHeight = dimension.height;
        } else {
            this.preferredTileWidth = 256;
            this.preferredTileHeight = 256;
        }
        this.isBoundsAdjustmentAllowed = bl;
    }

    public static ImageLayout fixedSize(RenderedImage renderedImage) {
        return new FixedSize(renderedImage);
    }

    public final Dimension getPreferredTileSize() {
        return new Dimension(this.preferredTileWidth, this.preferredTileHeight);
    }

    private static int toTileSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5 = 2 * n2;
        if (n <= n5) {
            return n;
        }
        int n6 = n % n2;
        if (n6 == 0) {
            return n2;
        }
        int[] nArray = MathFunctions.divisors(n);
        int n7 = Arrays.binarySearch(nArray, n2);
        if ((n7 ^= 0xFFFFFFFF) < nArray.length) {
            if (n7 == 0) {
                n4 = 0;
                n3 = 1;
            } else {
                n4 = nArray[n7 - 1];
                n3 = n4 < 180 ? 1 : 0;
            }
            int n8 = nArray[n7];
            if (n8 <= (bl ? n5 : n) && (n3 != 0 || n8 - n2 <= n2 - n4)) {
                return n8;
            }
            if (n3 == 0) {
                return n4;
            }
        }
        if (!bl) {
            return n;
        }
        n4 = n2;
        n7 = n5;
        while (--n7 >= 180) {
            n3 = n % n7;
            if (n3 <= n6 && (n3 != n6 || Math.abs(n7 - n2) >= Math.abs(n4 - n2))) continue;
            n6 = n3;
            n4 = n7;
        }
        return n4;
    }

    public Dimension suggestTileSize(int n, int n2, boolean bl) {
        return new Dimension(ImageLayout.toTileSize(n, this.preferredTileWidth, bl), ImageLayout.toTileSize(n2, this.preferredTileHeight, bl));
    }

    public Dimension suggestTileSize(RenderedImage renderedImage, Rectangle rectangle, boolean bl) {
        int n;
        int n2;
        boolean bl2;
        boolean bl3;
        if (rectangle != null && rectangle.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((short)29, "bounds"));
        }
        if (bl && renderedImage != null && !this.isBoundsAdjustmentAllowed) {
            ColorModel colorModel = renderedImage.getColorModel();
            boolean bl4 = bl = colorModel != null;
            if (bl) {
                if (colorModel instanceof IndexColorModel) {
                    bl = ((IndexColorModel)colorModel).getTransparentPixel() == 0;
                } else {
                    boolean bl5 = bl = colorModel.getTransparency() != 1;
                }
            }
        }
        if (rectangle != null) {
            bl3 = true;
            bl2 = true;
            n2 = rectangle.width;
            n = rectangle.height;
        } else if (renderedImage != null) {
            bl3 = renderedImage.getNumXTiles() <= 1;
            bl2 = renderedImage.getNumYTiles() <= 1;
            n2 = bl3 ? renderedImage.getWidth() : renderedImage.getTileWidth();
            n = bl2 ? renderedImage.getHeight() : renderedImage.getTileHeight();
        } else {
            return this.getPreferredTileSize();
        }
        Dimension dimension = new Dimension(ImageLayout.toTileSize(n2, this.preferredTileWidth, bl & bl3), ImageLayout.toTileSize(n, this.preferredTileHeight, bl & bl2));
        if (this.isBoundsAdjustmentAllowed && rectangle != null && !rectangle.isEmpty()) {
            int n3 = ImageLayout.sizeToAdd(rectangle.width, dimension.width);
            int n4 = ImageLayout.sizeToAdd(rectangle.height, dimension.height);
            if ((rectangle.width += n3) < 0) {
                rectangle.width -= dimension.width;
            }
            if ((rectangle.height += n4) < 0) {
                rectangle.height -= dimension.height;
            }
            rectangle.translate(-n3 / 2, -n4 / 2);
        }
        return dimension;
    }

    private static int sizeToAdd(int n, int n2) {
        if ((n %= n2) != 0) {
            n = n2 - n;
        }
        return n;
    }

    public BandedSampleModel createBandedSampleModel(int n, int n2, RenderedImage renderedImage, Rectangle rectangle) {
        Dimension dimension = this.suggestTileSize(renderedImage, rectangle, this.isBoundsAdjustmentAllowed);
        return RasterFactory.unique(new BandedSampleModel(n, dimension.width, dimension.height, n2));
    }

    public SampleModel createCompatibleSampleModel(RenderedImage renderedImage, Rectangle rectangle) {
        ArgumentChecks.ensureNonNull("image", renderedImage);
        Dimension dimension = this.suggestTileSize(renderedImage, rectangle, this.isBoundsAdjustmentAllowed);
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel.getWidth() != dimension.width || sampleModel.getHeight() != dimension.height) {
            sampleModel = sampleModel.createCompatibleSampleModel(dimension.width, dimension.height);
            sampleModel = RasterFactory.unique(sampleModel);
        }
        return sampleModel;
    }

    public Point getMinTile() {
        return null;
    }

    public String toString() {
        return Strings.toString(this.getClass(), "preferredTileSize", new StringBuilder().append(this.preferredTileWidth).append('\u00d7').append(this.preferredTileHeight), "isBoundsAdjustmentAllowed", this.isBoundsAdjustmentAllowed);
    }

    private static final class FixedSize
    extends ImageLayout {
        private final int xmin;
        private final int ymin;

        FixedSize(RenderedImage renderedImage) {
            super(new Dimension(renderedImage.getTileWidth(), renderedImage.getTileHeight()), false);
            this.xmin = renderedImage.getMinTileX();
            this.ymin = renderedImage.getMinTileY();
        }

        @Override
        public Dimension suggestTileSize(int n, int n2, boolean bl) {
            return this.getPreferredTileSize();
        }

        @Override
        public Dimension suggestTileSize(RenderedImage renderedImage, Rectangle rectangle, boolean bl) {
            return this.getPreferredTileSize();
        }

        @Override
        public Point getMinTile() {
            return new Point(this.xmin, this.ymin);
        }
    }
}

