/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.collection.Containers;
import org.opengis.metadata.identification.CharacterSet;

final class LegacyCodes {
    static final Map<String, String> IANA_TO_LEGACY;
    static final Map<String, String> LEGACY_TO_IANA;

    private LegacyCodes() {
    }

    static String fromIANA(String string) {
        String string2 = IANA_TO_LEGACY.get(string);
        if (string2 == null && (string2 = IANA_TO_LEGACY.get(string.toUpperCase(Locale.US))) == null) {
            return string;
        }
        return string2;
    }

    static String toIANA(String string) {
        String string2 = LEGACY_TO_IANA.get(string);
        if (string2 == null && (string2 = LEGACY_TO_IANA.get(string.toLowerCase(Locale.US))) == null) {
            return string;
        }
        return string2;
    }

    static {
        CharacterSet[] characterSetArray = CharacterSet.values();
        int n = Containers.hashMapCapacity(characterSetArray.length);
        IANA_TO_LEGACY = new HashMap<String, String>(n);
        LEGACY_TO_IANA = new HashMap<String, String>(n);
        for (CharacterSet characterSet : characterSetArray) {
            String string = characterSet.identifier().intern();
            String[] stringArray = characterSet.names();
            String string2 = stringArray[stringArray.length - 1];
            if (string2.equals("ebcdic")) {
                string2 = "EBCDIC";
            }
            IANA_TO_LEGACY.put(string2.toUpperCase(Locale.US), string);
            LEGACY_TO_IANA.put(string.toLowerCase(Locale.US), string2);
            IANA_TO_LEGACY.put(string2, string);
            LEGACY_TO_IANA.put(string, string2);
        }
    }
}

