/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class UnionType
extends AstType {
    public static final TokenRole UNION_TOKEN = new TokenRole("|", 2);

    public UnionType(AstType ... alternatives) {
        for (AstType ifType : alternatives) {
            this.addChild(ifType, Roles.TYPE);
        }
    }

    public final AstNodeCollection<AstType> getAlternatives() {
        return this.getChildrenByRole(Roles.TYPE);
    }

    @Override
    public TypeReference toTypeReference() {
        AstNodeCollection<AstType> alternatives = this.getAlternatives();
        TypeReference[] alternativeTypes = alternatives.isEmpty() ? TypeReference.EMPTY_REFERENCES : new TypeReference[alternatives.size()];
        int i = 0;
        for (AstType alternative : alternatives) {
            alternativeTypes[i++] = alternative.toTypeReference();
        }
        return com.strobel.assembler.metadata.UnionType.of(alternativeTypes);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitUnionType(this, data);
    }

    @Override
    public String toString() {
        AstNodeCollection<AstType> alternatives = this.getAlternatives();
        StringBuilder sb = new StringBuilder();
        boolean needToken = false;
        for (AstType alternative : alternatives) {
            if (needToken) {
                sb.append(" | ");
            }
            sb.append(alternative);
            needToken = true;
        }
        return sb.toString();
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof UnionType && this.getAlternatives().matches(((UnionType)other).getAlternatives(), match);
    }
}

