/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.DepthFirstAstVisitor;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;

public abstract class ContextTrackingVisitor<TResult>
extends DepthFirstAstVisitor<Void, TResult>
implements IAstTransform {
    protected final DecompilerContext context;

    protected ContextTrackingVisitor(DecompilerContext context) {
        this.context = VerifyArgument.notNull(context, "context");
    }

    protected final boolean inConstructor() {
        MethodDefinition currentMethod = this.context.getCurrentMethod();
        return currentMethod != null && currentMethod.isConstructor();
    }

    protected final boolean inStaticInitializer() {
        MethodDefinition currentMethod = this.context.getCurrentMethod();
        return currentMethod != null && currentMethod.isTypeInitializer();
    }

    protected final boolean inMethod() {
        return this.context.getCurrentMethod() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TResult visitTypeDeclaration(TypeDeclaration typeDeclaration, Void p) {
        TypeDefinition oldType = this.context.getCurrentType();
        MethodDefinition oldMethod = this.context.getCurrentMethod();
        try {
            this.context.setCurrentType(typeDeclaration.getUserData(Keys.TYPE_DEFINITION));
            this.context.setCurrentMethod(null);
            TResult TResult = this.visitTypeDeclarationOverride(typeDeclaration, p);
            return TResult;
        }
        finally {
            this.context.setCurrentType(oldType);
            this.context.setCurrentMethod(oldMethod);
        }
    }

    protected TResult visitTypeDeclarationOverride(TypeDeclaration typeDeclaration, Void p) {
        return (TResult)super.visitTypeDeclaration(typeDeclaration, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TResult visitMethodDeclaration(MethodDeclaration node, Void p) {
        assert (this.context.getCurrentMethod() == null);
        try {
            this.context.setCurrentMethod(node.getUserData(Keys.METHOD_DEFINITION));
            TResult TResult = this.visitMethodDeclarationOverride(node, p);
            return TResult;
        }
        finally {
            this.context.setCurrentMethod(null);
        }
    }

    protected TResult visitMethodDeclarationOverride(MethodDeclaration node, Void p) {
        return (TResult)super.visitMethodDeclaration(node, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TResult visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
        assert (this.context.getCurrentMethod() == null);
        try {
            this.context.setCurrentMethod(node.getUserData(Keys.METHOD_DEFINITION));
            Object s = super.visitConstructorDeclaration(node, p);
            return (TResult)s;
        }
        finally {
            this.context.setCurrentMethod(null);
        }
    }

    @Override
    public void run(AstNode compilationUnit) {
        compilationUnit.acceptVisitor(this, null);
    }

    protected IMetadataResolver resolver() {
        TypeDefinition currentType = this.context.getCurrentType();
        return currentType != null ? currentType.getResolver() : MetadataSystem.instance();
    }

    protected AstType makeType(TypeReference reference) {
        VerifyArgument.notNull(reference, "reference");
        AstBuilder builder = this.context.getUserData(Keys.AST_BUILDER);
        if (builder != null) {
            return builder.convertType(reference);
        }
        SimpleType type = new SimpleType(reference.getName());
        TypeDefinition resolvedType = reference.resolve();
        type.putUserData(Keys.TYPE_REFERENCE, reference);
        if (resolvedType != null) {
            type.putUserData(Keys.TYPE_DEFINITION, resolvedType);
        }
        return type;
    }

    protected AstType makeType(String descriptor) {
        AstType reference = this.makeType(this.resolver().lookupType(descriptor));
        if (reference == null) {
            return new SimpleType(descriptor.replace('/', '.'));
        }
        return reference;
    }
}

