/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.google.zxing.common;

import java.util.Hashtable;
import zext.plantuml.com.google.zxing.DecodeHintType;

public final class StringUtils {
    private static final String PLATFORM_DEFAULT_ENCODING = System.getProperty("file.encoding");
    public static final String SHIFT_JIS = "SJIS";
    private static final String EUC_JP = "EUC_JP";
    private static final String UTF8 = "UTF8";
    private static final String ISO88591 = "ISO8859_1";
    private static final boolean ASSUME_SHIFT_JIS = "SJIS".equalsIgnoreCase(PLATFORM_DEFAULT_ENCODING) || "EUC_JP".equalsIgnoreCase(PLATFORM_DEFAULT_ENCODING);

    private StringUtils() {
    }

    public static String guessEncoding(byte[] bytes, Hashtable hints) {
        String characterSet;
        if (hints != null && (characterSet = (String)hints.get(DecodeHintType.CHARACTER_SET)) != null) {
            return characterSet;
        }
        if (bytes.length > 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            return UTF8;
        }
        int length = bytes.length;
        boolean canBeISO88591 = true;
        boolean canBeShiftJIS = true;
        boolean canBeUTF8 = true;
        int utf8BytesLeft = 0;
        int maybeDoubleByteCount = 0;
        int maybeSingleByteKatakanaCount = 0;
        boolean sawLatin1Supplement = false;
        boolean sawUTF8Start = false;
        boolean lastWasPossibleDoubleByteStart = false;
        for (int i = 0; i < length && (canBeISO88591 || canBeShiftJIS || canBeUTF8); ++i) {
            int nextValue;
            int value = bytes[i] & 0xFF;
            if (value >= 128 && value <= 191) {
                if (utf8BytesLeft > 0) {
                    --utf8BytesLeft;
                }
            } else {
                if (utf8BytesLeft > 0) {
                    canBeUTF8 = false;
                }
                if (value >= 192 && value <= 253) {
                    sawUTF8Start = true;
                    int valueCopy = value;
                    while ((valueCopy & 0x40) != 0) {
                        ++utf8BytesLeft;
                        valueCopy <<= 1;
                    }
                }
            }
            if ((value == 194 || value == 195) && i < length - 1 && (nextValue = bytes[i + 1] & 0xFF) <= 191 && (value == 194 && nextValue >= 160 || value == 195 && nextValue >= 128)) {
                sawLatin1Supplement = true;
            }
            if (value >= 127 && value <= 159) {
                canBeISO88591 = false;
            }
            if (value >= 161 && value <= 223 && !lastWasPossibleDoubleByteStart) {
                ++maybeSingleByteKatakanaCount;
            }
            if (!lastWasPossibleDoubleByteStart && (value >= 240 && value <= 255 || value == 128 || value == 160)) {
                canBeShiftJIS = false;
            }
            if (value >= 129 && value <= 159 || value >= 224 && value <= 239) {
                if (lastWasPossibleDoubleByteStart) {
                    lastWasPossibleDoubleByteStart = false;
                    continue;
                }
                lastWasPossibleDoubleByteStart = true;
                if (i >= bytes.length - 1) {
                    canBeShiftJIS = false;
                    continue;
                }
                nextValue = bytes[i + 1] & 0xFF;
                if (nextValue < 64 || nextValue > 252) {
                    canBeShiftJIS = false;
                    continue;
                }
                ++maybeDoubleByteCount;
                continue;
            }
            lastWasPossibleDoubleByteStart = false;
        }
        if (utf8BytesLeft > 0) {
            canBeUTF8 = false;
        }
        if (canBeShiftJIS && ASSUME_SHIFT_JIS) {
            return SHIFT_JIS;
        }
        if (canBeUTF8 && sawUTF8Start) {
            return UTF8;
        }
        if (canBeShiftJIS && (maybeDoubleByteCount >= 3 || 20 * maybeSingleByteKatakanaCount > length)) {
            return SHIFT_JIS;
        }
        if (!sawLatin1Supplement && canBeISO88591) {
            return ISO88591;
        }
        return PLATFORM_DEFAULT_ENCODING;
    }
}

