/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance;

import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class ListProvenance<T extends Provenance>
implements Provenance,
Iterable<T> {
    private static final long serialVersionUID = 1L;
    private final List<T> list;

    public ListProvenance(List<T> list) {
        this.list = Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public ListProvenance() {
        this.list = Collections.emptyList();
    }

    public List<T> getList() {
        return this.list;
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        return this.list.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListProvenance)) {
            return false;
        }
        ListProvenance that = (ListProvenance)o;
        return this.list.equals(that.list);
    }

    public int hashCode() {
        return Objects.hash(this.list);
    }

    public static <T extends Provenance, U extends Provenancable<T>> ListProvenance<T> createListProvenance(Collection<U> collection) {
        if (collection == null || collection.isEmpty()) {
            return new ListProvenance<T>();
        }
        ArrayList outputList = new ArrayList();
        for (Provenancable e : collection) {
            outputList.add(e.getProvenance());
        }
        return new ListProvenance(outputList);
    }
}

