/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.transport.connector.MLConnectorSearchAction;
import org.opensearch.ml.common.transport.model.MLModelSearchAction;
import org.opensearch.ml.common.transport.model_group.MLModelGroupSearchAction;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="SearchIndexTool")
public class SearchIndexTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchIndexTool.class);
    public static final String INPUT_FIELD = "input";
    public static final String INDEX_FIELD = "index";
    public static final String QUERY_FIELD = "query";
    public static final String INPUT_SCHEMA_FIELD = "input_schema";
    public static final String STRICT_FIELD = "strict";
    public static final String TYPE = "SearchIndexTool";
    private static final String DEFAULT_DESCRIPTION = "Use this tool to search an index by providing two parameters: 'index' for the index name, and 'query' for the OpenSearch DSL formatted query. Only use this tool when both index name and DSL query is available.";
    public static final String DEFAULT_INPUT_SCHEMA = "{\"type\":\"object\",\"properties\":{\"index\":{\"type\":\"string\",\"description\":\"OpenSearch index name. for example: index1\"},\"query\":{\"type\":\"object\",\"description\":\"OpenSearch search index query. You need to get index mapping to write correct search query. It must be a valid OpenSearch query. Valid value:\\n{\\\"query\\\":{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}},\\\"size\\\":2,\\\"_source\\\":\\\"population_description\\\"}\\nInvalid value: \\n{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}}\\nThe value is invalid because the match not wrapped by \\\"query\\\".\",\"additionalProperties\":false}},\"required\":[\"index\",\"query\"],\"additionalProperties\":false}";
    private static final Gson GSON = new GsonBuilder().serializeSpecialFloatingPointValues().create();
    public static final Map<String, Object> DEFAULT_ATTRIBUTES = Map.of("input_schema", "{\"type\":\"object\",\"properties\":{\"index\":{\"type\":\"string\",\"description\":\"OpenSearch index name. for example: index1\"},\"query\":{\"type\":\"object\",\"description\":\"OpenSearch search index query. You need to get index mapping to write correct search query. It must be a valid OpenSearch query. Valid value:\\n{\\\"query\\\":{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}},\\\"size\\\":2,\\\"_source\\\":\\\"population_description\\\"}\\nInvalid value: \\n{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}}\\nThe value is invalid because the match not wrapped by \\\"query\\\".\",\"additionalProperties\":false}},\"required\":[\"index\",\"query\"],\"additionalProperties\":false}", "strict", false);
    private String name = "SearchIndexTool";
    private Map<String, Object> attributes;
    private String description = "Use this tool to search an index by providing two parameters: 'index' for the index name, and 'query' for the OpenSearch DSL formatted query. Only use this tool when both index name and DSL query is available.";
    private Client client;
    private NamedXContentRegistry xContentRegistry;

    public SearchIndexTool(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.attributes = new HashMap<String, Object>();
        this.attributes.put(INPUT_SCHEMA_FIELD, DEFAULT_INPUT_SCHEMA);
        this.attributes.put(STRICT_FIELD, false);
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public boolean validate(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return false;
        }
        boolean argumentsFromInput = parameters.containsKey(INPUT_FIELD) && parameters.get(INPUT_FIELD) != null;
        boolean argumentsFromParameters = parameters.containsKey(INDEX_FIELD) && parameters.containsKey(QUERY_FIELD);
        return argumentsFromInput || argumentsFromParameters;
    }

    private SearchRequest getSearchRequest(String index, String query) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        XContentParser queryParser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        searchSourceBuilder.parseXContent(queryParser);
        return new SearchRequest().source(searchSourceBuilder).indices(new String[]{index});
    }

    private static Map<String, Object> processResponse(SearchHit hit) {
        HashMap<String, Object> docContent = new HashMap<String, Object>();
        docContent.put("_index", hit.getIndex());
        docContent.put("_id", hit.getId());
        docContent.put("_score", Float.valueOf(hit.getScore()));
        docContent.put("_source", hit.getSourceAsMap());
        return docContent;
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        try {
            String input = parameters.get(INPUT_FIELD);
            JsonObject jsonObject = (JsonObject)GSON.fromJson(input, JsonObject.class);
            String index = Optional.ofNullable(jsonObject).map(x -> x.get(INDEX_FIELD)).map(JsonElement::getAsString).orElse(parameters.getOrDefault(INDEX_FIELD, null));
            String query = Optional.ofNullable(jsonObject).map(x -> x.get(QUERY_FIELD)).map(JsonElement::toString).orElse(parameters.getOrDefault(QUERY_FIELD, null));
            if (index == null || query == null) {
                listener.onFailure((Exception)new IllegalArgumentException("SearchIndexTool's two parameter: index and query are required!"));
                return;
            }
            SearchRequest searchRequest = this.getSearchRequest(index, query);
            ActionListener actionListener = ActionListener.wrap(r -> {
                SearchHit[] hits = r.getHits().getHits();
                if (hits != null && hits.length > 0) {
                    StringBuilder contextBuilder = new StringBuilder();
                    for (SearchHit hit : hits) {
                        Map<String, Object> docContent = SearchIndexTool.processResponse(hit);
                        String doc = GSON.toJson(docContent);
                        contextBuilder.append(doc).append("\n");
                    }
                    listener.onResponse((Object)contextBuilder.toString());
                } else {
                    listener.onResponse((Object)"");
                }
            }, e -> {
                log.error("Failed to search index", (Throwable)e);
                listener.onFailure(e);
            });
            if (Objects.equals(index, ".plugins-ml-connector")) {
                this.client.execute((ActionType)MLConnectorSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else if (Objects.equals(index, ".plugins-ml-model")) {
                this.client.execute((ActionType)MLModelSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else if (Objects.equals(index, ".plugins-ml-model-group")) {
                this.client.execute((ActionType)MLModelGroupSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else {
                this.client.search(searchRequest, actionListener);
            }
        }
        catch (Exception e2) {
            log.error("Failed to search index", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setXContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    public static class Factory
    implements Tool.Factory<SearchIndexTool> {
        private Client client;
        private static Factory INSTANCE;
        private NamedXContentRegistry xContentRegistry;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<SearchIndexTool> clazz = SearchIndexTool.class;
            synchronized (SearchIndexTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client, NamedXContentRegistry xContentRegistry) {
            this.client = client;
            this.xContentRegistry = xContentRegistry;
        }

        public SearchIndexTool create(Map<String, Object> params) {
            return new SearchIndexTool(this.client, this.xContentRegistry);
        }

        public String getDefaultDescription() {
            return SearchIndexTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return SearchIndexTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        public Map<String, Object> getDefaultAttributes() {
            return DEFAULT_ATTRIBUTES;
        }
    }
}

