/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import com.google.common.annotations.VisibleForTesting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.Mode;

public final class EngineResolver {
    private static Logger logger = LogManager.getLogger(EngineResolver.class);
    public static final EngineResolver INSTANCE = new EngineResolver();

    private EngineResolver() {
    }

    @VisibleForTesting
    KNNEngine resolveEngine(KNNMethodConfigContext knnMethodConfigContext, KNNMethodContext knnMethodContext, boolean requiresTraining) {
        return this.logAndReturnEngine(this.resolveKNNEngine(knnMethodConfigContext, knnMethodContext, requiresTraining, Version.CURRENT));
    }

    public KNNEngine resolveEngine(KNNMethodConfigContext knnMethodConfigContext, KNNMethodContext knnMethodContext, boolean requiresTraining, Version version) {
        return this.logAndReturnEngine(this.resolveKNNEngine(knnMethodConfigContext, knnMethodContext, requiresTraining, version));
    }

    private KNNEngine resolveKNNEngine(KNNMethodConfigContext knnMethodConfigContext, KNNMethodContext knnMethodContext, boolean requiresTraining, Version version) {
        if (this.hasUserConfiguredEngine(knnMethodContext)) {
            return knnMethodContext.getKnnEngine();
        }
        if (requiresTraining) {
            return KNNEngine.FAISS;
        }
        Mode mode = knnMethodConfigContext.getMode();
        CompressionLevel compressionLevel = knnMethodConfigContext.getCompressionLevel();
        if (!Mode.isConfigured(mode) && !CompressionLevel.isConfigured(compressionLevel)) {
            return KNNEngine.DEFAULT;
        }
        if (compressionLevel == CompressionLevel.x4) {
            return KNNEngine.LUCENE;
        }
        if (!CompressionLevel.isConfigured(compressionLevel) || compressionLevel == CompressionLevel.x1) {
            return this.resolveEngineForX1OrNoCompression(mode, version);
        }
        return KNNEngine.FAISS;
    }

    private boolean hasUserConfiguredEngine(KNNMethodContext knnMethodContext) {
        return knnMethodContext != null && knnMethodContext.isEngineConfigured();
    }

    private KNNEngine resolveEngineForX1OrNoCompression(Mode mode, Version version) {
        if (version != null && version.onOrAfter(Version.V_2_19_0)) {
            return KNNEngine.FAISS;
        }
        return mode == Mode.ON_DISK ? KNNEngine.FAISS : KNNEngine.NMSLIB;
    }

    private KNNEngine logAndReturnEngine(KNNEngine knnEngine) {
        if (KNNEngine.DEPRECATED_ENGINES.contains(knnEngine)) {
            logger.warn("[Deprecation] {} engine is deprecated and will be removed in a future release.", (Object)knnEngine);
        }
        return knnEngine;
    }
}

