/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.constant.ForecastCommonMessages;
import org.opensearch.forecast.settings.ForecastNumericSetting;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.constant.CommonValue;
import org.opensearch.timeseries.dataprocessor.ImputationOption;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Feature;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.ShingleGetter;
import org.opensearch.timeseries.model.TimeConfiguration;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;
import org.opensearch.timeseries.util.ParseUtils;

public class Forecaster
extends Config {
    public static final String FORECAST_PARSE_FIELD_NAME = "Forecaster";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(Forecaster.class, new ParseField("Forecaster", new String[0]), it -> Forecaster.parse(it));
    public static final String HORIZON_FIELD = "horizon";
    public static final String FORECAST_INTERVAL_FIELD = "forecast_interval";
    public static final int DEFAULT_HORIZON_SHINGLE_RATIO = 3;
    private Integer horizon;

    public Forecaster(String forecasterId, Long version, String name, String description, String timeField, List<String> indices, List<Feature> features, QueryBuilder filterQuery, TimeConfiguration forecastInterval, TimeConfiguration windowDelay, Integer shingleSize, Map<String, Object> uiMetadata, Integer schemaVersion, Instant lastUpdateTime, List<String> categoryFields, User user, String resultIndex, Integer horizon, ImputationOption imputationOption, Integer recencyEmphasis, Integer seasonIntervals, Integer historyIntervals, Integer customResultIndexMinSize, Integer customResultIndexMinAge, Integer customResultIndexTTL, Boolean flattenResultIndexMapping, Instant lastBreakingUIChangeTime) {
        super(forecasterId, version, name, description, timeField, indices, features, filterQuery, windowDelay, shingleSize, uiMetadata, schemaVersion, lastUpdateTime, categoryFields, user, resultIndex, forecastInterval, imputationOption, recencyEmphasis, seasonIntervals, new ForecastShingleGetter(seasonIntervals, horizon), historyIntervals, customResultIndexMinSize, customResultIndexMinAge, customResultIndexTTL, flattenResultIndexMapping, lastBreakingUIChangeTime);
        this.checkAndThrowValidationErrors(ValidationAspect.FORECASTER);
        if (forecastInterval == null) {
            throw new ValidationException(ForecastCommonMessages.NULL_FORECAST_INTERVAL, ValidationIssueType.FORECAST_INTERVAL, ValidationAspect.FORECASTER);
        }
        if (((IntervalTimeConfiguration)forecastInterval).getInterval() <= 0L) {
            throw new ValidationException(ForecastCommonMessages.INVALID_FORECAST_INTERVAL, ValidationIssueType.FORECAST_INTERVAL, ValidationAspect.FORECASTER);
        }
        int maxCategoryFields = ForecastNumericSetting.maxCategoricalFields();
        if (categoryFields != null && categoryFields.size() > maxCategoryFields) {
            throw new ValidationException(CommonMessages.getTooManyCategoricalFieldErr(maxCategoryFields), ValidationIssueType.CATEGORY, ValidationAspect.FORECASTER);
        }
        if (this.invalidHorizon(horizon)) {
            throw new ValidationException("Horizon size must be a positive integer no larger than 384. Got " + horizon, ValidationIssueType.HORIZON_SIZE, ValidationAspect.FORECASTER);
        }
        if (this.shingleSize < 4) {
            throw new ValidationException("Shingle size must be no less than 4. Got " + shingleSize, ValidationIssueType.SHINGLE_SIZE_FIELD, ValidationAspect.FORECASTER);
        }
        this.horizon = horizon == null ? this.suggestHorizon() : horizon;
    }

    public Forecaster(StreamInput input) throws IOException {
        super(input);
        this.horizon = input.readInt();
    }

    @Override
    public void writeTo(StreamOutput output) throws IOException {
        super.writeTo(output);
        output.writeInt(this.horizon.intValue());
    }

    public boolean invalidHorizon(Integer horizonToTest) {
        return horizonToTest != null && (horizonToTest < 1 || horizonToTest > 384);
    }

    @Override
    public boolean invalidShingleSizeRange(Integer shingleSizeToTest) {
        return shingleSizeToTest != null && (shingleSizeToTest < 4 || shingleSizeToTest > 128);
    }

    public static Forecaster parse(XContentParser parser) throws IOException {
        return Forecaster.parse(parser, null);
    }

    public static Forecaster parse(XContentParser parser, String forecasterId) throws IOException {
        return Forecaster.parse(parser, forecasterId, null);
    }

    public static Forecaster parse(XContentParser parser, String forecasterId, Long version) throws IOException {
        return Forecaster.parse(parser, forecasterId, version, null, null);
    }

    public static Forecaster parse(XContentParser parser, String forecasterId, Long version, TimeValue defaultForecastInterval, TimeValue defaultForecastWindowDelay) throws IOException {
        String name = null;
        String description = "";
        String timeField = null;
        ArrayList<String> indices = new ArrayList<String>();
        MatchAllQueryBuilder filterQuery = QueryBuilders.matchAllQuery();
        TimeConfiguration forecastInterval = defaultForecastInterval == null ? null : new IntervalTimeConfiguration(defaultForecastInterval.getMinutes(), ChronoUnit.MINUTES);
        TimeConfiguration windowDelay = defaultForecastWindowDelay == null ? null : new IntervalTimeConfiguration(defaultForecastWindowDelay.getSeconds(), ChronoUnit.SECONDS);
        Integer shingleSize = null;
        ArrayList<Feature> features = new ArrayList<Feature>();
        Integer schemaVersion = CommonValue.NO_SCHEMA_VERSION;
        Map uiMetadata = null;
        Instant lastUpdateTime = null;
        User user = null;
        String resultIndex = null;
        List categoryField = null;
        Integer horizon = null;
        ImputationOption imputationOption = null;
        Integer recencyEmphasis = null;
        Integer seasonality = null;
        Integer historyIntervals = null;
        Integer customResultIndexMinSize = null;
        Integer customResultIndexMinAge = null;
        Integer customResultIndexTTL = null;
        Boolean flattenResultIndexMapping = null;
        Instant lastBreakingUIChangeTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block63: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    break;
                }
                case "description": {
                    description = parser.text();
                    break;
                }
                case "time_field": {
                    timeField = parser.text();
                    break;
                }
                case "indices": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        indices.add(parser.text());
                    }
                    continue block63;
                }
                case "ui_metadata": {
                    uiMetadata = parser.map();
                    break;
                }
                case "schema_version": {
                    schemaVersion = parser.intValue();
                    break;
                }
                case "filter_query": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    try {
                        filterQuery = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                        break;
                    }
                    catch (ParsingException | XContentParseException e) {
                        throw new ValidationException("Custom query error in data filter: " + e.getMessage(), ValidationIssueType.FILTER_QUERY, ValidationAspect.FORECASTER);
                    }
                    catch (IllegalArgumentException e) {
                        if (e.getMessage().contains("empty clause")) continue block63;
                        throw e;
                    }
                }
                case "forecast_interval": {
                    try {
                        forecastInterval = TimeConfiguration.parse(parser);
                        break;
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalArgumentException && e.getMessage().contains(CommonMessages.NEGATIVE_TIME_CONFIGURATION)) {
                            throw new ValidationException("Forecasting interval must be a positive integer", ValidationIssueType.FORECAST_INTERVAL, ValidationAspect.FORECASTER);
                        }
                        throw e;
                    }
                }
                case "feature_attributes": {
                    try {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            features.add(Feature.parse(parser));
                        }
                        continue block63;
                    }
                    catch (Exception e) {
                        if (e instanceof ParsingException || e instanceof XContentParseException) {
                            throw new ValidationException("Custom query error: " + e.getMessage(), ValidationIssueType.FEATURE_ATTRIBUTES, ValidationAspect.FORECASTER);
                        }
                        throw e;
                    }
                }
                case "window_delay": {
                    try {
                        windowDelay = TimeConfiguration.parse(parser);
                        break;
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalArgumentException && e.getMessage().contains(CommonMessages.NEGATIVE_TIME_CONFIGURATION)) {
                            throw new ValidationException("Window delay interval must be a positive integer", ValidationIssueType.WINDOW_DELAY, ValidationAspect.FORECASTER);
                        }
                        throw e;
                    }
                }
                case "shingle_size": {
                    shingleSize = parser.intValue();
                    break;
                }
                case "last_update_time": {
                    lastUpdateTime = ParseUtils.toInstant(parser);
                    break;
                }
                case "category_field": {
                    categoryField = parser.list();
                    break;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    break;
                }
                case "result_index": {
                    resultIndex = parser.text();
                    break;
                }
                case "horizon": {
                    horizon = parser.intValue();
                    break;
                }
                case "imputation_option": {
                    imputationOption = ImputationOption.parse(parser);
                    break;
                }
                case "recency_emphasis": {
                    recencyEmphasis = parser.intValue();
                    break;
                }
                case "suggested_seasonality": {
                    seasonality = parser.currentToken() == XContentParser.Token.VALUE_NULL ? null : Integer.valueOf(parser.intValue());
                    break;
                }
                case "history": {
                    historyIntervals = parser.intValue();
                    break;
                }
                case "result_index_min_size": {
                    customResultIndexMinSize = Forecaster.onlyParseNumberValue(parser);
                    break;
                }
                case "result_index_min_age": {
                    customResultIndexMinAge = Forecaster.onlyParseNumberValue(parser);
                    break;
                }
                case "result_index_ttl": {
                    customResultIndexTTL = Forecaster.onlyParseNumberValue(parser);
                    break;
                }
                case "flatten_custom_result_index": {
                    flattenResultIndexMapping = parser.booleanValue();
                    break;
                }
                case "last_ui_breaking_change_time": {
                    lastBreakingUIChangeTime = ParseUtils.toInstant(parser);
                    break;
                }
                default: {
                    parser.skipChildren();
                }
            }
        }
        Forecaster forecaster = new Forecaster(forecasterId, version, name, description, timeField, indices, features, (QueryBuilder)filterQuery, forecastInterval, windowDelay, shingleSize, uiMetadata, schemaVersion, lastUpdateTime, categoryField, user, resultIndex, horizon, imputationOption, recencyEmphasis, seasonality, historyIntervals, customResultIndexMinSize, customResultIndexMinAge, customResultIndexTTL, flattenResultIndexMapping, lastBreakingUIChangeTime);
        return forecaster;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder = super.toXContent(xContentBuilder, params);
        xContentBuilder.field(FORECAST_INTERVAL_FIELD, (ToXContent)this.interval).field(HORIZON_FIELD, this.horizon);
        return xContentBuilder.endObject();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Forecaster forecaster = (Forecaster)o;
        return super.equals(o) && Objects.equal((Object)this.horizon, (Object)forecaster.horizon);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 89 * hash + (this.horizon != null ? this.horizon.hashCode() : 0);
        return hash;
    }

    @Override
    public String validateCustomResultIndex(String resultIndex) {
        if (resultIndex != null && !resultIndex.startsWith("opensearch-forecast-result-")) {
            return ForecastCommonMessages.INVALID_RESULT_INDEX_PREFIX;
        }
        return super.validateCustomResultIndex(resultIndex);
    }

    @Override
    protected ValidationAspect getConfigValidationAspect() {
        return ValidationAspect.FORECASTER;
    }

    public Integer getHorizon() {
        return this.horizon;
    }

    public Integer suggestHorizon() {
        return this.shingleSize * 3;
    }

    @Override
    protected int getMinimumShingle() {
        return 4;
    }

    static class ForecastShingleGetter
    implements ShingleGetter {
        private Integer seasonIntervals;
        private Integer horizon;

        public ForecastShingleGetter(Integer seasonIntervals, Integer horizon) {
            this.seasonIntervals = seasonIntervals;
            this.horizon = horizon;
        }

        @Override
        public Integer getShingleSize(Integer customShingleSize) {
            if (customShingleSize != null) {
                return customShingleSize;
            }
            int candidate = 8;
            if (this.seasonIntervals != null) {
                candidate = Math.max(candidate, this.seasonIntervals / 2);
            }
            if (this.horizon != null) {
                candidate = Math.max(candidate, this.horizon / 3);
            }
            return candidate;
        }
    }
}

