/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.symbol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Decorator {
    private final ArrayList<Map<Class<? extends Decoration>, Decoration>> decorations;
    private final ArrayList<Set<Class<? extends Condition>>> conditions;

    public Decorator(int nodeCount) {
        this.decorations = new ArrayList(nodeCount);
        this.conditions = new ArrayList(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            this.decorations.add(new HashMap());
            this.conditions.add(new HashSet());
        }
    }

    public <T extends Decoration> T put(int identifier, T decoration) {
        return (T)this.decorations.get(identifier).put(decoration.getClass(), decoration);
    }

    public <T extends Decoration> T remove(int identifier, Class<T> type) {
        return (T)((Decoration)type.cast(this.decorations.get(identifier).remove(type)));
    }

    public <T extends Decoration> T get(int identifier, Class<T> type) {
        return (T)((Decoration)type.cast(this.decorations.get(identifier).get(type)));
    }

    public boolean has(int identifier, Class<? extends Decoration> type) {
        return this.decorations.get(identifier).containsKey(type);
    }

    public <T extends Decoration> boolean copy(int originalIdentifier, int targetIdentifier, Class<T> type) {
        T decoration = this.get(originalIdentifier, type);
        if (decoration != null) {
            this.put(targetIdentifier, decoration);
            return true;
        }
        return false;
    }

    public boolean set(int identifier, Class<? extends Condition> type) {
        return this.conditions.get(identifier).add(type);
    }

    public boolean delete(int identifier, Class<? extends Condition> type) {
        return this.conditions.get(identifier).remove(type);
    }

    public boolean exists(int identifier, Class<? extends Condition> type) {
        return this.conditions.get(identifier).contains(type);
    }

    public boolean replicate(int originalIdentifier, int targetIdentifier, Class<? extends Condition> type) {
        if (this.exists(originalIdentifier, type)) {
            this.set(targetIdentifier, type);
            return true;
        }
        return false;
    }

    public static interface Decoration {
    }

    public static interface Condition {
    }
}

