/*
 * Decompiled with CFR 0.152.
 */
package mediathek.update;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mediathek.config.Konstanten;
import mediathek.config.MVConfig;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.SwingErrorDialog;
import mediathek.update.DialogHinweisUpdate;
import mediathek.update.ServerProgramInformation;
import mediathek.update.UpdateNotificationDialog;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProgrammUpdateSuchen {
    private static final String UPDATE_SEARCH_TITLE = "Software-Aktualisierung";
    private static final String UPDATE_ERROR_MESSAGE = "Es ist ein Fehler bei der Softwareaktualisierung aufgetreten.\nDie aktuelle Version konnte nicht ermittelt werden.";
    private static final Logger logger = LogManager.getLogger(ProgrammUpdateSuchen.class);
    private static final String SPI_RECEPTION_ERROR_MSG = "Did not receive ServerProgramInformation";
    private static final String PI_VERSION_INVALID_MSG = "progInfo.version() is invalid";
    private final ArrayList<String[]> listInfos = new ArrayList();

    public void checkVersion(boolean showAlert, boolean showProgramInformation, boolean showAllInformation, boolean silent) {
        this.retrieveProgramInformation().ifPresentOrElse(remoteProgramInfo -> SwingUtilities.invokeLater(() -> {
            if (showProgramInformation) {
                this.showProgramInformation(showAllInformation, silent);
            }
            if (remoteProgramInfo.getVersion().isInvalid()) {
                SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), UPDATE_ERROR_MESSAGE, new RuntimeException(PI_VERSION_INVALID_MSG));
                logger.warn(PI_VERSION_INVALID_MSG);
            } else if (Konstanten.MVVERSION.isOlderThan(remoteProgramInfo.getVersion())) {
                UpdateNotificationDialog dlg = new UpdateNotificationDialog((Frame)MediathekGui.ui(), "Software Update", remoteProgramInfo.getVersion());
                dlg.setVisible(true);
            } else if (showAlert) {
                this.displayNoUpdateAvailableMessage();
            }
        }), () -> {
            logger.warn(SPI_RECEPTION_ERROR_MSG);
            SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), UPDATE_ERROR_MESSAGE, new RuntimeException(SPI_RECEPTION_ERROR_MSG));
        });
    }

    private void displayNoUpdateAvailableMessage() {
        JOptionPane.showMessageDialog(MediathekGui.ui(), "Sie benutzen die aktuellste Version von MediathekView.", UPDATE_SEARCH_TITLE, 1);
    }

    private void displayInfoMessages(boolean showAll, boolean silent) {
        try {
            int angezeigt = 0;
            if (MVConfig.get(MVConfig.Configs.SYSTEM_HINWEIS_NR_ANGEZEIGT).isEmpty()) {
                MVConfig.add(MVConfig.Configs.SYSTEM_HINWEIS_NR_ANGEZEIGT, Integer.toString(-1));
            } else {
                angezeigt = Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_HINWEIS_NR_ANGEZEIGT));
            }
            StringBuilder text = new StringBuilder();
            int index = 0;
            for (String[] h2 : this.listInfos) {
                index = Integer.parseInt(h2[0]);
                if (!showAll && angezeigt >= index) continue;
                text.append("=======================================\n");
                text.append(h2[1]);
                text.append('\n');
                text.append('\n');
            }
            if (!text.isEmpty()) {
                DialogHinweisUpdate dlg = new DialogHinweisUpdate(null, text.toString());
                dlg.setVisible(true);
                MVConfig.add(MVConfig.Configs.SYSTEM_HINWEIS_NR_ANGEZEIGT, Integer.toString(index));
            } else if (!silent) {
                this.displayNoNewInfoMessage();
            }
        }
        catch (Exception ex) {
            logger.error("displayInfoMessages failed", (Throwable)ex);
        }
    }

    private void displayNoNewInfoMessage() {
        JOptionPane.showMessageDialog(MediathekGui.ui(), "Es liegen keine aktuellen Informationen vor.", "Programminformationen", 1);
    }

    private void showProgramInformation(boolean showAll, boolean silent) {
        if (this.listInfos.isEmpty()) {
            if (showAll) {
                this.displayNoNewInfoMessage();
            }
        } else {
            this.displayInfoMessages(showAll, silent);
        }
    }

    /*
     * Exception decompiling
     */
    private Optional<ServerProgramInformation> retrieveProgramInformation() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

