/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.Common;
import java.io.File;
import java.io.IOException;

public class ShellLink {
    public static final int SW_SHOWNORMAL = 1;
    public static final int SW_SHOWMAXIMIZED = 3;
    public static final int SW_SHOWMINNOACTIVE = 7;
    private static boolean init;

    private static native boolean createWide0(String var0, String var1, String var2, String var3, String var4, boolean var5, String var6, int var7);

    private static native boolean changeNotify0(byte[] var0, byte[] var1);

    private static native boolean initialize0();

    public static native boolean uninitialize();

    public static synchronized void initialize() {
        if (InstallerUtil.isWindows() && !init) {
            init = true;
            ShellLink.initialize0();
        }
    }

    public static boolean create(File file, File shortcutTo, File iconFile, String arguments, boolean runAsAdministrator, String description, File workingDirectory, int showCmd) {
        ShellLink.initialize();
        try {
            String destPath = shortcutTo.getCanonicalPath();
            if (shortcutTo.isDirectory() && !destPath.endsWith("\\")) {
                destPath = destPath + "\\";
            }
            if (iconFile == null && !shortcutTo.isDirectory() && destPath.endsWith(".exe")) {
                iconFile = shortcutTo;
            }
            if (workingDirectory == null) {
                workingDirectory = shortcutTo.isDirectory() ? shortcutTo : shortcutTo.getParentFile();
            }
            workingDirectory = workingDirectory.getCanonicalFile();
            boolean ret = ShellLink.createWide0(file.getAbsolutePath(), destPath, workingDirectory.getAbsolutePath(), iconFile == null ? null : iconFile.getAbsolutePath(), arguments, runAsAdministrator, description, showCmd);
            if (ret) {
                ShellLink.changeNotify(file);
            }
            return ret;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void changeNotify(File file) {
        ShellLink.changeNotify0(Common.getAnsiCString(file), Common.getAnsiCString(file.getParentFile()));
    }

    static {
        Common.init();
        init = false;
    }
}

