/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.bitext;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.TestTools;
import org.languagetool.bitext.StringPair;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.IncorrectBitextExample;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.bitext.BitextPatternRule;
import org.languagetool.rules.patterns.bitext.BitextPatternRuleLoader;

public class BitextPatternRuleTest {
    @Test
    public void testBitextRulesFromXML() throws IOException {
        this.testBitextRulesFromXML(null);
    }

    private void testBitextRulesFromXML(Set<Language> ignoredLanguages) throws IOException {
        for (Language lang : Languages.getWithDemoLanguage()) {
            InputStream is;
            if (ignoredLanguages != null && ignoredLanguages.contains(lang)) continue;
            BitextPatternRuleLoader ruleLoader = new BitextPatternRuleLoader();
            String name = "/" + lang.getShortCode() + "/bitext.xml";
            try {
                is = JLanguageTool.getDataBroker().getFromRulesDirAsStream(name);
            }
            catch (RuntimeException ignored) {
                continue;
            }
            System.out.println("Running tests for " + lang.getName() + "...");
            JLanguageTool lt = new JLanguageTool(lang);
            List rules = ruleLoader.getRules(is, name);
            this.testBitextRulesFromXML(rules, lt, lang);
        }
    }

    private void testBitextRulesFromXML(List<BitextPatternRule> rules, JLanguageTool lt, Language lang) throws IOException {
        for (BitextPatternRule rule : rules) {
            this.testBitextRule(rule, lang, lt);
        }
    }

    private String cleanSentence(String str) {
        return this.cleanXML(str.replaceAll("[\\n\\t]+", ""));
    }

    private void testMarker(int expectedMatchStart, int expectedMatchEnd, Rule rule, Language lang) {
        if (expectedMatchStart == -1 || expectedMatchEnd == -1) {
            Assert.fail((String)(lang + ": No error position markup ('<marker>...</marker>') in bad example in rule " + rule));
        }
    }

    private void testBadSentence(String origBadSentence, List<String> suggestedCorrection, int expectedMatchStart, int expectedMatchEnd, AbstractPatternRule rule, Language lang, JLanguageTool lt) throws IOException {
        String badSentence = this.cleanXML(origBadSentence);
        Assert.assertTrue((badSentence.trim().length() > 0 ? 1 : 0) != 0);
        RuleMatch[] matches = this.getMatches((Rule)rule, badSentence, lt);
        Assert.assertTrue((String)(lang + ": Did expect one error in: \"" + badSentence + "\" (Rule: " + rule + "), got " + matches.length + ". Additional info:" + rule.getMessage()), (matches.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)(lang + ": Incorrect match position markup (start) for rule " + rule), (long)expectedMatchStart, (long)matches[0].getFromPos());
        Assert.assertEquals((String)(lang + ": Incorrect match position markup (end) for rule " + rule), (long)expectedMatchEnd, (long)matches[0].getToPos());
        if (suggestedCorrection != null && suggestedCorrection.size() > 0) {
            Assert.assertTrue((String)("You specified a correction but your message has no suggestions in rule " + rule), (boolean)rule.getMessage().contains("<suggestion>"));
            Assert.assertTrue((String)(lang + ": Incorrect suggestions: " + suggestedCorrection + " != " + matches[0].getSuggestedReplacements() + " for rule " + rule), (boolean)suggestedCorrection.equals(matches[0].getSuggestedReplacements()));
            if (matches[0].getSuggestedReplacements().size() > 0) {
                int fromPos = matches[0].getFromPos();
                int toPos = matches[0].getToPos();
                for (String repl : matches[0].getSuggestedReplacements()) {
                    String fixedSentence = badSentence.substring(0, fromPos) + repl + badSentence.substring(toPos);
                    matches = this.getMatches((Rule)rule, fixedSentence, lt);
                    if (matches.length <= 0) continue;
                    Assert.fail((String)("Incorrect input:\n  " + badSentence + "\nCorrected sentence:\n  " + fixedSentence + "\nBy Rule:\n  " + rule + "\nThe correction triggered an error itself:\n  " + matches[0] + "\n"));
                }
            }
        }
    }

    private void testBitextRule(BitextPatternRule rule, Language lang, JLanguageTool lt) throws IOException {
        JLanguageTool srcTool = new JLanguageTool(rule.getSourceLanguage());
        List goodSentences = rule.getCorrectBitextExamples();
        for (StringPair goodSentence : goodSentences) {
            Assert.assertTrue((String)("Got good sentence: '" + goodSentence.getSource() + "'"), (this.cleanSentence(goodSentence.getSource()).trim().length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Got good sentence: '" + goodSentence.getTarget() + "'"), (this.cleanSentence(goodSentence.getTarget()).trim().length() > 0 ? 1 : 0) != 0);
            Assert.assertFalse((String)(lang + ": Did not expect error in: " + goodSentence + " (Rule: " + rule + ")"), (boolean)this.match(rule, goodSentence.getSource(), goodSentence.getTarget(), srcTool, lt));
        }
        List badSentences = rule.getIncorrectBitextExamples();
        for (IncorrectBitextExample origBadExample : badSentences) {
            StringPair example = origBadExample.getExample();
            String origBadSrcSentence = example.getSource().replaceAll("[\\n\\t]+", "");
            String origBadTrgSentence = example.getTarget().replaceAll("[\\n\\t]+", "");
            List suggestedCorrection = origBadExample.getCorrections();
            int expectedSrcMatchStart = origBadSrcSentence.indexOf("<marker>");
            int expectedSrcMatchEnd = origBadSrcSentence.indexOf("</marker>") - "<marker>".length();
            this.testMarker(expectedSrcMatchStart, expectedSrcMatchEnd, (Rule)rule, lang);
            int expectedTrgMatchStart = origBadTrgSentence.indexOf("<marker>");
            int expectedTrgMatchEnd = origBadTrgSentence.indexOf("</marker>") - "<marker>".length();
            this.testMarker(expectedTrgMatchStart, expectedTrgMatchEnd, (Rule)rule, lang);
            this.testBadSentence(origBadSrcSentence, suggestedCorrection, expectedSrcMatchStart, expectedSrcMatchEnd, rule.getSrcRule(), lang, srcTool);
            this.testBadSentence(origBadTrgSentence, suggestedCorrection, expectedTrgMatchStart, expectedTrgMatchEnd, rule.getTrgRule(), lang, lt);
        }
    }

    private String cleanXML(String str) {
        return str.replaceAll("<([^<].*?)>", "");
    }

    private boolean match(BitextPatternRule rule, String src, String trg, JLanguageTool srcLanguageTool, JLanguageTool trgLanguageTool) throws IOException {
        AnalyzedSentence trgText;
        AnalyzedSentence srcText = srcLanguageTool.getAnalyzedSentence(src);
        RuleMatch[] matches = rule.match(srcText, trgText = trgLanguageTool.getAnalyzedSentence(trg));
        return matches.length > 0;
    }

    private RuleMatch[] getMatches(Rule rule, String sentence, JLanguageTool lt) throws IOException {
        AnalyzedSentence analyzedSentence = lt.getAnalyzedSentence(sentence);
        return rule.match(analyzedSentence);
    }

    public static void main(String[] args) throws IOException {
        BitextPatternRuleTest prt = new BitextPatternRuleTest();
        System.out.println("Running XML bitext pattern tests...");
        if (args.length == 0) {
            prt.testBitextRulesFromXML(null);
        } else {
            Set<Language> ignoredLanguages = TestTools.getLanguagesExcept(args);
            prt.testBitextRulesFromXML(ignoredLanguages);
        }
        System.out.println("Bitext pattern tests successful.");
    }
}

