/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import sun.security.ssl.Alert;
import sun.security.ssl.Authenticator;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.PostHandshakeContext;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLProducer;
import sun.security.ssl.SSLTrafficKeyDerivation;

final class KeyUpdate {
    static final SSLProducer kickstartProducer = new KeyUpdateKickstartProducer();
    static final SSLConsumer handshakeConsumer = new KeyUpdateConsumer();
    static final HandshakeProducer handshakeProducer = new KeyUpdateProducer();

    KeyUpdate() {
    }

    private static final class KeyUpdateProducer
    implements HandshakeProducer {
        private KeyUpdateProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            SSLCipher.SSLWriteCipher sSLWriteCipher;
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation;
            PostHandshakeContext postHandshakeContext = (PostHandshakeContext)connectionContext;
            KeyUpdateMessage keyUpdateMessage = (KeyUpdateMessage)handshakeMessage;
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced KeyUpdate post-handshake message", keyUpdateMessage);
            }
            if ((sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(postHandshakeContext.conContext.protocolVersion)) == null) {
                throw postHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)postHandshakeContext.conContext.protocolVersion));
            }
            SSLKeyDerivation sSLKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(postHandshakeContext, postHandshakeContext.conContext.outputRecord.writeCipher.baseSecret);
            if (sSLKeyDerivation == null) {
                throw postHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "no key derivation");
            }
            SecretKey secretKey = sSLKeyDerivation.deriveKey("TlsUpdateNplus1", null);
            SSLKeyDerivation sSLKeyDerivation2 = sSLTrafficKeyDerivation.createKeyDerivation(postHandshakeContext, secretKey);
            SecretKey secretKey2 = sSLKeyDerivation2.deriveKey("TlsKey", null);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(sSLKeyDerivation2.deriveKey("TlsIv", null).getEncoded());
            try {
                sSLWriteCipher = postHandshakeContext.negotiatedCipherSuite.bulkCipher.createWriteCipher(Authenticator.valueOf(postHandshakeContext.conContext.protocolVersion), postHandshakeContext.conContext.protocolVersion, secretKey2, ivParameterSpec, postHandshakeContext.sslContext.getSecureRandom());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw postHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failure to derive write secrets", generalSecurityException);
            }
            if (sSLWriteCipher == null) {
                throw postHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)postHandshakeContext.negotiatedCipherSuite) + ") and protocol version (" + (Object)((Object)postHandshakeContext.negotiatedProtocol) + ")");
            }
            sSLWriteCipher.baseSecret = secretKey;
            postHandshakeContext.conContext.outputRecord.changeWriteCiphers(sSLWriteCipher, ((KeyUpdateMessage)keyUpdateMessage).status.id);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine("KeyUpdate: write key updated", new Object[0]);
            }
            postHandshakeContext.conContext.finishPostHandshake();
            return null;
        }
    }

    private static final class KeyUpdateConsumer
    implements SSLConsumer {
        private KeyUpdateConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation;
            PostHandshakeContext postHandshakeContext = (PostHandshakeContext)connectionContext;
            KeyUpdateMessage keyUpdateMessage = new KeyUpdateMessage(postHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming KeyUpdate post-handshake message", keyUpdateMessage);
            }
            if ((sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(postHandshakeContext.conContext.protocolVersion)) == null) {
                throw postHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)postHandshakeContext.conContext.protocolVersion));
            }
            SSLKeyDerivation sSLKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(postHandshakeContext, postHandshakeContext.conContext.inputRecord.readCipher.baseSecret);
            if (sSLKeyDerivation == null) {
                throw postHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "no key derivation");
            }
            SecretKey secretKey = sSLKeyDerivation.deriveKey("TlsUpdateNplus1", null);
            SSLKeyDerivation sSLKeyDerivation2 = sSLTrafficKeyDerivation.createKeyDerivation(postHandshakeContext, secretKey);
            SecretKey secretKey2 = sSLKeyDerivation2.deriveKey("TlsKey", null);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(sSLKeyDerivation2.deriveKey("TlsIv", null).getEncoded());
            try {
                SSLCipher.SSLReadCipher sSLReadCipher = postHandshakeContext.negotiatedCipherSuite.bulkCipher.createReadCipher(Authenticator.valueOf(postHandshakeContext.conContext.protocolVersion), postHandshakeContext.conContext.protocolVersion, secretKey2, ivParameterSpec, postHandshakeContext.sslContext.getSecureRandom());
                if (sSLReadCipher == null) {
                    throw postHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)postHandshakeContext.negotiatedCipherSuite) + ") and protocol version (" + (Object)((Object)postHandshakeContext.negotiatedProtocol) + ")");
                }
                sSLReadCipher.baseSecret = secretKey;
                postHandshakeContext.conContext.inputRecord.changeReadCiphers(sSLReadCipher);
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.fine("KeyUpdate: read key updated", new Object[0]);
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw postHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failure to derive read secrets", generalSecurityException);
            }
            if (keyUpdateMessage.status == KeyUpdateRequest.REQUESTED) {
                handshakeProducer.produce(postHandshakeContext, new KeyUpdateMessage(postHandshakeContext, KeyUpdateRequest.NOTREQUESTED));
                return;
            }
            postHandshakeContext.conContext.finishPostHandshake();
        }
    }

    private static final class KeyUpdateKickstartProducer
    implements SSLProducer {
        private KeyUpdateKickstartProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext) throws IOException {
            PostHandshakeContext postHandshakeContext = (PostHandshakeContext)connectionContext;
            return handshakeProducer.produce(connectionContext, new KeyUpdateMessage(postHandshakeContext, KeyUpdateRequest.REQUESTED));
        }
    }

    static enum KeyUpdateRequest {
        NOTREQUESTED(0, "update_not_requested"),
        REQUESTED(1, "update_requested");

        final byte id;
        final String name;

        private KeyUpdateRequest(byte by, String string2) {
            this.id = by;
            this.name = string2;
        }

        static KeyUpdateRequest valueOf(byte by) {
            for (KeyUpdateRequest keyUpdateRequest : KeyUpdateRequest.values()) {
                if (keyUpdateRequest.id != by) continue;
                return keyUpdateRequest;
            }
            return null;
        }

        static String nameOf(byte by) {
            for (KeyUpdateRequest keyUpdateRequest : KeyUpdateRequest.values()) {
                if (keyUpdateRequest.id != by) continue;
                return keyUpdateRequest.name;
            }
            return "<UNKNOWN KeyUpdateRequest TYPE: " + (by & 0xFF) + ">";
        }
    }

    static final class KeyUpdateMessage
    extends SSLHandshake.HandshakeMessage {
        private final KeyUpdateRequest status;

        KeyUpdateMessage(PostHandshakeContext postHandshakeContext, KeyUpdateRequest keyUpdateRequest) {
            super(postHandshakeContext);
            this.status = keyUpdateRequest;
        }

        KeyUpdateMessage(PostHandshakeContext postHandshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(postHandshakeContext);
            if (byteBuffer.remaining() != 1) {
                throw postHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "KeyUpdate has an unexpected length of " + byteBuffer.remaining());
            }
            byte by = byteBuffer.get();
            this.status = KeyUpdateRequest.valueOf(by);
            if (this.status == null) {
                throw postHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid KeyUpdate message value: " + KeyUpdateRequest.nameOf(by));
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.KEY_UPDATE;
        }

        @Override
        public int messageLength() {
            return 1;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(this.status.id);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"KeyUpdate\": '{'\n  \"request_update\": {0}\n'}'", Locale.ENGLISH);
            Object[] objectArray = new Object[]{this.status.name};
            return messageFormat.format(objectArray);
        }
    }
}

