/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.MetaIndex;
import sun.security.action.GetPropertyAction;

public class JarIndex {
    private HashMap<String, LinkedList<String>> indexMap = new HashMap();
    private HashMap<String, LinkedList<String>> jarMap = new HashMap();
    private String[] jarFiles;
    public static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final boolean metaInfFilenames = "true".equals(AccessController.doPrivileged(new GetPropertyAction("sun.misc.JarIndex.metaInfFilenames")));

    public JarIndex() {
    }

    public JarIndex(InputStream is) throws IOException {
        this();
        this.read(is);
    }

    public JarIndex(String[] files) throws IOException {
        this();
        this.jarFiles = files;
        this.parseJars(files);
    }

    public static JarIndex getJarIndex(JarFile jar2) throws IOException {
        return JarIndex.getJarIndex(jar2, null);
    }

    public static JarIndex getJarIndex(JarFile jar2, MetaIndex metaIndex) throws IOException {
        JarIndex index = null;
        if (metaIndex != null && !metaIndex.mayContain(INDEX_NAME)) {
            return null;
        }
        JarEntry e = jar2.getJarEntry(INDEX_NAME);
        if (e != null) {
            index = new JarIndex(jar2.getInputStream(e));
        }
        return index;
    }

    public String[] getJarFiles() {
        return this.jarFiles;
    }

    private void addToList(String key, String value, HashMap<String, LinkedList<String>> t) {
        LinkedList<String> list = t.get(key);
        if (list == null) {
            list = new LinkedList();
            list.add(value);
            t.put(key, list);
        } else if (!list.contains(value)) {
            list.add(value);
        }
    }

    public LinkedList<String> get(String fileName) {
        int pos;
        LinkedList<String> jarFiles = null;
        jarFiles = this.indexMap.get(fileName);
        if (jarFiles == null && (pos = fileName.lastIndexOf("/")) != -1) {
            jarFiles = this.indexMap.get(fileName.substring(0, pos));
        }
        return jarFiles;
    }

    public void add(String fileName, String jarName) {
        int pos = fileName.lastIndexOf("/");
        String packageName = pos != -1 ? fileName.substring(0, pos) : fileName;
        this.addToList(packageName, jarName, this.indexMap);
        this.addToList(jarName, packageName, this.jarMap);
    }

    private void addExplicit(String fileName, String jarName) {
        this.addToList(fileName, jarName, this.indexMap);
        this.addToList(jarName, fileName, this.jarMap);
    }

    private void parseJars(String[] files) throws IOException {
        if (files == null) {
            return;
        }
        String currentJar = null;
        for (int i = 0; i < files.length; ++i) {
            currentJar = files[i];
            ZipFile zrf = new ZipFile(currentJar.replace('/', File.separatorChar));
            Enumeration<? extends ZipEntry> entries = zrf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String fileName = entry.getName();
                if (fileName.equals("META-INF/") || fileName.equals(INDEX_NAME) || fileName.equals("META-INF/MANIFEST.MF")) continue;
                if (!metaInfFilenames) {
                    this.add(fileName, currentJar);
                    continue;
                }
                if (!fileName.startsWith("META-INF/")) {
                    this.add(fileName, currentJar);
                    continue;
                }
                if (entry.isDirectory()) continue;
                this.addExplicit(fileName, currentJar);
            }
            zrf.close();
        }
    }

    public void write(OutputStream out) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, "UTF8"));
        bw.write("JarIndex-Version: 1.0\n\n");
        if (this.jarFiles != null) {
            for (int i = 0; i < this.jarFiles.length; ++i) {
                String jar2 = this.jarFiles[i];
                bw.write(jar2 + "\n");
                LinkedList<String> jarlist = this.jarMap.get(jar2);
                if (jarlist != null) {
                    Iterator listitr = jarlist.iterator();
                    while (listitr.hasNext()) {
                        bw.write((String)listitr.next() + "\n");
                    }
                }
                bw.write("\n");
            }
            bw.flush();
        }
    }

    public void read(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF8"));
        String line = null;
        String currentJar = null;
        Vector<String> jars = new Vector<String>();
        while ((line = br.readLine()) != null && !line.endsWith(".jar")) {
        }
        while (line != null) {
            if (line.length() != 0) {
                if (line.endsWith(".jar")) {
                    currentJar = line;
                    jars.add(currentJar);
                } else {
                    String name = line;
                    this.addToList(name, currentJar, this.indexMap);
                    this.addToList(currentJar, name, this.jarMap);
                }
            }
            line = br.readLine();
        }
        this.jarFiles = jars.toArray(new String[jars.size()]);
    }

    public void merge(JarIndex toIndex, String path) {
        for (Map.Entry<String, LinkedList<String>> e : this.indexMap.entrySet()) {
            String packageName = e.getKey();
            LinkedList<String> from_list = e.getValue();
            for (String jarName : from_list) {
                if (path != null) {
                    jarName = path.concat(jarName);
                }
                toIndex.add(packageName, jarName);
            }
        }
    }
}

